/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.IndependentBrowser;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserStandalone;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefDownloadItem;
import org.cef.handler.CefDownloadHandlerAdapter;
import org.cef.misc.Rectangle;

public final class Standalone
extends IndependentBrowser {
    public Standalone(String url, String title, Rectangle window) {
        Engine.initCEF(Engine.BrowserType.STANDALONE);
        this.createClient();
        this.setBrowser(this.getClientHandler().createBrowser(url, false, false, this.createRequestContext(), null));
        this.getBrowser().setReference(this);
        CefBrowser browser = this.getBrowser();
        if (browser instanceof CefBrowserStandalone) {
            CefBrowserStandalone standaloneBrowser = (CefBrowserStandalone)browser;
            if (title != null && !title.trim().isEmpty()) {
                standaloneBrowser.createBrowserTitle(title);
            }
            if (window != null) {
                standaloneBrowser.setWindow(window);
            }
        }
        this.getClientHandler().addDownloadHandler(new CefDownloadHandlerAdapter(){

            @Override
            public boolean onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
                callback.Continue("", true);
                return true;
            }
        });
        browser.createImmediately();
    }

    public Standalone(String url) {
        this(url, null, null);
    }

    public Standalone(String url, Rectangle window) {
        this(url, null, window);
    }

    public Standalone(String url, String title) {
        this(url, title, null);
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        this.isCreated().thenRun(() -> {
            CefBrowser browser = this.getBrowser();
            if (browser instanceof CefBrowserStandalone) {
                ((CefBrowserStandalone)browser).setFullscreen(fullscreen);
            }
        });
    }

    @Override
    public boolean isFullscreen() {
        CefBrowser browser = this.getBrowser();
        return browser instanceof CefBrowserStandalone && ((CefBrowserStandalone)browser).isFullscreen();
    }

    @Override
    public void setWindowIcon(String iconPath) {
        if (!OS.isWindows()) {
            throw new UnsupportedOperationException("Window icon customization not supported on Linux or MacOS");
        }
        this.isCreated().thenRun(() -> {
            CefBrowser browser = this.getBrowser();
            if (browser instanceof CefBrowserStandalone) {
                ((CefBrowserStandalone)browser).setWindowIcon(iconPath);
            }
        });
    }

    @Override
    public void setWindowTitle(String title) {
        this.isCreated().thenRun(() -> {
            CefBrowser browser = this.getBrowser();
            if (browser instanceof CefBrowserStandalone) {
                ((CefBrowserStandalone)browser).setWindowTitle(title);
            }
        });
    }
}

