/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefColor;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefWindowHandler;
import org.cef.handler.CefWindowHandlerAdapter;
import org.cef.misc.Point;
import org.cef.misc.Rectangle;
import org.cef.misc.SWTUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CefBrowserSwt
extends CefBrowser_N {
    public static Method autoScaleUp;
    private static int deviceZoom;
    private long handle;
    private Composite composite;
    protected org.eclipse.swt.graphics.Rectangle currentSize;
    private boolean visibleWayland = true;
    private Color parentBackgroundColor = null;
    private Point chromiumSize = null;
    private CefWindowHandler windowHandler = new CefWindowHandlerAdapter(){

        @Override
        public Rectangle getRect(CefBrowser browser) {
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (CefBrowserSwt.this.composite != null && !CefBrowserSwt.this.composite.isDisposed()) {
                Point size;
                Point point = size = SWTUtils.IS_WIN_MULTITHREAD ? CefBrowserSwt.this.chromiumSize : SWTUtils.syncExec(() -> CefBrowserSwt.this.getChromiumSize());
                if (OS.isWayland()) {
                    CefBrowserSwt.this.composite.getDisplay().syncExec(() -> {
                        Point offset = CefBrowserSwt.this.getChromiumOffset();
                        rectangle.setBounds(offset.x, offset.y, point.x, point.y);
                    });
                } else {
                    rectangle.setBounds(-1, -1, size.x, size.y);
                }
                SWTUtils.winMTExec(() -> {
                    if (!CefBrowserSwt.this.composite.isDisposed()) {
                        CefBrowserSwt.this.setCurrentSize();
                    }
                }, false);
            }
            return rectangle;
        }
    };

    static {
        try {
            Class<?> dpiClass = Class.forName("org.eclipse.swt.internal.DPIUtil");
            CefBrowserSwt.getAutoScaleMethod(dpiClass, "autoScaleUpUsingNativeDPI", new Class[]{Integer.TYPE});
            if (!"gtk".equals(SWT.getPlatform()) || autoScaleUp == null) {
                Method getDeviceZoom;
                if ("gtk".equals(SWT.getPlatform()) && SWT.getVersion() > 4965) {
                    CefBrowserSwt.getAutoScaleMethod(Class.forName("org.cef.browser.CefBrowserSwt"), "autoScaleUp", new Class[]{Integer.TYPE});
                } else if ("win32".equals(SWT.getPlatform()) && SWT.getVersion() >= 4970) {
                    CefBrowserSwt.getAutoScaleMethod(Class.forName("org.eclipse.swt.internal.Win32DPIUtils"), "pointToPixel", new Class[]{Integer.TYPE, Integer.TYPE});
                }
                if (autoScaleUp == null) {
                    CefBrowserSwt.getAutoScaleMethod(dpiClass, "autoScaleUp", new Class[]{Integer.TYPE});
                }
                deviceZoom = (getDeviceZoom = Class.forName("org.eclipse.swt.internal.DPIUtil").getDeclaredMethod("getDeviceZoom", new Class[0])) != null ? (Integer)getDeviceZoom.invoke(null, new Object[0]) : 100;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static int autoScaleUp(int size) {
        return (int)((double)size * ((double)deviceZoom / 100.0));
    }

    public int getBackgroundColor() {
        if (this.composite.isDisposed()) {
            return 0;
        }
        Color colorSwt = null;
        if (Boolean.getBoolean("chromium.inherit_bg_color")) {
            colorSwt = this.parentBackgroundColor;
        }
        if (colorSwt == null) {
            colorSwt = CefColor.DARK_MODE && !Boolean.getBoolean("chromium.white_bg_color") ? new Color((Device)this.composite.getDisplay(), CefColor.DARK_MODE_COLOR.getRed(), CefColor.DARK_MODE_COLOR.getGreen(), CefColor.DARK_MODE_COLOR.getBlue()) : new Color((Device)this.composite.getDisplay(), 255, 255, 255);
        }
        return (int)new CefColor(colorSwt.getAlpha(), colorSwt.getRed(), colorSwt.getGreen(), colorSwt.getBlue()).getColor();
    }

    private static void getAutoScaleMethod(Class<?> dpiClass, String method, Class<?>[] paramTypes) {
        try {
            autoScaleUp = dpiClass.getDeclaredMethod(method, paramTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public CefBrowserSwt(CefClient client, String url, CefRequestContext context) {
        super(client, url, context, null, null, null);
    }

    public CefBrowserSwt(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        super(client, url, context, parent, inspectAt, null);
    }

    @Override
    public CompletableFuture<Object> createScreenshot(boolean nativeResolution) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public void createImmediately() {
        this.createBrowserIfRequired(false);
    }

    public void createImmediately(final Composite composite) {
        this.composite = composite;
        if (composite.getParent() != null) {
            this.parentBackgroundColor = composite.getParent().getBackground();
        }
        this.handle = this.getHandle(composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CefBrowserSwt.this.close(true);
                CefApp.getInstance().doMessageLoopWork(1L);
            }
        });
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (OS.isWayland() && !CefBrowserSwt.this.isClosed()) {
                    Point size = CefBrowserSwt.this.getChromiumSize();
                    Point offset = CefBrowserSwt.this.getChromiumOffset();
                    CefBrowserSwt.this.updateUI(new Rectangle(offset.x, offset.y, size.x, size.y), null);
                }
            }

            public void controlResized(ControlEvent e) {
                if (!CefBrowserSwt.this.isClosed()) {
                    Point size = CefBrowserSwt.this.getChromiumSize();
                    CefBrowserSwt.this.setCurrentSize();
                    if (OS.isWayland()) {
                        Point offset = CefBrowserSwt.this.getChromiumOffset();
                        CefBrowserSwt.this.updateUI(new Rectangle(offset.x, offset.y, size.x, size.y), null);
                    } else {
                        CefBrowserSwt.this.wasResized(size.x, size.y, CefBrowserSwt.this.forceResizeWindow());
                    }
                }
            }
        });
        if (OS.isWayland()) {
            this.addVisibilityListeners();
        }
        if (OS.isLinux()) {
            final AtomicReference<Shell> shellRef = new AtomicReference<Shell>();
            final ControlAdapter moveAdapter = new ControlAdapter(){

                public void controlMoved(ControlEvent e) {
                    if (!CefBrowserSwt.this.isClosed()) {
                        CefBrowserSwt.this.notifyMoveOrResizeStarted();
                    }
                }
            };
            shellRef.set(composite.getShell());
            PaintListener reparentListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Shell oldShell;
                    Shell currentShell = composite.getShell();
                    if (currentShell != (oldShell = (Shell)shellRef.get())) {
                        currentShell.addControlListener((ControlListener)moveAdapter);
                        shellRef.set(currentShell);
                    }
                }
            };
            composite.getShell().addControlListener((ControlListener)moveAdapter);
            composite.addPaintListener(reparentListener);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Shell shell = (Shell)shellRef.get();
                    if (shell != null && !shell.isDisposed()) {
                        shell.removeControlListener((ControlListener)moveAdapter);
                    }
                }
            });
        }
        composite.getDisplay().syncExec(() -> {
            Point point = this.chromiumSize = this.getChromiumSize();
        });
        this.createImmediately();
    }

    private void addVisibilityListeners() {
        int visibilityDelay = 33;
        Runnable visibilitySetter = () -> {
            if (this.composite.isDisposed()) {
                return;
            }
            this.composite.getDisplay().syncExec(() -> this.setWindowVisibility(this.visibleWayland));
        };
        this.composite.getDisplay().addFilter(22, event -> {
            boolean isAncestor = this.isSameOrAncestor((Control)this.composite, event.widget);
            if (isAncestor && this.isPending_ && !this.visibleWayland) {
                this.visibleWayland = true;
                this.composite.getDisplay().timerExec(33, visibilitySetter);
            }
        });
        this.composite.getDisplay().addFilter(23, event -> {
            boolean isAncestor = this.isSameOrAncestor((Control)this.composite, event.widget);
            if (isAncestor && this.isPending_ && this.visibleWayland) {
                this.visibleWayland = false;
                this.composite.getDisplay().timerExec(33, visibilitySetter);
            }
        });
        this.composite.getDisplay().addListener(45, event -> {
            if (event.widget == this.composite && this.isPending_) {
                boolean newIsVisible = this.composite.getShell().isVisible();
                if (!newIsVisible && this.visibleWayland) {
                    this.visibleWayland = false;
                } else if (newIsVisible && !this.visibleWayland) {
                    this.visibleWayland = true;
                }
                this.composite.getDisplay().timerExec(33, visibilitySetter);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private boolean isSameOrAncestor(Control control, Widget ancestor) {
        if (!control.isDisposed()) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (control == ancestor) {
                return true;
            }
            control = control.getParent();
lbl6:
            // 2 sources

            ** while (control != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public void resize() {
        if (!this.isClosed()) {
            Monitor currentMonitor;
            Monitor primaryMonitor;
            Point size = this.getChromiumSize();
            if ("win32".equals(SWT.getPlatform()) && !(primaryMonitor = Display.getDefault().getPrimaryMonitor()).equals((Object)(currentMonitor = this.composite.getShell().getMonitor()))) {
                this.wasResized(size.x + 1, size.y, false);
            }
            this.setCurrentSize();
            if (OS.isWayland()) {
                Point offset = this.getChromiumOffset();
                this.updateUI(new Rectangle(offset.x, offset.y, size.x, size.y), null);
            } else {
                this.initialSize(size.x, size.y, false);
            }
        }
    }

    private long getHandle(Composite control) {
        long hwnd = 0L;
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("view");
                field.setAccessible(true);
                Object nsview = field.get(control);
                Class<?> idClass = Class.forName("org.eclipse.swt.internal.cocoa.id");
                Field idField = idClass.getField("id");
                hwnd = (Long)idField.get(nsview);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("win32".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = ((Number)field.get(control)).longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                Field field = Widget.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = ((Number)field.get(control)).longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hwnd;
    }

    private boolean createBrowserIfRequired(boolean hasParent) {
        if (this.isClosed()) {
            return false;
        }
        long windowHandle = this.handle;
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), windowHandle, false, false, null, this.getInspectAt());
                return true;
            }
            this.createBrowser(this.getClient(), windowHandle, this.getUrl(), false, false, null, this.getRequestContext());
            return true;
        }
        return false;
    }

    @Override
    public <T> T getUIComponent() {
        return null;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        return new CefBrowserSwt(client, url, context, parent, inspectAt);
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return this.windowHandler;
    }

    private Point getChromiumOffset() {
        org.eclipse.swt.graphics.Point location = this.getComposite().getDisplay().map((Control)this.getComposite().getParent(), null, this.getComposite().getLocation());
        Point size = new Point(location.x, location.y);
        Point scaled = this.applyScale(size);
        if (scaled != null && (scaled.x > size.x || scaled.y > size.y)) {
            size = scaled;
        }
        return size;
    }

    private Point getChromiumSize() {
        Point size = new Point(this.getComposite().getSize().x, this.getComposite().getSize().y);
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            return size;
        }
        Point scaled = this.applyScale(size);
        if (scaled != null && (scaled.x > size.x || scaled.y > size.y)) {
            size = scaled;
        }
        if (size.x > 0) {
            Point finalSize = size;
            SWTUtils.asyncExec(() -> this.wasResized(point.x + 1, point.y, this.forceResizeWindow()));
        }
        return size;
    }

    private Point applyScale(Point size) {
        if (autoScaleUp == null) {
            return null;
        }
        try {
            Object scaledY;
            Object scaledX;
            if (autoScaleUp.getParameterCount() == 2) {
                scaledX = autoScaleUp.invoke(null, size.x, deviceZoom);
                scaledY = autoScaleUp.invoke(null, size.y, deviceZoom);
            } else {
                scaledX = autoScaleUp.invoke(null, size.x);
                scaledY = autoScaleUp.invoke(null, size.y);
            }
            return new Point(((Number)scaledX).intValue(), ((Number)scaledY).intValue());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public org.eclipse.swt.graphics.Rectangle getCurrentBounds() {
        return this.currentSize;
    }

    private org.eclipse.swt.graphics.Rectangle setCurrentSize() {
        this.currentSize = this.composite.getDisplay().map((Control)this.composite, (Control)this.composite.getShell(), this.composite.getClientArea());
        return this.currentSize;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void cleanJGlobalRef() {
        this.jGlobalRef_ = 0L;
    }

    private boolean forceResizeWindow() {
        return OS.isWindows() && SWTUtils.IS_WIN_MULTITHREAD && SWT.getVersion() > 4965;
    }
}

