/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.kms.katalon.session.core.model.AuthenticationRequest;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.RememberedCredential;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.SessionExpireSchedule;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.session.core.services.ISessionManager;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
public class SessionController
implements ISessionController {
    private static ISessionController instance;
    @Inject
    ISessionManager sessionManager;

    public static ISessionController getInstance() {
        if (instance == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(SessionController.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (ISessionController)ContextInjectionFactory.make(SessionController.class, (IEclipseContext)context);
        }
        return instance;
    }

    public Session restoreSession() throws SessionException {
        return this.sessionManager.restoreSession();
    }

    public Session getSession() {
        return this.sessionManager.getSession();
    }

    public AuthenticationRequest setupAuthenticationRequest() throws SessionException {
        return this.sessionManager.setupAuthenticationRequest();
    }

    public Session authenticateWithApiKey(String apiKey, Long organizationId) throws SessionException {
        return this.sessionManager.authenticateWithApiKey(apiKey, organizationId);
    }

    public Session activateWithAuthenticationRequest(AuthenticationRequest request) throws SessionException {
        return this.sessionManager.activateWithAuthenticationRequest(request);
    }

    public Session activateWithPassword(String username, String password) throws SessionException {
        return this.sessionManager.activateWithPassword(username, password);
    }

    public Session activateWithApiKey(String apiKey) throws SessionException {
        return this.activateWithApiKey(apiKey, null);
    }

    public Session activateWithApiKey(String apiKey, Long organizationId) throws SessionException {
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            return new Session();
        }
        return this.sessionManager.activateWithApiKey(apiKey, organizationId);
    }

    public void logout() throws SessionException {
        this.sessionManager.logout();
    }

    public void deactivate() throws SessionException {
        this.sessionManager.deactivate();
    }

    public void deactivateWithApiKey(String apiKey, Long organizationId) throws SessionException {
        this.sessionManager.deactivateWithApiKey(apiKey, organizationId);
    }

    public void reactivation() throws SessionException {
        this.sessionManager.reactivation();
    }

    public void renewTokens() throws SessionException {
        this.sessionManager.renewTokens();
    }

    public List<Organization> getOrganizationsOfSelectedAccount() {
        return this.sessionManager.getOrganizationsOfSelectedAccount();
    }

    public void setOrganization(Organization organization) throws SessionException {
        this.sessionManager.setOrganization(organization);
    }

    public Session activateWithEngineAmiMachine() throws SessionException {
        return this.sessionManager.activateWithEngineAmiMachine();
    }

    public Session activateOffline(File licenseFile) throws SessionException {
        String activationCode = "";
        try {
            activationCode = FileUtils.readFileToString((File)licenseFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return null;
        }
        if (activationCode.isEmpty()) {
            return null;
        }
        return this.sessionManager.activateOffline(activationCode);
    }

    public boolean checkTestingOfflineLicense(File licenseFile) throws SessionException {
        return this.sessionManager.checkTestingOfflineLicense(licenseFile);
    }

    public UserInfo getUserInfo() {
        return this.sessionManager.getUserInfo();
    }

    public UserInfo getUserInfo(String serverUrl, AuthenticationToken adminToken) throws SessionException {
        return this.sessionManager.getUserInfo(serverUrl, adminToken);
    }

    public void startScheduleCheckingLicense(Runnable expiredHandler, Runnable renewHandler) {
        this.sessionManager.startScheduleCheckingLicense(expiredHandler, renewHandler);
    }

    public void startScheduleCheckingToken(Consumer<SessionExpireSchedule> expiredHandler, Runnable renewHandler) {
        this.sessionManager.startScheduleCheckingToken(expiredHandler, renewHandler);
    }

    public void endScheduleCheckingLicense() {
        this.sessionManager.endScheduleCheckingLicense();
    }

    public void endScheduleCheckingAdminToken() {
        this.sessionManager.endScheduleCheckingToken();
    }

    public boolean isActivated() {
        return this.sessionManager.isActivated();
    }

    public Date getExpirationOnline(String licenseFeature) throws SessionException {
        return this.sessionManager.getExpirationOnline(licenseFeature);
    }

    public boolean shouldShowBrowserLoginAvailableDialog() {
        return this.sessionManager.shouldShowBrowserLoginAvailableDialog();
    }

    public void toggleShowBrowserLoginAvailableDialog(boolean shouldDisplay) {
        this.sessionManager.toggleShowBrowserLoginAvailableDialog(shouldDisplay);
    }

    public void resetSession() {
        this.sessionManager.resetSession();
    }

    public RememberedCredential getRememberedCredential() {
        return this.sessionManager.getRememberedCredential();
    }

    public void clearRememberedCredential() {
        this.sessionManager.clearRememberedCredential();
    }

    public LicenseType getLicenseType() {
        return this.sessionManager.getLicenseType();
    }

    public SessionExpireSchedule.Reason getLastExpireReason() {
        return this.sessionManager.getLastExpireReason();
    }

    public void clearLastExpireReason() {
        this.sessionManager.clearLastExpireReason();
    }
}

