/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.keyword.constants.ComposerKeywordMessageConstants;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import java.text.MessageFormat;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DuplicatedImportDialog
extends AbstractDialog {
    public static final int KEEP_BOTH_ID = 22;
    private Composite container;
    private String existedFileName;
    private Button appliedToAllBtn;
    private boolean applyToAll;

    public DuplicatedImportDialog(Shell parentShell, String fileName) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setDialogTitle(StringConstants.DIA_TITLE_IMPORT_KEYWORD);
        this.existedFileName = fileName;
        this.applyToAll = false;
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        String warningMsg = MessageFormat.format(ComposerKeywordMessageConstants.DIA_MSG_FILE_ALREADY_EXIST_WARN, this.existedFileName);
        StyledText text = new StyledText(this.container, 0);
        text.setText(warningMsg);
        StyleRange boldStyle = new StyleRange();
        boldStyle.start = warningMsg.indexOf(this.existedFileName);
        boldStyle.length = this.existedFileName.length();
        boldStyle.fontStyle = 1;
        text.setStyleRange(boldStyle);
        text.setBackground(this.container.getBackground());
        this.appliedToAllBtn = new Button(this.container, 32);
        this.appliedToAllBtn.setText(StringConstants.DIA_BTN_APPLY_THIS_ACTION_TO_ALL);
        this.appliedToAllBtn.setSelection(false);
        return this.container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, StringConstants.DIA_BTN_OVERWRITE, true);
        this.createButton(parent, 5, StringConstants.DIA_BTN_SKIP, true);
        this.createButton(parent, 22, StringConstants.DIA_BTN_KEEP_BOTH, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        this.setReturnCode(buttonId);
        this.close();
    }

    protected void registerControlModifyListeners() {
        this.appliedToAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DuplicatedImportDialog.this.setApplyToAll(DuplicatedImportDialog.this.appliedToAllBtn.getSelection());
            }
        });
    }

    protected void setInput() {
    }

    public boolean isApplyToAll() {
        return this.applyToAll;
    }

    public void setApplyToAll(boolean applyToAll) {
        this.applyToAll = applyToAll;
    }
}

