/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.parts;

import com.kms.katalon.application.preference.ProjectSettingPreference;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.command.ProjectParameterizedCommandBuilder;
import com.kms.katalon.composer.components.impl.handler.CommandCaller;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.project.constants.ImageConstants;
import com.kms.katalon.composer.project.menu.SampleProjectParameterizedCommandBuilder;
import com.kms.katalon.composer.project.sample.SampleProjectType;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProjectProvider;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class ExplorerGettingStartView {
    private Composite compositeRecentParent;
    private Composite compositeRecentProjects;
    private Composite recentProjectsWrapper;
    private Composite compositeSampleProjects;
    private Composite container;
    private List<Composite> itemProjects = new ArrayList<Composite>();
    private ScrolledComposite recentProjectScrollComposite;
    private GridData gdCompositeRecentParent;
    private GridLayout glCompositeRecentProjects;
    private GridData gdCompositeSampleParent;

    public Composite createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        Label lblGettingStart = new Label(this.container, 0);
        lblGettingStart.setText("START");
        ControlUtils.setFontToBeBold((Control)lblGettingStart);
        Composite compositeProjects = new Composite(this.container, 0);
        compositeProjects.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout glCompositeProject = new GridLayout();
        glCompositeProject.marginTop = 0;
        glCompositeProject.marginLeft = 5;
        glCompositeProject.marginRight = 0;
        glCompositeProject.marginBottom = 0;
        glCompositeProject.verticalSpacing = 7;
        compositeProjects.setLayout((Layout)glCompositeProject);
        if (!ApplicationInfo.isPlatformStudio()) {
            ComponentBuilder.canvas((Composite)compositeProjects).text("New Project").autoSizeMD(140).primaryButton().onClick(event -> this.onNewProjectClicked()).build();
        }
        ComponentBuilder.canvas((Composite)compositeProjects).text("Open Project").autoSizeMD(140).grayButton().onClick(event -> this.onOpenProjectClicked()).build();
        if (!ApplicationInfo.isPlatformStudio()) {
            ComponentBuilder.canvas((Composite)compositeProjects).text("Clone Git Project").autoSizeMD(140).grayButton().onClick(event -> this.onCloneProjectClicked()).build();
        }
        this.compositeRecentParent = new Composite(this.container, 0);
        GridLayout glCompositeRecentParent = new GridLayout();
        glCompositeRecentParent.marginWidth = 0;
        glCompositeRecentParent.marginHeight = 0;
        this.compositeRecentParent.setLayout((Layout)glCompositeRecentParent);
        this.gdCompositeRecentParent = new GridData(16384, 128, true, false);
        this.gdCompositeRecentParent.verticalIndent = 10;
        this.compositeRecentParent.setLayoutData((Object)this.gdCompositeRecentParent);
        if (ApplicationInfo.isPlatformStudio()) {
            this.compositeRecentParent.setBackgroundMode(2);
        }
        Label lblRecent = new Label(this.compositeRecentParent, 0);
        lblRecent.setText("RECENT PROJECTS");
        ControlUtils.setFontToBeBold((Control)lblRecent);
        if (ApplicationInfo.isPlatformStudio()) {
            this.recentProjectsWrapper = (Composite)ComponentBuilder.gridContainer((Composite)this.compositeRecentParent, (int)1, (int)0).fill().build();
            this.compositeRecentProjects = new Composite(this.recentProjectsWrapper, 0);
            this.recentProjectScrollComposite = DialogUtil.autoScroll((Composite)this.recentProjectsWrapper, (int)512, (boolean)true);
            this.recentProjectScrollComposite.setAlwaysShowScrollBars(false);
        } else {
            this.compositeRecentProjects = new Composite(this.compositeRecentParent, 0);
        }
        this.glCompositeRecentProjects = new GridLayout();
        this.glCompositeRecentProjects.marginTop = 0;
        this.glCompositeRecentProjects.marginLeft = 5;
        this.glCompositeRecentProjects.marginRight = 0;
        this.glCompositeRecentProjects.marginBottom = 0;
        this.compositeRecentProjects.setLayout((Layout)this.glCompositeRecentProjects);
        this.setLayoutForRecentComposite();
        if (ApplicationInfo.isPlatformStudio()) {
            ComponentEventUtil.addListeners((Widget)this.compositeRecentParent, event -> {
                Composite firstProjectComposite = this.itemProjects.get(0);
                if (!firstProjectComposite.isDisposed()) {
                    int eachProjectLineHeight;
                    int totalLineHeight;
                    int height = this.compositeRecentProjects.computeSize((int)-1, (int)-1).y;
                    int containerW = this.container.computeSize((int)-1, (int)-1).x;
                    int showHeight = height;
                    if (this.itemProjects.size() > 0 && height >= (totalLineHeight = ((eachProjectLineHeight = this.itemProjects.get((int)0).computeSize((int)-1, (int)-1).y) + this.glCompositeRecentProjects.verticalSpacing) * 10 + eachProjectLineHeight * 3 / 4)) {
                        showHeight = totalLineHeight;
                    }
                    ComponentUtil.setSize((Control)this.recentProjectsWrapper, (int)containerW, (int)showHeight);
                    this.compositeRecentProjects.pack();
                    this.recentProjectsWrapper.pack();
                    this.recentProjectScrollComposite.setMinSize(containerW, height);
                }
            }, (int[])new int[]{11});
            this.recentProjectScrollComposite.pack();
            this.compositeRecentParent.pack();
        }
        Composite compositeSampleParent = new Composite(this.container, 0);
        GridLayout glCompositeSampleParent = new GridLayout();
        glCompositeSampleParent.marginWidth = 0;
        glCompositeSampleParent.marginHeight = 0;
        compositeSampleParent.setLayout((Layout)glCompositeSampleParent);
        this.gdCompositeSampleParent = new GridData(16384, 128, false, false);
        this.gdCompositeSampleParent.verticalIndent = 10;
        compositeSampleParent.setLayoutData((Object)this.gdCompositeSampleParent);
        if (!ApplicationInfo.isPlatformStudio()) {
            Label lblSample = new Label(compositeSampleParent, 0);
            lblSample.setText("SAMPLE PROJECTS");
            ControlUtils.setFontToBeBold((Control)lblSample);
        }
        this.compositeSampleProjects = new Composite(compositeSampleParent, 0);
        GridLayout glCompositeSampleProjects = new GridLayout();
        glCompositeSampleProjects.marginTop = 0;
        glCompositeSampleProjects.marginLeft = 5;
        glCompositeSampleProjects.marginRight = 0;
        glCompositeSampleProjects.marginBottom = 0;
        this.compositeSampleProjects.setLayout((Layout)glCompositeSampleProjects);
        this.setLayoutForSampleComposite();
        return this.container;
    }

    public void refreshRecentProjects() {
        while (this.compositeRecentProjects.getChildren().length > 0) {
            this.compositeRecentProjects.getChildren()[0].dispose();
        }
        if (ApplicationInfo.isPlatformStudio()) {
            this.itemProjects.clear();
            this.setLayoutForRecentComposite();
            ComponentEventUtil.trigger((Widget)this.compositeRecentParent, (int)11, null);
            this.recentProjectScrollComposite.pack();
            this.compositeRecentParent.pack();
        } else {
            this.setLayoutForRecentComposite();
        }
        this.container.layout(true, true);
    }

    private void setLayoutForRecentComposite() {
        if (this.getRecentProjects().isEmpty()) {
            this.gdCompositeRecentParent.heightHint = 0;
        } else {
            this.gdCompositeRecentParent.heightHint = -1;
            this.createRecentProjectComposite();
        }
    }

    private void setLayoutForSampleComposite() {
        this.gdCompositeSampleParent.heightHint = -1;
        if (!ApplicationInfo.isPlatformStudio()) {
            this.createSampleProjectComposite();
        }
    }

    private void createRecentProjectComposite() {
        for (final ProjectEntity project : this.getRecentProjects()) {
            Composite compositeItemProject = new Composite(this.compositeRecentProjects, 0);
            GridLayout glCompositeItemProject = new GridLayout(2, false);
            glCompositeItemProject.marginWidth = 0;
            glCompositeItemProject.marginHeight = 0;
            compositeItemProject.setLayout((Layout)glCompositeItemProject);
            if (ApplicationInfo.isPlatformStudio()) {
                compositeItemProject.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
                compositeItemProject.setBackgroundMode(2);
            }
            Link lnkProject = new Link(compositeItemProject, 0);
            lnkProject.setText(String.format("<a>%s</a>", project.getName()));
            lnkProject.setToolTipText(project.getFolderLocation());
            lnkProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Trackings.trackTestExplorerActionUsed((String)"existing_project");
                        new CommandCaller().call(new ProjectParameterizedCommandBuilder().createRecentProjectParameterizedCommand(project));
                    }
                    catch (CommandException ex) {
                        LoggerSingleton.logError((Throwable)ex);
                    }
                }
            });
            StyledText txtProjectLocation = new StyledText(compositeItemProject, 8);
            txtProjectLocation.setText(String.format("(%s)", project.getFolderLocation()));
            StyledString styledString = new StyledString().append(String.format("(%s)", project.getFolderLocation()), StyledString.DECORATIONS_STYLER);
            txtProjectLocation.setStyleRanges(styledString.getStyleRanges());
            this.itemProjects.add(compositeItemProject);
        }
    }

    private void createSampleProjectComposite() {
        for (final SampleRemoteProject project : this.getSampleProjects()) {
            Composite compositeItemProject = new Composite(this.compositeSampleProjects, 0);
            GridLayout glCompositeItemProject = new GridLayout(2, false);
            glCompositeItemProject.marginWidth = 0;
            glCompositeItemProject.marginHeight = 0;
            compositeItemProject.setLayout((Layout)glCompositeItemProject);
            compositeItemProject.setCursor(Display.getDefault().getSystemCursor(21));
            Label projectImage = new Label(compositeItemProject, 0);
            GridData layoutData = new GridData(16384, 0x1000000, false, true);
            projectImage.setLayoutData((Object)layoutData);
            projectImage.setImage(this.getIconImageForProject(project.getType()));
            Label projectName = new Label(compositeItemProject, 0);
            projectName.setText(project.getName());
            GridData layoutData1 = new GridData(16384, 0x1000000, false, false);
            projectName.setLayoutData((Object)layoutData1);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    try {
                        Trackings.trackTestExplorerSampleProject((String)project.getName());
                        new CommandCaller().call(new SampleProjectParameterizedCommandBuilder().createRemoteProjectParameterizedCommand(project));
                    }
                    catch (CommandException ex) {
                        LoggerSingleton.logError((Throwable)ex);
                    }
                }
            };
            compositeItemProject.addMouseListener((MouseListener)mouseAdapter);
            projectImage.addMouseListener((MouseListener)mouseAdapter);
            projectName.addMouseListener((MouseListener)mouseAdapter);
        }
    }

    public Image getIconImageForProject(SampleProjectType projectType) {
        switch (projectType) {
            case MOBILE: {
                return ImageConstants.SAMPLE_MOBILE_16;
            }
            case WS: {
                return ImageConstants.SAMPLE_WS_16;
            }
        }
        return ImageConstants.WEB_ICON;
    }

    private List<ProjectEntity> getRecentProjects() {
        try {
            return new ProjectSettingPreference().getRecentProjects();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<SampleRemoteProject> getSampleProjects() {
        return SampleRemoteProjectProvider.getCachedProjects();
    }

    private void onNewProjectClicked() {
        try {
            Trackings.trackTestExplorerActionUsed((String)"create_new_project");
            new CommandCaller().call("com.kms.katalon.composer.project.command.add");
        }
        catch (CommandException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void onOpenProjectClicked() {
        try {
            Trackings.trackTestExplorerActionUsed((String)"open_project");
            new CommandCaller().call("com.kms.katalon.composer.project.command.open");
        }
        catch (CommandException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void onCloneProjectClicked() {
        try {
            Trackings.trackTestExplorerActionUsed((String)"clone_git_project");
            new CommandCaller().call("com.kms.katalon.composer.integration.git.command.clone");
        }
        catch (CommandException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }
}

