/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.capability.constant.DriverType;
import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.mobile.core.enums.MobileProvider;
import com.katalon.mobile.core.interfaces.IMobileDevice;
import com.katalon.mobile.core.interfaces.IMobileProvider;
import com.katalon.mobile.core.interfaces.IMobileProviderFactory;
import com.katalon.mobile.models.LocalProvider;
import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.constant.ParameterType;
import com.katalon.recorder.core.domain.exception.DriverConnectorInitializationException;
import com.katalon.recorder.core.domain.exception.MissingDeviceSystemPropertiesException;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesException;
import com.katalon.recorder.core.domain.exception.RecordingException;
import com.katalon.recorder.core.domain.exception.SaveTestCaseDialogCancelledException;
import com.katalon.recorder.core.domain.exception.SaveTestObjectDialogCancelledException;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IKeywordRef;
import com.katalon.recorder.core.domain.model.IParameter;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.domain.model.KeywordStep;
import com.katalon.recorder.core.domain.model.SingleParameter;
import com.katalon.recorder.core.infrastructure.IKeywordDefinitionProvider;
import com.katalon.recorder.mobile.core.domain.IMobileRecorderManager;
import com.katalon.recorder.mobile.core.enums.MobileAction;
import com.katalon.recorder.mobile.core.exceptions.ApplicationFileCorruptedException;
import com.katalon.recorder.mobile.core.exceptions.ApplicationFileNotFoundException;
import com.katalon.recorder.mobile.core.exceptions.ApplicationFileTooLargeException;
import com.katalon.recorder.mobile.core.exceptions.ApplicationIdInvalidFormatException;
import com.katalon.recorder.mobile.core.exceptions.ApplicationIdMissingException;
import com.katalon.recorder.mobile.core.exceptions.ApplicationPathMissingException;
import com.katalon.recorder.mobile.core.exceptions.DirectoryNotWritableException;
import com.katalon.recorder.mobile.core.exceptions.DriverNotInitializedException;
import com.katalon.recorder.mobile.core.exceptions.FileAlreadyExistsException;
import com.katalon.recorder.mobile.core.exceptions.InvalidApplicationException;
import com.katalon.recorder.mobile.core.exceptions.InvalidApplicationExtensionException;
import com.katalon.recorder.mobile.core.exceptions.InvalidApplicationIdException;
import com.katalon.recorder.mobile.core.exceptions.InvalidFileTypeException;
import com.katalon.recorder.mobile.core.exceptions.InvalidPathFormatException;
import com.katalon.recorder.mobile.core.exceptions.PageSourceCaptureFailedException;
import com.katalon.recorder.mobile.core.exceptions.ParentDirectoryMissingException;
import com.katalon.recorder.mobile.core.exceptions.ScreenshotCaptureFailedException;
import com.katalon.recorder.mobile.core.exceptions.UnsupportedDriverTypeException;
import com.katalon.recorder.mobile.core.exceptions.UnsupportedScreenshotException;
import com.katalon.recorder.mobile.core.infrastructure.IMobileRecorderPreferences;
import com.katalon.recorder.mobile.core.interfaces.IMobileActionRequest;
import com.katalon.recorder.mobile.core.interfaces.IMobileActionResult;
import com.katalon.recorder.mobile.core.interfaces.IMobileStartRecordingResponse;
import com.katalon.recorder.mobile.core.models.CustomProviderConfiguration;
import com.katalon.recorder.mobile.core.models.IMobileRecordingConnection;
import com.katalon.recorder.mobile.core.models.IMobileRecordingConnectionMetadata;
import com.katalon.recorder.mobile.core.models.MobileActionResult;
import com.katalon.recorder.mobile.core.models.MobileCapturedObject;
import com.katalon.recorder.mobile.core.models.MobileDeviceScreenInfo;
import com.katalon.recorder.mobile.core.models.MobileRecorderConfiguration;
import com.katalon.recorder.mobile.core.models.MobileRecordingConnection;
import com.katalon.recorder.mobile.core.models.MobileRecordingConnectionMetadata;
import com.katalon.recorder.mobile.core.models.MobileSaveTestCaseRequest;
import com.katalon.recorder.mobile.core.models.RemoteProviderConfiguration;
import com.katalon.recorder.mobile.domain.DeviceScreenInfo;
import com.katalon.recorder.mobile.domain.RecordingRunConfiguration;
import com.katalon.recorder.mobile.models.dto.MobileStartRecordingResponse;
import com.katalon.recorder.mobile.utils.CapturedObjectConverter;
import com.katalon.recorder.mobile.utils.FolderEntityConverter;
import com.katalon.recorder.mobile.utils.LocatorStrategyConverter;
import com.katalon.recorder.mobile.utils.MobileActionUtil;
import com.katalon.recorder.mobile.utils.MobileDevicePlatformConverter;
import com.katalon.recorder.mobile.utils.VariableConverter;
import com.katalon.recorder.util.ParameterTypeConverter;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialogV2;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveTestCaseDialog;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverterV2;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.MobileElementHelper;
import com.kms.katalon.composer.project.handlers.SettingHandler;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.handlers.OpenTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.mobile.common.FindElementsResult;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.mobile.helper.MobileScreenCaptor;
import com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.mobile.keyword.internal.MobileLocatorFinder;
import com.kms.katalon.core.model.internal.MobilePlatformExecutionSettings;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testcase.WSVerificationTestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.configuration.CustomRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.CustomRunConfigurationContributor;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.WSVerificationTestCaseExecutedEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.RecordingScriptLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.mobile.driver.AndroidDriverConnector;
import com.kms.katalon.execution.mobile.driver.IosDriverConnector;
import com.kms.katalon.execution.setting.MobileSettingStore;
import com.kms.katalon.execution.util.ExecutionProfileStore;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.swt.widgets.Display;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class MobileRecorderManager
implements IMobileRecorderManager {
    private Logger logger = LoggerFactory.getLogger(MobileRecorderManager.class);
    public final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public final String REMOTE_DRIVER_PROPERTY = "Remote";
    public final String EXISTING_DRIVER_PROPERTY = "Existing";
    public final String START_APPIUM_SERVER_JOB_NAME = "Starting Appium Server";
    public final String START_APPLICATION_JOB_NAME = "Starting application";
    public final String CLOSE_APPLICATION_JOB_NAME = "Closing application";
    public final String GET_CONTEXTS_JOB_NAME = "Getting the application context";
    public final String EXECUTE_ACTION_JOB_NAME = "Executing action";
    public final String SETUP_EXECUTION_SETTINGS_JOB_NAME = "Setup execution settings";
    public final String CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH = PropertySettingStoreUtil.EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + "execution";
    private final String APPIUM_DESIRED_KEY = "appium:desired";
    private final String APPIUM_DESIRED_DEVICE_NAME_KEY = "deviceName";
    private final String APPIUM_DEVICE_NAME_KEY = "appium:deviceName";
    private final int MOBILE_ELEMENT_TIMEOUT_IN_SECONDS = 60;
    @Inject
    private IMobileProviderFactory providerFactory;
    @Inject
    private IMobileRecorderPreferences preferences;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    IKeywordDefinitionProvider keywordDefinitionProvider;
    private final Executor recordingExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setName("RecordingExecutorThread");
        t.setDaemon(true);
        return t;
    });

    private Map<String, Object> buildCommonGeneralExecutionSettings() {
        Object reportProperties;
        DefaultExecutionSetting generalExecutionSetting = new DefaultExecutionSetting();
        int timeout = 60;
        try {
            MobilePlatformExecutionSettings settings;
            MobileSettingStore store = MobileSettingStore.getStore();
            if (store != null && (settings = store.getExecutionSettings()) != null) {
                timeout = settings.getElementTimeoutInSeconds();
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to load mobile settings (IO error), using default timeout: {} seconds", (Object)60, (Object)e);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error loading mobile settings, using default timeout: {} seconds", (Object)60, (Object)e);
        }
        generalExecutionSetting.setTimeout(timeout);
        Map generalProperties = generalExecutionSetting.getGeneralProperties();
        if (generalProperties != null && (reportProperties = generalProperties.get("report")) instanceof Map) {
            Map reportPropertiesMap = (Map)reportProperties;
            reportPropertiesMap.put("screenCaptureOption", false);
        }
        return generalProperties;
    }

    private Map<String, Object> buildCustomExecutionSettings(String profile) throws RecordingException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> executionProperties = new LinkedHashMap<String, Map<String, Object>>();
        executionProperties.put("general", this.buildCommonGeneralExecutionSettings());
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        String configurationFolderPath = projectEntity.getFolderLocation();
        try {
            CustomRunConfiguration customRunConfiguration = new CustomRunConfiguration(configurationFolderPath, profile);
            Map driverConnectors = customRunConfiguration.getDriverConnectors();
            executionProperties.put("drivers", this.getDriverExecutionProperties(driverConnectors));
        }
        catch (ExecutionException | IOException e) {
            throw new DriverConnectorInitializationException(e);
        }
        properties.put("execution", executionProperties);
        return properties;
    }

    private Map<String, Object> buildLocalExecutionSettings(IMobileDevice device) throws RecordingException {
        if (device.getDriverType() == null) {
            throw new UnsupportedDriverTypeException(null);
        }
        if (device.getDeviceSystemProperties() == null || device.getDeviceSystemProperties().isEmpty()) {
            throw new MissingDeviceSystemPropertiesException(device.getDeviceName());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> executionProperties = new LinkedHashMap<String, Map<String, Object>>();
        executionProperties.put("general", this.buildCommonGeneralExecutionSettings());
        HashMap<String, IDriverConnector> driverConnectors = new HashMap<String, IDriverConnector>(2);
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        String configurationFolderPath = projectEntity.getFolderLocation();
        try {
            AndroidDriverConnector driverConnector = null;
            if (DriverType.ANDROID_DRIVER.equals((Object)device.getDriverType())) {
                driverConnector = new AndroidDriverConnector(configurationFolderPath);
            } else if (DriverType.IOS_DRIVER.equals((Object)device.getDriverType())) {
                driverConnector = new IosDriverConnector(configurationFolderPath);
            }
            if (driverConnector != null) {
                driverConnector.updateSystemProperties(device.getDeviceSystemProperties());
                driverConnectors.put("Mobile", (IDriverConnector)driverConnector);
            }
        }
        catch (IOException e) {
            throw new DriverConnectorInitializationException((Throwable)e);
        }
        executionProperties.put("drivers", this.getDriverExecutionProperties(driverConnectors));
        properties.put("execution", executionProperties);
        return properties;
    }

    private Map<String, Object> buildRemoteExecutionSettings() throws RecordingException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> executionProperties = new LinkedHashMap<String, Map<String, Object>>();
        executionProperties.put("general", this.buildCommonGeneralExecutionSettings());
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        String configurationFolderPath = projectEntity.getFolderLocation();
        try {
            RemoteWebRunConfiguration remoteRunConfiguration = new RemoteWebRunConfiguration(configurationFolderPath);
            Map driverConnectors = remoteRunConfiguration.getDriverConnectors();
            executionProperties.put("drivers", this.getDriverExecutionProperties(driverConnectors));
        }
        catch (IOException e) {
            throw new DriverConnectorInitializationException((Throwable)e);
        }
        properties.put("execution", executionProperties);
        return properties;
    }

    public CompletableFuture<String> captureDevicePageSourceAsync() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(() -> {
            try {
                AppiumDriver driver = null;
                try {
                    driver = MobileDriverFactory.getDriver();
                }
                catch (StepFailedException stepFailedException) {
                    throw new DriverNotInitializedException();
                }
                String pageSource = driver.getPageSource();
                if (pageSource == null || pageSource.isEmpty()) {
                    throw new PageSourceCaptureFailedException();
                }
                future.complete(pageSource);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<MobileDeviceScreenInfo> captureDeviceScreenInfoAsync() {
        CompletableFuture<MobileDeviceScreenInfo> future = new CompletableFuture<MobileDeviceScreenInfo>();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(() -> {
            try {
                AppiumDriver driver = null;
                try {
                    driver = MobileDriverFactory.getDriver();
                }
                catch (StepFailedException stepFailedException) {
                    throw new DriverNotInitializedException();
                }
                Dimension screenSize = driver.manage().window().getSize();
                int screenWidth = screenSize.getWidth();
                int screenHeight = screenSize.getHeight();
                float scaleFactor = 1.0f;
                if (driver instanceof IOSDriver) {
                    IOSDriver iosDriver = (IOSDriver)driver;
                    Object info = iosDriver.executeScript("mobile: deviceScreenInfo", new Object[0]);
                    if (info == null) {
                        throw new RecordingException("The raw data is null.");
                    }
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        String json = mapper.writeValueAsString(info);
                        DeviceScreenInfo screenInfo = (DeviceScreenInfo)mapper.readValue(json, DeviceScreenInfo.class);
                        scaleFactor = screenInfo.getScale();
                    }
                    catch (JsonProcessingException e) {
                        throw new RecordingException("Failed to parse screen info", (Throwable)e);
                    }
                }
                MobileDeviceScreenInfo deviceScreenInfo = new MobileDeviceScreenInfo(screenWidth, screenHeight, scaleFactor);
                future.complete(deviceScreenInfo);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<String> captureDeviceScreenshotAsync() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(() -> {
            try {
                AppiumDriver driver = null;
                try {
                    driver = MobileDriverFactory.getDriver();
                }
                catch (StepFailedException stepFailedException) {
                    throw new DriverNotInitializedException();
                }
                if (!(driver instanceof TakesScreenshot)) {
                    throw new UnsupportedScreenshotException();
                }
                String screenshot = "";
                try {
                    screenshot = (String)driver.getScreenshotAs(OutputType.BASE64);
                }
                catch (WebDriverException webDriverException) {
                    throw new ScreenshotCaptureFailedException();
                }
                if (screenshot == null || screenshot.isEmpty()) {
                    throw new ScreenshotCaptureFailedException();
                }
                future.complete(screenshot);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<IMobileActionResult> executeActionAsync(IMobileActionRequest request) {
        final CompletableFuture<IMobileActionResult> future = new CompletableFuture<IMobileActionResult>();
        MobileAction action = request.getAction();
        IStep step = request.getStep();
        IKeywordDefinition keywordDefinition = this.keywordDefinitionProvider.lookup(KeywordPlatform.MOBILE, action.getMethodName(), step.getArguments().size());
        step.setKeywordDefinition(keywordDefinition);
        List arguments = request.getArguments();
        final List<ICapturedObject> capturedObjects = arguments.stream().filter(obj -> obj instanceof ICapturedObject).map(obj -> (ICapturedObject)obj).toList();
        final IStep executionStep = step;
        final List executionArguments = arguments;
        Job executeActionJob = new Job("Executing action"){

            protected IStatus run(IProgressMonitor monitor) {
                Object value = null;
                try {
                    value = MobileRecorderManager.this.executeStep(executionStep, executionArguments);
                }
                catch (RecordingException e) {
                    MobileRecorderManager.this.logger.error("Failed to execute action.");
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to execute action.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Execute action successfully.");
                future.complete(new MobileActionResult(executionStep, capturedObjects, value));
                return Status.OK_STATUS;
            }
        };
        executeActionJob.schedule();
        return future;
    }

    private Object executeStep(IStep step, List<Object> arguments) throws RecordingException {
        Method method = this.getKeywordMethod(step);
        if (method == null) {
            throw new RecordingException("No method found for step: " + String.valueOf(step));
        }
        List convertedArguments = arguments.stream().map(arg -> arg instanceof ICapturedObject ? CapturedObjectConverter.toMobileTestObject((ICapturedObject)arg) : arg).collect(Collectors.toList());
        Object[] args = convertedArguments == null || convertedArguments.isEmpty() ? new Object[]{} : convertedArguments.toArray();
        try {
            return method.invoke(null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RecordingException("Failed to execute the method: " + method.getName() + " with args " + Arrays.toString(args), (Throwable)e);
        }
    }

    private IStep generateCloseApplicationStep() {
        KeywordStep step = new KeywordStep();
        step.setKeywordDefinition(this.keywordDefinitionProvider.lookup(KeywordPlatform.MOBILE, "closeApplication", 0));
        return step;
    }

    private IStep generateStartApplicationStep(String applicationPath) {
        KeywordStep step = new KeywordStep();
        step.setKeywordDefinition(this.keywordDefinitionProvider.lookup(KeywordPlatform.MOBILE, "startApplication", 2));
        step.setArguments(List.of(applicationPath, Boolean.TRUE));
        return step;
    }

    private IStep generateStartExistingApplicationStep(String applicationId) {
        KeywordStep step = new KeywordStep();
        step.setKeywordDefinition(this.keywordDefinitionProvider.lookup(KeywordPlatform.MOBILE, "startExistingApplication", 1));
        step.setArguments(List.of(applicationId));
        return step;
    }

    private IStep generateGetContextsStep() {
        KeywordStep step = new KeywordStep();
        step.setKeywordDefinition(this.keywordDefinitionProvider.lookup(KeywordPlatform.MOBILE, "getContexts", 0));
        return step;
    }

    public CompletableFuture<List<IMobileDevice>> getDevicesAsync(MobileProvider provider, MobileDevicePlatform platform) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList devices = new ArrayList();
            IMobileProvider mobileDeviceProvider = this.providerFactory.getProvider(provider);
            if (mobileDeviceProvider != null) {
                devices.addAll(mobileDeviceProvider.getDevices(platform));
            }
            return devices;
        });
    }

    private Map<String, Object> getDriverExecutionProperties(Map<String, IDriverConnector> driverConnectors) {
        LinkedHashMap<String, Object> driverProperties = new LinkedHashMap<String, Object>();
        HashMap<String, Map> driverSystemProperties = new HashMap<String, Map>();
        HashMap<String, Map> driverPerferencesProperties = new HashMap<String, Map>();
        for (Map.Entry<String, IDriverConnector> driverConnector : driverConnectors.entrySet()) {
            if (driverConnector == null) continue;
            driverSystemProperties.put(driverConnector.getKey(), driverConnector.getValue().getSystemProperties());
            driverPerferencesProperties.put(driverConnector.getKey(), driverConnector.getValue().getUserConfigProperties());
        }
        driverProperties.put("system", driverSystemProperties);
        driverProperties.put("preferences", driverPerferencesProperties);
        return driverProperties;
    }

    private Method getKeywordMethod(IStep action) throws RecordingException {
        IKeywordDefinition keywordDefinition = action.getKeywordDefinition();
        IKeywordRef keywordRef = keywordDefinition.getKeywordRef();
        List parameters = keywordDefinition.getParameters();
        List singles = parameters.stream().filter(p -> p instanceof SingleParameter).map(p -> (SingleParameter)p).collect(Collectors.toList());
        if (KeywordPlatform.MOBILE.equals((Object)keywordRef.getPlatform())) {
            Object[] paramTypes = singles.isEmpty() ? new Class[]{} : (Class[])singles.stream().map(p -> ParameterTypeConverter.toClass((ParameterType)p.getType())).toArray(Class[]::new);
            try {
                return MobileBuiltInKeywords.class.getMethod(keywordRef.getName(), (Class<?>[])paramTypes);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RecordingException("Cannot find keyword method: " + keywordRef.getName() + " with params " + Arrays.toString(paramTypes), (Throwable)e);
            }
        }
        return null;
    }

    private String getAppiumServerUrl() {
        return AppiumDriverManager.getAppiumServerUrl();
    }

    private String getAppiumExistingSessionId() throws DriverNotInitializedException {
        AppiumDriver driver = null;
        try {
            driver = MobileDriverFactory.getDriver();
        }
        catch (StepFailedException stepFailedException) {
            throw new DriverNotInitializedException();
        }
        return driver.getSessionId().toString();
    }

    public int getNewCommandTimeout() throws RecordingException {
        AppiumDriver driver = null;
        try {
            driver = MobileDriverFactory.getDriver();
        }
        catch (StepFailedException stepFailedException) {
            throw new DriverNotInitializedException();
        }
        driver.manage().timeouts();
        Capabilities capabilities = driver.getCapabilities();
        Object timeoutObj = capabilities.getCapability("newCommandTimeout");
        if (timeoutObj == null) {
            return 0;
        }
        if (timeoutObj instanceof Number) {
            return ((Number)timeoutObj).intValue();
        }
        try {
            return Integer.parseInt(timeoutObj.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private TestCaseEntity getTestCase(String testCaseName, FolderEntity testCaseFolder, SaveTestCaseDialog.ExportTestCaseOption exportOption) throws Exception {
        switch (exportOption) {
            case APPEND_TO_TEST_CASE: 
            case OVERWRITE_TEST_CASE: {
                return TestCaseController.getInstance().getTestCaseByDisplayId(testCaseFolder.getIdForDisplay() + "/" + testCaseName);
            }
            case EXPORT_TO_NEW_TEST_CASE: {
                TestCaseEntity testCaseEntity = TestCaseController.getInstance().newTestCaseWithoutSave(testCaseFolder, testCaseName);
                return TestCaseController.getInstance().saveNewTestCase(testCaseEntity);
            }
        }
        return null;
    }

    private int getTextObjectIndex(IStep step) {
        IKeywordDefinition keywordDefinition = step.getKeywordDefinition();
        if (keywordDefinition == null || keywordDefinition.getParameters() == null) {
            return -1;
        }
        List parameters = keywordDefinition.getParameters();
        List arguments = step.getArguments();
        if (arguments == null || parameters.size() != arguments.size()) {
            return -1;
        }
        int i = 0;
        while (i < parameters.size()) {
            SingleParameter singleParam;
            IParameter param = (IParameter)parameters.get(i);
            if (param instanceof SingleParameter && ParameterType.TEST_OBJECT.equals((Object)(singleParam = (SingleParameter)param).getType())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void heartbeat() throws RecordingException {
        AppiumDriver driver = null;
        try {
            driver = MobileDriverFactory.getDriver();
        }
        catch (StepFailedException stepFailedException) {
            throw new DriverNotInitializedException();
        }
        driver.findElement(By.xpath((String)"/*"));
    }

    public MobileRecorderConfiguration loadConfiguration() throws RecorderPreferencesException {
        return this.preferences.loadConfiguration();
    }

    public void saveConfiguration(MobileRecorderConfiguration configuration) throws RecorderPreferencesException {
        this.preferences.saveConfiguration(configuration);
    }

    public void saveTestCase(MobileSaveTestCaseRequest saveTestCaseRequest) {
        FolderTreeEntity testCaseFolderTree;
        List capturedElements = saveTestCaseRequest.getCapturedElements();
        List steps = saveTestCaseRequest.getSteps();
        List variables = saveTestCaseRequest.getVariables();
        if (!capturedElements.isEmpty()) {
            boolean isSelectAllTestObject = saveTestCaseRequest.isSelectAllTestObject();
            FolderEntity testObjectFolder = saveTestCaseRequest.getTestObjectFolder();
            testCaseFolderTree = FolderEntityConverter.getFolderTree(testObjectFolder);
            AddElementToObjectRepositoryDialogV2.ConflictOptions testObjectConflictOption = saveTestCaseRequest.getTestObjectConflictOption();
            List conflictedElementEntities = saveTestCaseRequest.getConflictedElementEntities();
            AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult addTestObjectResult = new AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult(isSelectAllTestObject, capturedElements, testCaseFolderTree, testObjectConflictOption, capturedElements.size(), conflictedElementEntities);
            CapturedMobileElementConverterV2 converter = new CapturedMobileElementConverterV2();
            MobileElementHelper helper = new MobileElementHelper();
            ArrayList<WebElementTreeEntity> selectedTreeEntities = new ArrayList<WebElementTreeEntity>();
            for (CapturedMobileElement capturedElement : capturedElements) {
                try {
                    if (capturedElement.isConflicted()) {
                        helper.addConflictedMobileElement(capturedElement, addTestObjectResult, selectedTreeEntities);
                        continue;
                    }
                    MobileElementEntity mobileElement = converter.convert(capturedElement, testObjectFolder);
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)mobileElement);
                    capturedElement.setScriptId(mobileElement.getIdForDisplay());
                    selectedTreeEntities.add(new WebElementTreeEntity((WebElementEntity)mobileElement, (ITreeEntity)testCaseFolderTree));
                }
                catch (Exception e2) {
                    this.logger.error(e2.getMessage());
                }
            }
            ExplorerPart.getInstance().setSelectedItems(selectedTreeEntities.toArray());
            for (IStep step : steps) {
                int index = this.getTextObjectIndex(step);
                if (index < 0) continue;
                String name = (String)step.getArguments().get(index);
                Optional<CapturedMobileElement> first = capturedElements.stream().filter(e -> e.getScriptId().endsWith("/" + name)).findFirst();
                first.ifPresent(e -> {
                    String string = step.getArguments().set(index, e.getScriptId());
                });
            }
        }
        String testCaseName = saveTestCaseRequest.getTestCaseName();
        FolderEntity testCaseFolder = saveTestCaseRequest.getTestCaseFolder();
        testCaseFolderTree = FolderEntityConverter.getFolderTree(testCaseFolder);
        SaveTestCaseDialog.ExportTestCaseOption exportTestCaseOption = saveTestCaseRequest.getExportTestCaseOption();
        TestCaseEntity testCaseEntity = null;
        try {
            testCaseEntity = this.getTestCase(testCaseName, testCaseFolder, exportTestCaseOption);
        }
        catch (Exception e3) {
            this.logger.error("Failed to retrieve test case: " + e3.getMessage(), (Throwable)e3);
        }
        TestCaseTreeEntity testCaseTreeEntity = new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)testCaseFolderTree);
        ExplorerPart.getInstance().refreshTreeEntity((Object)testCaseFolderTree);
        ExplorerPart.getInstance().setSelectedItems(new Object[]{testCaseTreeEntity});
        MCompositePart part = OpenTestCaseHandler.getInstance().openTestCase(testCaseEntity);
        boolean shouldOverride = false;
        if (SaveTestCaseDialog.ExportTestCaseOption.OVERWRITE_TEST_CASE.equals((Object)exportTestCaseOption)) {
            shouldOverride = true;
        }
        boolean isNewTestCase = false;
        if (SaveTestCaseDialog.ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE.equals((Object)exportTestCaseOption)) {
            isNewTestCase = true;
        }
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)part.getObject();
        TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        testCaseCompositePart.setScriptContentToManual();
        ScriptNodeWrapper scriptNodeWrapper = new ScriptNodeWrapper();
        scriptNodeWrapper.addDefaultImports();
        scriptNodeWrapper.addImport(Keys.class);
        BlockStatementWrapper blockStatementWrapper = scriptNodeWrapper.getBlock();
        for (IStep step : steps) {
            try {
                ExpressionStatementWrapper expressionStatementWrapper = (ExpressionStatementWrapper)MobileActionUtil.generateTestStep(step, (ASTNodeWrapper)scriptNodeWrapper);
                blockStatementWrapper.addChild((ASTNodeWrapper)expressionStatementWrapper);
            }
            catch (Exception e4) {
                this.logger.error(e4.getMessage());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(scriptNodeWrapper);
        ScriptNodeWrapper script = null;
        try {
            script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)stringBuilder.toString());
        }
        catch (GroovyParsingException e5) {
            this.logger.error("Failed to parse Groovy script: " + e5.getMessage(), (Throwable)e5);
        }
        List children = script.getBlock().getAstChildren();
        if (shouldOverride) {
            testCasePart.clearAndAddStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        } else {
            testCasePart.addStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        }
        testCasePart.addImports(script.getImports());
        testCasePart.getTreeTableInput().setChanged(true);
        if (!variables.isEmpty()) {
            VariableEntity[] variableEntities = (VariableEntity[])variables.stream().map(v -> VariableConverter.toEntity(v)).toArray(VariableEntity[]::new);
            testCasePart.addVariables(variableEntities);
        }
        testCaseCompositePart.changeScriptNode(testCasePart.getTreeTableInput().getMainClassNode());
        try {
            testCaseCompositePart.recorderSave(isNewTestCase);
        }
        catch (Exception e6) {
            this.logger.error("Failed to save test case: " + e6.getMessage(), (Throwable)e6);
        }
    }

    public CompletableFuture<IMobileStartRecordingResponse> startCustomRecordingAsync(String profileName, String applicationPath, String applicationId) {
        final CompletableFuture<IMobileStartRecordingResponse> future = new CompletableFuture<IMobileStartRecordingResponse>();
        final MobileStartRecordingResponse mobileStartRecordingResponse = new MobileStartRecordingResponse();
        try {
            RunConfiguration.setExecutionSetting(this.buildCustomExecutionSettings(profileName));
        }
        catch (RecordingException e) {
            future.completeExceptionally(e);
        }
        IStep step = null;
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)applicationPath)) {
            step = this.generateStartApplicationStep(applicationPath);
            arguments.add(applicationPath);
            arguments.add(Boolean.TRUE);
        } else if (StringUtils.isNotEmpty((CharSequence)applicationId)) {
            step = this.generateStartExistingApplicationStep(applicationId);
            arguments.add(applicationId);
        } else {
            Map preferencesProperties = RunConfiguration.getDriverPreferencesProperties((String)"Remote");
            applicationPath = (String)preferencesProperties.get("app");
            if (StringUtils.isNotEmpty((CharSequence)applicationPath)) {
                step = this.generateStartApplicationStep(applicationPath);
                arguments.add(applicationPath);
                arguments.add(Boolean.TRUE);
            } else {
                Map systemProperties = RunConfiguration.getDriverSystemProperties((String)"Remote");
                String remoteMobileDriver = (String)systemProperties.get("remoteMobileDriver");
                if (StringUtils.isNotEmpty((CharSequence)remoteMobileDriver)) {
                    DriverType driverType = DriverType.valueOf((String)remoteMobileDriver);
                    if (DriverType.ANDROID_DRIVER.equals((Object)driverType)) {
                        applicationId = (String)preferencesProperties.get("appPackage");
                    } else if (DriverType.IOS_DRIVER.equals((Object)driverType)) {
                        applicationId = (String)preferencesProperties.get("bundleId");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)applicationId)) {
                        step = this.generateStartExistingApplicationStep(applicationId);
                        arguments.add(applicationId);
                    }
                }
            }
        }
        mobileStartRecordingResponse.setApplicationPath(applicationPath);
        mobileStartRecordingResponse.setApplicationId(applicationId);
        final IStep executionStep = step;
        final ArrayList<Object> executionArguments = arguments;
        Job startApplicationJob = new Job("Starting application"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AppiumDriver driver;
                    MobileRecorderManager.this.executeStep(executionStep, executionArguments);
                    try {
                        driver = MobileDriverFactory.getDriver();
                    }
                    catch (StepFailedException stepFailedException) {
                        throw new DriverNotInitializedException();
                    }
                    Capabilities capabilities = driver.getCapabilities();
                    String deviceId = (String)capabilities.getCapability("appium:udid");
                    mobileStartRecordingResponse.setDeviceId(deviceId);
                    MobileDevicePlatform devicePlatform = null;
                    if (driver instanceof AndroidDriver) {
                        devicePlatform = MobileDevicePlatform.ANDROID;
                    } else if (driver instanceof IOSDriver) {
                        devicePlatform = MobileDevicePlatform.IOS;
                    }
                    mobileStartRecordingResponse.setDevicePlatform(devicePlatform);
                    mobileStartRecordingResponse.setCapabilities(MobileRecorderManager.this.toMap(capabilities));
                }
                catch (RecordingException e) {
                    MobileRecorderManager.this.logger.error("Failed to start application.", (Throwable)e);
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to start application.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Started application successfully.");
                mobileStartRecordingResponse.setStep(executionStep);
                mobileStartRecordingResponse.setMobileRecordingConnection(MobileRecorderManager.this.generateMobileRecordingConnectionInfo(mobileStartRecordingResponse));
                future.complete(mobileStartRecordingResponse);
                return Status.OK_STATUS;
            }
        };
        startApplicationJob.schedule();
        return future;
    }

    public CompletableFuture<IMobileStartRecordingResponse> startLocalRecordingAsync(final MobileDevicePlatform devicePlatform, final String deviceId, String applicationPath, String applicationId) {
        final CompletableFuture<IMobileStartRecordingResponse> future = new CompletableFuture<IMobileStartRecordingResponse>();
        final MobileStartRecordingResponse mobileStartRecordingResponse = new MobileStartRecordingResponse();
        mobileStartRecordingResponse.setDeviceId(deviceId);
        mobileStartRecordingResponse.setDevicePlatform(devicePlatform);
        mobileStartRecordingResponse.setApplicationPath(applicationPath);
        mobileStartRecordingResponse.setApplicationId(applicationId);
        IStep step = null;
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)applicationPath)) {
            step = this.generateStartApplicationStep(applicationPath);
            arguments.add(applicationPath);
            arguments.add(Boolean.TRUE);
        } else if (StringUtils.isNotEmpty((CharSequence)applicationId)) {
            step = this.generateStartExistingApplicationStep(applicationId);
            arguments.add(applicationId);
        }
        Job setupExecutionSettingsJob = new Job("Setup execution settings"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LocalProvider localDeviceProvider = (LocalProvider)MobileRecorderManager.this.providerFactory.getProvider(MobileProvider.LOCAL);
                    List devices = localDeviceProvider.getDevices(devicePlatform);
                    IMobileDevice device = devices.stream().filter(d -> deviceId.equals(d.getDeviceId())).findFirst().orElse(null);
                    RunConfiguration.setExecutionSetting(MobileRecorderManager.this.buildLocalExecutionSettings(device));
                }
                catch (RecordingException e) {
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to setup execution settings.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Setup execution settings successfully.");
                return Status.OK_STATUS;
            }
        };
        final Job startAppiumServerJob = new Job("Starting Appium Server"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
                    String logFilePath = projectEntity.getFolderLocation() + File.separator + "appium.log";
                    RunConfiguration.setAppiumLogFilePath((String)logFilePath);
                    AppiumDriverManager.startAppiumServerJS((int)120, line -> {
                        boolean bl = MobileRecorderManager.this.eventBroker.post("appium/update/log", (Object)line);
                    });
                }
                catch (Exception e) {
                    MobileRecorderManager.this.logger.error("Failed to start appium server.", (Throwable)e);
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to start appium server.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Started appium server successfully.");
                return Status.OK_STATUS;
            }
        };
        final IStep executionStep = step;
        final ArrayList<Object> executionArguments = arguments;
        final Job startApplicationJob = new Job("Starting application"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AppiumDriver driver;
                    MobileRecorderManager.this.executeStep(executionStep, executionArguments);
                    try {
                        driver = MobileDriverFactory.getDriver();
                    }
                    catch (StepFailedException stepFailedException) {
                        throw new DriverNotInitializedException();
                    }
                    Capabilities capabilities = driver.getCapabilities();
                    mobileStartRecordingResponse.setCapabilities(MobileRecorderManager.this.toMap(capabilities));
                }
                catch (RecordingException e) {
                    MobileRecorderManager.this.logger.error("Failed to start application.", (Throwable)e);
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to start application.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Started application successfully.");
                mobileStartRecordingResponse.setStep(executionStep);
                mobileStartRecordingResponse.setMobileRecordingConnection(MobileRecorderManager.this.generateMobileRecordingConnectionInfo(mobileStartRecordingResponse));
                future.complete(mobileStartRecordingResponse);
                return Status.OK_STATUS;
            }
        };
        setupExecutionSettingsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    startAppiumServerJob.schedule();
                    return;
                }
                if (startAppiumServerJob != null) {
                    startAppiumServerJob.cancel();
                }
            }
        });
        startAppiumServerJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    startApplicationJob.schedule();
                    return;
                }
                if (startApplicationJob != null) {
                    startApplicationJob.cancel();
                }
            }
        });
        setupExecutionSettingsJob.schedule();
        return future;
    }

    public CompletableFuture<IMobileStartRecordingResponse> startRemoteRecordingAsync(String applicationPath, String applicationId) {
        final CompletableFuture<IMobileStartRecordingResponse> future = new CompletableFuture<IMobileStartRecordingResponse>();
        final MobileStartRecordingResponse mobileStartRecordingResponse = new MobileStartRecordingResponse();
        try {
            RunConfiguration.setExecutionSetting(this.buildRemoteExecutionSettings());
        }
        catch (RecordingException e) {
            future.completeExceptionally(e);
        }
        IStep step = null;
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)applicationPath)) {
            step = this.generateStartApplicationStep(applicationPath);
            arguments.add(applicationPath);
            arguments.add(Boolean.TRUE);
        } else if (StringUtils.isNotEmpty((CharSequence)applicationId)) {
            step = this.generateStartExistingApplicationStep(applicationId);
            arguments.add(applicationId);
        } else {
            Map preferencesProperties = RunConfiguration.getDriverPreferencesProperties((String)"Remote");
            applicationPath = (String)preferencesProperties.get("app");
            if (StringUtils.isNotEmpty((CharSequence)applicationPath)) {
                step = this.generateStartApplicationStep(applicationPath);
                arguments.add(applicationPath);
                arguments.add(Boolean.TRUE);
            } else {
                Map systemProperties = RunConfiguration.getDriverSystemProperties((String)"Remote");
                String remoteMobileDriver = (String)systemProperties.get("remoteMobileDriver");
                if (StringUtils.isNotEmpty((CharSequence)remoteMobileDriver)) {
                    DriverType driverType = DriverType.valueOf((String)remoteMobileDriver);
                    if (DriverType.ANDROID_DRIVER.equals((Object)driverType)) {
                        applicationId = (String)preferencesProperties.get("appPackage");
                    } else if (DriverType.IOS_DRIVER.equals((Object)driverType)) {
                        applicationId = (String)preferencesProperties.get("bundleId");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)applicationId)) {
                    step = this.generateStartExistingApplicationStep(applicationId);
                    arguments.add(applicationId);
                }
            }
        }
        mobileStartRecordingResponse.setApplicationPath(applicationPath);
        mobileStartRecordingResponse.setApplicationId(applicationId);
        final IStep executionStep = step;
        final ArrayList<Object> executionArguments = arguments;
        Job startApplicationJob = new Job("Starting application"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AppiumDriver driver;
                    MobileRecorderManager.this.executeStep(executionStep, executionArguments);
                    try {
                        driver = MobileDriverFactory.getDriver();
                    }
                    catch (StepFailedException stepFailedException) {
                        throw new DriverNotInitializedException();
                    }
                    Capabilities capabilities = driver.getCapabilities();
                    String deviceId = (String)capabilities.getCapability("appium:udid");
                    mobileStartRecordingResponse.setDeviceId(deviceId);
                    MobileDevicePlatform devicePlatform = null;
                    if (driver instanceof AndroidDriver) {
                        devicePlatform = MobileDevicePlatform.ANDROID;
                    } else if (driver instanceof IOSDriver) {
                        devicePlatform = MobileDevicePlatform.IOS;
                    }
                    mobileStartRecordingResponse.setDevicePlatform(devicePlatform);
                    mobileStartRecordingResponse.setCapabilities(MobileRecorderManager.this.toMap(capabilities));
                }
                catch (RecordingException e) {
                    MobileRecorderManager.this.logger.error("Failed to start application.", (Throwable)e);
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to start application.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Started application successfully.");
                mobileStartRecordingResponse.setStep(executionStep);
                mobileStartRecordingResponse.setMobileRecordingConnection(MobileRecorderManager.this.generateMobileRecordingConnectionInfo(mobileStartRecordingResponse));
                future.complete(mobileStartRecordingResponse);
                return Status.OK_STATUS;
            }
        };
        startApplicationJob.schedule();
        return future;
    }

    public CompletableFuture<IStep> stopRecordingAsync() {
        IStep step;
        final CompletableFuture<IStep> future = new CompletableFuture<IStep>();
        final IStep executionStep = step = this.generateCloseApplicationStep();
        final ArrayList executionArguments = new ArrayList();
        Job closeApplicationJob = new Job("Closing application"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MobileRecorderManager.this.executeStep(executionStep, executionArguments);
                }
                catch (RecordingException e) {
                    MobileRecorderManager.this.logger.error("Failed to close application.");
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to close application.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Closed application successfully.");
                future.complete(executionStep);
                return Status.OK_STATUS;
            }
        };
        closeApplicationJob.schedule();
        return future;
    }

    public CompletableFuture<Void> validateApplicationId(MobileProvider provider, MobileDevicePlatform platform, String id) {
        return CompletableFuture.runAsync(() -> {
            if (id == null || id.trim().isEmpty()) {
                throw new ApplicationIdMissingException(id);
            }
            String trimmedId = id.trim();
            switch (platform) {
                case ANDROID: {
                    String androidRegex = "^[a-zA-Z][a-zA-Z0-9_]*(\\.[a-zA-Z][a-zA-Z0-9_]*)+$";
                    if (trimmedId.matches(androidRegex)) break;
                    throw new ApplicationIdInvalidFormatException(id, platform);
                }
                case IOS: {
                    String iosRegex = "^[A-Za-z0-9\\-]+(\\.[A-Za-z0-9\\-]+)+$";
                    if (trimmedId.matches(iosRegex)) break;
                    throw new ApplicationIdInvalidFormatException(id, platform);
                }
                default: {
                    throw new InvalidApplicationIdException("Unsupported platform: " + String.valueOf(platform));
                }
            }
        });
    }

    public CompletableFuture<Void> validateApplicationPath(MobileProvider provider, MobileDevicePlatform platform, String path) {
        return CompletableFuture.runAsync(() -> {
            if (path == null || path.trim().isEmpty()) {
                throw new ApplicationPathMissingException(path);
            }
            File file = new File(path);
            if (!file.exists()) {
                throw new ApplicationFileNotFoundException(path);
            }
            long limit = 0x20000000L;
            long fileSize = file.length();
            if (fileSize > limit) {
                throw new ApplicationFileTooLargeException(path, fileSize, limit);
            }
            String lowerPath = path.toLowerCase();
            switch (platform) {
                case ANDROID: {
                    if (lowerPath.endsWith(".apk") || lowerPath.endsWith(".aab")) break;
                    throw new InvalidApplicationExtensionException(path, platform);
                }
                case IOS: {
                    if (lowerPath.endsWith(".ipa") || lowerPath.endsWith(".app")) break;
                    throw new InvalidApplicationExtensionException(path, platform);
                }
                default: {
                    throw new InvalidApplicationException("Unsupported platform: " + String.valueOf(platform));
                }
            }
            if (!file.canRead() || fileSize == 0L) {
                throw new ApplicationFileCorruptedException(path);
            }
        });
    }

    public CompletableFuture<List<MobileProvider>> getSupportedProvidersAsync() {
        return CompletableFuture.supplyAsync(() -> this.providerFactory.getSupportedProviders());
    }

    public CompletableFuture<List<IKeywordDefinition>> getMobileKeywordDefinitionsAsync() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList keywords = new ArrayList();
            keywords.addAll(this.keywordDefinitionProvider.getKeywordDefinitions(KeywordPlatform.MOBILE));
            keywords.addAll(this.keywordDefinitionProvider.getCustomKeywordDefinitions());
            return keywords;
        });
    }

    public CompletableFuture<List<String>> getApplicationContextsAsync() {
        IStep step;
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        final IStep executionStep = step = this.generateGetContextsStep();
        final ArrayList executionArguments = new ArrayList();
        Job job = new Job("Getting the application context"){

            protected IStatus run(IProgressMonitor monitor) {
                List contexts = new ArrayList();
                try {
                    contexts = (List)MobileRecorderManager.this.executeStep(executionStep, executionArguments);
                }
                catch (RecordingException e) {
                    MobileRecorderManager.this.logger.error("Failed to get contexts.");
                    future.completeExceptionally(e);
                    return new Status(8, "com.katalon.recorder.mobile", "Failed to get contexts.", (Throwable)e);
                }
                MobileRecorderManager.this.logger.info("Get contexts successfully.");
                future.complete(contexts);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return future;
    }

    public CompletableFuture<TestStatus.TestStatusValue> runSteps(MobileDevicePlatform mobileDevicePlatform, List<IStep> steps, List<ICapturedObject> capturedObjects, List<IVariable> variables) {
        return CompletableFuture.supplyAsync(() -> {
            String sessionId = null;
            try {
                sessionId = this.getAppiumExistingSessionId();
            }
            catch (DriverNotInitializedException e) {
                throw new CompletionException(e);
            }
            File recordSessionFolder = new File(ProjectController.getInstance().getTempDir(), "record/" + sessionId);
            recordSessionFolder.mkdirs();
            File capturedObjectsFile = new File(recordSessionFolder, "captured_objects.json");
            this.writeCapturedObjectsToFile(capturedObjects, capturedObjectsFile);
            ScriptNodeWrapper scriptNodeWrapper = this.buildScriptNode(steps);
            String script = this.buildGroovyScript(scriptNodeWrapper);
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            WSVerificationTestCaseEntity testCaseEntity = new WSVerificationTestCaseEntity();
            testCaseEntity.setId("MobileVerification_" + System.currentTimeMillis());
            testCaseEntity.setVariables(new ArrayList());
            testCaseEntity.setProject(project);
            testCaseEntity.setScript(script);
            String appiumServerUrl = this.getAppiumServerUrl();
            MobileDriverType mobileDriverType = MobileDevicePlatformConverter.toMobileDriverType(mobileDevicePlatform);
            RecordingRunConfiguration runConfiguration = new RecordingRunConfiguration(project.getFolderLocation(), sessionId, appiumServerUrl, mobileDriverType.toString());
            runConfiguration.setCapturedTestObjectsCacheFile(capturedObjectsFile);
            runConfiguration.setExecutionProfile(ExecutionProfileStore.getInstance().getSelectedProfile());
            try {
                runConfiguration.build((FileEntity)testCaseEntity, (IExecutedEntity)new WSVerificationTestCaseExecutedEntity(testCaseEntity));
            }
            catch (ExecutionException | IOException e) {
                throw new CompletionException(e);
            }
            return runConfiguration;
        }, this.recordingExecutor).thenComposeAsync(this::runRecordingAsync, this.recordingExecutor);
    }

    private void writeCapturedObjectsToFile(List<ICapturedObject> capturedObjects, File file) {
        if (capturedObjects.isEmpty()) {
            return;
        }
        HashMap<String, MobileTestObject> capturedObjectsCache = new HashMap<String, MobileTestObject>();
        for (ICapturedObject obj : capturedObjects) {
            MobileTestObject mobileTestObject = CapturedObjectConverter.toMobileTestObject(obj);
            capturedObjectsCache.put(mobileTestObject.getObjectId(), mobileTestObject);
        }
        try {
            FileUtils.write((File)file, (CharSequence)JsonUtil.toJson(capturedObjectsCache), (String)Charset.defaultCharset().name());
        }
        catch (IOException e) {
            this.logger.error("Failed to write captured objects: " + e.getMessage(), (Throwable)e);
        }
    }

    private ScriptNodeWrapper buildScriptNode(List<IStep> steps) {
        ScriptNodeWrapper scriptNodeWrapper = new ScriptNodeWrapper();
        scriptNodeWrapper.addDefaultImports();
        scriptNodeWrapper.addImport(Keys.class);
        BlockStatementWrapper block = scriptNodeWrapper.getBlock();
        for (IStep step : steps) {
            try {
                ExpressionStatementWrapper expr = (ExpressionStatementWrapper)MobileActionUtil.generateTestStep(step, (ASTNodeWrapper)scriptNodeWrapper);
                block.addChild((ASTNodeWrapper)expr);
            }
            catch (Exception e) {
                this.logger.error("Failed to generate step: " + e.getMessage(), (Throwable)e);
            }
        }
        return scriptNodeWrapper;
    }

    private String buildGroovyScript(ScriptNodeWrapper nodeWrapper) {
        StringBuilder sb = new StringBuilder();
        new GroovyWrapperParser(sb).parseGroovyAstIntoScript(nodeWrapper);
        return sb.toString();
    }

    private CompletableFuture<TestStatus.TestStatusValue> runRecordingAsync(RecordingRunConfiguration runConfiguration) {
        RecordingScriptLauncher[] launcherHolder;
        CompletableFuture<TestStatus.TestStatusValue> future = new CompletableFuture<TestStatus.TestStatusValue>();
        LauncherManager launcherManager = LauncherManager.getInstance();
        launcherHolder = new RecordingScriptLauncher[]{new RecordingScriptLauncher(launcherManager, (IRunConfiguration)runConfiguration, () -> {
            try {
                ILauncherResult result = launcherHolder[0].getResult();
                TestStatus.TestStatusValue[] statusValues = result.getResultValues();
                future.complete(statusValues[0]);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        })};
        launcherManager.addLauncher((ILauncher)launcherHolder[0]);
        return future;
    }

    public SaveTestCaseDialog.ExportTestCaseSelectionResult openSaveTestCaseDialog() throws RecordingException {
        SaveTestCaseDialog saveTestCaseDialog = new SaveTestCaseDialog(Display.getDefault().getActiveShell());
        if (saveTestCaseDialog.open() != 0) {
            throw new SaveTestCaseDialogCancelledException();
        }
        return saveTestCaseDialog.getResult();
    }

    public AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult openSaveTestObjectDialog(List<ICapturedObject> objects) throws RecordingException {
        if (objects.isEmpty()) {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            FolderEntity rootFolderEntity = null;
            try {
                rootFolderEntity = FolderController.getInstance().getObjectRepositoryRoot(projectEntity);
            }
            catch (Exception exception) {}
            return new AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult(true, new ArrayList(), new FolderTreeEntity(rootFolderEntity, null), AddElementToObjectRepositoryDialogV2.ConflictOptions.CREATE_NEW_OBJECT, 0);
        }
        List mobileElements = objects.stream().map(o -> CapturedObjectConverter.toCapturedMobileElement(o)).collect(Collectors.toList());
        AddElementToObjectRepositoryDialogV2 objectRepositoryDialog = new AddElementToObjectRepositoryDialogV2(Display.getDefault().getActiveShell(), mobileElements, true);
        if (objectRepositoryDialog.open() != 0) {
            throw new SaveTestObjectDialogCancelledException();
        }
        return objectRepositoryDialog.getDialogResult();
    }

    public CompletableFuture<List<WebElement>> findElementsByLocatorTypeAsync(ICapturedObject object, LocatorType locatorType) {
        return CompletableFuture.supplyAsync(() -> {
            AppiumDriver driver;
            try {
                driver = MobileDriverFactory.getDriver();
            }
            catch (StepFailedException stepFailedException) {
                throw new DriverNotInitializedException();
            }
            MobileTestObject testObject = CapturedObjectConverter.toMobileTestObject(object);
            LocatorStrategy locatorStrategy = LocatorStrategyConverter.toStrategy(locatorType);
            try {
                FindElementsResult findElementResult = MobileCommonHelper.findElementsByLocatorStrategy((AppiumDriver)driver, (TestObject)testObject, (int)1, (LocatorStrategy)locatorStrategy);
                return findElementResult.getElements();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<WebElement>> findElementsByDefaultLocatorAsync(ICapturedObject object) {
        return CompletableFuture.supplyAsync(() -> {
            AppiumDriver driver;
            try {
                driver = MobileDriverFactory.getDriver();
            }
            catch (StepFailedException stepFailedException) {
                throw new DriverNotInitializedException();
            }
            MobileTestObject testObject = CapturedObjectConverter.toMobileTestObject(object);
            try {
                FindElementsResult findElementResult = MobileCommonHelper.findElementsByDefaultLocator((AppiumDriver)driver, (TestObject)testObject, (int)1);
                return findElementResult.getElements();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<String> captureElementScreenshot(WebElement element) {
        return CompletableFuture.supplyAsync(() -> {
            AppiumDriver driver;
            try {
                driver = MobileDriverFactory.getDriver();
            }
            catch (StepFailedException stepFailedException) {
                throw new DriverNotInitializedException();
            }
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = MobileScreenCaptor.takeElementScreenshot((AppiumDriver)driver, (WebElement)element, new ArrayList(), (Color)Color.white);
            }
            catch (Exception e) {
                throw new RecordingException("Failed to capture element screenshot", (Throwable)e);
            }
            try {
                Throwable e = null;
                Object var4_7 = null;
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                    byte[] imageBytes = outputStream.toByteArray();
                    return Base64.getEncoder().encodeToString(imageBytes);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new RecordingException("Failed to convert image to Base64", (Throwable)e);
            }
        });
    }

    public void openRemoteCapabilitySetting() {
        SettingHandler.getInstance().openSettingsPage((Object)"com.katalon.composer.capability.settings.default.4");
    }

    public void openCustomCapabilitySetting() {
        SettingHandler.getInstance().openSettingsPage((Object)"com.katalon.composer.capability.settings.default.6");
    }

    public CompletableFuture<ICapturedObject> resetLocatorAsync(ICapturedObject object, LocatorType locatorType) {
        return CompletableFuture.supplyAsync(() -> {
            if (LocatorType.ATTRIBUTES.equals((Object)locatorType)) {
                List attributes = object.getAttributes();
                for (ICapturedObjectAttribute attribute : attributes) {
                    attribute.setEnabled(MobileCapturedObject.STABLE_ATTRIBUTES.contains(attribute.getName()));
                }
            }
            MobileTestObject testObject = CapturedObjectConverter.toMobileTestObject(object);
            LocatorStrategy locatorStrategy = LocatorStrategyConverter.toStrategy(locatorType);
            String locator = MobileLocatorFinder.findLocator((TestObject)testObject, (LocatorStrategy)locatorStrategy);
            object.addLocator(locatorType, locator);
            return object;
        });
    }

    public RemoteProviderConfiguration getRemoteProviderConfiguration() {
        RemoteProviderConfiguration providerConfiguration = new RemoteProviderConfiguration();
        try {
            RemoteWebRunConfiguration remoteRunConfiguration = new RemoteWebRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation());
            Map driverConnectors = remoteRunConfiguration.getDriverConnectors();
            RemoteWebDriverConnector driverConnector = (RemoteWebDriverConnector)driverConnectors.get("Remote");
            if (RemoteWebDriverConnector.RemoteWebDriverConnectorType.Appium.equals((Object)driverConnector.getRemoteWebDriverConnectorType())) {
                String remoteServerUrl = driverConnector.getRemoteServerUrl();
                providerConfiguration.setRemoteServerUrl(remoteServerUrl);
                MobileDriverType driverType = driverConnector.getMobileDriverType();
                if (MobileDriverType.ANDROID_DRIVER.equals((Object)driverType)) {
                    providerConfiguration.setDevicePlatform(MobileDevicePlatform.ANDROID);
                } else if (MobileDriverType.IOS_DRIVER.equals((Object)driverType)) {
                    providerConfiguration.setDevicePlatform(MobileDevicePlatform.IOS);
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        return providerConfiguration;
    }

    public CustomProviderConfiguration getCustomProviderConfiguration() {
        File customProfileSettingFolder;
        CustomProviderConfiguration providerConfiguration = new CustomProviderConfiguration();
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null && (customProfileSettingFolder = new File(currentProject.getFolderLocation() + File.separator + this.CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH)).exists() && customProfileSettingFolder.isDirectory()) {
            HashMap<String, MobileDevicePlatform> customProfiles = new HashMap<String, MobileDevicePlatform>();
            File[] profiles = customProfileSettingFolder.listFiles();
            if (profiles != null) {
                File[] fileArray = profiles;
                int n = profiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File profile = fileArray[n2];
                    if (profile.isDirectory() && !profile.isHidden()) {
                        CustomRunConfigurationContributor customRunConfigurationContributor = new CustomRunConfigurationContributor(profile.getName());
                        try {
                            CustomRunConfiguration runConfiguration = (CustomRunConfiguration)customRunConfigurationContributor.getRunConfiguration(currentProject.getFolderLocation());
                            Map driverConnectors = runConfiguration.getDriverConnectors();
                            RemoteWebDriverConnector driverConnector = (RemoteWebDriverConnector)driverConnectors.get("Remote");
                            if (driverConnector != null && RemoteWebDriverConnector.RemoteWebDriverConnectorType.Appium.equals((Object)driverConnector.getRemoteWebDriverConnectorType())) {
                                MobileDriverType driverType = driverConnector.getMobileDriverType();
                                if (MobileDriverType.ANDROID_DRIVER.equals((Object)driverType)) {
                                    customProfiles.put(profile.getName(), MobileDevicePlatform.ANDROID);
                                } else if (MobileDriverType.IOS_DRIVER.equals((Object)driverType)) {
                                    customProfiles.put(profile.getName(), MobileDevicePlatform.IOS);
                                }
                            }
                        }
                        catch (ExecutionException | IOException e) {
                            this.logger.error(e.getMessage());
                        }
                    }
                    ++n2;
                }
            }
            providerConfiguration.setProfiles(customProfiles);
        }
        return providerConfiguration;
    }

    public CompletableFuture<ICapturedObject> setDefaultLocatorAsync(ICapturedObject object, LocatorType locatorType) {
        return CompletableFuture.supplyAsync(() -> {
            object.setLocatorType(locatorType);
            return object;
        });
    }

    private Map<String, Object> toMap(Capabilities caps) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (caps == null) {
            return map;
        }
        for (String key : caps.getCapabilityNames()) {
            Object value = caps.getCapability(key);
            if (value instanceof Optional) {
                Optional opt = (Optional)value;
                map.put(key, opt.orElse(null));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public CompletableFuture<Void> cleanupAsync() {
        return CompletableFuture.runAsync(() -> AppiumDriverManager.closeDriver());
    }

    private IMobileRecordingConnection generateMobileRecordingConnectionInfo(IMobileStartRecordingResponse response) {
        if (response == null) {
            return null;
        }
        return new MobileRecordingConnection(response.getDeviceId(), (IMobileRecordingConnectionMetadata)new MobileRecordingConnectionMetadata(response.getDevicePlatform() == MobileDevicePlatform.ANDROID ? DriverType.ANDROID_DRIVER : DriverType.IOS_DRIVER, response.getDeviceId(), this.extractDeviceName(response), this.extractApplicationName(response), ""));
    }

    private String extractDeviceName(IMobileStartRecordingResponse response) {
        if (response == null) {
            return "";
        }
        if (response.getCapabilities() != null) {
            String deviceName;
            Map map;
            Map appiumDesiredMap;
            String deviceName2;
            Object appiumDesired;
            Map caps = response.getCapabilities();
            if (caps.get("appium:desired") != null && (appiumDesired = caps.get("appium:desired")) instanceof Map && StringUtils.isNotEmpty((CharSequence)(deviceName2 = (String)(appiumDesiredMap = (map = (Map)appiumDesired)).get("deviceName")))) {
                return deviceName2;
            }
            if (caps.get("appium:deviceName") != null && StringUtils.isNotEmpty((CharSequence)(deviceName = (String)caps.get("appium:deviceName")))) {
                return deviceName;
            }
        }
        return response.getDeviceId();
    }

    private String extractApplicationName(IMobileStartRecordingResponse response) {
        if (response == null) {
            return "";
        }
        String applicationPath = response.getApplicationPath();
        if (StringUtils.isNotEmpty((CharSequence)applicationPath)) {
            try {
                Path path = Paths.get(applicationPath, new String[0]);
                return path.getFileName().toString();
            }
            catch (Exception exception) {
                return applicationPath;
            }
        }
        String applicationId = response.getApplicationId();
        if (StringUtils.isNotEmpty((CharSequence)applicationId)) {
            return applicationId;
        }
        return "";
    }

    public CompletableFuture<Void> validateScreenshotFilePath(String filePath) {
        return CompletableFuture.runAsync(() -> {
            Path path;
            if (filePath == null || filePath.trim().isEmpty()) {
                throw new InvalidPathFormatException();
            }
            try {
                path = Path.of(filePath, new String[0]);
            }
            catch (InvalidPathException e) {
                throw new InvalidPathFormatException((Throwable)e);
            }
            if (!filePath.toLowerCase().endsWith(".png")) {
                throw new InvalidFileTypeException();
            }
            File file = path.toFile();
            File parent = file.getParentFile();
            if (parent == null || !parent.exists()) {
                throw new ParentDirectoryMissingException();
            }
            if (!parent.canWrite()) {
                throw new DirectoryNotWritableException();
            }
            if (file.exists()) {
                throw new FileAlreadyExistsException();
            }
        });
    }
}

