/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.part.composites;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.part.composites.HelpSelfHealingInsightsComposite;
import com.kms.katalon.composer.components.util.ColorUtil;
import java.text.MessageFormat;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelfHealingToolbarComposite
extends Composite {
    private String documentationUrl = SmartXPathMessageConstants.UNDERSTAND_SELF_HEALING_INSIGHTS_DOCUMENT_LINK;
    private Button btnApprove;
    private Button btnDiscard;
    private Button btnConfigure;
    private Label lblHealingStatus;

    public SelfHealingToolbarComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents(this);
    }

    protected void createContents(Composite container) {
        this.configContainer(container);
        this.createStatusComposite(container);
        Composite buttonsComposite = this.createButtonsComposite(container);
        this.createHelpButton(buttonsComposite);
        this.btnConfigure = this.createConfigureButton(buttonsComposite);
        this.btnDiscard = this.createDiscardButton(buttonsComposite);
        this.btnApprove = this.createApproveButton(buttonsComposite);
    }

    protected Composite configContainer(Composite container) {
        GridData toolbarLayoutData = new GridData(4, 4, true, false);
        container.setLayoutData((Object)toolbarLayoutData);
        GridLayout toolbarLayout = new GridLayout(2, false);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        container.setLayout((Layout)toolbarLayout);
        return container;
    }

    protected Composite createStatusComposite(Composite container) {
        Composite statusComposite = new Composite(container, 0);
        statusComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout statusLayout = new GridLayout(2, false);
        statusComposite.setLayout((Layout)statusLayout);
        this.lblHealingStatus = new Label(statusComposite, 64);
        this.lblHealingStatus.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        return statusComposite;
    }

    protected Composite createButtonsComposite(Composite container) {
        Composite buttonsComposite = new Composite(container, 0);
        buttonsComposite.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        RowLayout buttonsLayout = new RowLayout();
        buttonsLayout.wrap = true;
        buttonsLayout.pack = true;
        buttonsLayout.spacing = 5;
        buttonsLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        return buttonsComposite;
    }

    protected Button createApproveButton(Composite buttonsComposite) {
        Button btnApprove = new Button(buttonsComposite, 8);
        btnApprove.setText(SmartXPathMessageConstants.BTN_APPROVE_PROPOSED_LOCATORS);
        Shell shell = btnApprove.getShell();
        if (shell != null) {
            shell.setDefaultButton(btnApprove);
        }
        return btnApprove;
    }

    protected Button createDiscardButton(Composite buttonsComposite) {
        Button btnDiscard = new Button(buttonsComposite, 8);
        btnDiscard.setText(SmartXPathMessageConstants.BTN_DISCARD_PROPOSED_LOCATORS);
        return btnDiscard;
    }

    protected Button createConfigureButton(Composite buttonsComposite) {
        Button btnConfigure = new Button(buttonsComposite, 8);
        btnConfigure.setText(SmartXPathMessageConstants.BTN_CONFIGURE_SELF_HEALING);
        return btnConfigure;
    }

    protected Composite createHelpButton(Composite buttonsComposite) {
        Composite helpComposite = new Composite(buttonsComposite, 0);
        GridLayout helpLayout = new GridLayout();
        helpLayout.marginWidth = 0;
        helpLayout.marginHeight = 2;
        helpComposite.setLayout((Layout)helpLayout);
        helpComposite.setData((Object)new GridData());
        return new HelpSelfHealingInsightsComposite(helpComposite, this.documentationUrl);
    }

    public void setSuccessMessage(String message) {
        this.lblHealingStatus.setText(message);
        this.lblHealingStatus.setForeground(ColorUtil.getTextSuccessfulColor());
        this.lblHealingStatus.requestLayout();
    }

    public void setErrorMessage(String message) {
        this.lblHealingStatus.setText(message);
        this.lblHealingStatus.setForeground(ColorUtil.getTextSuccessfulColor());
        this.lblHealingStatus.requestLayout();
    }

    public void notifyRecoverSucceeded(int numberRecovered) {
        this.setSuccessMessage(MessageFormat.format(numberRecovered == 1 ? SmartXPathMessageConstants.MSG_RECOVER_BROKEN_TEST_OBJECTS_SUCCEEDED_SINGULAR : SmartXPathMessageConstants.MSG_RECOVER_BROKEN_TEST_OBJECTS_SUCCEEDED_PLURAL, numberRecovered));
    }

    public void notifyRecoverFailed() {
        this.setSuccessMessage(SmartXPathMessageConstants.MSG_RECOVER_BROKEN_TEST_OBJECTS_FAILED);
    }

    public void notifyDiscardSucceeded(int numberDiscarded) {
        this.setSuccessMessage(MessageFormat.format(numberDiscarded == 1 ? SmartXPathMessageConstants.MSG_DISCARD_BROKEN_TEST_OBJECTS_SUCCEEDED_SINGULAR : SmartXPathMessageConstants.MSG_DISCARD_BROKEN_TEST_OBJECTS_SUCCEEDED_PLURAL, numberDiscarded));
    }

    public void clearStatusMessage() {
        this.lblHealingStatus.setText("");
        this.lblHealingStatus.requestLayout();
    }

    public void addApproveListener(SelectionListener listener) {
        this.btnApprove.addSelectionListener(listener);
    }

    public void addDiscardListener(SelectionListener listener) {
        this.btnDiscard.addSelectionListener(listener);
    }

    public void addConfigureListener(SelectionListener listener) {
        this.btnConfigure.addSelectionListener(listener);
    }

    public void setMouseTrackListenerToAllButtons(MouseTrackListener listener) {
        this.btnApprove.addMouseTrackListener(listener);
        this.btnDiscard.addMouseTrackListener(listener);
        this.btnConfigure.addMouseTrackListener(listener);
    }
}

