/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.katalon.plugin.smart_xpath.settings.AbstractSettingPage;
import com.katalon.plugin.smart_xpath.settings.composites.HelpCompositeForExecutionDialog;
import com.katalon.plugin.smart_xpath.settings.composites.SelfHealingMobileExcludedKeywordsComposite;
import com.katalon.plugin.smart_xpath.settings.composites.SelfHealingPrioritizedLocatorStrategiesComposite;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.execution.setting.MobileSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class SelfHealingMobileSettingPage
extends AbstractSettingPage {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private static final String LBL_LOCATOR_STRATEGY_SELECTION_FOR_SELF_HEALING_EXECUTION = SmartXPathMessageConstants.LBL_LOCATOR_STRATEGY_SELECTION_FOR_SELF_HEALING_EXECUTION;
    private static final String LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD = SmartXPathMessageConstants.LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD;
    private Button checkboxEnableSelfHealing;
    private SelfHealingMobileExcludedKeywordsComposite excludedKeywordsComposite;
    private SelfHealingPrioritizedLocatorStrategiesComposite prioritizedLocatorStrategiesCompositeForAndroid;
    private SelfHealingPrioritizedLocatorStrategiesComposite prioritizedLocatorStrategiesCompositeForIos;
    private Link link;
    private final String documentationUrl = SmartXPathMessageConstants.SELF_HEALING_DOCUMENT_LINK;
    private MobileSettingStore preferenceStore = MobileSettingStore.getStore();
    private int LOCATOR_STRATEGIES_HEIGHT_HINT = 20;

    private void setInput() {
        try {
            List prioritizedLocatorStrategiesForAndroid = this.preferenceStore.getPrioritizedLocatorStrategies(MobilePlatform.ANDROID);
            this.prioritizedLocatorStrategiesCompositeForAndroid.setInput(prioritizedLocatorStrategiesForAndroid);
            this.prioritizedLocatorStrategiesCompositeForAndroid.setTitle(MobilePlatform.ANDROID.getMobilePlatform());
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        try {
            List prioritizedLocatorStrategiesForIos = this.preferenceStore.getPrioritizedLocatorStrategies(MobilePlatform.IOS);
            this.prioritizedLocatorStrategiesCompositeForIos.setInput(prioritizedLocatorStrategiesForIos);
            this.prioritizedLocatorStrategiesCompositeForIos.setTitle(MobilePlatform.IOS.getMobilePlatform());
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        try {
            this.excludedKeywordsComposite.setInput(this.preferenceStore.getExcludedKeywords());
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        boolean isEnableSelfHealing = this.getEnableSelfHealingFromPluginPreference();
        this.checkboxEnableSelfHealing.setSelection(this.canUseSelfHealing() && isEnableSelfHealing);
    }

    @Override
    protected void createSettingsArea(Composite parent) {
        Composite mainContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        mainContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainContainer.setLayout((Layout)layout);
        this.createCheckboxEnableSelfHealing(mainContainer);
        Composite locatorStrategiesComposite = new Composite(mainContainer, 0);
        GridData locatorStrategiesData = new GridData(4, 128, true, false);
        locatorStrategiesData.heightHint = this.LOCATOR_STRATEGIES_HEIGHT_HINT;
        locatorStrategiesComposite.setLayoutData((Object)locatorStrategiesData);
        GridLayout locatorStrategiesLayout = new GridLayout(2, false);
        locatorStrategiesLayout.verticalSpacing = 10;
        locatorStrategiesLayout.marginHeight = 0;
        locatorStrategiesLayout.marginWidth = 0;
        locatorStrategiesComposite.setLayout((Layout)locatorStrategiesLayout);
        Label locatorStrategiesLabel = new Label(locatorStrategiesComposite, 0);
        locatorStrategiesLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        locatorStrategiesLabel.setText(LBL_LOCATOR_STRATEGY_SELECTION_FOR_SELF_HEALING_EXECUTION);
        this.createLinkDefaultLocatorStrategy(locatorStrategiesComposite);
        Composite prioritizedLocatorStrategiesComposite = new Composite(mainContainer, 0);
        prioritizedLocatorStrategiesComposite.setLayout((Layout)new GridLayout(2, false));
        GridData prioritizedLocatorStrategiesData = new GridData(4, 128, true, false);
        prioritizedLocatorStrategiesComposite.setLayoutData((Object)prioritizedLocatorStrategiesData);
        this.prioritizedLocatorStrategiesCompositeForAndroid = this.buildPrioritizeSelectionMethodsComposite(prioritizedLocatorStrategiesComposite);
        this.prioritizedLocatorStrategiesCompositeForIos = this.buildPrioritizeSelectionMethodsComposite(prioritizedLocatorStrategiesComposite);
        this.createExcludeWithKeywordsComposite(mainContainer);
    }

    private void createLinkDefaultLocatorStrategy(Composite parent) {
        if (this.link == null) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            composite.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
            layout.verticalSpacing = 10;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label linkImage = new Label(composite, 0);
            linkImage.setImage(ImageConstants.IMG_16_SETTING);
            this.link = new Link(composite, 0);
            this.link.setText(String.format("<a>%s</a>", SmartXPathMessageConstants.SELF_HEALING_NAVIGATE_TO_TEST_DESIGN));
            this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingMobileSettingPage.this.navigateToWebUITestDesignPage();
                }
            });
        }
    }

    private void createCheckboxEnableSelfHealing(Composite parent) {
        if (this.checkboxEnableSelfHealing == null) {
            Composite composite = new Composite(parent, 0);
            GridData gridData = new GridData(4, 128, true, false);
            gridData.heightHint = 20;
            composite.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = 10;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.checkboxEnableSelfHealing = new Button(composite, 32);
            this.checkboxEnableSelfHealing.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.checkboxEnableSelfHealing.setText(LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD);
            this.checkboxEnableSelfHealing.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (!SelfHealingMobileSettingPage.this.canUseSelfHealing()) {
                        SelfHealingMobileSettingPage.this.checkboxEnableSelfHealing.setSelection(false);
                        SelfHealingMobileSettingPage.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.SELF_HEALING);
                    }
                    SelfHealingMobileSettingPage.this.handleInputChanged((Control)SelfHealingMobileSettingPage.this.checkboxEnableSelfHealing, null);
                }
            });
            new HelpCompositeForExecutionDialog(composite, this.documentationUrl);
        }
    }

    private SelfHealingPrioritizedLocatorStrategiesComposite buildPrioritizeSelectionMethodsComposite(Composite parent) {
        final SelfHealingPrioritizedLocatorStrategiesComposite prioritizeSelectionMethodsComposite = new SelfHealingPrioritizedLocatorStrategiesComposite(parent, 0);
        prioritizeSelectionMethodsComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelfHealingMobileSettingPage.this.handleInputChanged((Control)prioritizeSelectionMethodsComposite, null);
            }
        });
        return prioritizeSelectionMethodsComposite;
    }

    private void navigateToWebUITestDesignPage() {
        this.eventBroker.post("SETTINGS/PAGE_CHANGE", (Object)"com.kms.katalon.composer.mobile.settings");
    }

    private Composite createExcludeWithKeywordsComposite(Composite parent) {
        if (this.excludedKeywordsComposite == null) {
            this.excludedKeywordsComposite = new SelfHealingMobileExcludedKeywordsComposite(parent, 0);
            this.excludedKeywordsComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingMobileSettingPage.this.handleInputChanged((Control)SelfHealingMobileSettingPage.this.excludedKeywordsComposite, null);
                }
            });
        }
        return this.excludedKeywordsComposite;
    }

    private boolean getEnableSelfHealingFromPluginPreference() {
        return this.preferenceStore.getSelfHealingEnabled(this.canUseSelfHealing());
    }

    @Override
    protected void initialize() throws IOException {
        this.setInput();
    }

    @Override
    protected void performDefaults() {
        try {
            this.preferenceStore.setSelfHealingEnabled(this.canUseSelfHealing());
            this.preferenceStore.setDefaultPrioritizedLocatorStrategies(MobilePlatform.ANDROID);
            this.preferenceStore.setDefaultPrioritizedLocatorStrategies(MobilePlatform.IOS);
            this.preferenceStore.setDefaultExcludedKeywords();
            this.initialize();
        }
        catch (IOException e) {
            LoggerSingleton.logError(e);
        }
        super.performDefaults();
    }

    @Override
    protected boolean saveSettings() {
        try {
            this.preferenceStore.setExcludedKeywords(this.excludedKeywordsComposite.getInput());
            this.preferenceStore.setPrioritizedLocatorStrategies(MobilePlatform.ANDROID, this.prioritizedLocatorStrategiesCompositeForAndroid.getInput());
            this.preferenceStore.setPrioritizedLocatorStrategies(MobilePlatform.IOS, this.prioritizedLocatorStrategiesCompositeForIos.getInput());
            if (this.canUseSelfHealing()) {
                this.preferenceStore.setSelfHealingEnabled(this.checkboxEnableSelfHealing.getSelection());
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
        return true;
    }

    @Override
    protected boolean hasChanged() {
        List prioritizedLocatorStrategies;
        if (!this.isValid()) {
            return false;
        }
        boolean isEnableSelfHealing = this.checkboxEnableSelfHealing.getSelection();
        if (isEnableSelfHealing != this.getEnableSelfHealingFromPluginPreference()) {
            return true;
        }
        try {
            prioritizedLocatorStrategies = this.preferenceStore.getPrioritizedLocatorStrategies(MobilePlatform.ANDROID);
            if (!this.prioritizedLocatorStrategiesCompositeForAndroid.compareInput(prioritizedLocatorStrategies)) {
                return true;
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
        try {
            prioritizedLocatorStrategies = this.preferenceStore.getPrioritizedLocatorStrategies(MobilePlatform.IOS);
            if (!this.prioritizedLocatorStrategiesCompositeForIos.compareInput(prioritizedLocatorStrategies)) {
                return true;
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
        try {
            List excludedKeywords = this.preferenceStore.getExcludedKeywords();
            return !this.excludedKeywordsComposite.compareInput(excludedKeywords);
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
    }

    @Override
    public boolean hasDocumentation() {
        return false;
    }

    private boolean canUseSelfHealing() {
        return this.featureController.canUse(ProductFeature.SELF_HEALING);
    }
}

