/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.katalon.plugin.smart_xpath.settings.AbstractSettingPage;
import com.katalon.plugin.smart_xpath.settings.composites.ExcludeObjectsUsedWithKeywordsComposite;
import com.katalon.plugin.smart_xpath.settings.composites.HelpCompositeForExecutionDialog;
import com.katalon.plugin.smart_xpath.settings.composites.PrioritizeSelectionMethodsComposite;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.core.selfhealing.SelfHealingInputSource;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.util.collections.Pair;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SelfHealingWebUISettingPage
extends AbstractSettingPage {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private static final String LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD = SmartXPathMessageConstants.LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD;
    private Button checkboxEnableSelfHealing;
    private ExcludeObjectsUsedWithKeywordsComposite excludeObjectsUsedWithKeywordsComposite;
    private PrioritizeSelectionMethodsComposite prioritizeSelectionMethodsComposite;
    private final String documentationUrl = SmartXPathMessageConstants.SELF_HEALING_DOCUMENT_LINK;
    private List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder = Collections.emptyList();
    private List<String> excludeKeywordNames = Collections.emptyList();
    private List<String> excludeKeywordNamesDoNotShowOnUI = Collections.emptyList();
    private WebUiExecutionSettingStore preferenceStore = WebUiExecutionSettingStore.getStore();
    private Button enableAISelfHealingCheckbox;
    private Group inputSourcesGroup;
    private Button usePageSourceCheckbox;
    private Button useAccessibilityTreeCheckbox;
    private Button useFullPageScreenshotCheckbox;
    private Button useElementScreenshotCheckbox;

    private void setInput() {
        try {
            List excludeKeywordFromSettingStoreList = this.preferenceStore.getExcludeKeywordFromSettingStoreList();
            this.excludeKeywordNamesDoNotShowOnUI = this.preferenceStore.getExcludeKeywordDoNotShowOnUIList();
            this.excludeKeywordNames = excludeKeywordFromSettingStoreList.stream().filter(keyword -> !this.excludeKeywordNamesDoNotShowOnUI.contains(keyword)).collect(Collectors.toList());
            this.methodsPriorityOrder = this.preferenceStore.getMethodsPriorityOrder();
            this.enableAISelfHealingCheckbox.setSelection(this.preferenceStore.getAISelfHealingEnabled().booleanValue());
            List inputSources = this.preferenceStore.getAISelfHealingInputSources();
            this.usePageSourceCheckbox.setSelection(inputSources.contains(SelfHealingInputSource.PAGE_SOURCE));
            this.useAccessibilityTreeCheckbox.setSelection(inputSources.contains(SelfHealingInputSource.ACCESSIBILITY_TREE));
            this.useElementScreenshotCheckbox.setSelection(inputSources.contains(SelfHealingInputSource.ELEMENT_SCREENSHOT));
            this.useFullPageScreenshotCheckbox.setSelection(inputSources.contains(SelfHealingInputSource.FULL_PAGE_SCREENSHOT));
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        this.excludeObjectsUsedWithKeywordsComposite.setInput(this.excludeKeywordNames, this.excludeKeywordNamesDoNotShowOnUI);
        this.prioritizeSelectionMethodsComposite.setInput(this.methodsPriorityOrder);
        boolean isEnableSelfHealing = this.getEnableSelfHealingFromPluginPreference();
        this.checkboxEnableSelfHealing.setSelection(this.canUseSelfHealing() && isEnableSelfHealing);
        this.updateInputSourceCheckboxes();
    }

    @Override
    protected void createSettingsArea(Composite parent) {
        Composite mainContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        mainContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainContainer.setLayout((Layout)layout);
        this.createCheckboxEnableSelfHealing(mainContainer);
        this.createMethodsPriorityOrderComposite(mainContainer);
        this.createExcludeWithKeywordsComposite(mainContainer);
        this.createAISelfHealingSection(mainContainer);
    }

    private void createAISelfHealingSection(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).colSpan(2).fillHorizontal().build();
        ComponentBuilder.separator2((Composite)container).fillHorizontal().build();
        Composite selfHealingLine = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().build();
        this.enableAISelfHealingCheckbox = (Button)ComponentBuilder.checkBox((Composite)selfHealingLine).text("Enable AI Self-Healing").onChange(event -> this.handleInputChanged()).build();
        ComponentBuilder.helpButton((Composite)selfHealingLine, (String)this.documentationUrl).left().build();
        this.inputSourcesGroup = (Group)ComponentBuilder.group((Composite)container).gridLayout(1).margin(5).text("Input data sources").fillHorizontal().onChange(event -> this.handleInputChanged()).build();
        this.usePageSourceCheckbox = (Button)ComponentBuilder.checkBox((Composite)this.inputSourcesGroup).text("Page source").fillHorizontal().onChange(event -> this.handleInputChanged()).build();
        this.useAccessibilityTreeCheckbox = (Button)ComponentBuilder.checkBox((Composite)this.inputSourcesGroup).text("Accessibility tree").fillHorizontal().onChange(event -> this.handleInputChanged()).build();
        this.useFullPageScreenshotCheckbox = (Button)ComponentBuilder.checkBox((Composite)this.inputSourcesGroup).text("Full-page screenshot").fillHorizontal().onChange(event -> this.handleInputChanged()).build();
        this.useElementScreenshotCheckbox = (Button)ComponentBuilder.checkBox((Composite)this.inputSourcesGroup).text("Element screenshot").fillHorizontal().onChange(event -> this.handleInputChanged()).build();
    }

    @Override
    protected void handleInputChanged() {
        super.handleInputChanged();
        this.updateInputSourceCheckboxes();
    }

    private void updateInputSourceCheckboxes() {
        boolean isAISelfHealingEnabled = this.enableAISelfHealingCheckbox.getSelection();
        this.inputSourcesGroup.setEnabled(isAISelfHealingEnabled);
        this.usePageSourceCheckbox.setEnabled(isAISelfHealingEnabled);
        this.useAccessibilityTreeCheckbox.setEnabled(isAISelfHealingEnabled);
        this.useFullPageScreenshotCheckbox.setEnabled(isAISelfHealingEnabled);
        this.useElementScreenshotCheckbox.setEnabled(isAISelfHealingEnabled);
    }

    private void createCheckboxEnableSelfHealing(Composite parent) {
        this.checkboxEnableSelfHealing = new Button(parent, 32);
        this.checkboxEnableSelfHealing.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.checkboxEnableSelfHealing.setText(LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD);
        this.checkboxEnableSelfHealing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!SelfHealingWebUISettingPage.this.canUseSelfHealing()) {
                    SelfHealingWebUISettingPage.this.checkboxEnableSelfHealing.setSelection(false);
                    SelfHealingWebUISettingPage.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.SELF_HEALING);
                }
                SelfHealingWebUISettingPage.this.handleInputChanged((Control)SelfHealingWebUISettingPage.this.checkboxEnableSelfHealing, null);
            }
        });
        new HelpCompositeForExecutionDialog(parent, this.documentationUrl);
    }

    private List<Pair<SelectorMethod, Boolean>> createMethodsPriorityOrderComposite(Composite parent) {
        if (this.prioritizeSelectionMethodsComposite == null) {
            this.prioritizeSelectionMethodsComposite = new PrioritizeSelectionMethodsComposite(parent, 0);
            this.prioritizeSelectionMethodsComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingWebUISettingPage.this.handleInputChanged((Control)SelfHealingWebUISettingPage.this.prioritizeSelectionMethodsComposite, null);
                }
            });
            this.prioritizeSelectionMethodsComposite.addNavigateToWebUITestDesignListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingWebUISettingPage.this.navigateToWebUITestDesignPage();
                }
            });
        }
        return this.methodsPriorityOrder;
    }

    private void navigateToWebUITestDesignPage() {
        this.eventBroker.post("SETTINGS/PAGE_CHANGE", (Object)"com.kms.katalon.composer.webui.setting.testdesign.webui");
    }

    private Composite createExcludeWithKeywordsComposite(Composite parent) {
        if (this.excludeObjectsUsedWithKeywordsComposite == null) {
            this.excludeObjectsUsedWithKeywordsComposite = new ExcludeObjectsUsedWithKeywordsComposite(parent, 0);
            this.excludeObjectsUsedWithKeywordsComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingWebUISettingPage.this.handleInputChanged((Control)SelfHealingWebUISettingPage.this.excludeObjectsUsedWithKeywordsComposite, null);
                }
            });
        }
        return this.excludeObjectsUsedWithKeywordsComposite;
    }

    private boolean getEnableSelfHealingFromPluginPreference() {
        return this.preferenceStore.getSelfHealingEnabled(this.canUseSelfHealing());
    }

    private List<Pair<SelectorMethod, Boolean>> getMethodsPriorityOrderFromPluginPreference() {
        List value = null;
        try {
            value = this.preferenceStore.getMethodsPriorityOrder();
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return null;
        }
        return value;
    }

    private List<String> getExcludeKeywordsFromPluginPreference() {
        List value = null;
        try {
            value = this.preferenceStore.getExcludeKeywordFromSettingStoreList();
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        return value;
    }

    @Override
    protected void initialize() throws IOException {
        this.setInput();
    }

    @Override
    protected void performDefaults() {
        try {
            this.preferenceStore.setEnableSelfHealing(this.canUseSelfHealing());
            this.preferenceStore.setDefaultMethodsPriorityOrder();
            this.preferenceStore.setDefaultExcludeKeywordList();
            this.preferenceStore.resetAISelfHealingEnabled();
            this.preferenceStore.resetAISeflHealingInputSources();
            this.initialize();
        }
        catch (IOException e) {
            LoggerSingleton.logError(e);
        }
        super.performDefaults();
    }

    @Override
    protected boolean saveSettings() {
        try {
            this.preferenceStore.setExcludeKeywordList(this.excludeObjectsUsedWithKeywordsComposite.getInput());
            this.preferenceStore.setMethodsPritorityOrder(this.prioritizeSelectionMethodsComposite.getInput());
            this.preferenceStore.setAISelfHealingEnabled(Boolean.valueOf(this.enableAISelfHealingCheckbox.getSelection()));
            ArrayList<SelfHealingInputSource> selectedInputSources = new ArrayList<SelfHealingInputSource>();
            if (this.usePageSourceCheckbox.getSelection()) {
                selectedInputSources.add(SelfHealingInputSource.PAGE_SOURCE);
            }
            if (this.useAccessibilityTreeCheckbox.getSelection()) {
                selectedInputSources.add(SelfHealingInputSource.ACCESSIBILITY_TREE);
            }
            if (this.useElementScreenshotCheckbox.getSelection()) {
                selectedInputSources.add(SelfHealingInputSource.ELEMENT_SCREENSHOT);
            }
            if (this.useFullPageScreenshotCheckbox.getSelection()) {
                selectedInputSources.add(SelfHealingInputSource.FULL_PAGE_SCREENSHOT);
            }
            this.preferenceStore.setAISelfHealingInputSources(selectedInputSources);
            if (this.canUseSelfHealing()) {
                this.preferenceStore.setEnableSelfHealing(this.checkboxEnableSelfHealing.getSelection());
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
        return true;
    }

    @Override
    protected boolean hasChanged() throws IOException {
        List<SelfHealingInputSource> uiInputSources;
        if (!this.isValid()) {
            return false;
        }
        boolean isEnableSelfHealing = this.checkboxEnableSelfHealing.getSelection();
        if (isEnableSelfHealing != this.getEnableSelfHealingFromPluginPreference()) {
            return true;
        }
        List<String> excludeKeywordNamesBeforeSetting = this.getExcludeKeywordsFromPluginPreference();
        if (!this.excludeObjectsUsedWithKeywordsComposite.compareInput(excludeKeywordNamesBeforeSetting)) {
            return true;
        }
        List<Pair<SelectorMethod, Boolean>> methodsPriorityOrderSetting = this.getMethodsPriorityOrderFromPluginPreference();
        if (!this.prioritizeSelectionMethodsComposite.compareInput(methodsPriorityOrderSetting)) {
            return true;
        }
        Boolean isAISelfHealingEnabled = this.preferenceStore.getAISelfHealingEnabled();
        if (isAISelfHealingEnabled.booleanValue() != this.enableAISelfHealingCheckbox.getSelection()) {
            return true;
        }
        List savedInputSources = this.preferenceStore.getAISelfHealingInputSources();
        boolean isSameInputSources = new HashSet(savedInputSources).equals(new HashSet<SelfHealingInputSource>(uiInputSources = this.getUIInputSources()));
        return !isSameInputSources;
    }

    private List<SelfHealingInputSource> getUIInputSources() {
        ArrayList<SelfHealingInputSource> uiInputSources = new ArrayList<SelfHealingInputSource>();
        if (this.usePageSourceCheckbox.getSelection()) {
            uiInputSources.add(SelfHealingInputSource.PAGE_SOURCE);
        }
        if (this.useAccessibilityTreeCheckbox.getSelection()) {
            uiInputSources.add(SelfHealingInputSource.ACCESSIBILITY_TREE);
        }
        if (this.useElementScreenshotCheckbox.getSelection()) {
            uiInputSources.add(SelfHealingInputSource.ELEMENT_SCREENSHOT);
        }
        if (this.useFullPageScreenshotCheckbox.getSelection()) {
            uiInputSources.add(SelfHealingInputSource.FULL_PAGE_SCREENSHOT);
        }
        return uiInputSources;
    }

    @Override
    public boolean hasDocumentation() {
        return false;
    }

    private boolean canUseSelfHealing() {
        return this.featureController.canUse(ProductFeature.SELF_HEALING);
    }
}

