/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class TestSuiteLogRecord
extends AbstractLogRecord {
    private static final String TEST_CASE_REMAINING_RETRY_COUNT = "remainingRetryCount";
    private static final String TOTAL_TEST_CASES = "total_test_cases";
    private static final String PASSED_TEST_CASES = "passed_test_cases";
    private static final String FAILED_TEST_CASES = "failed_test_cases";
    private static final String ERROR_TEST_CASES = "error_test_cases";
    private static final String INCOMPLETE_TEST_CASES = "incomplete_test_cases";
    private static final String SKIPPED_TEST_CASES = "skipped_test_cases";
    private static final EnumSet<TestStatus.TestStatusValue> ERROR_STATUSES = EnumSet.of(TestStatus.TestStatusValue.ERROR, TestStatus.TestStatusValue.FAILED, TestStatus.TestStatusValue.INCOMPLETE);
    private String devicePlatform;
    private String logFolder;
    private Map<String, String> runData;
    private String testSuiteCollectionId;
    private String testSuiteCollectionName;
    private String testSuiteCollectionPath;
    private Map<String, String> buildData;
    private Map<String, String> desiredCaps;
    private boolean isCompleted;
    private List<ILogRecord> testSuiteLogRecords;
    private List<ILogRecord> beforeTestSuiteLogRecords;
    private List<ILogRecord> afterTestSuiteLogRecords;
    private String executionProfile;
    private String testSuitePath;
    private String testSuiteCollectionLocation;

    public String getTestSuiteCollectionId() {
        return this.testSuiteCollectionId;
    }

    public void setTestSuiteCollectionId(String testSuiteCollectionId) {
        this.testSuiteCollectionId = testSuiteCollectionId;
    }

    public String getTestSuiteCollectionName() {
        return this.testSuiteCollectionName;
    }

    public void setTestSuiteCollectionName(String testSuiteCollectionName) {
        this.testSuiteCollectionName = testSuiteCollectionName;
    }

    public String getTestSuiteCollectionPath() {
        return this.testSuiteCollectionPath;
    }

    public void setTestSuiteCollectionPath(String testSuiteCollectionPath) {
        this.testSuiteCollectionPath = testSuiteCollectionPath;
    }

    public TestSuiteLogRecord(String name, String logFolder) {
        super(name);
        this.logFolder = logFolder;
        this.runData = new HashMap<String, String>();
        this.buildData = new HashMap<String, String>();
        this.setType("TEST_SUITE");
        this.testSuiteLogRecords = new ArrayList<ILogRecord>();
    }

    public void setStatus(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getBrowser() {
        Object browser = "";
        Object browserName = "";
        if (this.getRunData().containsKey("browser")) {
            browserName = this.getRunData().get("browser");
        }
        if (StringUtils.isBlank((CharSequence)browserName)) {
            browserName = this.getValueFromDesiredCaps("browserName");
            String browserVersion = this.getValueFromDesiredCaps("browserVersion");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{browserVersion})) {
                browserName = (String)browserName + " " + browserVersion;
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{browserName})) {
            browserName = StringUtils.capitalize((String)browserName);
            String devicePlatform = this.getDevicePlatform();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{devicePlatform})) {
                boolean isMobile;
                boolean bl = isMobile = StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"android") || StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"ios");
                if (!isMobile) {
                    browserName = this.formatDevicePlatform(devicePlatform) + " - " + (String)browserName;
                    String driverType = this.getRemoteWebDriverType();
                    if (StringUtils.equals((CharSequence)driverType, (CharSequence)"TESTCLOUD_DRIVER")) {
                        String browserFullVersion = TestCloudPropertyUtil.getInstance().buildBrowserFullVersion((String)browserName, this.getRunData().get("browserVersionType"));
                        browserName = "TestCloud - " + browserFullVersion;
                    }
                }
            }
            browser = browserName;
        }
        return browser;
    }

    public String getRemoteWebDriverType() {
        RunConfiguration.setExecutionSettingFile(this.getLogFolder() + "/execution.properties");
        return RunConfiguration.getDriverSystemProperty("Remote", "browserType");
    }

    public String getLogFolder() {
        return this.logFolder;
    }

    public int getTotalTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(null);
    }

    public int getTotalPassedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.PASSED);
    }

    public int getTotalFailedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.FAILED);
    }

    public int getTotalErrorTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.ERROR);
    }

    public int getTotalIncompleteTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
    }

    public int getTotalSkippedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.SKIPPED);
    }

    public TestStatus.TestStatusValue getSummaryStatus() {
        if (this.getTotalIncompleteTestCases() > 0) {
            return TestStatus.TestStatusValue.INCOMPLETE;
        }
        if (this.getTotalErrorTestCases() > 0) {
            return TestStatus.TestStatusValue.ERROR;
        }
        if (this.getTotalFailedTestCases() > 0) {
            return TestStatus.TestStatusValue.FAILED;
        }
        if (this.getTotalSkippedTestCases() == this.getTotalTestCases()) {
            return TestStatus.TestStatusValue.SKIPPED;
        }
        return TestStatus.TestStatusValue.PASSED;
    }

    public ILogRecord[] getFinalTestCases() {
        return this.filterFinalTestCasesResult(true);
    }

    public ILogRecord[] filterFinalTestCasesResult() {
        return this.filterFinalTestCasesResult(false);
    }

    public ILogRecord[] filterFinalTestCasesResult(boolean testCaseOnly) {
        ILogRecord[] childLogRecords = this.getChildRecords();
        ArrayList<ILogRecord> filterChildLogRecords = new ArrayList<ILogRecord>();
        int i = 0;
        while (i < childLogRecords.length) {
            ILogRecord childLogRecord = childLogRecords[i];
            if (!testCaseOnly || childLogRecord instanceof TestCaseLogRecord) {
                int remainingRetryCount;
                TestCaseLogRecord testCaseLog;
                Map<String, String> testCaseProperties;
                if (this.isFailedOrErrorTestCase(childLogRecord) && (testCaseProperties = (testCaseLog = (TestCaseLogRecord)childLogRecord).getProperties()) != null && testCaseProperties.containsKey(TEST_CASE_REMAINING_RETRY_COUNT) && (remainingRetryCount = Integer.parseInt(testCaseProperties.get(TEST_CASE_REMAINING_RETRY_COUNT))) > 0) {
                    if (i == childLogRecords.length - 1) {
                        filterChildLogRecords.add(childLogRecord);
                    }
                } else {
                    filterChildLogRecords.add(childLogRecord);
                }
            }
            ++i;
        }
        return filterChildLogRecords.toArray(new ILogRecord[filterChildLogRecords.size()]);
    }

    private boolean isFailedOrErrorTestCase(ILogRecord logRecord) {
        if (!(logRecord instanceof TestCaseLogRecord)) {
            return false;
        }
        switch (logRecord.getStatus().getStatusValue()) {
            case FAILED: 
            case ERROR: {
                return true;
            }
        }
        return false;
    }

    private int getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue testStatusValue) {
        ILogRecord[] childLogRecords = this.filterFinalTestCasesResult();
        int total = 0;
        ILogRecord[] iLogRecordArray = childLogRecords;
        int n = childLogRecords.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord childLogRecord = iLogRecordArray[n2];
            if (childLogRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLog = (TestCaseLogRecord)childLogRecord;
                if (testStatusValue == null || testCaseLog.getStatus().statusValue == testStatusValue) {
                    ++total;
                }
            }
            ++n2;
        }
        return total;
    }

    public String getDeviceName() {
        String deviceName = null;
        if (this.getRunData().containsKey("deviceName")) {
            deviceName = this.getRunData().get("deviceName");
        }
        if (StringUtils.isBlank(deviceName)) {
            deviceName = this.getValueFromDesiredCaps("deviceName");
        }
        if (StringUtils.isBlank(deviceName)) {
            deviceName = this.getValueFromDesiredCaps("appium:deviceName");
        }
        deviceName = this.enrichDeviceNameWhenPrivateDevice(deviceName);
        return deviceName;
    }

    private String enrichDeviceNameWhenPrivateDevice(String deviceName) {
        String udid = this.getValueFromDesiredCaps("appium:udid");
        if (StringUtils.isBlank((CharSequence)udid)) {
            return deviceName;
        }
        return deviceName + " (UDID: " + udid.substring(0, 6) + ")";
    }

    public String getMobileDeviceName() {
        boolean isMobile;
        String devicePlatform = this.getDevicePlatform();
        String mobileDeviceName = "";
        boolean bl = isMobile = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{devicePlatform}) && (StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"android") || StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"ios"));
        if (isMobile) {
            String driverType = this.getRemoteWebDriverType();
            String deviceVersion = this.getDeviceVersion();
            String deviceName = this.getDeviceName();
            if (StringUtils.isNotBlank((CharSequence)deviceName)) {
                devicePlatform = this.formatDevicePlatform(devicePlatform);
                mobileDeviceName = StringUtils.equals((CharSequence)driverType, (CharSequence)"TESTCLOUD_DRIVER") ? MessageFormat.format("TestCloud - {0} {1} - {2}", devicePlatform, deviceVersion, deviceName) : MessageFormat.format("{0} {1} - {2}", devicePlatform, deviceVersion, deviceName);
            }
        }
        return mobileDeviceName;
    }

    public String getDeviceId() {
        return this.getRunData().containsKey("deviceId") ? this.getRunData().get("deviceId") : "";
    }

    public String getDevicePlatform() {
        if (StringUtils.isBlank((CharSequence)this.devicePlatform)) {
            String platform = "";
            if (this.getRunData().containsKey("deviceOS")) {
                platform = this.getRunData().get("deviceOS");
            } else {
                platform = this.getValueFromDesiredCaps("platform");
                if (StringUtils.isBlank((CharSequence)platform) && StringUtils.isBlank((CharSequence)(platform = this.getValueFromDesiredCaps("platformName")))) {
                    platform = this.getRunData().get("deviceOS");
                }
            }
            this.devicePlatform = platform;
        }
        return this.devicePlatform;
    }

    public String getDeviceVersion() {
        if (this.getRunData().containsKey("deviceOSVersion")) {
            return this.getRunData().get("deviceOSVersion");
        }
        String platformVersion = this.getValueFromDesiredCaps("platformVersion");
        if (StringUtils.isBlank((CharSequence)platformVersion) && StringUtils.isBlank((CharSequence)(platformVersion = this.getValueFromDesiredCaps("appium:platformVersion"))) && this.getRunData().containsKey("desiredCapabilities")) {
            String json = this.getRunData().get("desiredCapabilities");
            JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
            try {
                String deviceVersion = jsonObject.getAsJsonObject("katalon:options").get("deviceVersion").getAsString();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{deviceVersion})) {
                    platformVersion = deviceVersion;
                }
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }
        return platformVersion;
    }

    private String getValueFromDesiredCaps(String key) {
        if (this.desiredCaps != null && !this.desiredCaps.isEmpty()) {
            return this.desiredCaps.get(key);
        }
        if (this.getRunData().containsKey("desiredCapabilities")) {
            String json = this.getRunData().get("desiredCapabilities");
            try {
                this.desiredCaps = (Map)new ObjectMapper().readValue(json, HashMap.class);
                return this.desiredCaps.get(key);
            }
            catch (JsonProcessingException jsonProcessingException) {
                return "";
            }
        }
        return "";
    }

    public void setDevicePlatform(String devicePlatform) {
        this.devicePlatform = devicePlatform;
    }

    public String getUserFullName() {
        return this.getRunData().containsKey("userFullName") ? this.getRunData().get("userFullName") : "";
    }

    public String getProjectName() {
        return this.getRunData().containsKey("projectName") ? this.getRunData().get("projectName") : "";
    }

    public String getOs() {
        return this.getRunData().containsKey("os") ? this.getRunData().get("os") : "";
    }

    public String getHostName() {
        return this.getRunData().containsKey("hostName") ? this.getRunData().get("hostName") : "";
    }

    public String getAppVersion() {
        return this.getRunData().containsKey("katalonVersion") ? this.getRunData().get("katalonVersion") : "";
    }

    public String getQtestBuildNumber() {
        return this.getBuildData().containsKey("qTestBuildNumber") ? this.getBuildData().get("qTestBuildNumber") : "";
    }

    public String getQtestBuildURL() {
        return this.getBuildData().containsKey("qTestBuildURL") ? this.getBuildData().get("qTestBuildURL") : "";
    }

    public String getAzurebBuildDefinitionId() {
        if (this.getBuildData().containsKey("adoDefinitionId")) {
            return this.getBuildData().get("adoDefinitionId");
        }
        if (this.getBuildData().containsKey("adoDefinitionID")) {
            return this.getBuildData().get("adoDefinitionID");
        }
        if (this.getBuildData().containsKey("adoBuildDefId")) {
            return this.getBuildData().get("adoBuildDefId");
        }
        if (this.getBuildData().containsKey("adoBuildDefID")) {
            return this.getBuildData().get("adoBuildDefID");
        }
        return "";
    }

    public String getAzurebReleaseDefinitionId() {
        if (this.getBuildData().containsKey("adoReleaseDefId")) {
            return this.getBuildData().get("adoReleaseDefId");
        }
        if (this.getBuildData().containsKey("adoReleaseDefID")) {
            return this.getBuildData().get("adoReleaseDefID");
        }
        return "";
    }

    public Map<String, String> getRunData() {
        return this.runData;
    }

    public void addRunData(Map<String, String> runData) {
        this.runData.putAll(runData);
    }

    public Map<String, String> getBuildData() {
        return this.buildData;
    }

    public void addBuildData(Map<String, String> buildData) {
        this.buildData.putAll(buildData);
    }

    public <T extends ILogRecord> int getChildIndex(T child) {
        return Arrays.asList(this.getChildRecords()).indexOf(child);
    }

    public List<String> getLogFiles() {
        ArrayList<String> logFiles = new ArrayList<String>();
        String[] stringArray = new File(this.getLogFolder()).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childFile = stringArray[n2];
            if (FilenameUtils.getExtension((String)childFile).equals("log")) {
                logFiles.add(childFile);
            }
            ++n2;
        }
        return logFiles;
    }

    @Override
    public String getSystemOutMsg() {
        return this.getJUnitMessage();
    }

    @Override
    public String getSystemErrorMsg() {
        TestStatus status = this.getStatus();
        String stackTrace = status.getStackTrace();
        if (status.getStatusValue().isError()) {
            return this.getJUnitMessage() + stackTrace;
        }
        return stackTrace;
    }

    public TestCaseLogRecord getLastTestCaseLogRecord() {
        return this.getChildRecords().length > 0 ? (TestCaseLogRecord)this.getChildRecords()[this.getChildRecords().length - 1] : null;
    }

    public List<TestCaseLogRecord> getAllTestCaseLogRecords() {
        return Arrays.stream(this.filterFinalTestCasesResult()).filter(TestCaseLogRecord.class::isInstance).map(TestCaseLogRecord.class::cast).collect(Collectors.toList());
    }

    private String formatDevicePlatform(String devicePlatform) {
        if (StringUtils.isBlank((CharSequence)devicePlatform)) {
            return "";
        }
        if (StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"ios")) {
            return "iOS";
        }
        if (StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"macos") || StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"mac os x") || StringUtils.equals((CharSequence)devicePlatform.toLowerCase(), (CharSequence)"mac")) {
            return "macOS";
        }
        return StringUtils.capitalize((String)devicePlatform.toLowerCase());
    }

    public List<ILogRecord> getTestSuiteListenerLogRecords() {
        if (this.testSuiteLogRecords == null) {
            return new ArrayList<ILogRecord>();
        }
        return this.testSuiteLogRecords;
    }

    public void addTestSuiteLogRecords(ILogRecord logRecord) {
        if (this.testSuiteLogRecords == null) {
            this.testSuiteLogRecords = new ArrayList<ILogRecord>();
        }
        this.testSuiteLogRecords.add(logRecord);
    }

    public long getFirstTestCaseStartTime() {
        ILogRecord[] childRecords = this.getChildRecords();
        if (childRecords.length == 0) {
            return 0L;
        }
        return childRecords[0].getStartTime();
    }

    public List<ILogRecord> getBeforeTestSuiteLogRecords() {
        if (CollectionUtils.isEmpty(this.testSuiteLogRecords)) {
            return Collections.emptyList();
        }
        if (!CollectionUtils.isEmpty(this.beforeTestSuiteLogRecords)) {
            return this.beforeTestSuiteLogRecords;
        }
        long firstTestCaseStartTime = this.getFirstTestCaseStartTime();
        this.beforeTestSuiteLogRecords = this.testSuiteLogRecords.stream().filter(logRecord -> logRecord.getStartTime() < firstTestCaseStartTime).collect(Collectors.toList());
        return this.beforeTestSuiteLogRecords;
    }

    public List<ILogRecord> getAfterTestSuiteLogRecords() {
        if (CollectionUtils.isEmpty(this.testSuiteLogRecords)) {
            return Collections.emptyList();
        }
        if (!CollectionUtils.isEmpty(this.afterTestSuiteLogRecords)) {
            return this.afterTestSuiteLogRecords;
        }
        HashSet<ILogRecord> beforeLogRecordSet = new HashSet<ILogRecord>(this.getBeforeTestSuiteLogRecords());
        this.afterTestSuiteLogRecords = this.testSuiteLogRecords.stream().filter(logRecord -> !beforeLogRecordSet.contains(logRecord)).collect(Collectors.toList());
        return this.afterTestSuiteLogRecords;
    }

    @Override
    public TestStatus getStatus() {
        TestStatus status = new TestStatus();
        Set statuses = this.getAllTestCaseLogRecords().stream().map(testCase -> testCase.getStatus().getStatusValue()).collect(Collectors.toSet());
        if (statuses.contains((Object)TestStatus.TestStatusValue.ERROR)) {
            status.setStatusValue(TestStatus.TestStatusValue.ERROR);
        } else if (statuses.contains((Object)TestStatus.TestStatusValue.FAILED)) {
            status.setStatusValue(TestStatus.TestStatusValue.FAILED);
        } else if (statuses.contains((Object)TestStatus.TestStatusValue.PASSED)) {
            status.setStatusValue(TestStatus.TestStatusValue.PASSED);
        } else if (statuses.contains((Object)TestStatus.TestStatusValue.SKIPPED)) {
            status.setStatusValue(TestStatus.TestStatusValue.SKIPPED);
        } else {
            status.setStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
        }
        return status;
    }

    public String getErrorMessage() {
        return this.getAllTestCaseLogRecords().stream().filter(tc -> ERROR_STATUSES.contains((Object)tc.getStatus().getStatusValue())).map(AbstractLogRecord::getMessage).filter(StringUtils::isNotBlank).findFirst().orElse("");
    }

    public String getExecutionProfile() {
        return this.executionProfile;
    }

    public void setExecutionProfile(String executionProfile) {
        this.executionProfile = executionProfile;
    }

    public Map<String, Map<String, Integer>> getOrigin() {
        HashMap<String, Map<String, Integer>> originMap = new HashMap<String, Map<String, Integer>>();
        for (TestCaseLogRecord testCaseLog : this.getAllTestCaseLogRecords()) {
            String origin = testCaseLog.getOrigin();
            if (StringUtils.isBlank((CharSequence)origin)) continue;
            Map countMap = originMap.getOrDefault(origin, new HashMap());
            countMap.put(TOTAL_TEST_CASES, countMap.getOrDefault(TOTAL_TEST_CASES, 0) + 1);
            TestStatus.TestStatusValue statusValue = testCaseLog.getStatus().getStatusValue();
            countMap.put(PASSED_TEST_CASES, countMap.getOrDefault(PASSED_TEST_CASES, 0) + (statusValue == TestStatus.TestStatusValue.PASSED ? 1 : 0));
            countMap.put(FAILED_TEST_CASES, countMap.getOrDefault(FAILED_TEST_CASES, 0) + (statusValue == TestStatus.TestStatusValue.FAILED ? 1 : 0));
            countMap.put(ERROR_TEST_CASES, countMap.getOrDefault(ERROR_TEST_CASES, 0) + (statusValue == TestStatus.TestStatusValue.ERROR ? 1 : 0));
            countMap.put(INCOMPLETE_TEST_CASES, countMap.getOrDefault(INCOMPLETE_TEST_CASES, 0) + (statusValue == TestStatus.TestStatusValue.INCOMPLETE ? 1 : 0));
            countMap.put(SKIPPED_TEST_CASES, countMap.getOrDefault(SKIPPED_TEST_CASES, 0) + (statusValue == TestStatus.TestStatusValue.SKIPPED ? 1 : 0));
            originMap.put(origin, countMap);
        }
        return originMap;
    }

    public String getTestSuitePath() {
        return this.testSuitePath;
    }

    public void setTestSuitePath(String testSuitePath) {
        this.testSuitePath = testSuitePath;
    }

    public String getTestSuiteCollectionLocation() {
        return this.testSuiteCollectionLocation;
    }

    public void setTestSuiteCollectionLocation(String testSuiteCollectionLocation) {
        this.testSuiteCollectionLocation = testSuiteCollectionLocation;
    }
}

