/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.util.RequestInformation;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.lightbody.bmp.core.har.HarContent;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;

public class KatalonHarEntry
extends HarEntry {
    private RequestInformation _katalonRequestInformation;
    private Pattern secureValuesPattern;

    public KatalonHarEntry() {
    }

    public KatalonHarEntry(HarEntry harEntry, Pattern secureValuesPattern) {
        this();
        HarResponse response;
        List headers;
        this.secureValuesPattern = secureValuesPattern;
        this.setPageref(harEntry.getPageref());
        this.setStartedDateTime(harEntry.getStartedDateTime());
        HarRequest request = harEntry.getRequest();
        if (request != null) {
            HarPostData postData;
            String url = request.getUrl();
            request.setUrl(this.maskValue(url));
            headers = request.getHeaders();
            if (headers != null) {
                headers = headers.stream().map(header -> new HarNameValuePair(header.getName(), this.maskValue(header.getValue()))).collect(Collectors.toList());
                request.getHeaders().clear();
                request.getHeaders().addAll(headers);
            }
            if ((postData = request.getPostData()) != null) {
                List dataParams = postData.getParams();
                if (dataParams != null) {
                    postData.setParams(dataParams.stream().map(param -> {
                        param.setValue(this.maskValue(param.getValue()));
                        return param;
                    }).collect(Collectors.toList()));
                }
                postData.setText(this.maskValue(postData.getText()));
                postData.setComment(this.maskValue(postData.getComment()));
            }
            request.setComment(this.maskValue(request.getComment()));
            this.setRequest(request);
        }
        if ((response = harEntry.getResponse()) != null) {
            HarContent content;
            headers = response.getHeaders();
            if (headers != null) {
                headers = headers.stream().map(header -> new HarNameValuePair(header.getName(), this.maskValue(header.getValue()))).collect(Collectors.toList());
                response.getHeaders().clear();
                response.getHeaders().addAll(headers);
            }
            if ((content = response.getContent()) != null) {
                content.setText(this.maskValue(content.getText()));
                content.setComment(this.maskValue(content.getComment()));
            }
            response.setRedirectURL(this.maskValue(response.getRedirectURL()));
            response.setComment(this.maskValue(response.getComment()));
            this.setResponse(response);
        }
        this.setCache(harEntry.getCache());
        this.setTimings(harEntry.getTimings());
        this.setServerIPAddress(harEntry.getServerIPAddress());
        this.setConnection(harEntry.getConnection());
        this.setComment(this.maskValue(harEntry.getComment()));
    }

    public RequestInformation get_katalonRequestInformation() {
        return this._katalonRequestInformation;
    }

    public void set_katalonRequestInformation(RequestInformation _katalonRequestInformation) {
        this._katalonRequestInformation = _katalonRequestInformation;
    }

    public String maskValue(String message) {
        if (message == null || this.secureValuesPattern == null) {
            return message;
        }
        Matcher matcher = this.secureValuesPattern.matcher(message);
        return matcher.replaceAll("\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022");
    }
}

