/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import com.kms.katalon.core.keyword.internal.IKeywordLoader;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordLoader
implements IKeywordLoader {
    private static final Logger logger = LoggerFactory.getLogger(KeywordLoader.class);
    private String keywordPlatform;
    private ClassLoader classLoader;

    public KeywordLoader(String keywordPlatform) {
        this.keywordPlatform = keywordPlatform;
    }

    private ClassLoader fetchClassLoader() {
        if (this.classLoader == null) {
            try {
                Bundle targetBundle = this.fetchBundle();
                if (targetBundle != null) {
                    BundleWiring wiring = (BundleWiring)targetBundle.adapt(BundleWiring.class);
                    this.classLoader = wiring.getClassLoader();
                }
            }
            catch (Throwable throwable) {
                logger.debug("Cannot load bundle, fallback to loading from class | keywordPlatform = {}", (Object)this.keywordPlatform);
                String className = this.getClassName();
                try {
                    this.classLoader = Class.forName(className).getClassLoader();
                }
                catch (Exception ex) {
                    logger.error("Cannot class loader | keywordPlatform = {} | className = {}", new Object[]{this.keywordPlatform, className, ex});
                }
            }
        }
        return this.classLoader;
    }

    private String getClassName() {
        if (StringUtils.equals((CharSequence)"builtin", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.keyword.BuiltinKeywords";
        }
        if (StringUtils.equals((CharSequence)"web", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords";
        }
        if (StringUtils.equals((CharSequence)"mobile", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords";
        }
        if (StringUtils.equals((CharSequence)"webservice", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.webservice.keyword.WSBuiltInKeywords";
        }
        if (StringUtils.equals((CharSequence)"windows", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.windows.keyword.WindowsBuiltinKeywords";
        }
        throw new IllegalArgumentException("Unsupported keyword platform: " + this.keywordPlatform);
    }

    private Bundle fetchBundle() {
        String bundleName = this.getBundleName();
        return Platform.getBundle((String)bundleName);
    }

    private String getBundleName() {
        if (StringUtils.equals((CharSequence)"builtin", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core";
        }
        if (StringUtils.equals((CharSequence)"web", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.webui";
        }
        if (StringUtils.equals((CharSequence)"mobile", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.mobile";
        }
        if (StringUtils.equals((CharSequence)"webservice", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.webservice";
        }
        if (StringUtils.equals((CharSequence)"windows", (CharSequence)this.keywordPlatform)) {
            return "com.kms.katalon.core.windows";
        }
        throw new IllegalArgumentException("Unsupported keyword platform: " + this.keywordPlatform);
    }

    @Override
    public List<Class<?>> loadAllClass(String ... packageNames) {
        ArrayList cls = new ArrayList();
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            cls.addAll(this.getAllClassInPackage(packageName));
            ++n2;
        }
        return cls;
    }

    @Override
    public List<Class<?>> loadAllClass(Class<?> aClass) {
        return this.getAllClassInPackage(aClass.getPackage().getName());
    }

    private List<Class<?>> getAllClassInPackage(String packageName) {
        try {
            ArrayList classes = new ArrayList();
            ClassLoader cld = this.fetchClassLoader();
            Enumeration<URL> urls = cld.getResources(packageName.replace('.', '/'));
            while (urls.hasMoreElements()) {
                File f;
                URL url = urls.nextElement();
                if (url.getProtocol().contains("jar")) {
                    String file = url.getFile();
                    file = file.substring(5, file.indexOf("!"));
                    return this.getAllClassInPackageJar(file, packageName);
                }
                if ("bundleresource".equalsIgnoreCase(url.getProtocol())) {
                    return this.getAllClassInBundleResource(url);
                }
                String path = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8.name());
                if (path.startsWith("/") && path.contains(":")) {
                    path = path.substring(1);
                }
                if (!(f = new File(path)).isDirectory()) continue;
                String[] stringArray = f.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (fileName.endsWith(".class")) {
                        classes.add(cld.loadClass((packageName + "." + fileName).replaceAll("\\.class", "")));
                    }
                    ++n2;
                }
            }
            return classes;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<Class<?>> getAllClassInPackageJar(String jarFile, String packageName) throws Exception {
        try (ZipFile jar = null;){
            jar = new JarFile(URLDecoder.decode(jarFile, StandardCharsets.UTF_8.name()));
            Pattern pat = Pattern.compile(packageName.replace('.', '/') + "/[^/]+");
            ArrayList classes = new ArrayList();
            ClassLoader cld = this.fetchClassLoader();
            Enumeration<JarEntry> entries = ((JarFile)jar).entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!pat.matcher(name).matches()) continue;
                classes.add(cld.loadClass(name.replace('/', '.').replaceAll("\\.class", "")));
            }
            ArrayList arrayList = classes;
            return arrayList;
        }
    }

    private List<Class<?>> getAllClassInBundleResource(URL url) throws Exception {
        Collection resources;
        Bundle bundle = this.fetchBundle();
        if (bundle == null) {
            throw new IllegalStateException("Cannot resolve current bundle");
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return Collections.emptyList();
        }
        String path = url.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((resources = wiring.listResources(path, "*.class", 2)) == null) {
            return Collections.emptyList();
        }
        ClassLoader cl = wiring.getClassLoader();
        return resources.stream().map(r -> r.replace('/', '.').replaceAll("\\.class$", "")).map(name -> {
            try {
                return cl.loadClass((String)name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

