/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.selfhealing.healers;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.selfhealing.SimpleTestObjectHealer;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.selfhealing.healers.AIService;
import com.kms.katalon.execution.selfhealing.healers.StandardTestObject;
import com.kms.katalon.execution.selfhealing.healers.StandardTestObjectMapper;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LLMTestObjectHealer
implements SimpleTestObjectHealer<LLMTestObjectHealingInput> {
    private KeywordLogger logger = KeywordLogger.getInstance(this.getClass());

    private String getSelfHealingAIModel() {
        return (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty("SELF_HEALING_AI_MODEL"), (CharSequence)"gpt-4o-mini");
    }

    public List<SimpleTestObjectHealer.FoundLocator> heal(LLMTestObjectHealingInput input) throws Exception {
        AIService aiService = new AIService();
        AIService.QuestionBuilder questionBuilder = new AIService.QuestionBuilder();
        StandardTestObject testObject = new StandardTestObjectMapper().map(input.testObject);
        AIService.QuestionMessageBuilder systemMessageBuilder = new AIService.QuestionMessageBuilder().system();
        systemMessageBuilder.addTextContent("### \ud83c\udfaf Goal\n\nGiven a broken test object and the current page state (Page DOM, Accessibility Tree, etc.), find up to 3 **reliable locators** for the broken test object at runtime, prioritizing text content matching across different languages, including Vietnamese, French, Chinese, etc. . If there are **no similar elements**, return an empty list for \"possibleLocators\" field.\n\n---\n\n### \ud83e\udded Reasoning Steps\n\n1. **Understand** the broken test object model.\n\tEverything here are captured at the capturing time.\n\t```typescript\n    type Locator = {\n        type: string; // XPath, CSS, Smart-locator (a Playwright custom locator syntax).\n        value: string;\n    }\n\ttype TestObject = {\n\t    filePath: string; // The test object file path in the local system.\n\t    name: string; // Test object name.\n\t    textContent: string; // The text content.\n\t    screenshotPath: string; // The screenshot file path in the local system.\n\t    attributes: Map<String, String>; // Element attributes.\n\t    locators: Array<Locator>; // Captured locators.\n\t}\n\t```\n\t2. Analyze the Test Object by extracting:\n\t- Selector information: XPath, CSS selector, tag, id, name, class, attributes, data-* attributes\n\t- DOM structure patterns: parent/child relationships if present\n\t- **Visible text**: including innerText, label text, aria-label, placeholder, title\n\t- Functional role: button, input, link, etc.\n\t3. Then find on the provided page the elements that are similar across ALL applicable dimensions:\n\t- Similarity dimensions:\n\t\t- Tag similarity \u2013 same HTML tag or same UI role\n\t\t- Attribute similarity \u2013 overlapping classes, attribute patterns, id/name patterns\n\t\t- DOM similarity \u2013 similar structural position (optional if DOM is missing)\n\t\t- **Text similarity** \u2013 measure similarity based on:\n\t\t\t- Levenshtein / fuzzy matching\n\t\t\t- semantic similarity of phrases, including across languages\n\t\t\t- shared keywords.\n\t\t\t- Similar meaning even if in different languages (e.g., \"\u0110\u1eb7t l\u1ecbch h\u1eb9n\" in Vietnamese is similar to \"Make Appointment\" in English).\n\t\t- Functional similarity \u2013 elements that serve the same purpose (e.g., \u201cLogin\u201d, \u201cSubmit\u201d buttons).\n\t- Try to avoid disabled or readonly elements. Only select them if they are the only element that match.\n\t4. **Generate** 1 unique locator per matched element (CSS or XPath) based on the given page source or accessibility tree.\n\t\t- The generated locator MUST be generated based on the given page source or accessibility tree.\n\t\t- The generated locator MUST be unique, pointed to one and only one element! Please check if the generated locator can also point to other elements or not.\n\t\t- **If accessibility tree is provided**, prioritize `ref` attributes for locators. But REMEMBER to rename the `ref` attribute to `data-mcp-ref`. E.g., In the accessibility tree, there is \"[ref=e42]\" => CSS selector must be \"[data-mcp-ref=\"e42\"]\".\n\n---\n\n### \u274c Critical Restrictions\n\n- **Do NOT propose an element based solely on contextual relevance** (e.g., page purpose, nearby text). Use explicit, inspectable data only.\n\n---\n\n### \ud83e\udde9 Output Rules\n\n- If the Page DOM or Accessibility Tree is provided: analyze it and list real elements.\n- If NOT provided: Return an empty list for `possibleLocators` field with a message indicating no locators were found.\n- Output **only** one valid JSON object (no explanations) follows the `Response` model below.\n- Up to 3 candidates, sorted by descending `confidence`. Prefer 1.\n- Prefer **CSS** when stable; **XPath** only when necessary.\n- Use attributes in this order: `id` \u2192 `data-*` \u2192 `name` \u2192 `aria-*` \u2192 short class chains \u2192 tag+attr.\n- Avoid dynamic attributes (e.g., `id-1234`).\n- Use index selectors only if necessary (confidence < 0.50).\n\n### \ud83e\udde0 Reason Field Rules\n\nEach `reason` must explicitly mention **which information** from the broken test object was matched.\n\n\u2705 Examples:\n- \"Matched text='Make Appointment' in button label.\"\n- \"Matched id='btn-make-appointment' from object attributes.\"\n- \"Text similarity 'Make Appointment' and '\u0110\u1eb7t l\u1ecbch h\u1eb9n'.\"\n\n\u274c Invalid:\n- \"This button is relevant to healthcare context.\"\n".trim());
        systemMessageBuilder.addTextContent("### \ud83e\udde9 Output Specification\n\n```typescript\ntype FoundLocator = {\n  type: \"CSS\" | \"XPath\";\n  value: string; // Pure CSS Selector or XPath value\n  semanticLocator: string; // Short, human-meaningful description of element\u2019s role\n  confidence: number; // How confident are you about this locator is the replacement for the broken test object. Value range: [0.00\u20131.00] (2 decimals)\n  reason: string; // Must specify which field(s) matched from the broken test object\n}\n\ntype Response = {\n    possibleLocators: Array<FoundLocator>;\n}\n```\n\nExample:\n\n```json\n{\n    possibleLocators: []\n}\n```\n".trim());
        if (StringUtils.isNotBlank((CharSequence)input.currentAction)) {
            systemMessageBuilder.addTextContent(MessageFormat.format("The current action that I'm going to perform on the target element is: \"{0}\". You should also based on this action to find a more suitable element.\n".trim(), input.currentAction));
        }
        if (StringUtils.isNotBlank((CharSequence)input.currentActionPrompt)) {
            systemMessageBuilder.addTextContent(MessageFormat.format("And with that action, there is an additional requirements here:\n\n```\n{0}\n```\n".trim(), input.currentActionPrompt));
        }
        questionBuilder.addMessage(systemMessageBuilder.build());
        AIService.QuestionMessageBuilder userMessageBuilder = new AIService.QuestionMessageBuilder().user();
        userMessageBuilder.addTextContent(MessageFormat.format("The broken test object:\n\n```json\n{0}\n```\n".trim(), JsonUtil.toJson((Object)testObject)));
        this.logger.logDebug("\n> Test Object:\n" + JsonUtil.toJson((Object)testObject, (boolean)true));
        if (StringUtils.isNotBlank((CharSequence)input.pageSource)) {
            userMessageBuilder.addTextContent(MessageFormat.format("The page source:\n\n```html\n{0}\n```\n".trim(), input.pageSource));
        }
        if (StringUtils.isNotBlank((CharSequence)input.accessibilityTree)) {
            userMessageBuilder.addTextContent(MessageFormat.format("The accessibility tree:\n\n```text\n{0}\n```\n".trim(), input.accessibilityTree));
        }
        if (StringUtils.isNotBlank((CharSequence)input.elementScreenshot)) {
            userMessageBuilder.addImageContent(input.elementScreenshot);
        }
        if (StringUtils.isNotBlank((CharSequence)input.fullpageScreenshot)) {
            userMessageBuilder.addImageContent(input.fullpageScreenshot);
        }
        questionBuilder.addMessage(userMessageBuilder.build());
        String selfHealingAIModel = this.getSelfHealingAIModel();
        this.logger.logInfo(MessageFormat.format("AI Self-healing model is set to \"{0}\". To change the model, use `System.setProperty(\"SELF_HEALING_AI_MODEL\", <your_desired_model>)", selfHealingAIModel));
        questionBuilder.model(selfHealingAIModel);
        String rawResponse = aiService.ask(questionBuilder.build());
        ChatResponse response = this.parseChatResponse(rawResponse);
        if (response == null || response.possibleLocators == null || response.possibleLocators.isEmpty()) {
            return null;
        }
        return response.possibleLocators;
    }

    private ChatResponse parseChatResponse(String rawResponse) throws Exception {
        try {
            ChatResponse chatResponse = (ChatResponse)JsonUtil.fromJson((String)Strings.extractJSONContent((String)rawResponse), ChatResponse.class);
            if (chatResponse != null && chatResponse.possibleLocators != null) {
                chatResponse.possibleLocators.forEach(locator -> {
                    if (locator.type == null) {
                        locator.type = locator.value.startsWith("/") ? SelectorMethod.XPATH : SelectorMethod.CSS;
                    }
                });
            }
            return chatResponse;
        }
        catch (Exception error) {
            throw new Exception("Cannot parse the response:\n" + rawResponse, error);
        }
    }

    private static class ChatResponse {
        public List<SimpleTestObjectHealer.FoundLocator> possibleLocators;

        private ChatResponse() {
        }
    }

    public static final class LLMTestObjectHealingInput {
        public TestObject testObject;
        public String pageSource;
        public String accessibilityTree;
        public String fullpageScreenshot;
        public String elementScreenshot;
        public String currentAction;
        public String currentActionPrompt;
    }
}

