/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.testdata.job.LoadExcelFileJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.checkpoint.ExcelCheckpointSourceInfo;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditCheckpointExcelSourceDialog
extends AbstractDialog {
    private static final String[] FILTER_NAMES = new String[]{"Microsoft Excel Spreadsheet Files (*.xls, *.xlsx)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xlsx; *.xls"};
    private ExcelCheckpointSourceInfo sourceInfo;
    protected Combo comboSheetNameOrCsvSeparator;
    private Text txtSourceUrl;
    private Button btnBrowse;
    private Button chkUsingRelativePath;
    private Button chkUsingFirstRowAsHeader;
    protected boolean isChanged;
    private LoadExcelFileJob loadFileJob;

    public EditCheckpointExcelSourceDialog(Shell parentShell, ExcelCheckpointSourceInfo sourceInfo) {
        super(parentShell);
        this.sourceInfo = sourceInfo.clone();
        this.setDialogTitle(StringConstants.DIA_TITLE_CHECKPOINT_SOURCE_INFO);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout glMain = new GridLayout();
        glMain.marginHeight = 0;
        glMain.marginWidth = 0;
        main.setLayout((Layout)glMain);
        this.createFileInfoPart(main);
        return parent;
    }

    private void createFileInfoPart(Composite parent) {
        Composite compFileInfo = new Composite(parent, 0);
        compFileInfo.setLayout((Layout)new GridLayout(3, false));
        compFileInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblSourceUrl = new Label(compFileInfo, 0);
        lblSourceUrl.setText(StringConstants.DIA_LBL_FILE_PATH);
        this.txtSourceUrl = new Text(compFileInfo, 2056);
        this.txtSourceUrl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnBrowse = new Button(compFileInfo, 0x800008);
        this.btnBrowse.setText(StringConstants.BROWSE);
        this.btnBrowse.setLayoutData((Object)new GridData(131072, 4, false, true));
        Label lblIndicator = new Label(compFileInfo, 0);
        lblIndicator.setText(this.getIndicatorLabel());
        this.comboSheetNameOrCsvSeparator = new Combo(compFileInfo, 8);
        this.comboSheetNameOrCsvSeparator.setLayoutData((Object)new GridData(4, 4, false, true));
        new Label(compFileInfo, 0);
        new Label(compFileInfo, 0);
        this.chkUsingFirstRowAsHeader = new Button(compFileInfo, 32);
        this.chkUsingFirstRowAsHeader.setText(StringConstants.DIA_CHK_USING_FIRST_ROW_AS_HEADER);
        this.chkUsingFirstRowAsHeader.setLayoutData((Object)new GridData(4, 4, false, true));
        new Label(compFileInfo, 0);
        new Label(compFileInfo, 0);
        this.chkUsingRelativePath = new Button(compFileInfo, 32);
        this.chkUsingRelativePath.setText(StringConstants.DIA_CHK_IS_USING_RELATIVE_PATH);
        this.chkUsingRelativePath.setLayoutData((Object)new GridData(4, 4, false, true));
        new Label(compFileInfo, 0);
    }

    private String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation();
    }

    protected void registerControlModifyListeners() {
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditCheckpointExcelSourceDialog.this.btnBrowse.getShell());
                dialog.setFilterNames(EditCheckpointExcelSourceDialog.this.getFilterNames());
                dialog.setFilterExtensions(EditCheckpointExcelSourceDialog.this.getFilterExtensions());
                String filePath = EditCheckpointExcelSourceDialog.this.sourceInfo.getSourceUrl();
                if (StringUtils.isBlank((String)filePath)) {
                    dialog.setFilterPath(EditCheckpointExcelSourceDialog.this.getProjectFolderLocation());
                } else {
                    dialog.setFileName(filePath);
                }
                String absolutePath = dialog.open();
                if (absolutePath == null || absolutePath.equals(filePath)) {
                    return;
                }
                EditCheckpointExcelSourceDialog.this.sourceInfo.setSourceUrl(absolutePath);
                EditCheckpointExcelSourceDialog.this.comboSheetNameOrCsvSeparator.clearSelection();
                EditCheckpointExcelSourceDialog.this.setInput();
                EditCheckpointExcelSourceDialog.this.setChanged();
            }
        });
        this.comboSheetNameOrCsvSeparator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedSheetName = EditCheckpointExcelSourceDialog.this.comboSheetNameOrCsvSeparator.getText();
                if (StringUtils.equals((String)EditCheckpointExcelSourceDialog.this.sourceInfo.getSheetNameOrSeparator(), (String)selectedSheetName)) {
                    return;
                }
                EditCheckpointExcelSourceDialog.this.sourceInfo.setSheetNameOrSeparator(selectedSheetName);
                EditCheckpointExcelSourceDialog.this.setChanged();
            }
        });
        this.chkUsingFirstRowAsHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCheckpointExcelSourceDialog.this.sourceInfo.setUsingFirstRowAsHeader(EditCheckpointExcelSourceDialog.this.chkUsingFirstRowAsHeader.getSelection());
                EditCheckpointExcelSourceDialog.this.setChanged();
            }
        });
        this.chkUsingRelativePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isRelativePath = EditCheckpointExcelSourceDialog.this.chkUsingRelativePath.getSelection();
                EditCheckpointExcelSourceDialog.this.sourceInfo.setUsingRelativePath(isRelativePath);
                EditCheckpointExcelSourceDialog.this.setChanged();
                String sourceUrl = EditCheckpointExcelSourceDialog.this.txtSourceUrl.getText();
                if (StringUtils.isBlank((String)sourceUrl)) {
                    return;
                }
                sourceUrl = isRelativePath ? PathUtil.absoluteToRelativePath((String)sourceUrl, (String)EditCheckpointExcelSourceDialog.this.getProjectFolderLocation()) : PathUtil.relativeToAbsolutePath((String)sourceUrl, (String)EditCheckpointExcelSourceDialog.this.getProjectFolderLocation());
                EditCheckpointExcelSourceDialog.this.txtSourceUrl.setText(sourceUrl);
                EditCheckpointExcelSourceDialog.this.sourceInfo.setSourceUrl(sourceUrl);
            }
        });
    }

    protected void setInput() {
        String sourceUrl = this.sourceInfo.getSourceUrl();
        boolean isRelativePath = this.sourceInfo.isUsingRelativePath();
        this.chkUsingRelativePath.setSelection(isRelativePath);
        this.chkUsingFirstRowAsHeader.setSelection(this.sourceInfo.isUsingFirstRowAsHeader());
        this.txtSourceUrl.setText(StringUtils.defaultString((String)sourceUrl));
        if (isRelativePath) {
            this.txtSourceUrl.setText(PathUtil.absoluteToRelativePath((String)sourceUrl, (String)this.getProjectFolderLocation()));
        }
        if (StringUtils.isNotBlank((String)sourceUrl)) {
            this.loadIndicatorData(StringUtils.defaultString((String)this.sourceInfo.getSheetNameOrSeparator()));
        }
    }

    private void loadIndicatorData(String indicator) {
        this.loadSheetNames(indicator, this.getIndicatorData());
    }

    private void loadSheetNames(String indicator, String[] sheetNames) {
        if (sheetNames == null) {
            return;
        }
        this.comboSheetNameOrCsvSeparator.setItems(sheetNames);
        int indicatorSelectionIndex = ArrayUtils.indexOf((Object[])sheetNames, (Object)indicator);
        if (indicatorSelectionIndex == -1) {
            this.comboSheetNameOrCsvSeparator.select(0);
            this.sourceInfo.setSheetNameOrSeparator(this.comboSheetNameOrCsvSeparator.getText());
            return;
        }
        this.comboSheetNameOrCsvSeparator.select(indicatorSelectionIndex);
    }

    protected String[] getIndicatorData() {
        this.loadFileJob = new LoadExcelFileJob(this.getSourceUrlAbsolutePath(), this.chkUsingFirstRowAsHeader.getSelection());
        this.loadFileJob.setUser(true);
        this.loadFileJob.schedule();
        this.loadFileJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult() != Status.OK_STATUS || (this).EditCheckpointExcelSourceDialog.this.loadFileJob.getExcelData() == null) {
                            return;
                        }
                        EditCheckpointExcelSourceDialog.this.loadSheetNames((this).EditCheckpointExcelSourceDialog.this.sourceInfo.getSheetNameOrSeparator(), (this).EditCheckpointExcelSourceDialog.this.loadFileJob.getExcelData().getSheetNames());
                    }
                });
            }
        });
        return null;
    }

    protected String getIndicatorLabel() {
        return StringConstants.DIA_LBL_SHEET_NAME;
    }

    protected String[] getFilterNames() {
        return FILTER_NAMES;
    }

    protected String[] getFilterExtensions() {
        return FILTER_EXTS;
    }

    public ExcelCheckpointSourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    private void setChanged() {
        if (this.isChanged) {
            return;
        }
        this.isChanged = true;
    }

    private String getSourceUrlAbsolutePath() {
        String sourceUrl = this.txtSourceUrl.getText();
        if (this.chkUsingRelativePath.getSelection()) {
            sourceUrl = PathUtil.relativeToAbsolutePath((String)sourceUrl, (String)this.getProjectFolderLocation());
        }
        return sourceUrl;
    }

    protected Point getInitialSize() {
        return new Point(500, super.getInitialSize().y);
    }

    protected int getShellStyle() {
        return 0x8860 | EditCheckpointExcelSourceDialog.getDefaultOrientation();
    }
}

