/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.handlers;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.exception.NullAttributeException;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameCheckpointHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object eventData = event.getProperty("org.eclipse.e4.data");
                if (eventData instanceof CheckpointTreeEntity) {
                    CheckpointTreeEntity checkpointTreeEntity = (CheckpointTreeEntity)eventData;
                    RenameCheckpointHandler.this.execute(checkpointTreeEntity);
                }
            }
        });
    }

    private void execute(CheckpointTreeEntity checkpointTreeEntity) {
        try {
            CheckpointEntity checkpoint = checkpointTreeEntity.getObject();
            if (checkpoint == null) {
                throw new NullAttributeException(StringConstants.HAND_EXC_CHECKPOINT_ENTITY_IS_NULL);
            }
            List existingNames = FolderController.getInstance().getChildrenNames(checkpoint.getParentFolder());
            RenameWizard renameWizard = new RenameWizard((ITreeEntity)checkpointTreeEntity, existingNames);
            CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
            if (wizardDialog.open() != 0) {
                return;
            }
            String oldName = checkpoint.getName();
            String newName = renameWizard.getNewNameValue();
            String id = checkpoint.getId();
            String oldDisplayedId = checkpoint.getIdForDisplay();
            if (StringUtils.isBlank((String)newName) || StringUtils.equals((String)newName, (String)oldName)) {
                return;
            }
            try {
                checkpoint.setName(newName);
                CheckpointController.getInstance().update(checkpoint);
                this.partService.saveAll(false);
                this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldDisplayedId, checkpoint.getIdForDisplay()});
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)checkpointTreeEntity.getParent());
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)checkpointTreeEntity);
                this.eventBroker.post("CHECKPOINT/UPDATED", (Object)new Object[]{id, checkpoint});
            }
            catch (DALException | FilePathTooLongException e) {
                checkpoint.setName(oldName);
                throw e;
            }
        }
        catch (FilePathTooLongException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR, (String)StringConstants.HAND_MSG_UNABLE_TO_RENAME_CHECKPOINT);
        }
    }
}

