/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.parts;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.dialogs.EditCheckpointExcelSourceDialog;
import com.kms.katalon.composer.checkpoint.parts.CheckpointAbstractPart;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.checkpoint.ExcelCheckpointSourceInfo;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CheckpointExcelPart
extends CheckpointAbstractPart {
    protected Button btnEdit;
    private Text txtSourceUrl;

    @Override
    protected Composite createSourceInfoPartDetails(Composite parent) {
        this.compSourceInfoDetails = new Composite(parent, 0);
        GridLayout glCompositeSrcInfoDetails = new GridLayout(4, false);
        glCompositeSrcInfoDetails.marginWidth = 0;
        glCompositeSrcInfoDetails.marginHeight = 0;
        this.compSourceInfoDetails.setLayout((Layout)glCompositeSrcInfoDetails);
        this.compSourceInfoDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSourceUrl = new Label(this.compSourceInfoDetails, 0);
        lblSourceUrl.setText(StringConstants.PART_LBL_FILE_PATH);
        this.txtSourceUrl = new Text(this.compSourceInfoDetails, 2056);
        this.txtSourceUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnEdit = new Button(this.compSourceInfoDetails, 0x800008);
        this.btnEdit.setText(StringConstants.EDIT);
        this.btnEdit.setLayoutData((Object)new GridData(131072, 4, false, true));
        return parent;
    }

    @Override
    protected void addSourceInfoConstrolListeners() {
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointExcelPart.this.executeOperation((IUndoableOperation)new ChangeExcelSourceInfoOperation());
            }
        });
    }

    @Override
    protected void loadCheckpointSourceInfo(CheckpointSourceInfo sourceInfo) {
        this.txtSourceUrl.setText(sourceInfo.getSourceUrl());
    }

    @Override
    protected String getDocumentationUrl() {
        return DocumentationMessageConstants.CHECKPOINT_EXCEL;
    }

    private class ChangeExcelSourceInfoOperation
    extends CheckpointAbstractPart.ChangeCheckpointSourceInfoOperation {
        public ChangeExcelSourceInfoOperation() {
            super(ChangeExcelSourceInfoOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CheckpointEntity checkpoint = CheckpointExcelPart.this.getCheckpoint();
            this.oldCheckpointSourceInfo = checkpoint.getSourceInfo().clone();
            EditCheckpointExcelSourceDialog dialog = new EditCheckpointExcelSourceDialog(Display.getCurrent().getActiveShell(), (ExcelCheckpointSourceInfo)checkpoint.getSourceInfo());
            if (dialog.open() != 0 || !dialog.isChanged()) {
                return Status.CANCEL_STATUS;
            }
            ExcelCheckpointSourceInfo sourceInfo = dialog.getSourceInfo();
            this.newCheckpointSourceInfo = sourceInfo.clone();
            checkpoint.setSourceInfo((CheckpointSourceInfo)sourceInfo);
            CheckpointExcelPart.this.loadCheckpointSourceInfo((CheckpointSourceInfo)sourceInfo);
            try {
                CheckpointController.getInstance().takeSnapshot(checkpoint);
                CheckpointExcelPart.this.setDirty(true);
                CheckpointExcelPart.this.eventBroker.post("CHECKPOINT/UPDATED", (Object)new Object[]{checkpoint.getId(), checkpoint});
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }
    }
}

