/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.provider;

import com.kms.katalon.composer.components.impl.providers.CellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.HyperLinkColumnLabelProvider;
import com.kms.katalon.composer.components.impl.providers.TableCellLayoutInfo;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.parts.ReportPart;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseGroupLogRecord;
import com.kms.katalon.core.setting.VideoRecorderSettings;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.execution.util.ExecutionUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;

public class HyperlinkTestCaseVideoLabelProvider
extends HyperLinkColumnLabelProvider<ILogRecord> {
    private final String VIDEO_ATTACHMENT_PROP_NAME = "video-attachment";
    private ReportPart reportPart;
    private VideoRecorderSettings videoSetting;

    public HyperlinkTestCaseVideoLabelProvider(ReportPart reportPart) {
        super(3);
        this.reportPart = reportPart;
        File executionSettingFile = ReportController.getInstance().getExecutionSettingFile(reportPart.getReport().getLocation());
        if (executionSettingFile.exists()) {
            try {
                Map reportProperties = ExecutionUtil.readRunConfigSettingFromFile((String)executionSettingFile.getAbsolutePath()).getOrDefault("report", Collections.emptyMap());
                Map videoRecorderSettings = reportProperties.getOrDefault("videoRecorderSettings", Collections.emptyMap());
                this.videoSetting = new VideoRecorderSettings();
                if (!videoRecorderSettings.isEmpty()) {
                    this.videoSetting = (VideoRecorderSettings)JsonUtil.fromJson((String)JsonUtil.toJson(videoRecorderSettings), VideoRecorderSettings.class);
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
        File file = this.getVideoFile((ILogRecord)cell.getElement());
        if (file == null || !file.exists()) {
            return;
        }
        Program.launch((String)file.getAbsolutePath());
    }

    protected Class<ILogRecord> getElementType() {
        return ILogRecord.class;
    }

    protected Image getImage(ILogRecord logRecord) {
        if (this.videoSetting == null) {
            return null;
        }
        File videoFile = this.getVideoFile(logRecord);
        return videoFile != null && videoFile.exists() ? ImageConstants.IMG_16_VIDEO : null;
    }

    private String recurGetPath(ILogRecord logRecord) {
        String vidPath;
        if (logRecord == null) {
            return null;
        }
        if (logRecord instanceof MessageLogRecord && !StringUtils.isEmpty((CharSequence)(vidPath = ((MessageLogRecord)logRecord).getVideoAttachment()))) {
            return vidPath;
        }
        ILogRecord[] iLogRecordArray = logRecord.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord childRecord = iLogRecordArray[n2];
            String path = this.recurGetPath(childRecord);
            if (path != null) {
                return path;
            }
            ++n2;
        }
        return null;
    }

    private String getVideoAttachmentPath(ILogRecord logRecord) {
        String path = this.recurGetPath(logRecord);
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        String[] arr = path.split(Pattern.quote(File.separator));
        String vidPath = arr[arr.length - 1];
        return vidPath;
    }

    private File getVideoFile(ILogRecord logRecord) {
        ReportEntity report = this.reportPart.getReport();
        if (report == null || this.videoSetting == null) {
            return null;
        }
        int index = LogRecordHelper.getLogRecordIndex((ILogRecord)logRecord);
        if (index < 0) {
            return null;
        }
        if (logRecord instanceof TestCaseGroupLogRecord) {
            ILogRecord[] children = logRecord.getChildRecords();
            return this.getVideoFile(children[children.length - 1]);
        }
        String fileName = this.getVideoAttachmentPath(logRecord);
        File recordingFile = new File(report.getVideoFolder(), fileName);
        if (recordingFile.exists()) {
            return recordingFile;
        }
        File browserRecordingFile = new File(report.getVideoFolder(), MessageFormat.format("recording-{0,number,#}.mp4", index + 1));
        if (browserRecordingFile.exists()) {
            return browserRecordingFile;
        }
        File fullscreenRecordingFile = new File(report.getVideoFolder(), MessageFormat.format("test_{0,number,#}{1}", index + 1, this.videoSetting.getVideoFormat().getExtension()));
        if (fullscreenRecordingFile.exists()) {
            return fullscreenRecordingFile;
        }
        return browserRecordingFile.exists() ? browserRecordingFile : fullscreenRecordingFile;
    }

    protected String getText(ILogRecord element) {
        return "";
    }

    public CellLayoutInfo getCellLayoutInfo() {
        return new TableCellLayoutInfo(){

            public int getLeftMargin() {
                return 15;
            }
        };
    }

    protected boolean isPlacedMouseHover(ViewerCell cell) {
        return cell != null && cell.getColumnIndex() == this.columnIndex && cell.getImage() != null;
    }

    protected boolean shouldShowCursor(ViewerCell cell, Point currentMouseLocation) {
        return cell.getBounds().contains(currentMouseLocation);
    }

    protected String getElementToolTipText(ILogRecord logRecord) {
        File videoFile = this.getVideoFile(logRecord);
        return videoFile != null && videoFile.exists() ? ComposerReportMessageConstants.PROVIDER_TOOLTIP_OPEN_RECORDED_VIDEO : null;
    }
}

