/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.TestCaseRootSelectionDialog;
import com.kms.katalon.composer.integration.qtest.dialog.provider.TestCaseFolderEntityProvider;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.model.TestCaseRepo;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TestCaseRepoDialog
extends Dialog {
    private Composite container;
    private Text txtQTestModule;
    private Text txtKatalonFolder;
    private Button btnUpdateProjects;
    private Button btnFindQTestModule;
    private Button btnBrowseKatalonFolder;
    private Combo cbProjects;
    private List<String> folderIds;
    private QTestModule qTestModule;
    private QTestProject qTestProject;
    private String folderId;
    private Map<Long, QTestProject> qTestProjectsMap = new LinkedHashMap<Long, QTestProject>();

    public Map<Long, QTestProject> getQTestProjectsMap() {
        return this.qTestProjectsMap;
    }

    public TestCaseRepoDialog(Shell parentShell, List<QTestProject> qTestProjects, List<String> folderIds, TestCaseRepo testCaseRepo) {
        super(parentShell);
        this.updateQTestProjectsMap(qTestProjects);
        this.folderIds = folderIds;
        if (testCaseRepo != null) {
            this.qTestProject = testCaseRepo.getQTestProject();
            this.qTestModule = testCaseRepo.getQTestModule();
            this.folderId = testCaseRepo.getFolderId();
        }
    }

    private void updateQTestProjectsMap(List<QTestProject> qTestProjects) {
        for (QTestProject qTestProject : qTestProjects) {
            this.qTestProjectsMap.put(qTestProject.getId(), qTestProject);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)this.container.getLayout();
        GridData gridData = (GridData)this.container.getLayoutData();
        gridData.widthHint = 500;
        gridLayout.numColumns = 3;
        Label lblQTestProject = new Label(this.container, 0);
        lblQTestProject.setText(StringConstants.DIA_TITLE_QTEST_PROJECT);
        this.cbProjects = new Combo(this.container, 0);
        this.cbProjects.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnUpdateProjects = new Button(this.container, 0);
        this.btnUpdateProjects.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUpdateProjects.setText(StringConstants.UPDATE);
        Label lblQTestModule = new Label(this.container, 0);
        lblQTestModule.setText(StringConstants.DIA_TITLE_QTEST_MODULE);
        this.txtQTestModule = new Text(this.container, 2056);
        this.txtQTestModule.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnFindQTestModule = new Button(this.container, 0);
        this.btnFindQTestModule.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnFindQTestModule.setText(StringConstants.FIND);
        Label lblKatalonFolder = new Label(this.container, 0);
        lblKatalonFolder.setText(StringConstants.DIA_TITLE_KATALON_FOLDER);
        this.txtKatalonFolder = new Text(this.container, 2048);
        this.txtKatalonFolder.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnBrowseKatalonFolder = new Button(this.container, 0);
        this.btnBrowseKatalonFolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnBrowseKatalonFolder.setText(StringConstants.BROWSE);
        return this.container;
    }

    public void create() {
        super.create();
        this.addButtonSelectionListeners();
        this.initialize();
        this.validate();
    }

    private void initialize() {
        if (this.qTestProject != null) {
            this.cbProjects.setText(this.qTestProject.getName());
        }
        this.updateProjectComboboxItems();
        if (this.folderId != null) {
            this.txtKatalonFolder.setText(this.folderId);
        }
        if (this.qTestModule != null) {
            this.txtQTestModule.setText(this.qTestModule.getName());
        }
    }

    private void updateProjectComboboxItems() {
        String selectedProjectName = this.cbProjects.getText();
        ArrayList<String> projectNames = new ArrayList<String>();
        for (QTestProject qTestProject : this.qTestProjectsMap.values()) {
            projectNames.add(qTestProject.getName());
        }
        this.cbProjects.setItems(projectNames.toArray(new String[projectNames.size()]));
        if (this.cbProjects.getItemCount() <= 0) {
            return;
        }
        if (selectedProjectName.isEmpty()) {
            this.cbProjects.select(0);
        } else {
            int index = projectNames.indexOf(selectedProjectName);
            if (index >= 0) {
                this.cbProjects.select(index);
            }
        }
    }

    private void addButtonSelectionListeners() {
        this.btnUpdateProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseRepoDialog.this.updateProjects();
                TestCaseRepoDialog.this.validate();
            }
        });
        this.btnFindQTestModule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseRepoDialog.this.findQTestModule();
                TestCaseRepoDialog.this.validate();
            }
        });
        this.btnBrowseKatalonFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseRepoDialog.this.findTestCaseFolder();
                TestCaseRepoDialog.this.validate();
            }
        });
        this.cbProjects.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QTestProject[] qTestProjects = TestCaseRepoDialog.this.qTestProjectsMap.values().toArray(new QTestProject[TestCaseRepoDialog.this.qTestProjectsMap.values().size()]);
                int index = TestCaseRepoDialog.this.cbProjects.getSelectionIndex();
                if (index >= 0) {
                    if (TestCaseRepoDialog.this.qTestProject != null && !TestCaseRepoDialog.this.qTestProject.equals((Object)qTestProjects[index])) {
                        TestCaseRepoDialog.this.qTestModule = null;
                        TestCaseRepoDialog.this.txtQTestModule.setText("");
                    }
                    TestCaseRepoDialog.this.qTestProject = qTestProjects[index];
                    TestCaseRepoDialog.this.validate();
                }
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (StringUtils.isBlank((String)this.folderId)) {
            newShell.setText(StringConstants.DIA_TITLE_CREATE_TEST_CASE_REPO);
        } else {
            newShell.setText(StringConstants.DIA_TITLE_EDIT_TEST_CASE_REPO);
        }
    }

    public List<String> getFolderIds() {
        return this.folderIds;
    }

    public void setFolderIds(List<String> folderIds) {
        this.folderIds = folderIds;
    }

    private void updateProjects() {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            List updatedProjects = QTestIntegrationProjectManager.getAllProject((IQTestCredential)QTestSettingCredential.getCredential((String)projectDir));
            this.mergeProjects(updatedProjects);
            this.updateProjectComboboxItems();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.DIA_MSG_UNABLE_TO_UPDATE_PROJECT, (String)e.getMessage());
        }
    }

    private void mergeProjects(List<QTestProject> updatedProjects) {
        block0: for (QTestProject updatedQTestProject : updatedProjects) {
            for (QTestProject currentQTestProject : this.qTestProjectsMap.values()) {
                if (updatedQTestProject.getId() != currentQTestProject.getId()) continue;
                updatedQTestProject.setTestCaseFolderIds(currentQTestProject.getTestCaseFolderIds());
                updatedQTestProject.setTestSuiteFolderIds(currentQTestProject.getTestSuiteFolderIds());
                continue block0;
            }
        }
        this.qTestProjectsMap.clear();
        this.updateQTestProjectsMap(updatedProjects);
        this.updateProjectComboboxItems();
    }

    private void findQTestModule() {
        try {
            String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
            QTestModule moduleRoot = QTestIntegrationFolderManager.getModuleRoot((IQTestCredential)QTestSettingCredential.getCredential((String)projectDir), (QTestProject)this.qTestProject);
            TestCaseRootSelectionDialog testCaseRootSelectionDialog = new TestCaseRootSelectionDialog(Display.getDefault().getActiveShell(), moduleRoot, true);
            testCaseRootSelectionDialog.setProjectDir(projectDir);
            testCaseRootSelectionDialog.setQTestProject(this.qTestProject);
            if (testCaseRootSelectionDialog.open() == 0) {
                this.qTestModule = testCaseRootSelectionDialog.getSelectedModule();
                this.txtQTestModule.setText(this.qTestModule.getName());
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.DIA_MSG_UNABLE_TO_UPDATE_MODULE, (String)e.getMessage());
        }
    }

    private void findTestCaseFolder() {
        try {
            TestCaseFolderEntityProvider entityProvider = new TestCaseFolderEntityProvider(this.folderIds);
            TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(this.getShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)entityProvider, (AbstractEntityViewerFilter)new EntityViewerFilter((EntityProvider)entityProvider));
            dialog.setAllowMultiple(false);
            dialog.setTitle(StringConstants.DIA_TITLE_TEST_CASE_FOLDER_BROWSER);
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            FolderEntity rootFolder = FolderController.getInstance().getTestCaseRoot(currentProject);
            FolderTreeEntity rootFolderTreeEntity = new FolderTreeEntity(rootFolder, null);
            FolderEntity selectedFolderEntity = FolderController.getInstance().getFolderByDisplayId(currentProject, this.folderId);
            if (selectedFolderEntity != null) {
                dialog.setInitialSelection((Object)new FolderTreeEntity(selectedFolderEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)selectedFolderEntity.getParentFolder(), (FolderEntity)rootFolder)));
            }
            dialog.setInput(Arrays.asList(rootFolderTreeEntity));
            if (dialog.open() == 0) {
                Object[] results = dialog.getResult();
                if (results == null || results.length != 1) {
                    return;
                }
                FolderTreeEntity folderTreeEntity = (FolderTreeEntity)results[0];
                this.folderId = folderTreeEntity.getObject().getIdForDisplay();
                this.txtKatalonFolder.setText(this.folderId);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.DIA_MSG_UNABLE_TO_FIND_TEST_CASE_FOLDER, (String)e.getClass().getSimpleName());
        }
    }

    public TestCaseRepo getTestCaseRepo() {
        TestCaseRepo repo = new TestCaseRepo();
        repo.setQTestModule(this.qTestModule);
        repo.setQTestProject(this.qTestProject);
        repo.setFolderId(this.folderId);
        return repo;
    }

    private void validate() {
        if (this.qTestProject == null || this.qTestModule == null || this.folderId == null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }
}

