/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.handler.AbstractQTestHandler;
import com.kms.katalon.composer.integration.qtest.job.UploadTestSuiteJob;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.model.TestSuiteQTestSuitePair;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class QTestUploadTestSuiteHandler
extends AbstractQTestHandler {
    @Inject
    private ESelectionService selectionService;
    private List<TestSuiteQTestSuitePair> fPairs;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CanExecute
    public boolean canExecute() {
        FolderEntity folderEntity;
        block9: {
            Object selectedEntity;
            block8: {
                ProjectEntity projectEntity;
                block7: {
                    projectEntity = ProjectController.getInstance().getCurrentProject();
                    selectedEntity = this.getFirstSelectedObject(this.selectionService);
                    if (selectedEntity != null) break block7;
                    return false;
                }
                if (QTestIntegrationUtil.canBeUploaded((IntegratedFileEntity)((IntegratedFileEntity)selectedEntity), (ProjectEntity)projectEntity)) break block8;
                return false;
            }
            this.fPairs = new ArrayList<TestSuiteQTestSuitePair>();
            if (selectedEntity instanceof TestSuiteEntity) {
                this.qualify((TestSuiteEntity)selectedEntity);
                return this.fPairs.size() > 0;
            }
            if (!(selectedEntity instanceof FolderEntity)) return this.fPairs.size() > 0;
            folderEntity = (FolderEntity)selectedEntity;
            if (folderEntity.getFolderType() == FolderEntity.FolderType.TESTSUITE) break block9;
            return false;
        }
        try {
            for (Object childObject : FolderController.getInstance().getAllDescentdantEntities(folderEntity)) {
                if (!(childObject instanceof TestSuiteEntity)) continue;
                this.qualify((TestSuiteEntity)childObject);
            }
            return this.fPairs.size() > 0;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    private void qualify(TestSuiteEntity testSuite) {
        try {
            List unUploadedQTestSuites = QTestIntegrationUtil.getUnuploadedQTestSuites((TestSuiteEntity)testSuite);
            if (unUploadedQTestSuites.size() > 0) {
                TestSuiteQTestSuitePair pair = new TestSuiteQTestSuitePair(testSuite, unUploadedQTestSuites);
                this.fPairs.add(pair);
            }
        }
        catch (QTestInvalidFormatException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Execute
    public void execute() {
        UploadTestSuiteJob job = new UploadTestSuiteJob(this.fPairs);
        job.doTask();
    }
}

