/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.StatusUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.model.CheckForTestCaseUpdatesResult;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.QTestSyncStatusUtil;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.ParityReportSummary;
import com.kms.katalon.integration.qtest.model.QTestTestCaseDiff;
import java.io.InterruptedIOException;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CheckForTestCaseUpdatesJob
extends QTestJob {
    private TestCaseEntity testCase;
    private CheckForTestCaseUpdatesResult result = new CheckForTestCaseUpdatesResult();

    public CheckForTestCaseUpdatesJob(String name, TestCaseEntity testCase) {
        super(name);
        this.testCase = testCase;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(StringConstants.JOB_TASK_FETCH_VERSION_AND_TEST_STEPS, 2);
        ProjectEntity project = this.getCurrentProject();
        try {
            if (monitor.isCanceled()) {
                throw new InterruptedIOException();
            }
            monitor.subTask(StringConstants.JOB_SUB_TASK_CHECK_VERSION);
            QTestSyncStatusUtil.recursivelyUnmarkAllStatuses((IntegratedFileEntity)this.testCase, (ProjectEntity)project);
            ParityReportSummary summary = ParityReportSummary.getSummaryForTestCases(Arrays.asList(this.testCase));
            if (summary.hasError(this.testCase)) {
                this.result.addError(this.testCase, summary.getError(this.testCase));
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (!summary.hasTestCaseWithVersionChanged()) {
                monitor.worked(2);
                this.result.setUpToDate(true);
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH", null);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.result.setUpToDate(false);
            QTestTestCase obsoleteTestCase = ((QTestTestCaseDiff)summary.getVersionDiffs().get(0)).getObsoleteQTestTestCase();
            QTestTestCase latestTestCase = ((QTestTestCaseDiff)summary.getVersionDiffs().get(0)).getLatestQTestTestCase();
            String currentVersion = obsoleteTestCase.getVersion();
            String latestVersion = latestTestCase.getVersion();
            String latestDescription = latestTestCase.getDescription();
            this.result.setCurrentVersion(currentVersion);
            this.result.setLatestVersion(latestVersion);
            this.result.setLatestDescription(latestDescription);
            monitor.worked(1);
            monitor.subTask(StringConstants.JOB_SUB_TASK_CHECK_TEST_STEPS);
            if (summary.hasTestCaseWithTestStepsChanged()) {
                String qTestStepDescription = QTestIntegrationUtil.getListTestStepDescription((QTestTestCase)latestTestCase);
                this.result.setLatestContent(qTestStepDescription);
            }
            monitor.worked(1);
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH", null);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            monitor.setCanceled(true);
            IStatus iStatus = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    public CheckForTestCaseUpdatesResult getCheckForUpdatesResult() {
        return this.result;
    }
}

