/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.StatusUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testcase.events.TestCaseUpdatedEvent;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.model.TestCaseRepo;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;

public class DisintegrateTestCaseJob
extends QTestJob {
    private boolean fCleanRepo;

    public DisintegrateTestCaseJob(boolean cleanRepo) {
        super(StringConstants.JOB_TITLE_DISINTEGRATE_TEST_CASE);
        this.setUser(true);
        this.fCleanRepo = cleanRepo;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(StringConstants.JOB_TASK_DISINTEGRATE_TEST_CASE, this.getFileEntities().size());
        for (FileEntity fileEntity : this.getFileEntities()) {
            try {
                if (fileEntity instanceof TestCaseEntity) {
                    TestCaseEntity testCaseEntity = (TestCaseEntity)fileEntity;
                    String testCaseId = testCaseEntity.getIdForDisplay();
                    monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_DISINTEGRATE_TEST_CASE, testCaseId));
                    IntegratedEntity testCaseIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity);
                    testCaseEntity.getIntegratedEntities().remove(testCaseIntegratedEntity);
                    TestCaseController.getInstance().updateTestCase(testCaseEntity);
                    this.getEventBroker().post("TESTCASE/UPDATED", (Object)new TestCaseUpdatedEvent(testCaseEntity.getId(), (FileEntity)testCaseEntity));
                    this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)testCaseEntity, (ProjectEntity)this.projectEntity));
                } else if (fileEntity instanceof FolderEntity) {
                    FolderEntity folderEntity = (FolderEntity)fileEntity;
                    if (folderEntity.getFolderType() != FolderEntity.FolderType.TESTCASE) continue;
                    String folderId = folderEntity.getIdForDisplay();
                    monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_DISINTEGRATE_TEST_CASE, folderId));
                    IntegratedEntity folderIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folderEntity);
                    if (folderIntegratedEntity != null) {
                        TestCaseRepo repo = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)folderEntity, (ProjectEntity)this.projectEntity);
                        if (repo != null && repo.getFolderId().equals(folderId)) {
                            if (this.fCleanRepo) {
                                this.removeTestCaseRepoFromProject(folderId, repo.getQTestProject());
                                this.saveFolder(folderEntity, folderIntegratedEntity);
                            }
                        } else {
                            this.saveFolder(folderEntity, folderIntegratedEntity);
                        }
                    }
                    for (Object childTestCaseEntityObject : FolderController.getInstance().getAllDescentdantEntities(folderEntity)) {
                        if (!(childTestCaseEntityObject instanceof IntegratedFileEntity)) continue;
                        if (childTestCaseEntityObject instanceof TestCaseEntity) {
                            TestCaseEntity testCaseEntity = (TestCaseEntity)childTestCaseEntityObject;
                            IntegratedEntity testCaseIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity);
                            if (testCaseIntegratedEntity != null) {
                                testCaseEntity.getIntegratedEntities().remove(testCaseIntegratedEntity);
                                TestCaseController.getInstance().updateTestCase(testCaseEntity);
                                this.getEventBroker().post("TESTCASE/UPDATED", (Object)new TestCaseUpdatedEvent(testCaseEntity.getId(), (FileEntity)testCaseEntity));
                            }
                        } else {
                            FolderEntity childFolderEntity = (FolderEntity)childTestCaseEntityObject;
                            IntegratedEntity childFolderIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)childFolderEntity);
                            if (folderIntegratedEntity == null) continue;
                            childFolderEntity.getIntegratedEntities().remove(childFolderIntegratedEntity);
                            FolderController.getInstance().saveFolder(childFolderEntity);
                        }
                        this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)folderEntity, (FolderEntity)FolderController.getInstance().getTestCaseRoot(this.projectEntity)));
                    }
                }
                monitor.worked(1);
            }
            catch (Exception e) {
                monitor.setCanceled(true);
                return StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    private void saveFolder(FolderEntity folderEntity, IntegratedEntity folderIntegratedEntity) throws Exception {
        folderEntity.getIntegratedEntities().remove(folderIntegratedEntity);
        FolderController.getInstance().saveFolder(folderEntity);
    }

    private void removeTestCaseRepoFromProject(String folderId, QTestProject qTestProject) throws Exception {
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.projectEntity);
        List qTestProjects = QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)projectIntegratedEntity);
        for (QTestProject systemQTestProject : qTestProjects) {
            if (!systemQTestProject.equals((Object)qTestProject)) continue;
            systemQTestProject.getTestCaseFolderIds().remove(folderId);
        }
        IntegratedEntity projectNewIntegratedEntity = QTestIntegrationProjectManager.getIntegratedEntityByQTestProjects((List)qTestProjects);
        this.projectEntity = (ProjectEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)this.projectEntity, (IntegratedEntity)projectNewIntegratedEntity);
        ProjectController.getInstance().updateProject(this.projectEntity);
    }
}

