/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IUserFileDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.UserFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UserFileServiceDataProvider
implements IUserFileDataProvider {
    public List<FileEntity> getChildren(FolderEntity parentFolder) throws DALException {
        File folder = new File(parentFolder.getLocation());
        if (!folder.exists() || folder.listFiles() == null) {
            return Collections.emptyList();
        }
        ArrayList<FileEntity> fileEntities = new ArrayList<FileEntity>();
        File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                UserFileEntity fileEntity = new UserFileEntity(file);
                fileEntity.setParentFolder(parentFolder);
                fileEntity.setProject(parentFolder.getProject());
                fileEntities.add((FileEntity)fileEntity);
            } else {
                FolderEntity childFolder = new FolderEntity();
                childFolder.setFolderType(FolderEntity.FolderType.USER);
                childFolder.setName(file.getName());
                childFolder.setParentFolder(parentFolder);
                childFolder.setProject(parentFolder.getProject());
                fileEntities.add((FileEntity)childFolder);
            }
            ++n2;
        }
        fileEntities.sort(new Comparator<FileEntity>(){

            @Override
            public int compare(FileEntity fileA, FileEntity fileB) {
                if (fileA instanceof FolderEntity && fileB instanceof UserFileEntity) {
                    return 1;
                }
                if (fileB instanceof FolderEntity && fileA instanceof UserFileEntity) {
                    return -1;
                }
                return fileA.getName().compareToIgnoreCase(fileB.getName());
            }
        });
        return fileEntities;
    }

    public UserFileEntity newFile(String name, FolderEntity parentFolder) throws DALException {
        try {
            File file = new File(parentFolder.getLocation(), name);
            file.createNewFile();
            UserFileEntity fileEntity = new UserFileEntity(file);
            fileEntity.setParentFolder(parentFolder);
            fileEntity.setProject(parentFolder.getProject());
            return fileEntity;
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
    }

    public UserFileEntity newRootFile(String name, ProjectEntity project) throws DALException {
        try {
            File file = new File(project.getFolderLocation(), name);
            file.createNewFile();
            UserFileEntity fileEntity = new UserFileEntity(file);
            fileEntity.setProject(project);
            return fileEntity;
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
    }

    public UserFileEntity renameFile(String newName, UserFileEntity userFileEntity) {
        File newFile = userFileEntity.getParentFolder() != null ? new File(userFileEntity.getParentFolder().getLocation(), newName) : new File(userFileEntity.getProject().getFolderLocation(), newName);
        userFileEntity.getFile().renameTo(newFile);
        userFileEntity.setFile(newFile);
        return userFileEntity;
    }

    public void deleteFile(UserFileEntity userFileEntity) {
        userFileEntity.getFile().delete();
    }

    public UserFileEntity getUserFileEntity(String userFilePath, ProjectEntity projectEntity) throws DALException {
        try {
            File userFile = new File(userFilePath);
            UserFileEntity userFileEntity = new UserFileEntity(userFile);
            userFileEntity.setParentFolder(FolderFileServiceManager.getFolder(userFile.getParent()));
            userFileEntity.setProject(projectEntity);
            return userFileEntity;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

