/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IWindowsElementDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.io.File;
import java.util.List;

public class WindowsElementFileServiceDataProvider
implements IWindowsElementDataProvider {
    private EntityService getEntityService() throws DALException {
        try {
            return EntityService.getInstance();
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public WindowsElementEntity get(String id) throws DALException {
        try {
            WindowsElementEntity testSuiteCollection = (WindowsElementEntity)EntityFileServiceManager.get(new File(id));
            if (testSuiteCollection != null) {
                testSuiteCollection.setProject(DataProviderState.getInstance().getCurrentProject());
            }
            return testSuiteCollection;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public List<WindowsElementEntity> getChildren(FolderEntity parentFolder) throws DALException {
        return null;
    }

    public void delete(String id) throws DALException {
        WindowsElementEntity windowsElementEntity = this.get(id);
        if (windowsElementEntity == null) {
            return;
        }
        try {
            EntityService.getInstance().deleteEntity((FileEntity)windowsElementEntity);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public WindowsElementEntity add(FolderEntity parentFolder, String newName) throws DALException, FilePathTooLongException {
        try {
            this.getEntityService().validateName(newName);
            this.checkDuplicate(parentFolder, newName, null);
            WindowsElementEntity windowsElementEntity = new WindowsElementEntity();
            windowsElementEntity.setParentFolder(parentFolder);
            windowsElementEntity.setProject(parentFolder.getProject());
            windowsElementEntity.setName(newName);
            PathValidationUtil.validatePathLength((FileEntity)windowsElementEntity);
            this.getEntityService().saveEntity((FileEntity)windowsElementEntity);
            return windowsElementEntity;
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    private void checkDuplicate(FolderEntity parentFolder, String newName, String oldName) throws DALException {
        if (!newName.equals(this.getEntityService().getAvailableName(parentFolder.getId(), newName, true, oldName))) {
            throw new InvalidNameException(StringConstants.DP_EXC_NAME_ALREADY_EXISTED);
        }
    }

    public WindowsElementEntity rename(String id, String newName) throws DALException, FilePathTooLongException {
        WindowsElementEntity currentWindowsElementEntity;
        block4: {
            this.getEntityService().validateName(newName);
            currentWindowsElementEntity = this.get(id);
            if (currentWindowsElementEntity != null) break block4;
            return null;
        }
        try {
            String oldId = currentWindowsElementEntity.getIdForDisplay();
            this.checkDuplicate(currentWindowsElementEntity.getParentFolder(), newName, currentWindowsElementEntity.getName());
            WindowsElementEntity clonedWindowsElementEntity = (WindowsElementEntity)currentWindowsElementEntity.clone();
            clonedWindowsElementEntity.setName(newName);
            PathValidationUtil.validatePathLength((FileEntity)clonedWindowsElementEntity);
            this.getEntityService().deleteEntity((FileEntity)currentWindowsElementEntity);
            currentWindowsElementEntity.setName(newName);
            this.getEntityService().saveEntity((FileEntity)currentWindowsElementEntity);
            TestArtifactScriptRefactor.createForWindowsObjectEntity((String)oldId).updateReferenceForProject(currentWindowsElementEntity.getIdForDisplay(), currentWindowsElementEntity.getProject());
            return currentWindowsElementEntity;
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public WindowsElementEntity update(WindowsElementEntity windowsElement) throws DALException {
        try {
            this.getEntityService().saveEntity((FileEntity)windowsElement);
            return this.get(windowsElement.getId());
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public WindowsElementEntity move(String id, FolderEntity newLocation) throws DALException, FilePathTooLongException {
        WindowsElementEntity windowsElementEntity = this.get(id);
        if (windowsElementEntity.getParentFolder().equals((Object)newLocation)) {
            return null;
        }
        String oldId = windowsElementEntity.getIdForDisplay();
        try {
            WindowsElementEntity movedElement = EntityFileServiceManager.move(windowsElementEntity, newLocation);
            TestArtifactScriptRefactor.createForWindowsObjectEntity((String)oldId).updateReferenceForProject(movedElement.getIdForDisplay(), windowsElementEntity.getProject());
            return movedElement;
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public WindowsElementEntity copy(String id, FolderEntity location) throws DALException, FilePathTooLongException {
        WindowsElementEntity windowsElementEntity = this.get(id);
        try {
            return EntityFileServiceManager.copy(windowsElementEntity, location);
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

