/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.dataprovider.setting.FileServiceDataProviderSetting;
import com.kms.katalon.dal.fileservice.manager.DataFileFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.ProjectFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestCaseFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestSuiteFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.WebElementFileServiceManager;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.dal.exception.CancelTaskException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.DataFilePropertyInputEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.util.ImportDuplicateEntityParameter;
import com.kms.katalon.entity.util.ImportDuplicateEntityResult;
import com.kms.katalon.entity.util.ImportType;
import com.kms.katalon.entity.util.Util;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class ImportFileServiceManager {
    public static final String PROGRESS = "progress";
    public static final String DUPLICATE_ENTITY = "duplicateentity";
    public static final long timeSleep = 100L;
    private int progress;
    private PropertyChangeSupport propertyChangeSupport;
    private ImportDuplicateEntityResult importDuplicateEntityResult;
    private ImportDuplicateEntityResult importDuplicateEntityResultFolder;
    private ImportDuplicateEntityResult importDuplicateEntityResultEntity;
    private boolean isCreateNewProject;
    private String projectName;
    private ProjectEntity currentProject;
    private ProjectEntity importProject;
    private ProjectEntity originalProject;
    private ImportType[] dataFileImportType;
    private ImportType[] folderImportType;
    private ImportType[] testObjectParentImportType;
    private ImportType[] testObjectChildrenImportType;
    private ImportType[] testCaseImportType;
    private ImportType[] testSuiteImportType;
    private Map<String, String> badTestCases;
    private boolean isCancelImportTask;
    private boolean isWaitingConfirmation;
    private Map<String, String> nameChangedDataFileFolders;
    private Map<String, String> nameChangedTestCaseFolders;
    private Map<String, String> nameChangedTestCases;
    private Map<String, String> nameChangedDataFiles;
    private Map<String, String> nameChangedWebElements;
    private List<TestCaseEntity> importedTestCase;
    private FolderEntity importWebElementRootFolder;

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.propertyChangeSupport.firePropertyChange(PROGRESS, this.progress, progress);
        this.progress = progress;
    }

    public Map<String, String> getBadTestCases() {
        return this.badTestCases;
    }

    private void raiseDuplicateEntityEvent(ImportType[] availableImportTypes, String message) {
        ImportDuplicateEntityParameter importDuplicateEntityParameter = new ImportDuplicateEntityParameter(availableImportTypes, message);
        this.propertyChangeSupport.firePropertyChange(DUPLICATE_ENTITY, null, importDuplicateEntityParameter);
    }

    private ImportDuplicateEntityResult getImportDuplicateEntityResult() {
        return this.importDuplicateEntityResult;
    }

    public void setImportDuplicateEntityResult(ImportDuplicateEntityResult importDuplicateEntityResult) {
        this.importDuplicateEntityResult = importDuplicateEntityResult;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    private boolean isCreateNewProject() {
        return this.isCreateNewProject;
    }

    private void setCreateNewProject(boolean isCreateNewProject) {
        this.isCreateNewProject = isCreateNewProject;
    }

    private String getProjectName() {
        return this.projectName;
    }

    private void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    private ProjectEntity getCurrentProject() {
        return this.currentProject;
    }

    private void setCurrentProject(ProjectEntity currentProject) {
        this.currentProject = currentProject;
    }

    public ImportFileServiceManager(boolean isCreateNewProject, String projectName, ProjectEntity currentProject) {
        this.setCreateNewProject(isCreateNewProject);
        this.setCurrentProject(currentProject);
        this.setCancelImportTask(false);
        this.setProjectName(projectName);
        this.setWaitingConfirmation(false);
        this.folderImportType = new ImportType[]{ImportType.New, ImportType.Merge};
        this.dataFileImportType = new ImportType[]{ImportType.New, ImportType.Override};
        this.testObjectParentImportType = new ImportType[]{ImportType.New, ImportType.Merge};
        this.testObjectChildrenImportType = new ImportType[]{ImportType.New, ImportType.Override};
        this.testCaseImportType = new ImportType[]{ImportType.New, ImportType.Override};
        this.testSuiteImportType = new ImportType[]{ImportType.New, ImportType.Override, ImportType.Merge};
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setImportDuplicateEntityResult(null);
        this.importDuplicateEntityResultFolder = null;
        this.importDuplicateEntityResultEntity = null;
        this.badTestCases = new HashMap<String, String>();
        this.nameChangedDataFileFolders = new HashMap<String, String>();
        this.nameChangedTestCaseFolders = new HashMap<String, String>();
        this.nameChangedTestCases = new HashMap<String, String>();
        this.nameChangedDataFiles = new HashMap<String, String>();
        this.nameChangedWebElements = new HashMap<String, String>();
        this.importedTestCase = new ArrayList<TestCaseEntity>();
    }

    public ProjectEntity executeImport(File importDirectory) throws Exception {
        int importProcess = 0;
        File tempProjectDirectory = null;
        this.originalProject = this.currentProject;
        try {
            File file;
            EntityService.getInstance().getEntityCache().clear();
            ProjectEntity project = null;
            if (this.isCreateNewProject()) {
                this.importProject = project = ProjectFileServiceManager.getProject(this.findEntityFile(ProjectEntity.getProjectFileExtension(), importDirectory).getAbsolutePath());
                tempProjectDirectory = importDirectory;
                project = ProjectFileServiceManager.addNewProject(this.getProjectName(), project.getDescription(), project.getPageLoadTimeout(), importDirectory.getParent());
                this.setCurrentProject(project);
            } else {
                project = this.getCurrentProject();
                this.importProject = ProjectFileServiceManager.getProject(this.findEntityFile(ProjectEntity.getProjectFileExtension(), importDirectory).getAbsolutePath());
                tempProjectDirectory = new File(project.getFolderLocation() + "_Temp_" + System.currentTimeMillis());
                FileUtils.copyDirectory((File)new File(project.getFolderLocation()), (File)tempProjectDirectory);
            }
            this.checkCancelImportTask();
            this.setProgress(importProcess += 3);
            DataProviderState.getInstance().setCurrentProject(this.currentProject);
            File[] fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.getName().equalsIgnoreCase(FileServiceConstant.DATA_FILE_ROOT_FOLDER_NAME) && file.isDirectory()) {
                    this.importDataFile(FolderFileServiceManager.getFolder(FileServiceConstant.getDataFileRootFolderLocation(project.getFolderLocation())), project, file);
                    break;
                }
                ++n2;
            }
            this.importDuplicateEntityResultEntity = null;
            this.checkCancelImportTask();
            this.setProgress(importProcess += 4);
            DataProviderState.getInstance().setCurrentProject(this.currentProject);
            fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.getName().equalsIgnoreCase(FileServiceConstant.OBJECT_REPOSITORY_ROOT_FOLDER_NAME) && file.isDirectory()) {
                    this.importWebElementRootFolder = FolderFileServiceManager.getFolder(FileServiceConstant.getObjectRepositoryRootFolderLocation(project.getFolderLocation()));
                    this.importTestObject(this.importWebElementRootFolder, project, null, file);
                    break;
                }
                ++n2;
            }
            this.importDuplicateEntityResultEntity = null;
            this.checkCancelImportTask();
            this.setProgress(importProcess += 3);
            DataProviderState.getInstance().setCurrentProject(this.currentProject);
            fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.getName().equalsIgnoreCase(FileServiceConstant.TEST_CASE_ROOT_FOLDER_NAME) && file.isDirectory()) {
                    this.importTestCase(FolderFileServiceManager.getFolder(FileServiceConstant.getTestCaseRootFolderLocation(project.getFolderLocation())), project, file);
                    break;
                }
                ++n2;
            }
            this.importDuplicateEntityResultEntity = null;
            this.checkCancelImportTask();
            this.setProgress(importProcess += 6);
            DataProviderState.getInstance().setCurrentProject(this.currentProject);
            fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.getName().equalsIgnoreCase(FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME) && file.isDirectory()) {
                    this.importTestSuite(FolderFileServiceManager.getFolder(FileServiceConstant.getTestSuiteRootFolderLocation(project.getFolderLocation())), project, file);
                    break;
                }
                ++n2;
            }
            this.importDuplicateEntityResultEntity = null;
            this.checkCancelImportTask();
            this.setProgress(importProcess += 3);
            EntityService.getInstance().getEntityCache().clear();
            ProjectEntity projectEntity = project;
            return projectEntity;
        }
        catch (Exception e) {
            if (tempProjectDirectory != null && tempProjectDirectory.exists()) {
                File projectFolder = new File(this.getCurrentProject().getFolderLocation());
                if (projectFolder.exists() && projectFolder.isDirectory()) {
                    FileUtils.cleanDirectory((File)projectFolder);
                }
                if (!this.isCreateNewProject) {
                    FileUtils.copyDirectory((File)tempProjectDirectory, (File)projectFolder);
                }
            }
            throw e;
        }
        finally {
            if (tempProjectDirectory != null && tempProjectDirectory.isDirectory() && !this.isCreateNewProject) {
                FileUtils.deleteDirectory((File)tempProjectDirectory);
            }
            DataProviderState.getInstance().setCurrentProject(this.originalProject);
        }
    }

    private void checkCancelImportTask() throws CancelTaskException {
        if (this.isCancelImportTask()) {
            throw new CancelTaskException();
        }
    }

    public File findEntityFile(String fileExtension, File directory) {
        int i = 0;
        while (i < directory.listFiles(EntityFileServiceManager.fileFilter).length) {
            if (directory.listFiles(EntityFileServiceManager.fileFilter)[i].getName().toLowerCase().endsWith(fileExtension.toLowerCase()) && directory.listFiles(EntityFileServiceManager.fileFilter)[i].isFile()) {
                return directory.listFiles(EntityFileServiceManager.fileFilter)[i];
            }
            ++i;
        }
        return null;
    }

    public File findFolder(String folderName, File directory) {
        int i = 0;
        while (i < directory.listFiles(EntityFileServiceManager.fileFilter).length) {
            if (directory.listFiles(EntityFileServiceManager.fileFilter)[i].getName().toLowerCase().equals(folderName.toLowerCase()) && directory.listFiles(EntityFileServiceManager.fileFilter)[i].isDirectory()) {
                return directory.listFiles(EntityFileServiceManager.fileFilter)[i];
            }
            ++i;
        }
        return null;
    }

    private FolderEntity importFolder(FolderEntity parentFolder, FolderEntity folder, ProjectEntity project, String rootFolderName, Map<String, String> nameChangedFolders) throws Exception, InterruptedException {
        this.checkCancelImportTask();
        DataProviderState.getInstance().setCurrentProject(this.currentProject);
        FolderEntity duplicateFolder = FolderFileServiceManager.getFolderByName(parentFolder, folder.getName(), project);
        if (duplicateFolder != null) {
            ImportDuplicateEntityResult result;
            if (!folder.getName().equals(rootFolderName)) {
                if (this.importDuplicateEntityResultFolder == null) {
                    StringBuilder folderStringBuilder = new StringBuilder("Folder: ");
                    folderStringBuilder.append(folder.getName());
                    this.importDuplicateEntityResultFolder = this.getDuplicateDialogResult(this.folderImportType, folderStringBuilder);
                }
                result = new ImportDuplicateEntityResult(this.importDuplicateEntityResultFolder.getImportType(), this.importDuplicateEntityResultFolder.isApplyToAll());
            } else {
                result = new ImportDuplicateEntityResult(ImportType.Merge, false);
            }
            if (result.getImportType() == ImportType.New) {
                String newFolderName = FolderFileServiceManager.getAvailableFolderName(parentFolder, folder.getName());
                if (nameChangedFolders != null) {
                    nameChangedFolders.put(folder.getRelativePath(), newFolderName);
                }
                folder.setName(newFolderName);
                folder = this.saveFolderEntity(parentFolder, folder);
            } else if (result.getImportType() == ImportType.Merge) {
                folder = duplicateFolder;
            }
            if (this.importDuplicateEntityResultFolder != null && !this.importDuplicateEntityResultFolder.isApplyToAll()) {
                this.importDuplicateEntityResultFolder = null;
            }
        } else {
            folder = this.saveFolderEntity(parentFolder, folder);
        }
        return folder;
    }

    private FolderEntity saveFolderEntity(FolderEntity parentFolder, FolderEntity folder) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.currentProject);
        return FolderFileServiceManager.addNewFolder(parentFolder, folder.getName());
    }

    private FolderEntity getFolderFromImportProject(File file) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.importProject);
        return FolderFileServiceManager.getFolder(file.getAbsolutePath());
    }

    public void importDataFile(FolderEntity parentFolder, ProjectEntity project, File importDirectory) throws Exception {
        this.checkCancelImportTask();
        File[] fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderEntity folderEntity = this.getFolderFromImportProject(file);
                folderEntity = this.importFolder(parentFolder, folderEntity, project, FileServiceConstant.DATA_FILE_ROOT_FOLDER_NAME, this.nameChangedDataFileFolders);
                this.importDataFile(folderEntity, project, file);
            } else if (file.isFile() && file.getName().toLowerCase().endsWith(DataFileEntity.getTestDataFileExtension().toLowerCase())) {
                DataFileEntity dataFile = this.createDataFile(file);
                dataFile = this.importDataFileEntity(parentFolder, dataFile, project);
            }
            ++n2;
        }
    }

    private DataFileEntity importDataFileEntity(FolderEntity parentFolder, DataFileEntity dataFile, ProjectEntity project) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.currentProject);
        DataFileEntity duplicateDataFile = DataFileFileServiceManager.getDuplicatedDataFile(parentFolder, dataFile.getName());
        this.updateDataFileGUID(project, dataFile);
        if (duplicateDataFile != null) {
            if (this.importDuplicateEntityResultEntity == null) {
                StringBuilder dataFileStringBuilder = new StringBuilder("Data File: ");
                dataFileStringBuilder.append(dataFile.getName());
                this.importDuplicateEntityResultEntity = this.getDuplicateDialogResult(this.dataFileImportType, dataFileStringBuilder);
            }
            if (this.importDuplicateEntityResultEntity.getImportType() == ImportType.New) {
                String oldLocation = dataFile.getRelativePath();
                dataFile.setName(DataFileFileServiceManager.getAvailableDataFileName(parentFolder, dataFile.getName()));
                this.saveDataFileEntity(parentFolder, dataFile);
                this.nameChangedDataFiles.put(oldLocation, dataFile.getName());
            } else if (this.importDuplicateEntityResultEntity.getImportType() == ImportType.Override) {
                DataFilePropertyInputEntity dataFileInputProperties = new DataFilePropertyInputEntity();
                dataFileInputProperties.setPk(duplicateDataFile.getLocation());
                dataFileInputProperties.setName(duplicateDataFile.getName());
                dataFileInputProperties.setDescription(dataFile.getDescription());
                dataFileInputProperties.setDataFileDriver(dataFile.getDriver().toString());
                dataFileInputProperties.setdataSourceURL(dataFile.getDataSourceUrl());
                dataFileInputProperties.setSheetName(dataFile.getSheetName());
                dataFileInputProperties.setIsInternalPath(dataFile.getIsInternalPath());
                dataFile = DataFileFileServiceManager.updateDataFileProperty(dataFileInputProperties, project);
            }
            if (!this.importDuplicateEntityResultEntity.isApplyToAll()) {
                this.importDuplicateEntityResultEntity = null;
            }
        } else {
            this.saveDataFileEntity(parentFolder, dataFile);
        }
        return dataFile;
    }

    private void saveDataFileEntity(FolderEntity parentFolder, DataFileEntity dataFile) throws Exception {
        DataFileEntity newDataFile = dataFile.clone();
        newDataFile.setParentFolder(parentFolder);
        newDataFile.setProject(parentFolder.getProject());
        newDataFile.setDataFileGUID(Util.generateGuid());
        PathValidationUtil.validatePathLength((FileEntity)newDataFile);
        EntityService.getInstance().saveEntity((FileEntity)newDataFile);
    }

    private boolean updateDataFileGUID(ProjectEntity project, DataFileEntity dataFile) throws Exception {
        DataFileEntity duplicatedDataFile = DataFileFileServiceManager.getByGUID(dataFile.getDataFileGUID(), project);
        if (duplicatedDataFile != null) {
            dataFile.setDataFileGUID(UUID.randomUUID().toString());
            return true;
        }
        return false;
    }

    public void importTestObject(FolderEntity parentFolder, ProjectEntity project, WebElementEntity parentWebElement, File importDirectory) throws Exception {
        this.checkCancelImportTask();
        File[] fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderEntity folderEntity = this.getFolderFromImportProject(file);
                folderEntity = this.importFolder(parentFolder, folderEntity, project, FileServiceConstant.OBJECT_REPOSITORY_ROOT_FOLDER_NAME, null);
                this.importTestObject(folderEntity, project, parentWebElement, file);
            } else if (file.isFile() && file.getName().toLowerCase().endsWith(WebElementEntity.getWebElementFileExtension().toLowerCase())) {
                boolean isParent = false;
                WebElementEntity webElement = this.createWebElement(file);
                this.importWebElementEntity(parentFolder, parentWebElement, webElement, project, isParent);
                if (this.importDuplicateEntityResultEntity != null && !this.importDuplicateEntityResultEntity.isApplyToAll()) {
                    this.importDuplicateEntityResultEntity = null;
                }
                if (this.importDuplicateEntityResultFolder != null && !this.importDuplicateEntityResultFolder.isApplyToAll()) {
                    this.importDuplicateEntityResultFolder = null;
                }
            }
            ++n2;
        }
    }

    private WebElementEntity importWebElementEntity(FolderEntity parentFolder, WebElementEntity parentWebElement, WebElementEntity webElement, ProjectEntity project, boolean isParent) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.currentProject);
        WebElementEntity duplicateWebElement = WebElementFileServiceManager.getDuplicateWebElement(parentWebElement, parentFolder, webElement.getName(), project);
        WebElementEntity newWebElement = null;
        if (duplicateWebElement != null) {
            StringBuilder webElementStringBuilder = new StringBuilder("Test Object: ");
            webElementStringBuilder.append(webElement.getName());
            if (this.importDuplicateEntityResultFolder == null && isParent) {
                webElementStringBuilder.append(" (which have children test objects)");
                this.importDuplicateEntityResultFolder = this.getDuplicateDialogResult(this.testObjectParentImportType, webElementStringBuilder);
            } else if (this.importDuplicateEntityResultEntity == null && !isParent) {
                this.importDuplicateEntityResultEntity = this.getDuplicateDialogResult(this.testObjectChildrenImportType, webElementStringBuilder);
            }
            if (!isParent && this.importDuplicateEntityResultEntity.getImportType() == ImportType.New || isParent && this.importDuplicateEntityResultFolder.getImportType() == ImportType.New) {
                this.updateWebElementGUID(project, webElement.getElementGuidId());
                newWebElement = this.saveWebElementEntity(parentFolder, parentWebElement, webElement, true);
            } else if (isParent && this.importDuplicateEntityResultFolder.getImportType() == ImportType.Merge || !isParent && this.importDuplicateEntityResultEntity.getImportType() == ImportType.Override) {
                duplicateWebElement.setDescription(webElement.getDescription());
                String oldGuid = duplicateWebElement.getElementGuidId();
                duplicateWebElement.setElementGuidId(webElement.getElementGuidId());
                newWebElement = WebElementFileServiceManager.updateTestObject(duplicateWebElement);
                this.updateWebElementPropertyRefElement(project, oldGuid, webElement);
            }
        } else {
            this.updateWebElementGUID(project, webElement.getElementGuidId());
            newWebElement = this.saveWebElementEntity(parentFolder, parentWebElement, webElement, false);
        }
        return newWebElement;
    }

    private void renameWebElement(FolderEntity parentFolder, WebElementEntity parentWebElement, WebElementEntity webElement) throws Exception {
        String oldLocation = webElement.getLocation();
        webElement.setName(WebElementFileServiceManager.getAvailableWebElementName(parentFolder, webElement.getName()));
        this.nameChangedWebElements.put(oldLocation, webElement.getName());
    }

    private WebElementEntity saveWebElementEntity(FolderEntity parentFolder, WebElementEntity parentWebElement, WebElementEntity webElement, boolean isRenamed) throws Exception {
        WebElementEntity newWebElement = webElement.clone();
        if (isRenamed) {
            PathValidationUtil.validatePathLength((FileEntity)newWebElement);
            this.renameWebElement(parentFolder, parentWebElement, newWebElement);
        }
        newWebElement.setParentFolder(parentFolder);
        newWebElement.setProject(this.currentProject);
        EntityService.getInstance().saveEntity((FileEntity)newWebElement);
        return newWebElement;
    }

    private boolean updateWebElementGUID(ProjectEntity project, String guid) throws Exception {
        WebElementEntity webElementEntity = WebElementFileServiceManager.getByGUID(guid, project);
        if (webElementEntity != null) {
            webElementEntity.setElementGuidId(Util.generateGuid());
            WebElementFileServiceManager.updateTestObject(webElementEntity);
            this.updateWebElementPropertyRefElement(project, guid, webElementEntity);
            return true;
        }
        return false;
    }

    private void updateWebElementPropertyRefElement(ProjectEntity project, String guid, WebElementEntity webElementEntity) throws Exception {
        for (WebElementEntity webElementWithRefElements : WebElementFileServiceManager.getWebElementPropertyByRefElement(guid, project, true)) {
            for (WebElementPropertyEntity property : webElementWithRefElements.getWebElementProperties()) {
                if (!property.getName().equalsIgnoreCase("ref_element")) continue;
                property.setValue(webElementEntity.getElementGuidId());
            }
            WebElementFileServiceManager.updateTestObject(webElementWithRefElements);
        }
    }

    public void importTestCase(FolderEntity parentFolder, ProjectEntity project, File importDirectory) throws Exception {
        this.checkCancelImportTask();
        File[] fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderEntity folderEntity = this.getFolderFromImportProject(file);
                folderEntity = this.importFolder(parentFolder, folderEntity, project, FileServiceConstant.TEST_CASE_ROOT_FOLDER_NAME, this.nameChangedTestCaseFolders);
                this.importTestCase(folderEntity, project, file);
            } else if (file.isFile() && file.getName().toLowerCase().endsWith(TestCaseEntity.getTestCaseFileExtension().toLowerCase())) {
                TestCaseEntity testCase = this.createTestCase(file);
                testCase = this.importTestCaseEntity(parentFolder, testCase, project);
            }
            ++n2;
        }
    }

    private TestCaseEntity importTestCaseEntity(FolderEntity parentFolder, TestCaseEntity testCase, ProjectEntity project) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.currentProject);
        TestCaseEntity duplicateTestCase = TestCaseFileServiceManager.getTestCaseByName(parentFolder, testCase.getName());
        this.updateTestCaseGUID(project, testCase);
        if (duplicateTestCase != null) {
            if (this.importDuplicateEntityResultEntity == null) {
                StringBuilder testCaseStringBuilder = new StringBuilder("Test Case: ");
                testCaseStringBuilder.append(testCase.getName());
                this.importDuplicateEntityResultEntity = this.getDuplicateDialogResult(this.testCaseImportType, testCaseStringBuilder);
            }
            if (this.importDuplicateEntityResultEntity.getImportType() == ImportType.New) {
                String oldLocation = testCase.getRelativePath();
                String newName = TestCaseFileServiceManager.getAvailableName(parentFolder, duplicateTestCase.getName());
                testCase.setName(newName);
                testCase = this.saveTestCaseEntity(parentFolder, testCase, project);
                this.nameChangedTestCases.put(oldLocation, testCase.getName());
            } else if (this.importDuplicateEntityResultEntity.getImportType() == ImportType.Override) {
                duplicateTestCase.setComment(testCase.getComment());
                duplicateTestCase.setDescription(testCase.getDescription());
                duplicateTestCase.setTag(testCase.getTag());
                duplicateTestCase.setTestCaseGuid(testCase.getTestCaseGuid());
                duplicateTestCase.setDataFiles(testCase.getDataFiles());
                this.updateTestCaseDataFileLink(project, duplicateTestCase);
                testCase = TestCaseFileServiceManager.updateTestCase(duplicateTestCase);
            }
        } else {
            testCase = this.saveTestCaseEntity(parentFolder, testCase, project);
        }
        this.importedTestCase.add(testCase);
        return testCase;
    }

    private void updateTestCaseDataFileLink(ProjectEntity project, TestCaseEntity newTestCase) {
        for (DataFileEntity dataFile : newTestCase.getDataFiles()) {
            this.checkDataFileNameChanged(dataFile);
            this.setProject(dataFile.getParentFolder(), project);
        }
    }

    private boolean updateTestCaseGUID(ProjectEntity project, TestCaseEntity testCase) throws Exception {
        TestCaseEntity duplicatedTestCase = TestCaseFileServiceManager.getByGUID(testCase.getTestCaseGuid(), project);
        if (duplicatedTestCase != null) {
            testCase.setTestCaseGuid(UUID.randomUUID().toString());
            return true;
        }
        return false;
    }

    private void setProject(FolderEntity folder, ProjectEntity project) {
        if (folder.getParentFolder() == null) {
            folder.setProject(project);
        } else {
            this.setProject(folder.getParentFolder(), project);
        }
    }

    private TestCaseEntity saveTestCaseEntity(FolderEntity parentFolder, TestCaseEntity testCase, ProjectEntity project) throws Exception {
        TestCaseEntity newTestCase = testCase.clone();
        newTestCase.setParentFolder(parentFolder);
        newTestCase.setProject(this.currentProject);
        PathValidationUtil.validatePathLength((FileEntity)newTestCase);
        this.updateTestCaseDataFileLink(project, newTestCase);
        EntityService.getInstance().saveEntity((FileEntity)newTestCase);
        return newTestCase;
    }

    public void importTestSuite(FolderEntity parentFolder, ProjectEntity project, File importDirectory) throws Exception {
        this.checkCancelImportTask();
        File[] fileArray = importDirectory.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderEntity folderEntity = this.getFolderFromImportProject(file);
                folderEntity = this.importFolder(parentFolder, folderEntity, project, FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME, null);
                this.importTestSuite(folderEntity, project, file);
            } else if (file.isFile() && file.getName().toLowerCase().endsWith(TestSuiteEntity.getTestSuiteFileExtension().toLowerCase())) {
                TestSuiteEntity testSuite = this.createTestSuite(file);
                this.importTestSuiteEntity(testSuite, parentFolder, project);
            }
            ++n2;
        }
    }

    private TestSuiteEntity importTestSuiteEntity(TestSuiteEntity testSuite, FolderEntity parentFolder, ProjectEntity project) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.currentProject);
        this.updateTestSuiteGUID(project, testSuite);
        TestSuiteEntity duplicateTestSuite = TestSuiteFileServiceManager.getTestSuiteByName(parentFolder, testSuite.getName());
        if (duplicateTestSuite != null) {
            if (this.importDuplicateEntityResultEntity == null) {
                StringBuilder testSuiteStringBuilder = new StringBuilder("Test Suite: ");
                testSuiteStringBuilder.append(testSuite.getName());
                this.importDuplicateEntityResultEntity = this.getDuplicateDialogResult(this.testSuiteImportType, testSuiteStringBuilder);
            }
            if (this.importDuplicateEntityResultEntity.getImportType() == ImportType.New) {
                testSuite.setName(TestSuiteFileServiceManager.getAvailableTestSuiteName(parentFolder, testSuite.getName()));
                this.saveTestSuiteEntity(testSuite, parentFolder, project);
            } else if (this.importDuplicateEntityResultEntity.getImportType() == ImportType.Override) {
                duplicateTestSuite.setDescription(testSuite.getDescription());
                duplicateTestSuite.setIsRerun(testSuite.getIsRerun());
                duplicateTestSuite.setNumberOfRerun(testSuite.getNumberOfRerun());
                duplicateTestSuite.setPageLoadTimeout(testSuite.getPageLoadTimeout());
                duplicateTestSuite.setTestSuiteGuid(testSuite.getTestSuiteGuid());
                duplicateTestSuite.setTestSuiteTestCaseLinks(testSuite.getTestSuiteTestCaseLinks());
                this.saveTestSuiteEntity(duplicateTestSuite, duplicateTestSuite.getParentFolder(), project);
            } else if (this.importDuplicateEntityResultEntity.getImportType() == ImportType.Merge) {
                if (duplicateTestSuite.getDescription() == null || duplicateTestSuite.getDescription().isEmpty()) {
                    duplicateTestSuite.setDescription(testSuite.getDescription());
                }
                for (TestSuiteTestCaseLink testSuiteTestCaseLink : testSuite.getTestSuiteTestCaseLinks()) {
                    TestCaseEntity testCase = new FileServiceDataProviderSetting().getTestCaseDataProvider().getTestCaseByDisplayId(testSuiteTestCaseLink.getTestCaseId());
                    this.checkTestCaseNameChanged(testCase);
                    this.setProject(testCase.getParentFolder(), project);
                    boolean isExisted = false;
                    for (TestSuiteTestCaseLink oldtestSuiteTestCaseLink : duplicateTestSuite.getTestSuiteTestCaseLinks()) {
                        if (!oldtestSuiteTestCaseLink.getTestCaseId().equals(testCase.getRelativePathForUI())) continue;
                        isExisted = true;
                        break;
                    }
                    if (isExisted) continue;
                    TestSuiteTestCaseLink newTestSuiteTestCaseLink = new TestSuiteTestCaseLink();
                    newTestSuiteTestCaseLink.setTestCaseId(testSuiteTestCaseLink.getTestCaseId());
                    newTestSuiteTestCaseLink.setIsReuseDriver(testSuiteTestCaseLink.getIsReuseDriver());
                    newTestSuiteTestCaseLink.setIsRun(testSuiteTestCaseLink.getIsRun());
                    duplicateTestSuite.getTestSuiteTestCaseLinks().add(newTestSuiteTestCaseLink);
                }
                TestSuiteFileServiceManager.resetParentForChildElement(duplicateTestSuite);
                EntityService.getInstance().saveEntityWithoutCache((FileEntity)duplicateTestSuite);
            }
        } else {
            this.saveTestSuiteEntity(testSuite, parentFolder, project);
        }
        return testSuite;
    }

    private boolean updateTestSuiteGUID(ProjectEntity project, TestSuiteEntity testSuite) throws Exception {
        TestSuiteEntity duplicatedTestSuite = TestSuiteFileServiceManager.getByGUID(testSuite.getTestSuiteGuid(), project);
        if (duplicatedTestSuite != null) {
            testSuite.setTestSuiteGuid(UUID.randomUUID().toString());
            return true;
        }
        return false;
    }

    private void checkTestCaseNameChanged(TestCaseEntity testCase) {
        String newName = this.nameChangedTestCases.get(testCase.getRelativePath());
        if (newName != null) {
            testCase.setName(newName);
        }
        this.checkFolderNameChanged(testCase.getParentFolder(), this.nameChangedTestCaseFolders);
    }

    private void checkDataFileNameChanged(DataFileEntity dataFile) {
        String newName = this.nameChangedDataFiles.get(dataFile.getRelativePath());
        if (newName != null) {
            dataFile.setName(newName);
        }
        this.checkFolderNameChanged(dataFile.getParentFolder(), this.nameChangedDataFileFolders);
    }

    private void checkFolderNameChanged(FolderEntity folder, Map<String, String> nameChangedFolderMap) {
        if (folder != null) {
            String newName = nameChangedFolderMap.get(folder.getRelativePath());
            if (newName != null) {
                folder.setName(newName);
            }
            this.checkFolderNameChanged(folder.getParentFolder(), nameChangedFolderMap);
        }
    }

    private void saveTestSuiteEntity(TestSuiteEntity testSuite, FolderEntity parentFolder, ProjectEntity project) throws Exception {
        TestSuiteEntity newTestSuite = testSuite.clone();
        newTestSuite.setParentFolder(parentFolder);
        newTestSuite.setProject(project);
        PathValidationUtil.validatePathLength((FileEntity)newTestSuite);
        FileServiceDataProviderSetting dataProviderSetting = new FileServiceDataProviderSetting();
        for (TestSuiteTestCaseLink testSuiteTestCaseLink : newTestSuite.getTestSuiteTestCaseLinks()) {
            TestCaseEntity testCase = dataProviderSetting.getTestCaseDataProvider().getTestCaseByDisplayId(testSuiteTestCaseLink.getTestCaseId());
            this.checkTestCaseNameChanged(testCase);
            this.setProject(testCase.getParentFolder(), project);
        }
        TestSuiteFileServiceManager.resetParentForChildElement(newTestSuite);
        EntityService.getInstance().saveEntity((FileEntity)newTestSuite);
    }

    public DataFileEntity createDataFile(File xmlFile) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.importProject);
        return DataFileFileServiceManager.getDataFile(xmlFile.getAbsolutePath());
    }

    public WebElementEntity createWebElement(File xmlFile) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.importProject);
        return WebElementFileServiceManager.getWebElement(xmlFile.getAbsolutePath());
    }

    public TestCaseEntity createTestCase(File xmlFile) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.importProject);
        return TestCaseFileServiceManager.getTestCase(xmlFile.getAbsolutePath());
    }

    public TestSuiteEntity createTestSuite(File xmlFile) throws Exception {
        DataProviderState.getInstance().setCurrentProject(this.importProject);
        return TestSuiteFileServiceManager.getTestSuite(xmlFile.getAbsolutePath());
    }

    private ImportDuplicateEntityResult getDuplicateDialogResult(ImportType[] importTypes, StringBuilder folderStringBuilder) throws InterruptedException, CancelTaskException {
        this.checkCancelImportTask();
        while (this.isWaitingConfirmation()) {
            Thread.sleep(100L);
        }
        this.setImportDuplicateEntityResult(null);
        this.raiseDuplicateEntityEvent(importTypes, folderStringBuilder.toString());
        while (this.getImportDuplicateEntityResult() == null) {
            Thread.sleep(100L);
        }
        if (this.getImportDuplicateEntityResult().getImportType() == ImportType.Cancel) {
            throw new CancelTaskException();
        }
        return this.getImportDuplicateEntityResult();
    }

    private boolean isCancelImportTask() {
        return this.isCancelImportTask;
    }

    public void setCancelImportTask(boolean cancelImportTask) {
        this.isCancelImportTask = cancelImportTask;
    }

    public boolean isWaitingConfirmation() {
        return this.isWaitingConfirmation;
    }

    public void setWaitingConfirmation(boolean isWaitingConfirmation) {
        this.isWaitingConfirmation = isWaitingConfirmation;
    }
}

