/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.vineflower.decompiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompiler;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.CommentUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.UnicodeUtil;

public class VineflowerDecompiler
extends BaseDecompiler {
    private String source = "";
    private long time;
    private long start;
    private String log = "";
    ByteArrayOutputStream loggerStream;

    public void decompile(String root, String packege, String className) {
        File tmpDir;
        if (root == null || packege == null || className == null) {
            return;
        }
        this.start = System.currentTimeMillis();
        this.log = "";
        this.source = "";
        this.loggerStream = new ByteArrayOutputStream();
        File workingDir = new File(String.valueOf(root) + "/" + packege);
        HashMap<String, String> mapOptions = new HashMap<String, String>();
        mapOptions.put("rsy", "1");
        mapOptions.put("dgs", "1");
        mapOptions.put("din", "1");
        mapOptions.put("den", "1");
        mapOptions.put("log", IFernflowerLogger.Severity.ERROR.name());
        mapOptions.put("asc", "1");
        if (ClassUtil.isDebug()) {
            mapOptions.put("__dump_original_lines__", "1");
            mapOptions.put("bsm", "1");
        }
        try {
            tmpDir = Files.createTempDirectory("ecd_vineflower", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary working directory", e);
        }
        String classNameFilterTmp = className.toLowerCase();
        if (classNameFilterTmp.endsWith(".class")) {
            classNameFilterTmp = classNameFilterTmp.substring(0, classNameFilterTmp.length() - 6);
        }
        final String classNameFilter = classNameFilterTmp;
        File[] files = workingDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).startsWith(classNameFilter) && name.endsWith(".class");
            }
        });
        try {
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                class EmbeddedConsoleDecompiler
                extends ConsoleDecompiler {
                    protected EmbeddedConsoleDecompiler(File file, Map map) {
                        super(file, map, (IFernflowerLogger)new PrintStreamLogger(new PrintStream(VineflowerDecompiler.this.loggerStream)));
                    }
                }
                try (EmbeddedConsoleDecompiler decompiler = new EmbeddedConsoleDecompiler(tmpDir, mapOptions);){
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        decompiler.addSource(f);
                        ++n2;
                    }
                    decompiler.decompileContext();
                    File classFile = new File(tmpDir, className.replaceAll("(?i)\\.class", ".java"));
                    this.source = UnicodeUtil.decode((String)FileUtil.getContent((File)classFile));
                    classFile.delete();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            FileUtil.deltree((File)tmpDir);
        }
        this.source = CommentUtil.clearComments((String)this.source);
        this.time = System.currentTimeMillis() - this.start;
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        this.start = System.currentTimeMillis();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract((String)archivePath, (String)packege, (String)className, (boolean)true, (String)workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
            }
            catch (Exception e) {
                this.exceptions.add(e);
                JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
                FileUtil.deltree((File)workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree((File)workingDir);
        }
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public String getLog() {
        if (this.loggerStream != null) {
            return String.valueOf(this.log) + this.loggerStream.toString();
        }
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return "Vineflower";
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return true;
    }

    public String getDecompilerName() {
        return "Vineflower";
    }

    public String getDecompilerVersion() {
        return "1.9.3";
    }
}

