/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.credential.QTestTokenManager;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.helper.QTestHttpRequestHelper;

public class QTestIntegrationAuthenticationManager {
    private QTestIntegrationAuthenticationManager() {
    }

    public static IQTestToken getToken(IQTestCredential qTestCrediential) throws QTestException {
        String requestResult = null;
        switch (qTestCrediential.getVersion()) {
            case V6: {
                requestResult = QTestHttpRequestHelper.getTokenViaQTestV6(qTestCrediential.getServerUrl(), qTestCrediential.getUsername(), qTestCrediential.getPassword());
                break;
            }
            case V7: {
                requestResult = QTestHttpRequestHelper.getV7Token(qTestCrediential.getServerUrl(), qTestCrediential.getUsername(), qTestCrediential.getPassword());
                break;
            }
        }
        return QTestTokenManager.getToken(requestResult);
    }

    public static boolean validateToken(String token) {
        return token != null && !token.isEmpty();
    }

    public static void authenticate(String username, String password) throws QTestUnauthorizedException {
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            throw new QTestUnauthorizedException("Your qTest username or password is not valid.\nPlease enter valid username and password in qTest setting page \nby choosing Project->Settings->qTest and click on Generate button.");
        }
    }
}

