/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.integration.IntegratedType;
import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.helper.QTestAPIRequestHelper;
import com.kms.katalon.integration.qtest.setting.QTestVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.qtest.api.auth.BasicQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.services.project.ProjectServiceClient;
import org.qas.qtest.api.services.project.model.ListProjectRequest;
import org.qas.qtest.api.services.project.model.Project;

public class QTestIntegrationProjectManager {
    private QTestIntegrationProjectManager() {
    }

    public static List<QTestProject> getQTestProjectsByIntegratedEntity(IntegratedEntity integratedEntity) {
        ArrayList<QTestProject> qTestProjects = new ArrayList<QTestProject>();
        if (integratedEntity == null) {
            return qTestProjects;
        }
        TreeMap properties = new TreeMap(integratedEntity.getProperties());
        try {
            for (Map.Entry entry : properties.entrySet()) {
                String value = (String)entry.getValue();
                JsonObject qTestProjectJsonObject = new JsonObject(value.replace("'", "\"").replace("},\n", "},"));
                QTestProject qTestProject = new QTestProject();
                qTestProject.setId(qTestProjectJsonObject.getLong("id"));
                qTestProject.setName(qTestProjectJsonObject.getString("name"));
                JsonArray testCaseFolderJsonArray = qTestProjectJsonObject.optJsonArray("testCaseFolderMappeds");
                int index = 0;
                while (index < testCaseFolderJsonArray.length()) {
                    qTestProject.getTestCaseFolderIds().add(testCaseFolderJsonArray.getString(index));
                    ++index;
                }
                JsonArray testSuiteFolderJsonArray = qTestProjectJsonObject.optJsonArray("testSuiteFolderMappeds");
                int index2 = 0;
                while (index2 < testSuiteFolderJsonArray.length()) {
                    qTestProject.getTestSuiteFolderIds().add(testSuiteFolderJsonArray.getString(index2));
                    ++index2;
                }
                qTestProjects.add(qTestProject);
            }
        }
        catch (JsonException jsonException) {}
        return qTestProjects;
    }

    public static IntegratedEntity getIntegratedEntityByQTestProjects(List<QTestProject> qTestProjects) {
        IntegratedEntity integratedEntity = new IntegratedEntity();
        integratedEntity.setProductName("qTest");
        integratedEntity.setType(IntegratedType.PROJECT);
        for (QTestProject qTestProject : qTestProjects) {
            String key = Integer.toString(qTestProjects.indexOf(qTestProject));
            StringBuilder valueBuilder = new StringBuilder(new JsonObject(qTestProject.getProperties()).toString());
            String value = valueBuilder.toString().replace("\"", "'").replace("},", "},\n");
            integratedEntity.getProperties().put(key, value);
        }
        return integratedEntity;
    }

    public static List<QTestProject> getAllProject(IQTestCredential credential) throws QTestException {
        ArrayList<QTestProject> qTestProjects;
        block7: {
            IQTestToken token;
            block6: {
                token = credential.getToken();
                if (token == null) {
                    throw new QTestUnauthorizedException("Token is not valid");
                }
                String accessToken = token.getAccessTokenHeader();
                if (!QTestIntegrationAuthenticationManager.validateToken(token.getAccessTokenHeader())) {
                    throw new QTestUnauthorizedException("Token is not valid");
                }
                qTestProjects = new ArrayList<QTestProject>();
                if (credential.getVersion() != QTestVersion.V6) break block6;
                BasicQTestCredentials credentials = new BasicQTestCredentials(accessToken);
                ProjectServiceClient projectService = new ProjectServiceClient((QTestCredentials)credentials);
                projectService.setEndpoint(credential.getServerUrl());
                List projects = projectService.listProject(new ListProjectRequest());
                for (Project project : projects) {
                    qTestProjects.add(new QTestProject(project.getId(), project.getName()));
                }
                break block7;
            }
            String result = QTestAPIRequestHelper.sendGetRequestViaAPI(credential.getServerUrl() + "/api/v3/projects", token);
            if (result == null) break block7;
            try {
                JsonArray projectArrs = new JsonArray(result);
                int index = 0;
                while (index < projectArrs.length()) {
                    JsonObject projectJsObj = projectArrs.getJsonObject(index);
                    qTestProjects.add(new QTestProject(projectJsObj.getLong("id"), projectJsObj.getString("name")));
                    ++index;
                }
            }
            catch (JsonException e) {
                QTestInvalidFormatException.createInvalidJsonFormatException(e.getMessage());
            }
        }
        return qTestProjects;
    }

    public static QTestProject getProjectByName(String name, IQTestCredential credential) throws QTestException {
        List<QTestProject> projects = QTestIntegrationProjectManager.getAllProject(credential);
        if (projects != null && projects.size() > 0) {
            for (QTestProject project : projects) {
                if (!project.getName().equals(name)) continue;
                return project;
            }
        }
        return null;
    }

    public static QTestProject getProjectByID(long id, IQTestCredential credential) throws QTestException {
        List<QTestProject> projects = QTestIntegrationProjectManager.getAllProject(credential);
        if (projects != null && projects.size() > 0) {
            for (QTestProject project : projects) {
                if (project.getId() != id) continue;
                return project;
            }
        }
        return null;
    }

    public static String getProjectAPIPrefix(IQTestCredential credential, QTestProject qTestProject) {
        return credential.getServerUrl() + "/api/v3/projects/" + Long.toString(qTestProject.getId());
    }
}

