/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.artifact.core;

import com.kms.katalon.composer.artifact.core.FolderType;
import com.kms.katalon.composer.artifact.core.util.EntityUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class TestArtifactScriptRefactor {
    private static final String CR_LEFT_PARENTHESIS = "(";
    private static final String CR_RIGHT_PARENTHESIS = ")";
    private static final String CR_PRIME = "'";
    private static final String CR_DOUBLE_PRIMES = "\"";
    private FolderType parentType;
    private boolean hasRightBracket;
    private boolean hasRightQuote;
    private boolean hasRightDoubleQuote;
    private boolean isFolder;
    private Map<String, String> entityIdLookup;

    public TestArtifactScriptRefactor(FolderType parentType, Map<String, String> entityIdLookup, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote) {
        this(parentType, entityIdLookup, hasRightBracket, hasRightQuote, hasRightDoubleQuote, false);
    }

    public TestArtifactScriptRefactor(FolderType parentType, Map<String, String> entityIdLookup, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote, boolean isFolder) {
        this.parentType = parentType;
        this.entityIdLookup = entityIdLookup;
        this.hasRightBracket = hasRightBracket;
        this.hasRightQuote = hasRightQuote;
        this.hasRightDoubleQuote = hasRightDoubleQuote;
        this.isFolder = isFolder;
    }

    public FolderType getParentType() {
        return this.parentType;
    }

    private String getReferencePrefix() {
        switch (this.parentType) {
            case TESTCASE: {
                return "findTestCase";
            }
            case WEBELEMENT: {
                return "findTestObject";
            }
        }
        return "";
    }

    private String getRelativeId(String s) {
        int firstSeparatorIdx = s.indexOf(EntityUtil.getEntityIdSeparator());
        if (firstSeparatorIdx < 0) {
            return s;
        }
        return s.substring(firstSeparatorIdx + (this.isFolder ? 0 : 1), s.length());
    }

    private String buildParentheses(String s) {
        return CR_LEFT_PARENTHESIS + s + (this.hasRightBracket ? CR_RIGHT_PARENTHESIS : "");
    }

    private String buildQuote(String s) {
        return CR_PRIME + s + (this.hasRightQuote ? CR_PRIME : "");
    }

    private String buildDoubleQuotes(String s) {
        return CR_DOUBLE_PRIMES + s + (this.hasRightDoubleQuote ? CR_DOUBLE_PRIMES : "");
    }

    private List<String> getQuotedReferences(String entityId) {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(entityId);
        return Arrays.asList(prefix + this.buildParentheses(this.buildQuote(entityId)), prefix + this.buildParentheses(this.buildQuote(relativeId)));
    }

    private List<String> getDoubleQuotedReferenceStrings(String entityId) {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(entityId);
        return Arrays.asList(prefix + this.buildParentheses(this.buildDoubleQuotes(entityId)), prefix + this.buildParentheses(this.buildDoubleQuotes(relativeId)));
    }

    public void replace(String oldEntityId, String newEntityId, File file) throws IOException {
        String scriptContent = this.getScriptContent(file);
        String relativeId = this.getRelativeId(newEntityId);
        String referencePrefix = this.getReferencePrefix();
        boolean updated = false;
        String newQuotedScript = referencePrefix + this.buildParentheses(this.buildQuote(relativeId));
        for (String potentialQuote : this.getQuotedReferences(oldEntityId)) {
            if (!scriptContent.contains(potentialQuote)) continue;
            scriptContent = scriptContent.replace(potentialQuote, newQuotedScript);
            updated = true;
        }
        String newDoubleQuotedScript = referencePrefix + this.buildParentheses(this.buildDoubleQuotes(relativeId));
        for (String potentialDoubleQuotes : this.getDoubleQuotedReferenceStrings(oldEntityId)) {
            if (!scriptContent.contains(potentialDoubleQuotes)) continue;
            scriptContent = scriptContent.replace(potentialDoubleQuotes, newDoubleQuotedScript);
            updated = true;
        }
        if (!updated) {
            return;
        }
        FileUtils.write((File)file, (CharSequence)scriptContent, (Charset)StandardCharsets.UTF_8);
    }

    private String getScriptContent(File scriptFile) throws IOException {
        return FileUtils.readFileToString((File)scriptFile, (Charset)StandardCharsets.UTF_8);
    }

    public void updateReferences(List<File> files) throws IOException {
        for (File scriptFile : files) {
            for (String oldEntityId : this.entityIdLookup.keySet()) {
                this.replace(oldEntityId, this.entityIdLookup.get(oldEntityId), scriptFile);
            }
        }
    }

    public static TestArtifactScriptRefactor createForTestCaseEntity(Map<String, String> entityIdLookup) {
        return new TestArtifactScriptRefactor(FolderType.TESTCASE, entityIdLookup, true, true, true);
    }

    public static TestArtifactScriptRefactor createForTestObjectEntity(Map<String, String> entityIdLookup) {
        return new TestArtifactScriptRefactor(FolderType.WEBELEMENT, entityIdLookup, false, true, true);
    }
}

