/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Ast;
import io.cucumber.cucumberexpressions.CucumberExpressionParser;
import io.cucumber.cucumberexpressions.GroupBuilder;
import io.cucumber.cucumberexpressions.TreeRegexp;
import io.cucumber.eclipse.editor.steps.StepDefinition;
import io.cucumber.eclipse.editor.steps.StepParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;

public class CucumberExpressionParserSupport {
    private static final Pattern BEGIN_ANCHOR = Pattern.compile("^\\^.*");
    private static final Pattern END_ANCHOR = Pattern.compile(".*\\$$");
    private static final Pattern SCRIPT_STYLE_REGEXP = Pattern.compile("^/(.*)/$");

    public static Template createTemplate(StepDefinition definition, String contextId) {
        String expressionString = definition.getExpression().getText();
        if (CucumberExpressionParserSupport.isRegularExpression(expressionString)) {
            return new RegularExpressionTemplate(definition, contextId);
        }
        return new CucumberExpressionTemplate(definition, contextId);
    }

    private static boolean isRegularExpression(String expressionString) {
        return BEGIN_ANCHOR.matcher(expressionString).find() || END_ANCHOR.matcher(expressionString).find() || SCRIPT_STYLE_REGEXP.matcher(expressionString).find();
    }

    public static TemplateBuffer evaluate(Template template) {
        String pattern = template.getPattern();
        if (template instanceof RegularExpressionTemplate) {
            RegularExpressionTemplate expressionTemplate = (RegularExpressionTemplate)template;
            ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
            for (GroupBuilder builder : expressionTemplate.groups) {
                int startIndex = builder.getStartIndex() - expressionTemplate.offset;
                TemplateVariable variable = new TemplateVariable("REG_EXP", pattern.substring(startIndex, builder.getEndIndex() - expressionTemplate.offset + 1), new int[]{startIndex});
                String source = builder.getSource();
                if (source.contains("|")) {
                    String[] values = source.split("\\|");
                    variable.setValues(values);
                }
                variables.add(variable);
            }
            return new TemplateBuffer(pattern, (TemplateVariable[])variables.toArray(TemplateVariable[]::new));
        }
        if (template instanceof CucumberExpressionTemplate) {
            CucumberExpressionTemplate cucumberTemplate = (CucumberExpressionTemplate)template;
            CucumberExpressionParser parser = new CucumberExpressionParser();
            Ast.Node ast = parser.parse(pattern);
            AtomicInteger counter = new AtomicInteger();
            ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
            CucumberExpressionParserSupport.parseAst(ast, Arrays.stream(cucumberTemplate.definition.getParameters()).iterator(), counter, variables);
            TemplateBuffer buffer = new TemplateBuffer(pattern, (TemplateVariable[])variables.toArray(TemplateVariable[]::new));
            return buffer;
        }
        return new TemplateBuffer(pattern, new TemplateVariable[0]);
    }

    public static String replaceVariables(String pattern, VariableReplacement replacement) {
        StringBuilder sb = new StringBuilder();
        if (CucumberExpressionParserSupport.isRegularExpression(pattern)) {
            TreeRegexp treeRegexp = new TreeRegexp(pattern);
            List groups = treeRegexp.getGroupBuilder().getChildren();
            int start = 0;
            for (GroupBuilder groupBuilder_ : groups) {
                sb.append(pattern.substring(start, groupBuilder_.getEndIndex()));
                if (replacement != VariableReplacement.DELETE) {
                    sb.append(replacement.getRegularExpressionReplacement());
                }
                start = groupBuilder_.getEndIndex();
            }
            if (start < pattern.length() - 1) {
                sb.append(pattern.substring(start, pattern.length() - 1));
            }
        } else {
            CucumberExpressionParser parser = new CucumberExpressionParser();
            Ast.Node ast = parser.parse(pattern);
            CucumberExpressionParserSupport.replaceVariables(ast, replacement, sb);
        }
        return sb.toString();
    }

    private static void replaceVariables(Ast.Node node, VariableReplacement replacement, StringBuilder buffer) {
        Ast.Node.Type type = node.type();
        switch (type) {
            case PARAMETER_NODE: {
                if (replacement == VariableReplacement.DELETE) break;
                buffer.append(replacement.getCucumberExpressionReplacement());
                break;
            }
            case ALTERNATION_NODE: {
                ArrayList values = new ArrayList();
                node.nodes().stream().map(Ast.Node::text).forEach(values::add);
                String join = String.join((CharSequence)"/", values);
                buffer.append(join);
                break;
            }
            case OPTIONAL_NODE: {
                Ast.Node child = (Ast.Node)node.nodes().get(0);
                String optionalText = child.text();
                buffer.append('(');
                buffer.append(optionalText);
                buffer.append(')');
                break;
            }
            default: {
                List childs;
                if (type != Ast.Node.Type.EXPRESSION_NODE) {
                    buffer.append(node.text());
                }
                if ((childs = node.nodes()) == null) break;
                for (Ast.Node child : childs) {
                    CucumberExpressionParserSupport.replaceVariables(child, replacement, buffer);
                }
            }
        }
    }

    private static void parseAst(Ast.Node node, Iterator<StepParameter> parameterNames, AtomicInteger counter, List<TemplateVariable> variables) {
        switch (node.type()) {
            case PARAMETER_NODE: {
                variables.add(CucumberExpressionParserSupport.parseParameter(node, parameterNames, counter));
                break;
            }
            case ALTERNATION_NODE: {
                variables.add(CucumberExpressionParserSupport.parseAlternation(node));
                break;
            }
            case OPTIONAL_NODE: {
                variables.add(CucumberExpressionParserSupport.parseOptional(node));
                break;
            }
            default: {
                List childs = node.nodes();
                if (childs == null) break;
                for (Ast.Node child : childs) {
                    CucumberExpressionParserSupport.parseAst(child, parameterNames, counter, variables);
                }
            }
        }
    }

    private static TemplateVariable parseOptional(Ast.Node node) {
        Ast.Node child = (Ast.Node)node.nodes().get(0);
        String optionalText = child.text();
        String fullText = "(" + optionalText + ")";
        TemplateVariable variable = new TemplateVariable("OPTIONAL_NODE", fullText, fullText, new int[]{node.start()});
        variable.setValue(optionalText);
        return variable;
    }

    private static TemplateVariable parseAlternation(Ast.Node node) {
        ArrayList<String> values = new ArrayList<String>();
        node.nodes().stream().map(Ast.Node::text).forEach(values::add);
        String join = String.join((CharSequence)"/", values);
        values.add(0, join);
        TemplateVariable variable = new TemplateVariable("ALTERNATION_NODE", join, (String[])values.toArray(String[]::new), new int[]{node.start()});
        return variable;
    }

    private static TemplateVariable parseParameter(Ast.Node node, Iterator<StepParameter> parameterNames, AtomicInteger counter) {
        String[] paramValues;
        List nodes = node.nodes();
        String paramType = nodes.isEmpty() ? "" : ((Ast.Node)nodes.get(0)).text();
        StepParameter param = parameterNames.hasNext() ? parameterNames.next() : null;
        int index = counter.getAndIncrement();
        String fullText = "{" + paramType + "}";
        if (param == null) {
            String paramName = paramType + index;
            paramValues = new String[]{paramName};
        } else {
            String paramName = param.getParameterName();
            String[] values = param.getValues();
            paramValues = values == null || values.length == 0 ? new String[]{paramName} : values;
        }
        TemplateVariable variable = new TemplateVariable(paramType, fullText, fullText, new int[]{node.start()});
        variable.setValues(paramValues);
        return variable;
    }

    private static final class CucumberExpressionTemplate
    extends Template {
        private final StepDefinition definition;

        public CucumberExpressionTemplate(StepDefinition definition, String contextId) {
            super(definition.getExpression().getText(), definition.getLabel(), contextId, definition.getExpression().getText(), true);
            this.definition = definition;
        }
    }

    private static final class RegularExpressionTemplate
    extends Template {
        private final List<GroupBuilder> groups;
        private final int offset;
        private final StepDefinition definition;

        public RegularExpressionTemplate(StepDefinition definition, String contextId) {
            super(definition.getExpression().getText(), definition.getLabel(), contextId, definition.getExpression().getText(), true);
            this.definition = definition;
            TreeRegexp treeRegexp = new TreeRegexp(definition.getExpression().getText());
            this.groups = treeRegexp.getGroupBuilder().getChildren();
            String pattern = definition.getExpression().getText();
            boolean startMarker = pattern.startsWith("^");
            boolean endMarker = pattern.endsWith("$");
            if (startMarker) {
                this.offset = 1;
                pattern = pattern.substring(1);
            } else {
                this.offset = 0;
            }
            if (endMarker) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            this.setPattern(pattern);
        }
    }

    public static enum VariableReplacement {
        DELETE,
        MATCH_ALL;


        private String getCucumberExpressionReplacement() {
            switch (this) {
                case MATCH_ALL: {
                    return "{}";
                }
            }
            return "";
        }

        private String getRegularExpressionReplacement() {
            switch (this) {
                case MATCH_ALL: {
                    return "(.*)";
                }
            }
            return "";
        }
    }
}

