/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.eclipse.editor.document.GherkinKeyword;
import io.cucumber.eclipse.editor.document.GherkinStream;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public final class GherkinEditorDocument
extends GherkinStream {
    private static final List<Function<GherkinDialect, List<String>>> STEP_KEYWORD_KEYS = Arrays.asList(GherkinDialect::getGivenKeywords, GherkinDialect::getWhenKeywords, GherkinDialect::getThenKeywords, GherkinDialect::getAndKeywords, GherkinDialect::getButKeywords);
    private static final List<Function<GherkinDialect, List<String>>> TOP_LEVEL_KEYWORD = Arrays.asList(GherkinDialect::getScenarioKeywords, GherkinDialect::getScenarioOutlineKeywords, GherkinDialect::getRuleKeywords, GherkinDialect::getBackgroundKeywords, GherkinDialect::getExamplesKeywords);
    private final GherkinDialectProvider provider = new GherkinDialectProvider();
    private static final ConcurrentHashMap<IDocument, GherkinEditorDocument> DOCUMENT_MAP = new ConcurrentHashMap();
    private volatile boolean dirty;
    private final IDocument document;
    private final GherkinDialect dialect;
    private final Locale locale;
    private Supplier<IResource> resourceSupplier;

    private GherkinEditorDocument(final IDocument document, Supplier<IResource> resourceSupplier) {
        super(GherkinEditorDocument.getEnvelopes(document, resourceSupplier));
        this.resourceSupplier = resourceSupplier;
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                GherkinEditorDocument.this.dirty = true;
                document.removeDocumentListener((IDocumentListener)this);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.document = document;
        Optional<String> langOpt = this.getFeature().map(f -> f.getLanguage()).filter(Objects::nonNull).filter(Predicate.not(String::isBlank));
        this.dialect = (GherkinDialect)langOpt.flatMap(lang -> this.provider.getDialect(lang)).or(() -> {
            try {
                String[] split;
                IRegion firstLine = document.getLineInformation(0);
                String line = document.get(firstLine.getOffset(), firstLine.getLength()).trim();
                if (line.startsWith("#") && (split = line.split("language:", 2)).length == 2) {
                    try {
                        return this.provider.getDialect(split[1].trim());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return Optional.of(this.provider.getDefaultDialect());
        }).get();
        this.locale = Locale.forLanguageTag(this.dialect.getLanguage());
    }

    private static Envelope[] getEnvelopes(IDocument document, Supplier<IResource> resourceSupplier) {
        GherkinParser parser = GherkinParser.builder().includeSource(true).includeGherkinDocument(true).includePickles(false).build();
        Source source = new Source("", document.get(), SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN);
        Envelope envelope = Envelope.of((Source)source);
        return (Envelope[])parser.parse(envelope).toArray(Envelope[]::new);
    }

    public GherkinDialect getDialect() {
        return this.dialect;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public Position getPosition(Location location) throws BadLocationException {
        return this.getPosition(location, 0);
    }

    public Position getPosition(Location location, int lineOffset) throws BadLocationException {
        int line = location.getLine().intValue();
        int offset = this.document.getLineOffset(line - 1 - lineOffset);
        return new Position(offset + location.getColumn().orElse(0L).intValue() - 1, 1);
    }

    public Position getEolPosition(Location location) throws BadLocationException {
        int line = location.getLine().intValue();
        int offset = this.document.getLineOffset(line - 1);
        int lineLength = this.document.getLineLength(line - 1);
        if (lineLength == 0) {
            return new Position(offset + lineLength, 1);
        }
        if (lineLength == 1) {
            char c = this.document.get(offset, 1).charAt(0);
            if (c == '\n' || c == '\r') {
                return new Position(offset, 1);
            }
            return new Position(offset + 1, 1);
        }
        char c = this.document.get(offset + lineLength - 2, 1).charAt(0);
        int eolOffset = c == '\r' ? 2 : 1;
        return new Position(offset + lineLength - eolOffset, 1);
    }

    public Stream<GherkinKeyword> getStepElementKeywords() {
        return STEP_KEYWORD_KEYS.stream().flatMap(this::keyWords);
    }

    public Stream<GherkinKeyword> getTopLevelKeywords() {
        return TOP_LEVEL_KEYWORD.stream().flatMap(this::keyWords);
    }

    public Stream<GherkinKeyword> getAllKeywords() {
        return Stream.concat(Stream.concat(this.getTopLevelKeywords(), this.getStepElementKeywords()), this.getFeatureKeywords());
    }

    public Stream<GherkinKeyword> getFeatureKeywords() {
        return this.keyWords(GherkinDialect::getFeatureKeywords);
    }

    public Optional<GherkinKeyword> getKeyWordOfLine(String line) {
        String typed = line.stripLeading();
        Optional<GherkinKeyword> keywordPrefix = this.getStepElementKeywords().sorted(Collections.reverseOrder((s1, s2) -> s1.getKey().length() - s2.getKey().length())).filter(keyWord -> typed.startsWith(keyWord.getKey() + " ")).findFirst();
        return keywordPrefix;
    }

    public Stream<GherkinKeyword> keyWords(Function<GherkinDialect, List<String>> keyWords) {
        return keyWords.apply(this.dialect).stream().map(s -> s.trim()).filter(Predicate.not(GherkinEditorDocument::isWildcard)).map(str -> new GherkinKeyword((String)str, this.locale, this.dialect));
    }

    public static GherkinEditorDocument get(IDocument document) {
        Objects.requireNonNull(document, "document can't be null");
        if (GherkinEditorDocument.isCompatible(document)) {
            return DOCUMENT_MAP.compute(document, (key, value) -> {
                if (value == null || value.dirty) {
                    return GherkinEditorDocument.parse(key, () -> GherkinEditorDocument.resourceForDocument(key));
                }
                return value;
            });
        }
        return null;
    }

    public static GherkinEditorDocument get(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (buffer != null) {
                return GherkinEditorDocument.get(buffer.getDocument());
            }
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream stream = file.getContents();){
                    return GherkinEditorDocument.parse((IDocument)new Document(IOUtils.toString((InputStream)stream, (String)file.getCharset())), () -> file);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return null;
            }
            catch (CoreException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean has(IDocument document) {
        return DOCUMENT_MAP.contains(document);
    }

    public static boolean isCompatible(IDocument document) {
        ITextFileBuffer buffer;
        if (document != null && (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document)) != null) {
            try {
                IContentType contentType = buffer.getContentType();
                if (contentType != null) {
                    return "io.cucumber.eclipse.editor.content-type.feature".equals(contentType.getId());
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public IResource getResource() {
        return this.resourceSupplier.get();
    }

    public static GherkinEditorDocument parse(IDocument document, Supplier<IResource> resource) {
        return new GherkinEditorDocument(document, resource);
    }

    public static IResource resourceForDocument(IDocument document) {
        IFile res;
        IPath location;
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer != null && (location = buffer.getLocation()) != null && (res = ResourcesPlugin.getWorkspace().getRoot().getFile(location)) != null && res.exists()) {
            return res;
        }
        return null;
    }

    private static boolean isWildcard(String keyword) {
        return "*".equals(keyword);
    }
}

