/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.eclipse.editor.debug.GherkingStackFrame;
import io.cucumber.eclipse.editor.debug.GherkingStepStackFrame;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.TestStep;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class TestStepEvent {
    private Feature feature;
    private Scenario scenario;
    private Step step;
    private TestStep testStep;
    private StepDefinition stepDefinition;

    TestStepEvent(Feature feature, Scenario scenario, Step step, TestStep testStep, StepDefinition stepDefinition) {
        this.feature = feature;
        this.scenario = scenario;
        this.step = step;
        this.testStep = testStep;
        this.stepDefinition = stepDefinition;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public Step getStep() {
        return this.step;
    }

    public IStackFrame[] getStackTrace(IThread thread) {
        GherkingStepStackFrame stepFrame = new GherkingStepStackFrame(thread, this.testStep, this.step, this.stepDefinition);
        GherkingStackFrame scenarioFrame = new GherkingStackFrame(thread, this.scenario.getLocation().getLine().intValue(), "[" + this.scenario.getKeyword().strip() + "] " + this.scenario.getName());
        GherkingStackFrame featureFrame = new GherkingStackFrame(thread, this.feature.getLocation().getLine().intValue(), "[" + this.feature.getKeyword().strip() + "] " + this.feature.getName());
        return new IStackFrame[]{stepFrame, scenarioFrame, featureFrame};
    }
}

