/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.launching;

import io.cucumber.eclipse.editor.Activator;
import io.cucumber.eclipse.editor.properties.CucumberEditorProperties;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;

public enum Mode {
    RUN,
    DEBUG,
    PROFILE;

    private String label;

    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        ILaunchMode mode = this.getLaunchMode();
        if (mode != null) {
            this.label = mode.getLabel().replace("&", "");
            return this.label;
        }
        return super.toString();
    }

    public ILaunchMode getLaunchMode() {
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            switch (this) {
                case RUN: {
                    return manager.getLaunchMode("run");
                }
                case DEBUG: {
                    return manager.getLaunchMode("debug");
                }
                case PROFILE: {
                    return manager.getLaunchMode("profile");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public static Mode parseString(String mode) {
        if ("run".equalsIgnoreCase(mode)) {
            return RUN;
        }
        if ("debug".equalsIgnoreCase(mode)) {
            return DEBUG;
        }
        if ("profile".equalsIgnoreCase(mode)) {
            return PROFILE;
        }
        return null;
    }

    public String getSymbol() {
        switch (this) {
            case RUN: {
                return String.valueOf('\u25b7');
            }
            case DEBUG: {
                return String.valueOf('\u25c9');
            }
            case PROFILE: {
                return String.valueOf('\u2690');
            }
        }
        return "";
    }

    public boolean showShortcut(IResource resource) {
        CucumberEditorProperties properties = CucumberEditorProperties.of(resource);
        if (properties.isEnabled()) {
            return properties.isShowShortcutFor(this);
        }
        return Activator.getDefault().getPreferenceStore().getBoolean("io.cucumber.eclipse.editor.show_run_shortcut_" + this.name());
    }
}

