/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.properties;

import io.cucumber.eclipse.editor.Images;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.eclipse.editor.preferences.CucumberPreferencePage;
import io.cucumber.eclipse.editor.properties.CucumberEditorProperties;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class CucumberPropertiesPage
extends PropertyPage {
    private Text validationPlugins;
    private Map<Mode, Button> modeButtons = new HashMap<Mode, Button>();
    private Button enableProjectSpecific;

    public CucumberPropertiesPage() {
        this.setTitle("Cucumber");
        this.setDescription("You can configure Cucumber related properties for your project here");
        this.setImageDescriptor(Images.getCukesIconDescriptor());
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        CucumberEditorProperties properties = CucumberEditorProperties.of(this.getResource());
        this.enableProjectSpecific = new Button(composite, 32);
        this.enableProjectSpecific.setText("Enable project specific settings");
        this.enableProjectSpecific.setSelection(properties.isEnabled());
        this.enableProjectSpecific.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CucumberPropertiesPage.this.updateUI();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Mode[] modeArray = Mode.values();
        int n = modeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mode mode = modeArray[n2];
            Button button = new Button(composite, 32);
            button.setSelection(properties.isShowShortcutFor(mode));
            button.setText(CucumberPreferencePage.getLabelForMode(mode));
            this.modeButtons.put(mode, button);
            ++n2;
        }
        this.updateUI();
        return composite;
    }

    protected void updateUI() {
        boolean enable = this.enableProjectSpecific.getSelection();
        for (Button b : this.modeButtons.values()) {
            b.setEnabled(enable);
        }
    }

    private IResource getResource() {
        return (IResource)this.getElement().getAdapter(IResource.class);
    }

    public boolean performOk() {
        CucumberEditorProperties properties = CucumberEditorProperties.of(this.getResource());
        properties.setEnabled(this.enableProjectSpecific.getSelection());
        for (Map.Entry<Mode, Button> entry : this.modeButtons.entrySet()) {
            properties.setShowShortcutFor(entry.getKey(), entry.getValue().getSelection());
        }
        properties.flush();
        return true;
    }
}

