/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.syntaxhighlight;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinKeywordScanner;
import io.cucumber.gherkin.GherkinDialect;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;

public class GherkinDamagerRepairer
extends DefaultDamagerRepairer {
    private String currentLanguage;

    public GherkinDamagerRepairer(GherkinKeywordScanner scanner) {
        super((ITokenScanner)scanner);
    }

    public void setDocument(IDocument document) {
        this.updateLanguage(GherkinEditorDocument.get(document));
        super.setDocument(document);
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        IRegion region = super.getDamageRegion(partition, e, documentPartitioningChanged);
        IDocument doc = e.getDocument();
        GherkinEditorDocument gherkinDocument = GherkinEditorDocument.get(doc);
        GherkinDialect dialect = gherkinDocument.getDialect();
        String language = dialect.getLanguage();
        if (!language.equals(this.currentLanguage)) {
            this.updateLanguage(gherkinDocument);
            return new Region(0, doc.getLength());
        }
        return region;
    }

    private void updateLanguage(GherkinEditorDocument gherkinDocument) {
        String language;
        this.currentLanguage = language = gherkinDocument.getDialect().getLanguage();
        GherkinKeywordScanner scanner = (GherkinKeywordScanner)this.fScanner;
        scanner.configureRules(gherkinDocument);
    }
}

