/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.AnsiEscapes;
import io.cucumber.core.plugin.Format;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;

final class Banner {
    private final boolean monochrome;
    private final PrintStream out;

    Banner(PrintStream out, boolean monochrome) {
        this.out = out;
        this.monochrome = monochrome;
    }

    void print(List<Line> lines, AnsiEscapes ... border) {
        int maxLength = lines.stream().map(Line::length).max(Comparator.comparingInt(a -> a)).orElseThrow(NoSuchElementException::new);
        StringBuilder out = new StringBuilder();
        Format borderFormat = this.monochrome ? Format.monochrome() : Format.color(border);
        out.append(borderFormat.text("\u250c" + this.times('\u2500', maxLength + 2) + "\u2510")).append("\n");
        for (Line line : lines) {
            int rightPad = maxLength - line.length();
            out.append(borderFormat.text("\u2502")).append(' ');
            for (Span span : line.spans) {
                Format format = this.monochrome ? Format.monochrome() : Format.color(span.escapes);
                out.append(format.text(span.text));
            }
            out.append(this.times(' ', rightPad)).append(' ').append(borderFormat.text("\u2502")).append("\n");
        }
        out.append(borderFormat.text("\u2514" + this.times('\u2500', maxLength + 2) + "\u2518")).append("\n");
        this.out.print(out);
    }

    private String times(char c, int count) {
        return new String(new char[count]).replace('\u0000', c);
    }

    static final class Line {
        private final List<Span> spans;

        Line(Span ... spans) {
            this.spans = Arrays.asList(spans);
        }

        Line(String text, AnsiEscapes ... escapes) {
            this(new Span(text, escapes));
        }

        int length() {
            return this.spans.stream().map(span -> ((Span)span).text.length()).mapToInt(Integer::intValue).sum();
        }
    }

    static final class Span {
        private final String text;
        private final AnsiEscapes[] escapes;

        Span(String text) {
            this.text = text;
            this.escapes = new AnsiEscapes[0];
        }

        Span(String text, AnsiEscapes ... escapes) {
            this.text = text;
            this.escapes = escapes;
        }
    }
}

