/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.part;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.operation.OperationExecutor;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.global.constants.StringConstants;
import com.kms.katalon.composer.global.part.ExecutionProfileCompositePart;
import com.kms.katalon.composer.global.provider.TableViewerProvider;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.composer.testcase.ast.editors.StringConstantCellEditor;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.global.enums.VariableValueType;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class GlobalVariablePart
extends CPart
implements TableViewerProvider,
EventHandler,
SavableCompositePart {
    private static String DEFAULT_VARIABLE_NAME = "G";
    private Table table;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private TableViewer tableViewer;
    private ToolItem tltmAdd;
    private ToolItem tltmRemove;
    private ToolItem tltmClear;
    private ToolItem tltmMoveUp;
    private ToolItem tltmMoveDown;
    private MPart mpart;
    private Composite composite;
    private Map<GlobalVariableEntity, String> needToUpdateVariables = new HashMap<GlobalVariableEntity, String>();
    private List<GlobalVariableEntity> globalVariables = new ArrayList<GlobalVariableEntity>();
    private ExecutionProfileEntity executionProfileEntity;
    private ExecutionProfileCompositePart parentExecutionProfileCompositePart;
    private static final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions((InputValueType)InputValueType.GlobalVariable);

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.mpart = mpart;
        this.executionProfileEntity = (ExecutionProfileEntity)mpart.getObject();
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof ExecutionProfileCompositePart) {
            this.parentExecutionProfileCompositePart = (ExecutionProfileCompositePart)compositePart.getObject();
        }
        this.initialize(mpart, this.partService);
        this.createComposite(parent);
        this.registerEventListeners();
    }

    private void createComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Composite compositeToolbar = new Composite(this.composite, 0);
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout gl_compositeToolbar = new GridLayout(1, false);
        gl_compositeToolbar.marginWidth = 0;
        gl_compositeToolbar.marginHeight = 0;
        compositeToolbar.setLayout((Layout)gl_compositeToolbar);
        compositeToolbar.setBackground(ColorUtil.getCompositeBackgroundColor());
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAdd = new ToolItem(toolBar, 0);
        this.tltmAdd.setText(StringConstants.PA_BTN_TIP_ADD);
        this.tltmAdd.setImage(ImageConstants.IMG_16_ADD);
        this.tltmRemove = new ToolItem(toolBar, 0);
        this.tltmRemove.setText(StringConstants.PA_BTN_TIP_REMOVE);
        this.tltmRemove.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmRemove.setDisabledImage(ImageConstants.IMG_16_REMOVE_DISABLED);
        this.tltmClear = new ToolItem(toolBar, 0);
        this.tltmClear.setText(StringConstants.PA_BTN_TIP_CLEAR);
        this.tltmClear.setImage(ImageConstants.IMG_16_CLEAR);
        this.tltmMoveUp = new ToolItem(toolBar, 0);
        this.tltmMoveUp.setText(StringConstants.PA_BTN_TIP_UP);
        this.tltmMoveUp.setImage(ImageConstants.IMG_16_MOVE_UP);
        this.tltmMoveDown = new ToolItem(toolBar, 0);
        this.tltmMoveDown.setText(StringConstants.PA_BTN_TIP_DOWN);
        this.tltmMoveDown.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        Composite compositeTable = new Composite(this.composite, 0);
        GridLayout gl_compositeTable = new GridLayout(1, false);
        gl_compositeTable.marginWidth = 0;
        gl_compositeTable.marginHeight = 0;
        compositeTable.setLayout((Layout)gl_compositeTable);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compositeTable.setBounds(0, 0, 64, 64);
        this.tableViewer = new TableViewer(compositeTable, 67586);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GlobalVariablePart.this.enableDisableBtns();
            }
        });
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Menu popupMenu = new Menu((Control)this.table);
        MenuItem showPreferenceMenuItem = new MenuItem(popupMenu, 64);
        showPreferenceMenuItem.setText(StringConstants.PA_MENU_CONTEXT_SHOW_PREFERENCES);
        showPreferenceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
                if (selection == null || selection.getFirstElement() == null) {
                    return;
                }
                GlobalVariablePart.this.eventBroker.post("GLOBAL_VARIABLE/SHOW_REFERENCES", selection.getFirstElement());
            }
        });
        this.table.setMenu(popupMenu);
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(200);
        tblclmnName.setText(StringConstants.PA_COL_NAME);
        tblclmnName.addSelectionListener((SelectionListener)this.createSortListener(this.tableViewer, tableViewerColumnName, 0));
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getName();
                }
                return "";
            }
        });
        tableViewerColumnName.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomTextCellEditor((Composite)GlobalVariablePart.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getName();
                }
                return "";
            }

            protected void setValue(Object element, Object value) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    GlobalVariablePart.this.executeOperation((IUndoableOperation)new ChangeGlobalVariableNameOperation((GlobalVariableEntity)element, (String)value));
                }
            }
        });
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDefaultValueType = tableViewerColumnValueType.getColumn();
        tblclmnDefaultValueType.setWidth(200);
        tblclmnDefaultValueType.setText(StringConstants.PA_COL_DEFAULT_VALUE_TYPE);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof GlobalVariableEntity)) {
                    return "";
                }
                GlobalVariableEntity globalVariable = (GlobalVariableEntity)element;
                InputValueType valueType = AstValueUtil.getTypeValue((Object)GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)globalVariable.getInitValue()));
                if (valueType != null) {
                    if (valueType.equals((Object)InputValueType.Number)) {
                        globalVariable.setValueType(VariableValueType.NUMBER);
                    } else if (valueType.equals((Object)InputValueType.String)) {
                        globalVariable.setValueType(VariableValueType.STRING);
                    } else {
                        globalVariable.setValueType(null);
                    }
                    return TreeEntityUtil.getReadableKeywordName((String)valueType.getName());
                }
                return "";
            }
        });
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, defaultInputValueTypes){
            private ExpressionWrapper expression;
            private Object oldValueTypeIndex;

            protected CellEditor getCellEditor(Object element) {
                return new CustomComboBoxCellEditor((Composite)GlobalVariablePart.this.tableViewer.getTable(), this.readableValueTypeNames);
            }

            protected boolean canEdit(Object element) {
                return element instanceof GlobalVariableEntity && !((GlobalVariableEntity)element).isProtected();
            }

            protected Object getValue(Object element) {
                this.oldValueTypeIndex = super.getValue((Object)GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)((GlobalVariableEntity)element).getInitValue()));
                return this.oldValueTypeIndex;
            }

            protected void setValue(Object element, Object value) {
                if (!(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= this.inputValueTypes.length) {
                    return;
                }
                InputValueType newValueType = this.inputValueTypes[(Integer)value];
                if (newValueType == this.inputValueTypes[(Integer)this.oldValueTypeIndex]) {
                    return;
                }
                this.oldValueTypeIndex = value;
                ASTNodeWrapper newAstNode = (ASTNodeWrapper)newValueType.getNewValue(this.expression != null ? this.expression.getParent() : null);
                if (newAstNode == null) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                GroovyWrapperParser groovyParser = new GroovyWrapperParser(stringBuilder);
                groovyParser.parse((Object)newAstNode);
                GlobalVariableEntity globalVariable = (GlobalVariableEntity)element;
                if (newValueType.equals((Object)InputValueType.Number)) {
                    globalVariable.setValueType(VariableValueType.NUMBER);
                } else if (newValueType.equals((Object)InputValueType.String)) {
                    globalVariable.setValueType(VariableValueType.STRING);
                } else {
                    globalVariable.setValueType(null);
                }
                globalVariable.setInitValue(stringBuilder.toString());
                this.getViewer().update(element, null);
                GlobalVariablePart.this.refresh();
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnValue = tableViewerColumnValue.getColumn();
        tblclmnValue.setWidth(350);
        tblclmnValue.setText(StringConstants.PA_COL_VALUE);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new MyLabelProvider(this){

            @Override
            public Image getImage(Object element) {
                GlobalVariableEntity entity;
                if (element != null && element instanceof GlobalVariableEntity && (entity = (GlobalVariableEntity)element).isProtected() && !entity.isDefaultValue()) {
                    return ImageConstants.IMG_12_EYE_SLASH;
                }
                return null;
            }

            @Override
            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    GlobalVariableEntity entity = (GlobalVariableEntity)element;
                    if (entity.isProtected()) {
                        if (entity.isDefaultValue()) {
                            return entity.getValue();
                        }
                        return "\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022";
                    }
                    return ((GlobalVariableEntity)element).getInitValue();
                }
                return "";
            }
        });
        tableViewerColumnValue.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            private ExpressionWrapper expression;

            protected CellEditor getCellEditor(Object element) {
                this.expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)((GlobalVariableEntity)element).getValue());
                if (this.expression == null) {
                    return null;
                }
                InputValueType inputValueType = AstValueUtil.getTypeValue((Object)this.expression);
                if (inputValueType != null && !inputValueType.equals((Object)InputValueType.String)) {
                    return inputValueType.getCellEditorForValue((Composite)GlobalVariablePart.this.tableViewer.getTable(), (Object)this.expression);
                }
                if (inputValueType.equals((Object)InputValueType.String) && inputValueType != null) {
                    return new MultilineTextCellEditor((Composite)GlobalVariablePart.this.tableViewer.getTable());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof GlobalVariableEntity;
            }

            protected Object getValue(Object element) {
                InputValueType inputValueType = AstValueUtil.getTypeValue((Object)this.expression);
                if (inputValueType != null) {
                    return inputValueType.getValueToEdit((Object)this.expression);
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (value == null) {
                    return;
                }
                InputValueType inputValueType = AstValueUtil.getTypeValue((Object)this.expression);
                if (inputValueType == null) {
                    return;
                }
                Object object = inputValueType.changeValue((Object)this.expression, value);
                if (!(object instanceof ASTNodeWrapper)) {
                    return;
                }
                GlobalVariableEntity variable = (GlobalVariableEntity)element;
                StringBuilder stringBuilder = new StringBuilder();
                new GroovyWrapperParser(stringBuilder).parse((Object)((ASTNodeWrapper)object));
                GlobalVariablePart.this.executeOperation((IUndoableOperation)new ChangeGlobalVariableValueOperation(variable, stringBuilder.toString()));
            }
        });
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDescription = tableViewerColumnDescription.getColumn();
        tblclmnDescription.setWidth(220);
        tblclmnDescription.setText(StringConstants.PA_COL_DESCRIPTION);
        tableViewerColumnDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getDescription();
                }
                return "";
            }
        });
        tableViewerColumnDescription.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomTextCellEditor((Composite)GlobalVariablePart.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return element instanceof GlobalVariableEntity;
            }

            protected Object getValue(Object element) {
                if (element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getDescription();
                }
                return StringConstants.EMPTY;
            }

            protected void setValue(Object element, Object value) {
                GlobalVariableEntity variable;
                String newParamDesc;
                if (element instanceof GlobalVariableEntity && value instanceof String && !(newParamDesc = (String)value).equals((variable = (GlobalVariableEntity)element).getDescription())) {
                    GlobalVariablePart.this.executeOperation((IUndoableOperation)new ChangeGlobalVariableDescriptionOperation(variable, newParamDesc));
                }
            }
        });
        TableViewerColumn tableViewerColumnProtected = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblColumnProtected = tableViewerColumnProtected.getColumn();
        tblColumnProtected.setWidth(100);
        tblColumnProtected.setText(StringConstants.PA_COL_PROTECTED);
        tblColumnProtected.setToolTipText("Values marked as protected will be securely masked and cannot be shared or exposed \n(for String and Number types).");
        tblColumnProtected.addSelectionListener((SelectionListener)this.createSortListener(this.tableViewer, tableViewerColumnProtected, 4));
        tableViewerColumnProtected.setLabelProvider((CellLabelProvider)new TypeCheckStyleCellTableLabelProvider<GlobalVariableEntity>(5){

            protected Image getImage(GlobalVariableEntity element) {
                if (element.getValueType() == null) {
                    return ColorUtil.isDarkTheme() ? ImageConstants.IMG_16_CHECKBOX_UNCHECKED_DISABLED_DARK : ImageConstants.IMG_16_CHECKBOX_UNCHECKED_DISABLED;
                }
                return element.isProtected() ? ImageConstants.IMG_16_CHECKBOX_CHECKED : ImageConstants.IMG_16_CHECKBOX_UNCHECKED;
            }

            protected String getText(GlobalVariableEntity element) {
                return "";
            }

            protected Class<GlobalVariableEntity> getElementType() {
                return GlobalVariableEntity.class;
            }
        });
        tableViewerColumnProtected.setEditingSupport((EditingSupport)new TypeCheckedEditingSupport<GlobalVariableEntity>((ColumnViewer)this.tableViewer){

            protected Class<GlobalVariableEntity> getElementType() {
                return GlobalVariableEntity.class;
            }

            protected CellEditor getCellEditorByElement(GlobalVariableEntity element) {
                return new CheckboxCellEditor(this.getComposite());
            }

            protected boolean canEditElement(GlobalVariableEntity element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    GlobalVariableEntity entity = element;
                    return entity.getValueType() != null;
                }
                return false;
            }

            protected Object getElementValue(GlobalVariableEntity element) {
                return element.isProtected();
            }

            protected void setElementValue(GlobalVariableEntity element, Object value) {
                UserProfile userProfile;
                if (!(value instanceof Boolean)) {
                    return;
                }
                boolean isProtected = (Boolean)value;
                if (element.isProtected() == isProtected) {
                    return;
                }
                boolean confirmed = true;
                if (element.isProtected() && (userProfile = UserProfileHelper.getCurrentProfile()).isShowProtectedGlobalVariableWarning()) {
                    MessageDialogWithToggle confirmDialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.PROTECTED_VALUE_TITLE, (String)MessageFormat.format("The value of {0} will be unmasked and revealed everywhere. Are you sure you want to process?", element.getName()), (String)ComposerComponentsImplMessageConstants.BTN_DO_NOT_SHOW_ME_AGAIN, (boolean)false, null, null);
                    confirmed = confirmDialog.getReturnCode() == 0;
                    boolean doNotShowAgain = confirmDialog.getToggleState();
                    if (doNotShowAgain) {
                        userProfile.setShowProtectedGlobalVariableWarning(!confirmDialog.getToggleState());
                        UserProfileHelper.saveProfile((UserProfile)userProfile);
                    }
                }
                if (confirmed) {
                    element.setProtected(isProtected);
                    if (element.isProtected()) {
                        element.setProtectedValue(element.getInitValue());
                        if (element.getValueType() == VariableValueType.STRING) {
                            element.setInitValue("''");
                        } else if (element.getValueType() == VariableValueType.NUMBER) {
                            element.setInitValue("0");
                        }
                    } else {
                        element.setInitValue(element.getProtectedValue());
                        element.setProtectedValue(null);
                    }
                    Trackings.trackClickProtectedGlobalVariable((boolean)element.isProtected());
                    this.getViewer().update((Object)element, null);
                    GlobalVariablePart.this.refresh();
                    GlobalVariablePart.this.setDirty(true);
                }
            }
        });
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.setInput();
        this.registerControlModifyListeners();
    }

    private void addNewVariable(GlobalVariableEntity variableEntity) {
        this.executeOperation((IUndoableOperation)new AddNewVariableOperation(variableEntity));
    }

    private void deleteSelectedVariables() {
        this.executeOperation((IUndoableOperation)new DeleteVariablesOperation());
    }

    private void clearVariables() {
        this.executeOperation((IUndoableOperation)new ClearVariableOperation());
    }

    private void moveUpVariable() {
        this.executeOperation((IUndoableOperation)new MoveUpVariableOperation());
    }

    private void moveDownVariable() {
        this.executeOperation((IUndoableOperation)new MoveDownVariableOperation());
    }

    private void registerControlModifyListeners() {
        this.tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariableEntity variable = GlobalVariablePart.this.executionProfileEntity.createGlobalVariableEntity();
                variable.setName(GlobalVariablePart.this.generateNewPropertyName());
                GlobalVariablePart.this.addNewVariable(variable);
            }
        });
        this.tltmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.deleteSelectedVariables();
            }
        });
        this.tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.clearVariables();
            }
        });
        this.tltmMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.moveUpVariable();
            }
        });
        this.tltmMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.moveDownVariable();
            }
        });
    }

    private void setInput() {
        try {
            this.setInput(this.executionProfileEntity.getGlobalVariableEntities());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setInput(List<GlobalVariableEntity> newInput) {
        this.globalVariables.clear();
        this.globalVariables.addAll(newInput);
        this.tableViewer.setInput(this.globalVariables);
        this.refresh();
    }

    protected void refresh() {
        this.tableViewer.refresh();
        this.enableDisableBtns();
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("GLOBAL_VARIABLE/REFRESH", (EventHandler)this);
        this.eventBroker.subscribe("EXECUTION_PROFILE/RENAMED", (EventHandler)this);
        this.eventBroker.subscribe("EXECUTION_PROFILE/DELETED", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "GLOBAL_VARIABLE/REFRESH": {
                this.setInput();
                this.clearUndoRedoHistory();
                this.needToUpdateVariables.clear();
                break;
            }
            case "EXECUTION_PROFILE/RENAMED": {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof Object)) {
                    return;
                }
                ExecutionProfileEntity renamedProfile = (ExecutionProfileEntity)object;
                if (!this.executionProfileEntity.equals((Object)renamedProfile)) break;
                this.executionProfileEntity = renamedProfile;
                this.updateMPart();
                break;
            }
            case "EXECUTION_PROFILE/DELETED": {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof ExecutionProfileEntity)) {
                    return;
                }
                ExecutionProfileEntity deletedProfile = (ExecutionProfileEntity)object;
                if (!this.executionProfileEntity.equals((Object)deletedProfile)) break;
                this.dispose();
            }
        }
    }

    private void clearUndoRedoHistory() {
        this.operationExecutor.dispose();
        this.operationExecutor = new OperationExecutor((Object)this);
    }

    public void setDirty(boolean isDirty) {
        this.parentExecutionProfileCompositePart.setDirty(isDirty);
    }

    private void updateMPart() {
        this.mpart.setLabel(this.executionProfileEntity.getName());
        this.mpart.setElementId(EntityPartUtil.getExecutionProfilePartId((String)this.executionProfileEntity.getIdForDisplay()));
    }

    public void updateProfileEntityFrom(ExecutionProfileEntity entity) {
        ExecutionProfileEntity oldExecutionProfileEntity = this.executionProfileEntity;
        if (entity != null) {
            this.executionProfileEntity = entity;
            this.executionProfileEntity.setName(oldExecutionProfileEntity.getName());
            this.executionProfileEntity.setProject(oldExecutionProfileEntity.getProject());
            this.executionProfileEntity.setParentFolder(oldExecutionProfileEntity.getParentFolder());
            this.setInput();
        }
    }

    @Persist
    public void save() throws Exception {
        List<String> duplicateVariableNames = this.getDuplicateVariableName();
        if (!duplicateVariableNames.isEmpty()) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)new IllegalArgumentException(), (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_GLOBAL_VARIABLE, (String)MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_DUPLICATE_VAR, String.join((CharSequence)", ", duplicateVariableNames)));
        }
        TableItem[] items = this.tableViewer.getTable().getItems();
        ArrayList<GlobalVariableEntity> sortedGlobalVariables = new ArrayList<GlobalVariableEntity>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            GlobalVariableEntity globalVariable = (GlobalVariableEntity)item.getData();
            sortedGlobalVariables.add(globalVariable);
            ++n2;
        }
        this.setInput(sortedGlobalVariables);
    }

    public void updateProfilEntityWithCurrentVariables() {
        this.executionProfileEntity.setGlobalVariableEntities(this.globalVariables);
    }

    public void updateVariableReferences() {
        if (this.needToUpdateVariableReferences()) {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            try {
                for (Map.Entry<GlobalVariableEntity, String> needToUpdateVariable : this.needToUpdateVariables.entrySet()) {
                    String globalVariablePrefix = "GlobalVariable.";
                    String oldValue = globalVariablePrefix + needToUpdateVariable.getValue();
                    String newValue = globalVariablePrefix + needToUpdateVariable.getKey().getName();
                    GroovyRefreshUtil.updateScriptReferencesInTestCaseAndCustomScripts((String)oldValue, (String)newValue, (ProjectEntity)currentProject);
                }
                this.needToUpdateVariables.clear();
            }
            catch (IOException | CoreException throwable) {
                MessageDialog.openWarning(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.PA_ERROR_MSG_UNABLE_TO_UPDATE_VAR_REFERENCES);
            }
        }
    }

    private void enableDisableBtns() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        boolean isEnabled = selection != null && selection.getFirstElement() != null;
        this.tltmRemove.setEnabled(isEnabled);
    }

    private List<String> getAllGlobalVariableName() {
        ArrayList<String> varNames = new ArrayList<String>();
        if (this.tableViewer == null || this.tableViewer.getTable().isDisposed()) {
            return varNames;
        }
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            varNames.add(((GlobalVariableEntity)item.getData()).getName());
            ++n2;
        }
        return varNames;
    }

    private List<String> getDuplicateVariableName() {
        List<String> variableNames = this.getAllGlobalVariableName();
        return variableNames.stream().filter(s -> Collections.frequency(variableNames, s) > 1).distinct().collect(Collectors.toList());
    }

    @PreDestroy
    public void dispose() {
        super.dispose();
        this.partService.hidePart(this.mpart);
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public boolean needToUpdateVariableReferences() {
        return !this.needToUpdateVariables.isEmpty();
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> res = new ArrayList<MPart>();
        res.add(this.getMPart());
        return res;
    }

    @Override
    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    @Override
    public void markDirty() {
        this.setDirty(true);
    }

    @Override
    public Map<GlobalVariableEntity, String> getNeedToUpdateVariables() {
        return this.needToUpdateVariables;
    }

    @Override
    public void performOperation(AbstractOperation operation) {
        this.executeOperation((IUndoableOperation)operation);
    }

    public ExecutionProfileEntity getEntity() {
        return this.executionProfileEntity;
    }

    public MPart getMPart() {
        return this.mpart;
    }

    public List<GlobalVariableEntity> getGlobalVariables() {
        return this.globalVariables;
    }

    private SelectionAdapter createSortListener(final TableViewer viewer, final TableViewerColumn column, final int columnIndex) {
        return new SelectionAdapter(){
            private int direction = 128;

            public void widgetSelected(SelectionEvent e) {
                Table table = viewer.getTable();
                if (table.getSortColumn() == column.getColumn()) {
                    this.direction = this.direction == 128 ? 1024 : 128;
                } else {
                    this.direction = 128;
                    table.setSortColumn(column.getColumn());
                }
                table.setSortDirection(this.direction);
                viewer.setComparator((ViewerComparator)new GlobalVariableEntityComparator(columnIndex, this.direction));
                GlobalVariablePart.this.markDirty();
            }
        };
    }

    public void setVariablesFromScriptContent(String scriptContent) throws Exception {
        ExecutionProfileEntity newVariableEntityWrapper = this.getVariableEntityWrapperFromScriptContent(scriptContent);
        if (newVariableEntityWrapper != null) {
            this.globalVariables.clear();
            this.globalVariables.addAll(newVariableEntityWrapper.getGlobalVariableEntities());
        } else {
            this.globalVariables.clear();
            this.globalVariables.addAll(new ArrayList());
        }
        this.tableViewer.setInput(this.globalVariables);
        this.refresh();
    }

    public ExecutionProfileEntity getVariableEntityWrapperFromScriptContent(String scriptContent) throws Exception {
        ExecutionProfileEntity newVariableEntityWrapper = null;
        if (scriptContent != null && scriptContent != "") {
            newVariableEntityWrapper = GlobalVariableController.getInstance().toExecutionProfileEntity(scriptContent);
        }
        return newVariableEntityWrapper;
    }

    public ExecutionProfileEntity getExecutionProfileEntity() {
        this.updateProfilEntityWithCurrentVariables();
        return this.executionProfileEntity;
    }

    public boolean isDirty() {
        return this.mpart.isDirty();
    }

    private String generateNewPropertyName() {
        String name = DEFAULT_VARIABLE_NAME;
        int index = 0;
        boolean isUnique = false;
        String newName = name + "_" + index;
        List<String> variableNames = this.getAllGlobalVariableName();
        while (!isUnique) {
            isUnique = true;
            for (String variableName : variableNames) {
                if (!variableName.equals(newName)) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                return newName;
            }
            newName = name + "_" + index;
            ++index;
        }
        return newName;
    }

    private class AddNewVariableOperation
    extends AbstractOperation {
        private GlobalVariableEntity variable;

        public AddNewVariableOperation(GlobalVariableEntity variable) {
            super(AddNewVariableOperation.class.getName());
            this.variable = variable;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.variable == null) {
                return Status.CANCEL_STATUS;
            }
            Trackings.trackCreatingObject((String)"profileVariable", (Object[])new Object[0]);
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.add(this.variable);
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.variable));
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.remove(this.variable);
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    public class ChangeGlobalVariableDescriptionOperation
    extends AbstractOperation {
        private GlobalVariableEntity variableEntity;
        private String oldDescription;
        private String newDescription;

        public ChangeGlobalVariableDescriptionOperation(GlobalVariableEntity variableEntity, String newDescription) {
            super(ChangeGlobalVariableDescriptionOperation.class.getName());
            this.variableEntity = variableEntity;
            this.newDescription = newDescription;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldDescription = this.variableEntity.getDescription();
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.changeVariableDescription(this.newDescription);
            return Status.OK_STATUS;
        }

        private void changeVariableDescription(String description) {
            this.variableEntity.setDescription(description);
            GlobalVariablePart.this.tableViewer.update((Object)this.variableEntity, null);
            GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.variableEntity));
            GlobalVariablePart.this.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.changeVariableDescription(this.oldDescription);
            return Status.OK_STATUS;
        }
    }

    public class ChangeGlobalVariableNameOperation
    extends AbstractOperation {
        private GlobalVariableEntity variableEntity;
        private String oldVariableName;
        private String newVariableName;

        public ChangeGlobalVariableNameOperation(GlobalVariableEntity variableEntity, String newVariableName) {
            super(ChangeGlobalVariableNameOperation.class.getName());
            this.variableEntity = variableEntity;
            this.newVariableName = newVariableName;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldVariableName = this.variableEntity.getName();
            if (StringUtils.isEmpty((CharSequence)this.newVariableName)) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)new IllegalArgumentException(), (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_GLOBAL_VARIABLE, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_VAR_CANNOT_BE_NULL_OR_EMPTY);
                return Status.CANCEL_STATUS;
            }
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.changeVariableName(this.newVariableName);
            if (StringUtils.isNotEmpty((CharSequence)this.oldVariableName)) {
                GlobalVariablePart.this.needToUpdateVariables.put(this.variableEntity, this.oldVariableName);
            }
            return Status.OK_STATUS;
        }

        private void changeVariableName(String variableName) {
            this.variableEntity.setName(variableName);
            GlobalVariablePart.this.tableViewer.update((Object)this.variableEntity, null);
            GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.variableEntity));
            GlobalVariablePart.this.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.changeVariableName(this.oldVariableName);
            if (GlobalVariablePart.this.needToUpdateVariables.containsKey(this.variableEntity)) {
                GlobalVariablePart.this.needToUpdateVariables.remove(this.variableEntity);
            } else if (StringUtils.isNotEmpty((CharSequence)this.newVariableName)) {
                GlobalVariablePart.this.needToUpdateVariables.put(this.variableEntity, this.newVariableName);
            }
            return Status.OK_STATUS;
        }
    }

    public class ChangeGlobalVariableValueOperation
    extends AbstractOperation {
        private GlobalVariableEntity variableEntity;
        private String oldValue;
        private String newValue;

        public ChangeGlobalVariableValueOperation(GlobalVariableEntity variableEntity, String newValue) {
            super(ChangeGlobalVariableValueOperation.class.getName());
            this.variableEntity = variableEntity;
            this.newValue = newValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = this.variableEntity.getValue();
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.changeVariableValue(this.newValue);
            return Status.OK_STATUS;
        }

        private void changeVariableValue(String value) {
            if (this.variableEntity.isProtected()) {
                this.variableEntity.setProtectedValue(value);
            } else {
                this.variableEntity.setInitValue(value);
            }
            GlobalVariablePart.this.tableViewer.update((Object)this.variableEntity, null);
            GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.variableEntity));
            GlobalVariablePart.this.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.changeVariableValue(this.oldValue);
            return Status.OK_STATUS;
        }
    }

    private class ClearVariableOperation
    extends AbstractOperation {
        private List<GlobalVariableEntity> oldInput;

        public ClearVariableOperation() {
            super(ClearVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (GlobalVariablePart.this.globalVariables.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            this.oldInput = new ArrayList<GlobalVariableEntity>(GlobalVariablePart.this.globalVariables);
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.clear();
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.setInput(this.oldInput);
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class CustomComboBoxCellEditor
    extends ComboBoxCellEditor {
        public CustomComboBoxCellEditor(Composite parent, String[] items) {
            super(parent, items);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData result = super.getLayoutData();
            result.minimumHeight = GlobalVariablePart.this.tableViewer.getTable().getItemHeight();
            return result;
        }
    }

    private class CustomTextCellEditor
    extends TextCellEditor {
        public CustomTextCellEditor(Composite parent) {
            super(parent);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData data = super.getLayoutData();
            data.minimumHeight = GlobalVariablePart.this.tableViewer.getTable().getItemHeight();
            return data;
        }
    }

    private class DeleteVariablesOperation
    extends AbstractOperation {
        private Map<GlobalVariableEntity, Integer> deletedVariables;

        public DeleteVariablesOperation() {
            super(DeleteVariablesOperation.class.getName());
            this.deletedVariables = new LinkedHashMap<GlobalVariableEntity, Integer>();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            StructuredSelection selection = (StructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
            if (selection.size() <= 0) {
                return Status.CANCEL_STATUS;
            }
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                GlobalVariableEntity selectedVariable;
                int index;
                Object selectedItem = objectArray[n2];
                if (selectedItem instanceof GlobalVariableEntity && (index = GlobalVariablePart.this.globalVariables.indexOf(selectedVariable = (GlobalVariableEntity)selectedItem)) != -1) {
                    if (selectedVariable.isProtected()) {
                        selectedVariable.setProtected(false);
                    }
                    this.deletedVariables.put(selectedVariable, index);
                }
                ++n2;
            }
            GlobalVariablePart.this.globalVariables.removeAll(selection.toList());
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.removeAll(this.deletedVariables.keySet());
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (Map.Entry<GlobalVariableEntity, Integer> deletedVariable : this.deletedVariables.entrySet()) {
                GlobalVariablePart.this.globalVariables.add(deletedVariable.getValue(), deletedVariable.getKey());
            }
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection(this.deletedVariables.keySet().toArray()));
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class GlobalVariableEntityComparator
    extends ViewerComparator {
        private int columnIndex;
        private int direction;

        public GlobalVariableEntityComparator(int columnIndex, int direction) {
            this.columnIndex = columnIndex;
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            GlobalVariableEntity g1 = (GlobalVariableEntity)e1;
            GlobalVariableEntity g2 = (GlobalVariableEntity)e2;
            if (this.columnIndex == 0) {
                result = g1.getName().compareToIgnoreCase(g2.getName());
            } else if (this.columnIndex == 4) {
                result = Boolean.compare(g1.isProtected(), g2.isProtected());
            }
            return this.direction == 128 ? result : -result;
        }
    }

    private class MoveDownVariableOperation
    extends AbstractOperation {
        private Integer moveDownVariable;

        public MoveDownVariableOperation() {
            super(MoveDownVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            StructuredSelection selection = (StructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
            if (selection.size() <= 0) {
                return Status.CANCEL_STATUS;
            }
            List selections = selection.toList();
            Collections.reverse(selections);
            for (Object selectedItem : selections) {
                GlobalVariableEntity selectedVariable;
                int indexMove;
                if (!(selectedItem instanceof GlobalVariableEntity) || (indexMove = GlobalVariablePart.this.globalVariables.indexOf(selectedVariable = (GlobalVariableEntity)selectedItem) + 1) >= GlobalVariablePart.this.globalVariables.size()) continue;
                GlobalVariableEntity variableAfter = GlobalVariablePart.this.globalVariables.get(indexMove);
                if (!variableAfter.equals(selectedVariable)) {
                    Collections.swap(GlobalVariablePart.this.globalVariables, indexMove - 1, indexMove);
                }
                this.moveDownVariable = indexMove;
                GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(indexMove)));
                break;
            }
            if (this.moveDownVariable == null) {
                return Status.CANCEL_STATUS;
            }
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.moveDownVariable != null) {
                Collections.swap(GlobalVariablePart.this.globalVariables, this.moveDownVariable - 1, (int)this.moveDownVariable);
                GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(this.moveDownVariable - 1)));
            }
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class MoveUpVariableOperation
    extends AbstractOperation {
        private Integer moveUpVariable;

        public MoveUpVariableOperation() {
            super(MoveUpVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            StructuredSelection selection = (StructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
            if (selection.size() <= 0) {
                return Status.CANCEL_STATUS;
            }
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                GlobalVariableEntity selectedVariable;
                int indexMove;
                Object selectedItem = objectArray[n2];
                if (selectedItem instanceof GlobalVariableEntity && (indexMove = GlobalVariablePart.this.globalVariables.indexOf(selectedVariable = (GlobalVariableEntity)selectedItem) - 1) >= 0) {
                    GlobalVariableEntity variableBefore = GlobalVariablePart.this.globalVariables.get(indexMove);
                    if (!variableBefore.equals(selectedVariable)) {
                        Collections.swap(GlobalVariablePart.this.globalVariables, indexMove, indexMove + 1);
                    }
                    this.moveUpVariable = indexMove;
                    GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(indexMove)));
                    break;
                }
                ++n2;
            }
            if (this.moveUpVariable == null) {
                return Status.CANCEL_STATUS;
            }
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.moveUpVariable != null) {
                Collections.swap(GlobalVariablePart.this.globalVariables, this.moveUpVariable + 1, (int)this.moveUpVariable);
                GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(this.moveUpVariable + 1)));
            }
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class MultilineTextCellEditor
    extends StringConstantCellEditor {
        public MultilineTextCellEditor(Composite parent) {
            super(parent, 2626);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData data = super.getLayoutData();
            data.minimumHeight = 100;
            data.verticalAlignment = 128;
            return data;
        }
    }

    class MyLabelProvider
    extends OwnerDrawLabelProvider {
        MyLabelProvider() {
        }

        protected String getText(Object element) {
            return null;
        }

        protected Image getImage(Object element) {
            return null;
        }

        protected void measure(org.eclipse.swt.widgets.Event event, Object element) {
            event.width = 200;
            event.height = 20;
        }

        protected void paint(org.eclipse.swt.widgets.Event event, Object element) {
            Image image = this.getImage(element);
            String text = this.getText(element);
            if (text == null) {
                text = "''";
            }
            int textX = event.x + 2;
            event.gc.drawText(text, textX, event.y + 4, true);
            int textWidth = event.gc.textExtent((String)text).x;
            int imageX = textX + textWidth + 5;
            if (image != null) {
                int imageY = event.y + (event.height - image.getBounds().height) / 2;
                event.gc.drawImage(image, imageX, imageY);
            }
        }
    }
}

