/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.infrastructure;

import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.constant.ParameterType;
import com.katalon.recorder.core.domain.exception.TestCaseException;
import com.katalon.recorder.core.domain.model.ArrayParameter;
import com.katalon.recorder.core.domain.model.BuiltinKeywordRef;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IKeywordRef;
import com.katalon.recorder.core.domain.model.IParameter;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.domain.model.ListParameter;
import com.katalon.recorder.core.domain.model.SingleParameter;
import com.katalon.recorder.core.infrastructure.ITestCaseService;
import com.katalon.recorder.core.infrastructure.IVariableService;
import com.katalon.recorder.core.infrastructure.dto.ASTNodeWrapperAdapter;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArrayExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClassExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ThrowStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputValueEditorProvider;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionParamValueType;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.objectspy.element.WebElement;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.openqa.selenium.Keys;

@Creatable
@Singleton
public class TestCaseService
implements ITestCaseService {
    private static final String THIS_VARIABLE = "this";
    private final IVariableService variableService;

    @Inject
    public TestCaseService(IVariableService variableService) {
        this.variableService = variableService;
    }

    public Map<String, ASTNodeWrapperAdapter> deserializeTestCase(String testCaseId) throws IllegalArgumentException, GroovyParsingException, TestCaseException {
        String scriptContent = this.getTestCaseContent(testCaseId);
        List<? extends ASTNodeWrapper> astNodes = this.convertToASTNodes(scriptContent);
        LinkedHashMap<String, ASTNodeWrapperAdapter> nodeAdapters = new LinkedHashMap<String, ASTNodeWrapperAdapter>();
        for (ASTNodeWrapper aSTNodeWrapper : astNodes) {
            ASTNodeWrapperAdapter astNodeWrapperAdapter = new ASTNodeWrapperAdapter(aSTNodeWrapper);
            nodeAdapters.put(astNodeWrapperAdapter.getAstRefId(), astNodeWrapperAdapter);
        }
        return nodeAdapters;
    }

    public List<IVariable> getVariablesFromTestCase(String testCaseId) throws TestCaseException {
        TestCaseEntity testCase = null;
        try {
            testCase = TestCaseController.getInstance().getTestCase(testCaseId);
        }
        catch (Exception e) {
            throw new TestCaseException("Exception when getting variables from test case | testCaseId = %s".formatted(testCaseId), (Throwable)e);
        }
        return this.variableService.loadVariableFrom(testCase.getVariables());
    }

    public ExpressionStatementWrapper generateTestStep(IStep step, ScriptNodeWrapper parentNode, Map<WebElement, FileEntity> elementEntityMap) {
        IKeywordDefinition keywordDef = step.getKeywordDefinition();
        IKeywordRef keywordRef = keywordDef.getKeywordRef();
        String keywordName = keywordRef.getName();
        KeywordPlatform platform = keywordRef.getPlatform();
        KeywordMethod method = this.getMethodInKeywordDefinition(keywordDef);
        if (method == null) {
            return null;
        }
        MethodCallExpressionWrapper methodCallExpressionWrapper = switch (platform) {
            case KeywordPlatform.WEB -> new MethodCallExpressionWrapper(this.getWebKeywordClass().getAliasName(), keywordName, (ASTNodeWrapper)parentNode);
            default -> throw new UnsupportedOperationException("Unsupported platform: " + String.valueOf(platform));
        };
        ArgumentListExpressionWrapper argumentListExpressionWrapper = methodCallExpressionWrapper.getArguments();
        KeywordParameter[] parameters = method.getParameters();
        List keywordParameters = keywordDef.getParameters();
        List arguments = step.getArguments();
        if (parameters.length != keywordParameters.size() || parameters.length != arguments.size()) {
            throw new IllegalArgumentException("Mismatch: method parameters (%s), keywordParameters (%s), arguments (%s)".formatted(parameters.length, keywordParameters.size(), arguments.size()));
        }
        int i = 0;
        while (i < keywordParameters.size()) {
            Object argumentValue = arguments.get(i);
            PropertyExpressionWrapper generatedExpression = null;
            IParameter keywordParameter = (IParameter)keywordParameters.get(i);
            if (keywordParameter instanceof SingleParameter) {
                SingleParameter singleParam = (SingleParameter)keywordParameter;
                ParameterType type = singleParam.getType();
                if (ParameterType.TEST_OBJECT.equals((Object)type)) {
                    FileEntity fileEntity = elementEntityMap.entrySet().stream().filter(entry -> Strings.CS.equals((String)argumentValue, ((WebElement)entry.getKey()).getScriptId())).reduce((a, b) -> b).map(Map.Entry::getValue).orElse(null);
                    if (fileEntity instanceof WebElementEntity) {
                        WebElementEntity webElementEntity = (WebElementEntity)fileEntity;
                        generatedExpression = AstEntityInputUtil.createNewFindTestObjectMethodCall((String)webElementEntity.getIdForDisplay(), (ASTNodeWrapper)parentNode);
                    } else {
                        generatedExpression = AstEntityInputUtil.createNewFindTestObjectMethodCall((String)((String)argumentValue), (ASTNodeWrapper)parentNode);
                    }
                } else if (ParameterType.FAILURE_HANDLING.equals((Object)type)) {
                    generatedExpression = AstKeywordsInputUtil.getNewFailureHandlingPropertyExpression(null);
                } else {
                    inputValueType = this.toInputValueType(singleParam.getType());
                    paramValueType = HTMLActionParamValueType.newInstance((InputValueEditorProvider)inputValueType, (Object)singleParam.getName());
                    if (InputValueType.String.equals((Object)inputValueType)) {
                        ExpressionWrapper value = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)GroovyStringUtil.toGroovyStringFormat((String)((String)argumentValue)));
                        paramValueType.setValue((Object)value);
                    } else {
                        paramValueType.setValue(this.getValue(inputValueType, argumentValue, parentNode));
                    }
                    generatedExpression = paramValueType.toExpressionWrapper();
                }
            } else if (keywordParameter instanceof ArrayParameter) {
                ArrayParameter arrayParam = (ArrayParameter)keywordParameter;
                inputValueType = InputValueType.Array;
                paramValueType = HTMLActionParamValueType.newInstance((InputValueEditorProvider)inputValueType, (Object)arrayParam.getName());
                paramValueType.setValue(this.getValue(inputValueType, argumentValue, parentNode));
                generatedExpression = paramValueType.toExpressionWrapper();
            } else if (keywordParameter instanceof ListParameter) {
                ListParameter listParam = (ListParameter)keywordParameter;
                InputValueType inputValueType = InputValueType.List;
                HTMLActionParamValueType paramValueType = HTMLActionParamValueType.newInstance((InputValueEditorProvider)inputValueType, (Object)listParam.getName());
                paramValueType.setValue(this.getValue(inputValueType, argumentValue, parentNode));
                generatedExpression = paramValueType.toExpressionWrapper();
            } else {
                throw new UnsupportedOperationException("Unsupported parameter type: " + String.valueOf(keywordParameter.getClass()));
            }
            argumentListExpressionWrapper.addExpression((ExpressionWrapper)generatedExpression);
            ++i;
        }
        return new ExpressionStatementWrapper((ExpressionWrapper)methodCallExpressionWrapper, (ASTNodeWrapper)parentNode);
    }

    private KeywordMethod getMethodInKeywordDefinition(IKeywordDefinition keywordDef) {
        IKeywordRef keywordRef = keywordDef.getKeywordRef();
        String keywordName = keywordRef.getName();
        KeywordPlatform keywordPlatform = null;
        if (keywordRef instanceof BuiltinKeywordRef) {
            BuiltinKeywordRef builtinKeywordRef = (BuiltinKeywordRef)keywordRef;
            keywordPlatform = builtinKeywordRef.getPlatform();
        }
        if (KeywordPlatform.WEB.equals(keywordPlatform)) {
            String simpleName = this.getWebKeywordClass().getSimpleName();
            List keywordMethods = KeywordController.getInstance().getBuiltInKeywords(simpleName);
            for (KeywordMethod keywordMethod : keywordMethods) {
                if (!keywordMethod.getName().equals(keywordName) || !this.isMatchingKeyword(keywordMethod, keywordDef)) continue;
                return keywordMethod;
            }
        }
        return null;
    }

    private InputValueType toInputValueType(ParameterType parameterType) {
        switch (parameterType) {
            case STRING: {
                return InputValueType.String;
            }
            case NUMBER: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case LONG: {
                return InputValueType.Number;
            }
            case BOOLEAN: {
                return InputValueType.Boolean;
            }
            case NULL: {
                return InputValueType.Null;
            }
            case VARIABLE: {
                return InputValueType.Variable;
            }
            case GLOBAL_VARIABLE: {
                return InputValueType.GlobalVariable;
            }
            case METHOD_CALL: {
                return InputValueType.MethodCall;
            }
            case ARRAY: {
                return InputValueType.Array;
            }
            case LIST: {
                return InputValueType.List;
            }
            case MAP: {
                return InputValueType.Map;
            }
            case CLOSURE: {
                return InputValueType.Closure;
            }
            case CLOSURE_LIST: {
                return InputValueType.ClosureList;
            }
            case CONDITION: {
                return InputValueType.Condition;
            }
            case BINARY: {
                return InputValueType.Binary;
            }
            case RANGE: {
                return InputValueType.Range;
            }
            case PROPERTY: {
                return InputValueType.Property;
            }
            case TEST_DATA_VALUE: {
                return InputValueType.TestDataValue;
            }
            case TEST_CASE: {
                return InputValueType.TestCase;
            }
            case TEST_OBJECT: {
                return InputValueType.TestObject;
            }
            case WINDOWS_OBJECT: {
                return InputValueType.WindowsObject;
            }
            case TEST_DATA: {
                return InputValueType.TestData;
            }
            case CHECKPOINT: {
                return InputValueType.Checkpoint;
            }
            case CLASS: {
                return InputValueType.Class;
            }
            case THIS: {
                return InputValueType.This;
            }
            case THROWABLE: {
                return InputValueType.Throwable;
            }
            case KEYS: {
                return InputValueType.Keys;
            }
            case KEY: {
                return InputValueType.Key;
            }
        }
        return InputValueType.String;
    }

    private boolean isMatchingKeyword(KeywordMethod keywordMethod, IKeywordDefinition keywordDef) {
        List parameters;
        boolean sameNumberOfParams;
        KeywordParameter[] keywordParameters = keywordMethod.getParameters();
        boolean bl = sameNumberOfParams = keywordParameters.length == (parameters = keywordDef.getParameters()).size();
        if (!sameNumberOfParams) {
            return false;
        }
        int i = 0;
        while (i < parameters.size()) {
            KeywordParameter keywordParameter;
            IParameter parameter = (IParameter)parameters.get(i);
            String name = parameter.getName();
            if (!Strings.CS.equals(name, (keywordParameter = keywordParameters[i]).getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private KeywordClass getWebKeywordClass() {
        return KeywordController.getInstance().getBuiltInKeywordClassByName(WebUiBuiltInKeywords.class.getName());
    }

    private String getTestCaseContent(String testCaseId) throws IllegalArgumentException, TestCaseException {
        TestCaseController testCaseController = TestCaseController.getInstance();
        TestCaseEntity testCaseEntity = null;
        try {
            testCaseEntity = testCaseController.getTestCase(testCaseId);
            if (testCaseEntity == null) {
                throw new TestCaseException("Test case not found | testCaseId = %s".formatted(testCaseId));
            }
        }
        catch (Exception e) {
            throw new TestCaseException("Exception when getting test case content | testCaseId = %s".formatted(testCaseId), (Throwable)e);
        }
        return new String(testCaseEntity.getScriptContents(), StandardCharsets.UTF_8);
    }

    private List<? extends ASTNodeWrapper> convertToASTNodes(String scriptContent) throws GroovyParsingException {
        List wrapper = new ArrayList();
        wrapper = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)scriptContent).getRunMethod().getBlock().getAstChildren();
        return wrapper;
    }

    private Object getValue(InputValueType inputValueType, Object value, ScriptNodeWrapper parent) {
        switch (inputValueType) {
            case String: {
                return new ConstantExpressionWrapper((Object)((String)value), (ASTNodeWrapper)parent);
            }
            case Number: {
                if (value instanceof Float) {
                    return new ConstantExpressionWrapper((Object)Float.valueOf(((Float)value).floatValue()), (ASTNodeWrapper)parent);
                }
                if (value instanceof Double) {
                    return new ConstantExpressionWrapper((Object)((Double)value), (ASTNodeWrapper)parent);
                }
                if (value instanceof Long) {
                    return new ConstantExpressionWrapper((Object)((Long)value), (ASTNodeWrapper)parent);
                }
                if (value instanceof Byte) {
                    return new ConstantExpressionWrapper((Object)((Byte)value), (ASTNodeWrapper)parent);
                }
                return new ConstantExpressionWrapper((Object)((Integer)value), (ASTNodeWrapper)parent);
            }
            case Boolean: {
                return new ConstantExpressionWrapper((Object)((Boolean)value), (ASTNodeWrapper)parent);
            }
            case Null: {
                return new ConstantExpressionWrapper((ASTNodeWrapper)parent);
            }
            case Binary: {
                return new BinaryExpressionWrapper((ASTNodeWrapper)parent);
            }
            case Variable: {
                return new VariableExpressionWrapper((ASTNodeWrapper)parent);
            }
            case MethodCall: {
                return new MethodCallExpressionWrapper((ASTNodeWrapper)parent);
            }
            case Condition: {
                return new BooleanExpressionWrapper((ASTNodeWrapper)parent);
            }
            case Array: {
                return new ArrayExpressionWrapper((ArrayExpression)value, (ASTNodeWrapper)parent);
            }
            case List: {
                return new ListExpressionWrapper((ASTNodeWrapper)parent);
            }
            case Map: {
                return new MapExpressionWrapper((ASTNodeWrapper)parent);
            }
            case ClosureList: {
                return new ClosureListExpressionWrapper((ASTNodeWrapper)parent);
            }
            case Range: {
                return new RangeExpressionWrapper((ASTNodeWrapper)parent);
            }
            case Property: {
                return new PropertyExpressionWrapper((ASTNodeWrapper)parent);
            }
            case GlobalVariable: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport("internal", "GlobalVariable");
                }
                return new PropertyExpressionWrapper(InputValueType.GlobalVariable.name(), (ASTNodeWrapper)parent);
            }
            case TestObject: {
                return AstEntityInputUtil.createNewFindTestObjectMethodCall((ASTNodeWrapper)parent);
            }
            case WindowsObject: {
                return AstEntityInputUtil.createNewFindWindowsObjectMethodCall((ASTNodeWrapper)parent);
            }
            case Class: {
                return new ClassExpressionWrapper(String.class, (ASTNodeWrapper)parent);
            }
            case TestDataValue: {
                return AstEntityInputUtil.createNewGetTestDataValueExpression(null, (Object)1, (Object)1, (ASTNodeWrapper)parent);
            }
            case TestData: {
                return AstEntityInputUtil.createNewFindTestDataExpression(null, (ASTNodeWrapper)parent);
            }
            case TestCase: {
                return AstEntityInputUtil.createNewFindTestCaseMethodCall(null, (ASTNodeWrapper)parent);
            }
            case Checkpoint: {
                return AstEntityInputUtil.createNewFindCheckpointMethodCall(null, (ASTNodeWrapper)parent);
            }
            case This: {
                return new VariableExpressionWrapper(THIS_VARIABLE, (ASTNodeWrapper)parent);
            }
            case Throwable: {
                return new ConstructorCallExpressionWrapper(ThrowStatementWrapper.DEFAULT_THROW_TYPE, (ASTNodeWrapper)parent);
            }
            case Key: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport(Keys.class);
                }
                return new PropertyExpressionWrapper(Keys.class.getSimpleName(), "ENTER", (ASTNodeWrapper)parent);
            }
            case Keys: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport(Keys.class);
                }
                return new MethodCallExpressionWrapper(Keys.class, "chord", (ASTNodeWrapper)parent);
            }
            case Closure: {
                return new ClosureExpressionWrapper(new ParameterWrapper[0], (ASTNodeWrapper)parent);
            }
        }
        return new ConstantExpressionWrapper((ASTNodeWrapper)parent);
    }
}

