/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.model;

import com.katalon.capability.constant.DriverPlatform;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.constant.RemoteDriverType;
import com.katalon.capability.model.ICapabilitySetting;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CustomCapabilitySetting
implements ICapabilitySetting {
    private String name;
    private Map<DriverType, ICapabilitySetting> values;

    public CustomCapabilitySetting(String name) {
        this.name = name;
        this.values = new LinkedHashMap<DriverType, ICapabilitySetting>();
    }

    public CustomCapabilitySetting(String name, Map<DriverType, ICapabilitySetting> values) {
        this.name = name;
        this.values = values;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public List<DriverType> getSupportedDriverTypes() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return new ArrayList<DriverType>(this.values.keySet());
    }

    @Override
    public DriverType getSupportedDriver(DriverPlatform driverPlatform) {
        if (driverPlatform == null || this.values == null || this.values.keySet().isEmpty()) {
            return null;
        }
        DriverType remote = null;
        DriverType testCloud = null;
        DriverType kobiton = null;
        for (DriverType driverType : this.values.keySet()) {
            if (driverPlatform == driverType.getDriverPlatform()) {
                return driverType;
            }
            if (DriverType.REMOTE_WEB_DRIVER != driverType) continue;
            ICapabilitySetting capability = this.values.get((Object)DriverType.REMOTE_WEB_DRIVER);
            String remoteDriverTypeStr = (String)capability.getValue().getOrDefault("remoteWebDriverType", "");
            RemoteDriverType remoteDriverType = RemoteDriverType.fromDisplayName(remoteDriverTypeStr);
            if ((DriverPlatform.WEB != driverPlatform || RemoteDriverType.SELENIUM != remoteDriverType) && (DriverPlatform.MOBILE != driverPlatform || RemoteDriverType.APPIUM != remoteDriverType)) continue;
            remote = driverType;
        }
        if (remote != null) {
            return remote;
        }
        if (testCloud != null) {
            return testCloud;
        }
        if (kobiton != null) {
            return kobiton;
        }
        return null;
    }

    @Override
    public Map<String, Object> getValue() {
        throw new UnsupportedOperationException("getValue method is not supported by CustomCapabilitySetting");
    }

    public Map<DriverType, ICapabilitySetting> getValues() {
        return this.values;
    }

    @Override
    public Map<String, Object> getValue(DriverType driverType) {
        if (this.values.containsKey((Object)driverType)) {
            this.values.get((Object)driverType).getValue(driverType);
        }
        return null;
    }

    @Override
    public void putProperty(String key, Object value) {
        throw new UnsupportedOperationException("putProperty method is not supported by CustomCapabilitySetting");
    }

    @Override
    public void setValue(Map<String, Object> value) {
        throw new UnsupportedOperationException("setValue method is not supported by CustomCapabilitySetting");
    }

    public void setValues(Map<DriverType, ICapabilitySetting> values) {
        this.values = values;
    }

    public void remove(DriverType driverType) {
        this.values.remove((Object)driverType);
    }

    public String toString() {
        List<String> capabilityList = this.values.entrySet().stream().map(entry -> ((DriverType)((Object)((Object)entry.getKey()))).getDisplayName() + ": " + ((ICapabilitySetting)entry.getValue()).toString()).toList();
        return StringUtils.join(capabilityList, (String)" + ");
    }

    @Override
    public CustomCapabilitySetting clone() {
        LinkedHashMap<DriverType, ICapabilitySetting> clonedValues = new LinkedHashMap<DriverType, ICapabilitySetting>();
        for (Map.Entry<DriverType, ICapabilitySetting> entry : this.values.entrySet()) {
            clonedValues.put(entry.getKey(), entry.getValue().clone());
        }
        return new CustomCapabilitySetting(this.name, clonedValues);
    }
}

