/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTHasBlock;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.CommentWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Comment;

public class ScriptNodeWrapper
extends ClassNodeWrapper
implements ASTHasBlock {
    private BlockStatementWrapper mainBlock;
    private String testCaseId;

    public ScriptNodeWrapper() {
        super(Script.class, null);
        this.mainBlock = new BlockStatementWrapper(this);
    }

    public ScriptNodeWrapper(ClassNode scriptClass) {
        super(scriptClass, null);
        this.mainBlock = this.getRunMethod().getBlock();
        ArrayList<CommentWrapper> commentWrappers = new ArrayList<CommentWrapper>();
        for (Comment comment : scriptClass.getModule().getContext().getComments()) {
            commentWrappers.add(new CommentWrapper(comment, (ASTNodeWrapper)this));
        }
        this.setInsideComments(commentWrappers);
    }

    public ScriptNodeWrapper(ScriptNodeWrapper scriptNodeWrapper) {
        super(scriptNodeWrapper, null);
        this.mainBlock = this.getRunMethod().getBlock();
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.addAll(this.getImports());
        astNodeWrappers.add(this.mainBlock);
        astNodeWrappers.addAll(this.fields);
        astNodeWrappers.addAll(this.methods);
        return astNodeWrappers;
    }

    @Override
    public BlockStatementWrapper getBlock() {
        return this.mainBlock;
    }

    public String getTestCaseId() {
        return this.testCaseId;
    }

    public void setMainBlock(BlockStatementWrapper mainBlock) {
        this.mainBlock = mainBlock;
    }

    public void setTestCaseId(String testCaseId) {
        this.testCaseId = testCaseId;
    }

    @Override
    public ScriptNodeWrapper clone() {
        return new ScriptNodeWrapper(this);
    }

    public MethodNodeWrapper getRunMethod() {
        for (MethodNodeWrapper methodNode : this.getMethods()) {
            if (!methodNode.getName().equals("run")) continue;
            return methodNode;
        }
        return null;
    }
}

