/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeCollection;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;

public class VariableExpressionWrapper
extends ExpressionWrapper {
    private static final String DEFAULT_VARIABLE_NAME = "a";
    private String variable;
    private ClassNodeWrapper originType;

    public VariableExpressionWrapper() {
        this(DEFAULT_VARIABLE_NAME, null);
    }

    public VariableExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        this(DEFAULT_VARIABLE_NAME, parentNodeWrapper);
    }

    public VariableExpressionWrapper(String variable) {
        this(variable, null);
    }

    public VariableExpressionWrapper(String variable, ASTNodeWrapper parentNodeWrapper) {
        this(variable, Object.class, parentNodeWrapper);
    }

    public VariableExpressionWrapper(String variable, Class<?> originType, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.variable = variable;
        this.originType = new ClassNodeWrapper(originType, (ASTNodeWrapper)this);
    }

    public VariableExpressionWrapper(VariableExpression expression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)expression, parentNodeWrapper);
        this.variable = expression.getName();
        this.originType = ClassNodeWrapper.getClassWrapper(expression.getOriginType(), this);
    }

    public VariableExpressionWrapper(VariableExpressionWrapper variableExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(variableExpressionWrapper, parentNodeWrapper);
        this.copyVariableProperties(variableExpressionWrapper);
    }

    private void copyVariableProperties(VariableExpressionWrapper variableExpressionWrapper) {
        this.variable = variableExpressionWrapper.getName();
        this.originType = new ClassNodeWrapper(variableExpressionWrapper.getOriginType(), (ASTNodeWrapper)this);
    }

    @Override
    public String getText() {
        return this.getVariable();
    }

    public String getName() {
        return this.getVariable();
    }

    public ClassNodeWrapper getOriginType() {
        return this.originType;
    }

    public void setOriginType(ClassNodeWrapper originType) {
        if (originType == null) {
            return;
        }
        originType.setParent(this);
        this.originType = originType;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public VariableExpressionWrapper clone() {
        return new VariableExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ClassNodeWrapper> astNodeWrappers = new ArrayList<ClassNodeWrapper>();
        astNodeWrappers.add(this.originType);
        return astNodeWrappers;
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof VariableExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyVariableProperties((VariableExpressionWrapper)input);
        return true;
    }

    @Override
    public Class<?> resolveType(ClassLoader classLoader) {
        String potentialClassName = this.getText();
        Class<?> loaded = this.loadClassQuietly(potentialClassName, classLoader);
        if (loaded != null) {
            return loaded;
        }
        Class<?> defaultClass = super.resolveType(classLoader);
        ImportNodeCollection importNodeCollection = this.getScriptClass().getImportNodeCollection();
        if (importNodeCollection == null || !importNodeCollection.isImported(potentialClassName)) {
            return defaultClass;
        }
        return this.loadClassQuietly(importNodeCollection.getQualifierForAlias(potentialClassName), classLoader);
    }
}

