/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.model;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.operation.AbstractCompositeOperation;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.ast.dialogs.MethodObjectBuilderDialog;
import com.kms.katalon.composer.testcase.ast.treetable.AstAbstractKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstMethodTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstScriptTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.TreeTableMenuItemConstants;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.FieldNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.AssertStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BreakStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CaseStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexChildStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexLastStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ContinueStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.DefaultStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ElseIfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ElseStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.EmptyStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.FinallyStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ForStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.IfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ReturnStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SwitchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ThrowStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.TryCatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.WhileStatementWrapper;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.testcase.providers.AstTestScriptGeneratorProvider;
import com.kms.katalon.composer.testcase.treetable.transfer.ScriptTransfer;
import com.kms.katalon.composer.testcase.treetable.transfer.ScriptTransferData;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.setting.TestCaseSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TestCaseTreeTableInput {
    private static final String OPERATION_LABEL_DRAG_AND_DROP_AST_NODES = "dragAndDropAstNodes";
    private static final String GROOVY_NEW_LINE_CHARACTER = "\n";
    private static final String WEB_SERVICE_KEYWORDS_CLASS_ALIAS_NAME = "WS";
    private TreeViewer treeTableViewer;
    private ScriptNodeWrapper mainClassNodeWrapper;
    private AstScriptTreeTableNode mainClassTreeNode;
    private ITestCasePart parentPart;
    private boolean isChanged;
    private IUndoContext undoContext;
    private IOperationHistory operationHistory;
    ArrayList<MethodCallExpressionWrapper> recordedElements = null;

    public ScriptNodeWrapper getMainClassNode() {
        return this.mainClassNodeWrapper;
    }

    public TestCaseTreeTableInput(ScriptNodeWrapper scriptNode, TreeViewer treeTableViewer, ITestCasePart parentPart) {
        this.treeTableViewer = treeTableViewer;
        this.mainClassNodeWrapper = scriptNode;
        this.parentPart = parentPart;
        this.undoContext = new ObjectUndoContext((Object)parentPart);
        this.setChanged(false);
    }

    public AstTreeTableNode getSelectedNode() {
        if (this.treeTableViewer.getSelection() instanceof ITreeSelection && ((ITreeSelection)this.treeTableViewer.getSelection()).getFirstElement() instanceof AstTreeTableNode) {
            return (AstTreeTableNode)((ITreeSelection)this.treeTableViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    public List<AstTreeTableNode> getSelectedNodes() {
        if (!(this.treeTableViewer.getSelection() instanceof ITreeSelection) || ((ITreeSelection)this.treeTableViewer.getSelection()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AstTreeTableNode> selectedNodes = new ArrayList<AstTreeTableNode>();
        Object[] selectedObjects = ((ITreeSelection)this.treeTableViewer.getSelection()).toArray();
        int i = 0;
        while (i < selectedObjects.length) {
            if (selectedObjects[i] instanceof AstTreeTableNode) {
                selectedNodes.add((AstTreeTableNode)selectedObjects[i]);
            }
            ++i;
        }
        return selectedNodes;
    }

    public List<ASTNodeWrapper> getSelectedNodeWrappers() {
        ArrayList<ASTNodeWrapper> selectedNodeWrappers = new ArrayList<ASTNodeWrapper>();
        for (AstTreeTableNode node : this.getSelectedNodes()) {
            selectedNodeWrappers.add(node.getASTObject());
        }
        return selectedNodeWrappers;
    }

    private int[] getIndex(AstTreeTableNode node) {
        AstTreeTableNode parent = node.getParent();
        int index = parent.getChildren().indexOf(node);
        if (parent.getParent() == null) {
            return new int[]{index};
        }
        return ArrayUtils.add((int[])this.getIndex(node.getParent()), (int)index);
    }

    public List<ASTNodeWrapper> getNodeWrappersFromFirstSelected() {
        int[] selectedIndices = this.getIndex(this.getSelectedNode());
        int fisrtSelected = selectedIndices[0];
        return this.mainClassNodeWrapper.getBlock().getAstChildren().stream().skip(fisrtSelected).collect(Collectors.toList());
    }

    public void setRecordedElements(ArrayList<MethodCallExpressionWrapper> recordedElements) {
        this.recordedElements = recordedElements;
    }

    public ArrayList<MethodCallExpressionWrapper> getRecordedElements() {
        return this.recordedElements;
    }

    public boolean addNewAstObject(ASTNodeWrapper astObject, AstTreeTableNode destinationNode, NodeAddType addType) {
        ArrayList<ASTNodeWrapper> astObjects = new ArrayList<ASTNodeWrapper>();
        astObjects.add(astObject);
        return this.addNewAstObjects(astObjects, destinationNode, addType);
    }

    public boolean addNewAstObjects(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode destinationNode, NodeAddType addType) {
        IStatus status = this.executeOperation((IUndoableOperation)new AddAstObjectsOperation(astObjects, destinationNode, addType));
        return status == Status.OK_STATUS;
    }

    private boolean internalAddNewAstObjects(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode destinationNode, NodeAddType addType, boolean setEdit) {
        ArrayList<AstNodeAddedEdit> astNodeAddedEdits = new ArrayList<AstNodeAddedEdit>();
        if (destinationNode == null) {
            astNodeAddedEdits.addAll(this.addAstObjects(astObjects, this.mainClassTreeNode));
        } else if (addType == NodeAddType.Add) {
            if (destinationNode.canHaveChildren()) {
                astNodeAddedEdits.addAll(this.addAstObjects(astObjects, destinationNode));
            } else {
                astNodeAddedEdits.addAll(this.insertASTObjects(astObjects, destinationNode, NodeAddType.InserAfter));
            }
        } else {
            astNodeAddedEdits.addAll(this.insertASTObjects(astObjects, destinationNode, addType));
        }
        if (!astNodeAddedEdits.isEmpty()) {
            this.processAfterEdits(astNodeAddedEdits, setEdit, true);
            return true;
        }
        return false;
    }

    private void processAfterEdits(List<AstNodeAddedEdit> astNodeAddedEdits, boolean setEdit, boolean multiSelect) {
        ArrayList<AstTreeTableNode> needRefreshNodes = new ArrayList<AstTreeTableNode>();
        for (AstNodeAddedEdit astNodeAddedEdit : astNodeAddedEdits) {
            needRefreshNodes.add(astNodeAddedEdit.getParentNode());
        }
        this.filterRelatedNodeList(needRefreshNodes);
        if (needRefreshNodes.isEmpty()) {
            return;
        }
        this.setDirty(true);
        for (AstTreeTableNode needRefreshNode : needRefreshNodes) {
            this.refreshTree(needRefreshNode);
        }
        AstNodeAddedEdit lastEdit = astNodeAddedEdits.get(astNodeAddedEdits.size() - 1);
        ASTNodeWrapper newAstObject = lastEdit.getNewAstObject();
        if (newAstObject == null) {
            return;
        }
        if (!multiSelect) {
            this.setSelection(lastEdit.getParentNode(), newAstObject);
        } else {
            ArrayList<AstTreeTableNode> selectedTreeTableNodes = new ArrayList<AstTreeTableNode>();
            for (AstNodeAddedEdit astNodeAddedEdit : astNodeAddedEdits) {
                selectedTreeTableNodes.add(this.getTreeTableNodeOfAstObjectFromParentNode(astNodeAddedEdit.getParentNode(), astNodeAddedEdit.getNewAstObject()));
            }
            this.setSelection(selectedTreeTableNodes);
        }
        if (setEdit) {
            this.setEdit(lastEdit.getParentNode(), newAstObject);
        }
    }

    private List<AstNodeAddedEdit> insertASTObjects(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode selectedTreeTableNode, NodeAddType addType) {
        if (astObjects == null || astObjects.isEmpty() || selectedTreeTableNode == null) {
            return Collections.emptyList();
        }
        ArrayList<AstNodeAddedEdit> astNodeAddedEdits = new ArrayList<AstNodeAddedEdit>();
        if (addType == NodeAddType.InserAfter) {
            astObjects = new ArrayList<ASTNodeWrapper>(astObjects);
            Collections.reverse(astObjects);
        }
        for (ASTNodeWrapper aSTNodeWrapper : astObjects) {
            AstNodeAddedEdit astNodeAddedEdit = this.insertAstObject(aSTNodeWrapper, selectedTreeTableNode, addType);
            if (astNodeAddedEdit == null) continue;
            astNodeAddedEdits.add(astNodeAddedEdit);
        }
        return astNodeAddedEdits;
    }

    private AstNodeAddedEdit insertAstObject(ASTNodeWrapper astObject, AstTreeTableNode sibblingNode, NodeAddType addType) {
        if (sibblingNode == null || sibblingNode.getASTObject() == null || sibblingNode.getParent() == null) {
            return null;
        }
        int sibblingIndex = this.getAstObjectIndex(sibblingNode);
        if (sibblingIndex == -1) {
            return null;
        }
        int newIndex = sibblingIndex + (addType == NodeAddType.InserAfter ? 1 : 0);
        ASTNodeWrapper parentAstNode = sibblingNode.getASTObject().getParent();
        if (parentAstNode.isChildAssignble(astObject) && parentAstNode.addChild(astObject, newIndex)) {
            return new AstNodeAddedEdit(sibblingNode.getParent(), astObject);
        }
        return null;
    }

    private AstNodeAddedEdit addAstObject(ASTNodeWrapper astObject, AstTreeTableNode parentNode) {
        if (parentNode == null) {
            return null;
        }
        if (parentNode.isChildAssignble(astObject) && parentNode.addChild(astObject)) {
            if (this.isComplexStatementOnTheSameLevel(astObject)) {
                parentNode = parentNode.getParent();
            }
            return new AstNodeAddedEdit(parentNode, astObject);
        }
        return null;
    }

    private List<AstNodeAddedEdit> addAstObjects(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode parentNode) {
        if (parentNode == null) {
            return null;
        }
        ArrayList<AstNodeAddedEdit> astNodeAddedEdits = new ArrayList<AstNodeAddedEdit>();
        for (ASTNodeWrapper aSTNodeWrapper : astObjects) {
            AstNodeAddedEdit astNodeAddedEdit = this.addAstObject(aSTNodeWrapper, parentNode);
            if (astNodeAddedEdit == null) continue;
            astNodeAddedEdits.add(astNodeAddedEdit);
        }
        return astNodeAddedEdits;
    }

    private AstTreeTableNode getTreeTableNodeOfAstObjectFromParentNode(AstTreeTableNode parentNode, ASTNodeWrapper astObject) {
        if (astObject == null) {
            return null;
        }
        for (AstTreeTableNode astNode : parentNode.getChildren()) {
            if (!astNode.getASTObject().equals(astObject)) continue;
            return astNode;
        }
        return null;
    }

    private boolean isComplexStatementOnTheSameLevel(ASTNodeWrapper newAstObject) {
        return newAstObject instanceof ElseStatementWrapper || newAstObject instanceof ElseIfStatementWrapper || newAstObject instanceof CatchStatementWrapper || newAstObject instanceof FinallyStatementWrapper;
    }

    private void setSelection(AstTreeTableNode parentNode, ASTNodeWrapper astObject) {
        if (parentNode != null) {
            this.treeTableViewer.setExpandedState((Object)parentNode, true);
        }
        this.setSelection(this.getTreeTableNodeOfAstObjectFromParentNode(parentNode, astObject));
    }

    private void setSelection(AstTreeTableNode treeTableNode) {
        if (treeTableNode == null) {
            return;
        }
        this.treeTableViewer.setSelection((ISelection)new StructuredSelection((Object)treeTableNode));
    }

    private void setSelection(List<AstTreeTableNode> treeTableNodes) {
        if (treeTableNodes == null || treeTableNodes.isEmpty()) {
            return;
        }
        this.treeTableViewer.setSelection((ISelection)new StructuredSelection(treeTableNodes));
    }

    private void setEdit(AstTreeTableNode parentNode, ASTNodeWrapper astObject) {
        this.setEdit(this.getTreeTableNodeOfAstObjectFromParentNode(parentNode, astObject));
    }

    private void setEdit(AstTreeTableNode treeTableNode) {
        if (treeTableNode == null) {
            return;
        }
        this.setFocus(treeTableNode);
        this.treeTableViewer.editElement((Object)treeTableNode, 0);
    }

    private void setFocus(AstTreeTableNode treeTableNode) {
        Tree tree = this.treeTableViewer.getTree();
        this.ensureTreeGotTopItem(treeTableNode, tree);
        tree.setFocus();
    }

    private void ensureTreeGotTopItem(AstTreeTableNode treeTableNode, Tree tree) {
        if (tree.getTopItem() != null) {
            return;
        }
        TreeItem treeItem = new TreeItem(tree, 0);
        treeItem.setData((Object)treeTableNode);
        tree.setTopItem(treeItem);
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(Object object) {
        AstTreeTableNode topItem = this.getTopItem();
        Object[] expandedElements = this.saveExpandedState();
        this.refreshObjectWithoutReloading(object);
        this.reloadExpandedState(expandedElements);
        this.setTopItem(topItem);
    }

    private void refreshObjectWithoutReloading(Object object) {
        if (object == null || object instanceof AstScriptTreeTableNode) {
            try {
                this.reloadTreeTableNodes();
            }
            catch (InterruptedException | InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            return;
        }
        this.refreshTree(object);
    }

    private void refreshTree(Object object) {
        if (object instanceof AstScriptTreeTableNode) {
            this.treeTableViewer.refresh();
            return;
        }
        this.treeTableViewer.refresh(object);
        if (!(object instanceof AstTreeTableNode)) {
            return;
        }
        AstTreeTableNode treeTableNode = (AstTreeTableNode)object;
        if (treeTableNode.canHaveChildren()) {
            treeTableNode.reloadChildren();
        }
    }

    public void reloadTreeTableNodes() throws InvocationTargetException, InterruptedException {
        ArrayList<AstScriptTreeTableNode> astTreeTableNodes = new ArrayList<AstScriptTreeTableNode>();
        this.mainClassTreeNode = new AstScriptTreeTableNode(this.mainClassNodeWrapper, null);
        astTreeTableNodes.add(this.mainClassTreeNode);
        this.reloadTestCaseVariables(this.parentPart.getVariables());
        this.treeTableViewer.setInput(astTreeTableNodes);
    }

    private void reloadExpandedState(Object[] expandedElements) {
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.treeTableViewer.setExpandedState(element, true);
            ++n2;
        }
        this.treeTableViewer.getControl().setRedraw(true);
    }

    private Object[] saveExpandedState() {
        this.treeTableViewer.getControl().setRedraw(false);
        Object[] expandedElements = this.treeTableViewer.getExpandedElements();
        return expandedElements;
    }

    public void reloadTestCaseVariables(VariableEntity[] variables) {
        this.mainClassNodeWrapper.clearFields();
        VariableEntity[] variableEntityArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            VariableEntity variable = variableEntityArray[n2];
            FieldNodeWrapper field = new FieldNodeWrapper(variable.getName(), Object.class, this.mainClassNodeWrapper);
            ExpressionWrapper expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(variable.getDefaultValue());
            if (expression != null) {
                expression.setParent(field);
                field.setInitialValueExpression(expression);
            }
            this.mainClassNodeWrapper.addField(field);
            ++n2;
        }
    }

    public void removeSelectedRows() {
        this.removeRows(this.getSelectedNodes());
    }

    public void clearRows() {
        this.mainClassTreeNode.getChildren().clear();
        if (OSUtil.isMacBigSurOrLater()) {
            this.treeTableViewer.getTree().redraw();
        }
    }

    public void removeRows(List<AstTreeTableNode> treeTableNodes) {
        this.executeOperation((IUndoableOperation)new RemoveAstTreeTableNodesOperation(treeTableNodes));
        if (OSUtil.isMacBigSurOrLater()) {
            this.treeTableViewer.getTree().redraw();
        }
    }

    private void processAfterRemove(List<AstTreeTableNode> refreshNodeList) {
        this.filterRelatedNodeList(refreshNodeList);
        if (refreshNodeList.isEmpty()) {
            return;
        }
        this.setDirty(true);
        for (AstTreeTableNode treeTableNode : refreshNodeList) {
            this.refreshObjectWithoutReloading(treeTableNode);
        }
    }

    private void filterRelatedNodeList(List<AstTreeTableNode> treeTableNodes) {
        if (treeTableNodes == null || treeTableNodes.isEmpty()) {
            return;
        }
        int count = 0;
        while (count < treeTableNodes.size() - 1) {
            boolean foundFlag = false;
            AstTreeTableNode astTreeTableNode = treeTableNodes.get(count);
            if (astTreeTableNode == null) {
                ++count;
                continue;
            }
            int index = 0;
            while (index < treeTableNodes.size()) {
                AstTreeTableNode otherAstTreeTableNode;
                if (count != index && (otherAstTreeTableNode = treeTableNodes.get(index)) != null && (astTreeTableNode.equals(otherAstTreeTableNode) || otherAstTreeTableNode.isDescendantNode(astTreeTableNode))) {
                    treeTableNodes.remove(count);
                    foundFlag = true;
                    break;
                }
                ++index;
            }
            if (foundFlag) continue;
            ++count;
        }
    }

    private void setTopItem(AstTreeTableNode treeTableNode) {
        if (treeTableNode == null) {
            return;
        }
        this.setTopItem(treeTableNode, this.treeTableViewer.getTree().getItems());
    }

    private boolean setTopItem(AstTreeTableNode treeTableNode, TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getData() != null && treeItem.getData().equals(treeTableNode)) {
                this.treeTableViewer.getTree().setTopItem(treeItem);
                return true;
            }
            if (this.setTopItem(treeTableNode, treeItem.getItems())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AstTreeTableNode getTopItem() {
        if (this.treeTableViewer == null) {
            return null;
        }
        TreeItem topItem = this.treeTableViewer.getTree().getTopItem();
        if (topItem != null && topItem.getData() instanceof AstTreeTableNode) {
            return (AstTreeTableNode)topItem.getData();
        }
        return null;
    }

    public void setDirty(boolean isDirty) {
        this.parentPart.setDirty(isDirty);
        this.setChanged(isDirty);
    }

    public void moveUp() {
        this.move(-1);
    }

    public void moveDown() {
        this.move(2);
    }

    private void move(int offset) {
        AstTreeTableNode selectedNode = this.getSelectedNode();
        if (Objects.nonNull(selectedNode)) {
            this.move(offset, selectedNode);
        }
    }

    private void move(int offset, AstTreeTableNode selectedNode) {
        this.executeOperation((IUndoableOperation)new MoveNodeOperation(selectedNode, offset));
    }

    private boolean isUnmoveableAstNode(AstTreeTableNode selectedNode) {
        return selectedNode == null || selectedNode.getASTObject() instanceof ComplexLastStatementWrapper;
    }

    public void updateMethod(MethodNodeWrapper oldMethod, MethodNodeWrapper newMethod) {
        if (this.mainClassNodeWrapper.setMethod(newMethod, this.mainClassNodeWrapper.indexOfMethod(oldMethod))) {
            this.setDirty(true);
            this.refresh();
            this.setSelection(this.mainClassTreeNode, newMethod);
        }
    }

    private int getAstObjectIndex(AstTreeTableNode node) {
        if (node == null || node.getASTObject() == null || node.getASTObject().getParent() == null) {
            return -1;
        }
        ASTNodeWrapper childNode = node.getASTObject();
        return childNode.getParent().indexOf(childNode);
    }

    public void changeFailureHandling(FailureHandling failureHandling) {
        this.changeFailureHandling(failureHandling, this.getSelectedNodes());
    }

    private void changeFailureHandling(FailureHandling failureHandling, List<AstTreeTableNode> treeTableNodes) {
        this.executeOperation((IUndoableOperation)new ChangeFailureHandlingOperation(failureHandling, treeTableNodes));
    }

    private GroovyWrapperParser getGroovyParser(ASTNodeWrapper astObject) {
        GroovyWrapperParser groovyParser = new GroovyWrapperParser(new StringBuilder());
        groovyParser.parse(astObject);
        return groovyParser;
    }

    public void copy(List<AstTreeTableNode> copyNodes) {
        this.collectMarkedRowAndSetToClipboard(copyNodes);
    }

    public void cut(List<AstTreeTableNode> cutNodes) {
        List<AstTreeTableNode> rowsToBeRemoved = this.collectMarkedRowAndSetToClipboard(cutNodes);
        this.removeRows(rowsToBeRemoved);
    }

    private List<AstTreeTableNode> collectMarkedRowAndSetToClipboard(List<AstTreeTableNode> markedRows) {
        ArrayList<AstTreeTableNode> rowsToBeRemoved = new ArrayList<AstTreeTableNode>();
        StringBuilder scriptSnippets = new StringBuilder();
        ArrayList<MethodCallExpressionWrapper> recordedElements = new ArrayList<MethodCallExpressionWrapper>();
        for (AstTreeTableNode astTreeTableNode : markedRows) {
            if (!TestCaseTreeTableInput.isNodeMoveable(astTreeTableNode)) continue;
            GroovyWrapperParser groovyParser = this.getGroovyParser(astTreeTableNode.getASTObject());
            scriptSnippets.append(groovyParser.getValue());
            scriptSnippets.append(GROOVY_NEW_LINE_CHARACTER);
            rowsToBeRemoved.add(astTreeTableNode);
            recordedElements.addAll(groovyParser.getRecordedElements());
        }
        this.setRecordedElements(recordedElements);
        if (scriptSnippets.length() == 0) {
            return rowsToBeRemoved;
        }
        Clipboard cb = new Clipboard(Display.getCurrent());
        ScriptTransferData transferData = new ScriptTransferData(scriptSnippets.toString(), this.parentPart.getTestCase().getId());
        cb.setContents(new Object[]{new ScriptTransferData[]{transferData}}, new Transfer[]{new ScriptTransfer()});
        return rowsToBeRemoved;
    }

    private String getTestCaseId() {
        TestCaseEntity testCase = this.parentPart.getTestCase();
        if (testCase != null) {
            return testCase.getId();
        }
        return this.mainClassNodeWrapper.getTestCaseId();
    }

    public static boolean isNodeMoveable(AstTreeTableNode astTreeTableNode) {
        return !(astTreeTableNode.getASTObject() instanceof ComplexLastStatementWrapper) && !(astTreeTableNode.getASTObject() instanceof ComplexChildStatementWrapper);
    }

    public boolean canPaste() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Object data = clipboard.getContents((Transfer)new ScriptTransfer());
        if (data == null) {
            return false;
        }
        String snippet = null;
        if (data instanceof String) {
            snippet = (String)data;
        } else if (data instanceof ScriptTransferData[]) {
            snippet = ((ScriptTransferData[])data)[0].getScriptSnippet();
        }
        try {
            ScriptNodeWrapper scriptNode = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(snippet);
            return scriptNode != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void paste(AstTreeTableNode destinationNode, NodeAddType addType) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Object data = clipboard.getContents((Transfer)new ScriptTransfer());
        String snippet = null;
        if (data instanceof String) {
            snippet = (String)data;
        } else if (data instanceof ScriptTransferData[]) {
            snippet = ((ScriptTransferData[])data)[0].getScriptSnippet();
        }
        try {
            ScriptNodeWrapper scriptNode = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(snippet);
            if (scriptNode == null) {
                return;
            }
            ArrayList<StatementWrapper> steps = new ArrayList<StatementWrapper>(scriptNode.getBlock().getStatements());
            this.replaceArgumentsWithRecordedElements(steps, this.getRecordedElements());
            this.addNewAstObjects(steps, destinationNode, addType);
        }
        catch (GroovyParsingException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void replaceArgumentsWithRecordedElements(List<StatementWrapper> steps, ArrayList<MethodCallExpressionWrapper> recordedElements) throws Exception {
        int elementIdx = 0;
        for (StatementWrapper step : steps) {
            if (step.getAstChildren() == null || step.getAstChildren().size() <= 0 || !(step.getAstChildren().get(0) instanceof MethodCallExpressionWrapper)) continue;
            MethodCallExpressionWrapper keyword = (MethodCallExpressionWrapper)step.getAstChildren().get(0);
            int numArguments = keyword.getArguments().getExpressions().size();
            int i = 0;
            while (i < numArguments) {
                ExpressionWrapper argument = keyword.getArguments().getExpressions().get(i);
                if (argument instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)argument).getMethodAsString().equals("findTestObject") && recordedElements != null) {
                    keyword.getArguments().setExpression(recordedElements.get(elementIdx), i);
                    ++elementIdx;
                }
                ++i;
            }
        }
    }

    public void disable() {
        this.disable(this.getSelectedNodes());
    }

    public void disable(List<AstTreeTableNode> treeTableNodes) {
        this.toogleDisabledMode(treeTableNodes, true);
    }

    public void enable() {
        this.enable(this.getSelectedNodes());
    }

    public void enable(List<AstTreeTableNode> treeTableNodes) {
        this.toogleDisabledMode(treeTableNodes, false);
    }

    private void toogleDisabledMode(List<AstTreeTableNode> treeTableNodes, boolean isDisableMode) {
        this.executeOperation((IUndoableOperation)new ToogleDisableStepsOperation(treeTableNodes, isDisableMode));
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public void addNewAstObject(int astObjectId, AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addDefaultImports();
        switch (astObjectId) {
            case 32: {
                this.addNewCustomKeyword(destinationNode, addType);
                break;
            }
            case 1: {
                this.addNewIfStatement(destinationNode, addType);
                break;
            }
            case 2: {
                this.addNewElseStatement(destinationNode, addType);
                break;
            }
            case 3: {
                this.addNewElseIfStatement(destinationNode, addType);
                break;
            }
            case 4: {
                this.addNewWhileStatement(destinationNode, addType);
                break;
            }
            case 5: {
                this.addNewForStatement(destinationNode, addType);
                break;
            }
            case 6: {
                this.addNewBinaryStatement(destinationNode, addType);
                break;
            }
            case 7: {
                this.addNewAssertStatement(destinationNode, addType);
                break;
            }
            case 8: {
                this.addNewMethodCall(destinationNode, addType);
                break;
            }
            case 9: {
                this.addNewBreakStatement(destinationNode, addType);
                break;
            }
            case 10: {
                this.addNewContinueStatement(destinationNode, addType);
                break;
            }
            case 11: {
                this.addNewReturnStatement(destinationNode, addType);
                break;
            }
            case 12: {
                this.addNewSwitchStatement(destinationNode, addType);
                break;
            }
            case 13: {
                this.addNewCaseStatement(destinationNode, addType);
                break;
            }
            case 14: {
                this.addNewDefaultStatement(destinationNode, addType);
                break;
            }
            case 15: {
                this.addNewTryStatement(destinationNode, addType);
                break;
            }
            case 16: {
                this.addNewCatchStatement(destinationNode, addType);
                break;
            }
            case 17: {
                this.addNewFinallyStatement(destinationNode, addType);
                break;
            }
            case 18: {
                this.addNewThrowStatement(destinationNode, addType);
                break;
            }
            case 72: {
                if (this.parentPart instanceof TestCasePart) {
                    this.addNewMethod(destinationNode, addType);
                    break;
                }
                MessageDialog.openWarning(null, (String)GlobalMessageConstants.WARN, (String)ComposerTestcaseMessageConstants.DIA_WARNING_METHOD_IN_CLOSURE);
                break;
            }
            case 70: {
                this.addCallTestCases(destinationNode, addType);
                break;
            }
            default: {
                if (!TreeTableMenuItemConstants.isBuildInKeywordID(astObjectId)) break;
                this.addNewBuiltInKeyword(destinationNode, addType, TreeTableMenuItemConstants.getContributingClassName(astObjectId));
            }
        }
        if (OSUtil.isMacBigSurOrLater() && this.treeTableViewer != null) {
            this.treeTableViewer.getTree().redraw();
        }
    }

    public boolean validateTestCase(TestCaseEntity calledTestCase) {
        if (calledTestCase == null) {
            return false;
        }
        if (StringUtils.equals((String)this.getTestCaseId(), (String)calledTestCase.getId()) || StringUtils.equals((String)this.getTestCaseId(), (String)calledTestCase.getRelativePathForUI())) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_TEST_CASE_CANNOT_CALL_ITSELF);
            return false;
        }
        return true;
    }

    public void addCallTestCases(AstTreeTableNode destinationNode, NodeAddType addType) {
        if (ProjectController.getInstance().getCurrentProject() == null) {
            return;
        }
        try {
            this.addCallTestCases(destinationNode, addType, this.collectCalledTestCases());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_UNABLE_TO_CALL_TEST_CASE);
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void addCallTestCases(AstTreeTableNode destinationNode, NodeAddType addType, TestCaseEntity[] testCaseArray) {
        if (testCaseArray == null || testCaseArray.length <= 0) {
            return;
        }
        ArrayList<ExpressionStatementWrapper> statementsToAdd = new ArrayList<ExpressionStatementWrapper>();
        ArrayList<VariableEntity> variablesToAdd = new ArrayList<VariableEntity>();
        ASTNodeWrapper parentNodeWrapper = this.getParentNodeForNewMethodCall(destinationNode);
        TestCaseEntity[] testCaseEntityArray = testCaseArray;
        int n = testCaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestCaseEntity testCase = testCaseEntityArray[n2];
            statementsToAdd.add(AstEntityInputUtil.generateCallTestCaseExpresionStatement(testCase, variablesToAdd, parentNodeWrapper));
            ++n2;
        }
        this.executeOperation((IUndoableOperation)new AddCallTestCaseStepsOperation(statementsToAdd, destinationNode, addType, variablesToAdd));
        Trackings.trackAddNewTestStep((String)"callTestCase");
    }

    private TestCaseEntity[] collectCalledTestCases() throws Exception {
        TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(new EntityProvider()));
        dialog.setAllowMultiple(false);
        dialog.setTitle(ComposerTestcaseMessageConstants.EDI_TITLE_TEST_CASE_BROWSER);
        dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject())));
        if (dialog.open() != 0) {
            return new TestCaseEntity[0];
        }
        Object[] selectedObjects = dialog.getResult();
        if (selectedObjects == null || selectedObjects.length == 0) {
            return new TestCaseEntity[0];
        }
        LinkedHashSet<TestCaseEntity> testCaseSet = new LinkedHashSet<TestCaseEntity>();
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof FolderTreeEntity || object instanceof TestCaseTreeEntity) {
                TestCaseEntity calledTestCase;
                ITreeEntity treeEntity = (ITreeEntity)object;
                if (treeEntity instanceof FolderTreeEntity) {
                    for (TestCaseEntity testCase : TestCaseEntityUtil.getTestCasesFromFolderTree((FolderTreeEntity)treeEntity)) {
                        if (!this.validateTestCase(testCase)) continue;
                        testCaseSet.add(testCase);
                    }
                } else if (treeEntity instanceof TestCaseTreeEntity && this.validateTestCase(calledTestCase = ((TestCaseTreeEntity)treeEntity).getObject())) {
                    testCaseSet.add(calledTestCase);
                }
            }
            ++n2;
        }
        return testCaseSet.toArray(new TestCaseEntity[testCaseSet.size()]);
    }

    public void addNewMethod(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.executeOperation((IUndoableOperation)new AddMethodOperation(addType, destinationNode));
    }

    public void addNewDefaultBuiltInKeyword(NodeAddType addType) {
        this.addNewAstObject(TreeTableMenuItemConstants.getMenuItemID(TestCasePreferenceDefaultValueInitializer.getDefaultKeywordType().getAliasName()), this.getSelectedNode(), addType);
    }

    public void addNewDefaultWebServiceKeyword(NodeAddType addType) {
        this.addNewAstObject(TreeTableMenuItemConstants.getMenuItemID(WEB_SERVICE_KEYWORDS_CLASS_ALIAS_NAME), this.getSelectedNode(), addType);
    }

    private void addNewBuiltInKeyword(AstTreeTableNode destinationNode, NodeAddType addType, String className) {
        this.addNewBuiltInKeyword(destinationNode, addType, KeywordController.getInstance().getBuiltInKeywordClassByName(className));
        Trackings.trackAddNewTestStep((String)className);
    }

    private void addNewBuiltInKeyword(AstTreeTableNode destinationNode, NodeAddType addType, KeywordClass keywordClass) {
        if (keywordClass == null) {
            return;
        }
        String defaultSettingKeywordName = TestCasePreferenceDefaultValueInitializer.getDefaultKeywords().get(keywordClass.getName());
        ExpressionStatementWrapper newBuiltinKeywordStatement = null;
        ASTNodeWrapper parentNodeWrapper = this.getParentNodeForNewMethodCall(destinationNode);
        if (StringUtils.isNotBlank((String)defaultSettingKeywordName) && KeywordController.getInstance().getBuiltInKeywordByName(keywordClass.getName(), defaultSettingKeywordName, null) != null) {
            MethodCallExpressionWrapper keywordMethodCallExpression = new MethodCallExpressionWrapper(keywordClass.getAliasName(), defaultSettingKeywordName, parentNodeWrapper);
            AstKeywordsInputUtil.generateMethodCallArguments(keywordMethodCallExpression, KeywordController.getInstance().getBuiltInKeywordByName(keywordClass.getName(), defaultSettingKeywordName, null));
            newBuiltinKeywordStatement = new ExpressionStatementWrapper(keywordMethodCallExpression, null);
        } else {
            newBuiltinKeywordStatement = AstKeywordsInputUtil.createBuiltInKeywordStatement(keywordClass.getAliasName(), ((KeywordMethod)KeywordController.getInstance().getBuiltInKeywords(keywordClass.getName(), true).get(0)).getName(), parentNodeWrapper);
        }
        this.addNewAstObject(newBuiltinKeywordStatement, destinationNode, addType);
    }

    public void addDefaultImports() {
        this.mainClassNodeWrapper.addDefaultImports();
    }

    public void addImports(List<ImportNodeWrapper> imports) {
        this.mainClassNodeWrapper.addImportNodes(imports);
    }

    public void addNewCustomKeyword(AstTreeTableNode destinationNode, NodeAddType addType) {
        ASTNodeWrapper parentNodeWrapper = this.getParentNodeForNewMethodCall(destinationNode);
        ExpressionStatementWrapper customKeywordStatement = AstKeywordsInputUtil.createNewCustomKeywordStatement(parentNodeWrapper);
        if (customKeywordStatement == null) {
            MessageDialog.openWarning(null, (String)GlobalMessageConstants.WARN, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_NO_CUSTOM_KEYWORD);
            return;
        }
        this.addNewAstObject(customKeywordStatement, destinationNode, addType);
        Trackings.trackAddNewTestStep((String)"custom");
    }

    public ASTNodeWrapper getParentNodeForNewMethodCall(AstTreeTableNode destinationNode) {
        return destinationNode != null ? destinationNode.getASTObject() : this.mainClassNodeWrapper;
    }

    private void addNewThrowStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new ThrowStatementWrapper(), destinationNode, addType);
    }

    public void addNewIfStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new IfStatementWrapper(), destinationNode, addType);
    }

    public void addNewElseStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new ElseStatementWrapper(), destinationNode, addType);
    }

    public void addNewElseIfStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new ElseIfStatementWrapper(), destinationNode, addType);
    }

    public void addNewWhileStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new WhileStatementWrapper(), destinationNode, addType);
    }

    public void addNewForStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new ForStatementWrapper(), destinationNode, addType);
    }

    public void addNewBinaryStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new ExpressionStatementWrapper(new BinaryExpressionWrapper()), destinationNode, addType);
    }

    public void addNewAssertStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new AssertStatementWrapper(), destinationNode, addType);
    }

    public void addNewMethodCall(AstTreeTableNode destinationNode, NodeAddType addType) {
        ASTNodeWrapper parentNodeWrapper = this.getParentNodeForNewMethodCall(destinationNode);
        this.addNewAstObject(new ExpressionStatementWrapper(new MethodCallExpressionWrapper(parentNodeWrapper)), destinationNode, addType);
    }

    public void addNewBreakStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new BreakStatementWrapper(), destinationNode, addType);
    }

    public void addNewContinueStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new ContinueStatementWrapper(), destinationNode, addType);
    }

    public void addNewReturnStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new ReturnStatementWrapper(), destinationNode, addType);
    }

    public void addNewSwitchStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new SwitchStatementWrapper(), destinationNode, addType);
    }

    public void addNewCaseStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new CaseStatementWrapper(), destinationNode, addType);
    }

    public void addNewDefaultStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new DefaultStatementWrapper(), destinationNode, addType);
    }

    public void addNewTryStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new TryCatchStatementWrapper(), destinationNode, addType);
    }

    public void addNewCatchStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new CatchStatementWrapper(), destinationNode, addType);
    }

    public void addNewFinallyStatement(AstTreeTableNode destinationNode, NodeAddType addType) {
        this.addNewAstObject(new FinallyStatementWrapper(), destinationNode, addType);
    }

    public void dragAndDropAstObjects(List<AstTreeTableNode> draggedNodes, List<StatementWrapper> droppedNodes, AstTreeTableNode destinationNode, NodeAddType addType) {
        AbstractCompositeOperation dragAndDropOperation = new AbstractCompositeOperation(OPERATION_LABEL_DRAG_AND_DROP_AST_NODES);
        dragAndDropOperation.add((IUndoableOperation)new AddAstObjectsOperation(droppedNodes, destinationNode, addType));
        dragAndDropOperation.add((IUndoableOperation)new RemoveAstTreeTableNodesOperation(draggedNodes));
        this.executeOperation((IUndoableOperation)dragAndDropOperation);
    }

    public String generateRawScriptFromSelectedStep() {
        AstTreeTableNode selectedNode = this.getSelectedNode();
        if (selectedNode == null || !(selectedNode.getASTObject() instanceof StatementWrapper)) {
            return null;
        }
        return AstTestScriptGeneratorProvider.generateScriptForExecuteFromTestStep(this.mainClassNodeWrapper, (StatementWrapper)selectedNode.getASTObject());
    }

    private IOperationHistory getOperationHistory() {
        if (this.operationHistory == null) {
            this.operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        }
        return this.operationHistory;
    }

    public IStatus executeOperation(IUndoableOperation operation, IProgressMonitor progressMonitor, IAdaptable adaptable) {
        IOperationHistory operationHistory = this.getOperationHistory();
        try {
            operation.addContext(this.undoContext);
            return operationHistory.execute(operation, progressMonitor, adaptable);
        }
        catch (ExecutionException e) {
            LoggerSingleton.logError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus executeOperation(IUndoableOperation operation, IAdaptable adaptable) {
        return this.executeOperation(operation, (IProgressMonitor)new NullProgressMonitor(), adaptable);
    }

    public IStatus executeOperation(IUndoableOperation operation) {
        return this.executeOperation(operation, null);
    }

    private class AddAstObjectsOperation
    extends AbstractOperation {
        private List<? extends ASTNodeWrapper> astObjects;
        private AstTreeTableNode destinationNode;
        private NodeAddType addType;

        public AddAstObjectsOperation(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode destinationNode, NodeAddType addType) {
            super(AddAstObjectsOperation.class.getName());
            this.astObjects = astObjects;
            this.destinationNode = destinationNode;
            this.addType = addType;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.astObjects == null) {
                return Status.CANCEL_STATUS;
            }
            return this.doAddAstObjects(true);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doAddAstObjects(false);
        }

        protected IStatus doAddAstObjects(boolean doSetEdit) {
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            boolean addSuccessfully = TestCaseTreeTableInput.this.internalAddNewAstObjects(this.astObjects, this.destinationNode, this.addType, doSetEdit);
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            if (addSuccessfully) {
                TestCaseTreeTableInput.this.treeTableViewer.getTree().showSelection();
                if (OSUtil.isMacBigSurOrLater()) {
                    TestCaseTreeTableInput.this.treeTableViewer.getTree().redraw();
                }
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            boolean removeSuccessfully = this.internalRemoveAstObjects(this.astObjects, this.destinationNode, this.addType);
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            if (OSUtil.isMacBigSurOrLater() && TestCaseTreeTableInput.this.treeTableViewer != null) {
                TestCaseTreeTableInput.this.treeTableViewer.getTree().redraw();
            }
            if (removeSuccessfully) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        private boolean internalRemoveAstObjects(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode destinationNode, NodeAddType addType) {
            ArrayList<AstTreeTableNode> refreshNodeList = new ArrayList<AstTreeTableNode>();
            if (destinationNode == null) {
                refreshNodeList.addAll(this.removeChildObjectFromParentNode(astObjects, TestCaseTreeTableInput.this.mainClassTreeNode));
            } else if (addType == NodeAddType.Add) {
                if (destinationNode.canHaveChildren()) {
                    refreshNodeList.addAll(this.removeChildObjectFromParentNode(astObjects, destinationNode));
                } else {
                    refreshNodeList.addAll(this.removeChildObjectFromParentNode(astObjects, destinationNode.getParent()));
                }
            } else {
                refreshNodeList.addAll(this.removeChildObjectFromParentNode(astObjects, destinationNode.getParent()));
            }
            if (!refreshNodeList.isEmpty()) {
                TestCaseTreeTableInput.this.processAfterRemove(refreshNodeList);
                return true;
            }
            return false;
        }

        protected List<AstTreeTableNode> removeChildObjectFromParentNode(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode parentNode) {
            if (parentNode == null || astObjects == null || astObjects.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<AstTreeTableNode> refreshNodeList = new ArrayList<AstTreeTableNode>();
            for (ASTNodeWrapper aSTNodeWrapper : astObjects) {
                parentNode.removeChild(aSTNodeWrapper);
                refreshNodeList.add(parentNode);
            }
            return refreshNodeList;
        }
    }

    private class AddCallTestCaseStepsOperation
    extends AddAstObjectsOperation {
        private List<VariableEntity> variableList;

        public AddCallTestCaseStepsOperation(List<? extends ASTNodeWrapper> astObjects, AstTreeTableNode destinationNode, NodeAddType addType, List<VariableEntity> variableList) {
            super(astObjects, destinationNode, addType);
            this.variableList = variableList;
        }

        @Override
        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = super.execute(monitor, info);
            if (status == Status.CANCEL_STATUS || this.variableList.isEmpty()) {
                return status;
            }
            this.doAddVariables();
            return status;
        }

        protected void doAddVariables() {
            TestCaseTreeTableInput.this.parentPart.addVariables(this.variableList.toArray(new VariableEntity[this.variableList.size()]));
        }

        @Override
        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = super.redo(monitor, info);
            this.doAddVariables();
            return status;
        }

        @Override
        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = super.undo(monitor, info);
            TestCaseTreeTableInput.this.parentPart.deleteVariables(this.variableList);
            return status;
        }
    }

    private class AddMethodOperation
    extends AbstractOperation {
        private NodeAddType addType;
        private AstTreeTableNode destinationNode;
        private MethodNodeWrapper method;

        public AddMethodOperation(NodeAddType addType, AstTreeTableNode destinationNode) {
            super(AddMethodOperation.class.getName());
            this.addType = addType;
            this.destinationNode = destinationNode;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            MethodObjectBuilderDialog dialog = new MethodObjectBuilderDialog(Display.getCurrent().getActiveShell(), null, null);
            if (dialog.open() != 0 || dialog.getReturnValue() == null) {
                return Status.CANCEL_STATUS;
            }
            this.method = dialog.getReturnValue();
            this.doAddMethod(this.method);
            return Status.OK_STATUS;
        }

        public void doAddMethod(MethodNodeWrapper method) {
            int selectedMethodIndex = -1;
            if (this.destinationNode instanceof AstMethodTreeTableNode) {
                selectedMethodIndex = TestCaseTreeTableInput.this.mainClassNodeWrapper.indexOfMethod(((AstMethodTreeTableNode)this.destinationNode).getASTObject());
            }
            if (selectedMethodIndex == -1) {
                TestCaseTreeTableInput.this.mainClassNodeWrapper.addMethod(method);
            } else {
                if (this.addType == NodeAddType.Add || this.addType == NodeAddType.InserAfter) {
                    ++selectedMethodIndex;
                }
                TestCaseTreeTableInput.this.mainClassNodeWrapper.addMethod(method, selectedMethodIndex);
            }
            TestCaseTreeTableInput.this.setDirty(true);
            TestCaseTreeTableInput.this.refresh();
            TestCaseTreeTableInput.this.setSelection(TestCaseTreeTableInput.this.mainClassTreeNode, method);
            TestCaseTreeTableInput.this.setFocus(TestCaseTreeTableInput.this.getTreeTableNodeOfAstObjectFromParentNode(TestCaseTreeTableInput.this.mainClassTreeNode, method));
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doAddMethod(this.method);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            TestCaseTreeTableInput.this.mainClassNodeWrapper.removeChild(this.method);
            TestCaseTreeTableInput.this.setDirty(true);
            TestCaseTreeTableInput.this.refresh();
            return Status.OK_STATUS;
        }
    }

    private class AstNodeAddedEdit {
        private AstTreeTableNode parentNode;
        private ASTNodeWrapper newAstObject;

        public AstNodeAddedEdit(AstTreeTableNode parentNode, ASTNodeWrapper newAstObject) {
            this.parentNode = parentNode;
            this.newAstObject = newAstObject;
        }

        public AstTreeTableNode getParentNode() {
            return this.parentNode;
        }

        public ASTNodeWrapper getNewAstObject() {
            return this.newAstObject;
        }
    }

    private class ChangeFailureHandlingOperation
    extends AbstractOperation {
        private FailureHandling failureHandling;
        private List<AstTreeTableNode> treeTableNodes;
        private List<FailureChangeEdit> failureChangeEdits;

        public ChangeFailureHandlingOperation(FailureHandling failureHandling, List<AstTreeTableNode> treeTableNodes) {
            super(ChangeFailureHandlingOperation.class.getName());
            this.failureChangeEdits = new ArrayList<FailureChangeEdit>();
            this.failureHandling = failureHandling;
            this.treeTableNodes = treeTableNodes;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.failureHandling == null || this.treeTableNodes == null || this.treeTableNodes.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.failureChangeEdits.clear();
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            int i = this.treeTableNodes.size() - 1;
            while (i >= 0) {
                AstAbstractKeywordTreeTableNode keywordNode;
                FailureHandling failureHandlingValue;
                if (this.treeTableNodes.get(i) instanceof AstAbstractKeywordTreeTableNode && !this.failureHandling.equals((Object)(failureHandlingValue = (keywordNode = (AstAbstractKeywordTreeTableNode)this.treeTableNodes.get(i)).getFailureHandlingValue())) && keywordNode.setFailureHandlingValue(this.failureHandling)) {
                    this.failureChangeEdits.add(new FailureChangeEdit(keywordNode, failureHandlingValue));
                    TestCaseTreeTableInput.this.treeTableViewer.update((Object)keywordNode, null);
                    TestCaseTreeTableInput.this.setDirty(true);
                }
                --i;
            }
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            for (FailureChangeEdit failureChangeEdit : this.failureChangeEdits) {
                AstAbstractKeywordTreeTableNode treeTableNode = failureChangeEdit.getTreeTableNode();
                FailureHandling oldFailureHandling = failureChangeEdit.getOldFailureHandling();
                if (oldFailureHandling == null) {
                    oldFailureHandling = this.getDefaultFailureHandling();
                }
                treeTableNode.setFailureHandlingValue(oldFailureHandling);
                TestCaseTreeTableInput.this.treeTableViewer.update((Object)treeTableNode, null);
                TestCaseTreeTableInput.this.setDirty(true);
            }
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            return Status.OK_STATUS;
        }

        private FailureHandling getDefaultFailureHandling() {
            return new TestCaseSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation()).getDefaultFailureHandling();
        }

        private class FailureChangeEdit {
            private AstAbstractKeywordTreeTableNode treeTableNode;
            private FailureHandling oldFailureHandling;

            public FailureChangeEdit(AstAbstractKeywordTreeTableNode treeTableNode, FailureHandling oldFailureHandling) {
                this.treeTableNode = treeTableNode;
                this.oldFailureHandling = oldFailureHandling;
            }

            public AstAbstractKeywordTreeTableNode getTreeTableNode() {
                return this.treeTableNode;
            }

            public FailureHandling getOldFailureHandling() {
                return this.oldFailureHandling;
            }
        }
    }

    private class MoveNodeOperation
    extends AbstractOperation {
        private AstTreeTableNode selectedNode;
        private ASTNodeWrapper selectedAstObject;
        private AstTreeTableNode parentNode;
        private int offset;

        public MoveNodeOperation(AstTreeTableNode selectedNode, int offset) {
            super(MoveNodeOperation.class.getName());
            this.selectedNode = selectedNode;
            this.offset = offset;
            if (Objects.nonNull(selectedNode)) {
                this.selectedAstObject = selectedNode.getASTObject();
                this.parentNode = selectedNode.getParent();
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (TestCaseTreeTableInput.this.isUnmoveableAstNode(this.selectedNode)) {
                return Status.CANCEL_STATUS;
            }
            return this.doMove(this.offset);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doMove(this.offset);
        }

        protected IStatus doMove(int moveOffset) {
            ASTNodeWrapper parentASTNode = this.selectedAstObject.getParent();
            int currentIndex = parentASTNode.indexOf(this.selectedAstObject);
            int newIndex = currentIndex + moveOffset;
            if (newIndex < 0) {
                return Status.CANCEL_STATUS;
            }
            ASTNodeWrapper tempNode = new EmptyStatementWrapper(parentASTNode);
            if (this.selectedAstObject instanceof MethodNodeWrapper) {
                tempNode = new MethodNodeWrapper(parentASTNode);
            }
            if (!parentASTNode.addChild(tempNode, newIndex) && !parentASTNode.addChild(tempNode)) {
                return Status.CANCEL_STATUS;
            }
            parentASTNode.removeChild(this.selectedAstObject);
            parentASTNode.addChild(this.selectedAstObject, parentASTNode.indexOf(tempNode));
            parentASTNode.removeChild(tempNode);
            TestCaseTreeTableInput.this.setDirty(true);
            TestCaseTreeTableInput.this.refreshObjectWithoutReloading(this.parentNode);
            TestCaseTreeTableInput.this.setSelection(this.parentNode, this.selectedAstObject);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doMove(1 - this.offset);
        }
    }

    public static enum NodeAddType {
        Add,
        InserBefore,
        InserAfter;

    }

    private class RemoveAstTreeTableNodesOperation
    extends AbstractOperation {
        private List<AstTreeTableNode> treeTableNodes;
        private List<AstNodeRemovedEdit> removedAstNodeEdits;

        public RemoveAstTreeTableNodesOperation(List<AstTreeTableNode> treeTableNodes) {
            super(RemoveAstTreeTableNodesOperation.class.getName());
            this.treeTableNodes = treeTableNodes;
            this.removedAstNodeEdits = new ArrayList<AstNodeRemovedEdit>();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.treeTableNodes == null || this.treeTableNodes.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.removedAstNodeEdits.clear();
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            ArrayList<AstTreeTableNode> refreshNodeList = new ArrayList<AstTreeTableNode>();
            int i = 0;
            while (i < this.treeTableNodes.size()) {
                int childIndex;
                ASTNodeWrapper parentAstObject;
                AstTreeTableNode treeTableNode = this.treeTableNodes.get(i);
                ASTNodeWrapper astObject = treeTableNode.getASTObject();
                if (treeTableNode != null && astObject != null && (parentAstObject = astObject.getParent()) != null && (childIndex = parentAstObject.indexOf(astObject)) >= 0 && parentAstObject.removeChild(astObject) && treeTableNode.getParent() != null) {
                    refreshNodeList.add(treeTableNode.getParent());
                    this.removedAstNodeEdits.add(new AstNodeRemovedEdit(treeTableNode.getParent(), parentAstObject, astObject, childIndex));
                }
                ++i;
            }
            TestCaseTreeTableInput.this.processAfterRemove(refreshNodeList);
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            if (OSUtil.isMacBigSurOrLater()) {
                TestCaseTreeTableInput.this.treeTableViewer.getTree().redraw();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            ArrayList<AstNodeAddedEdit> refreshNodeList = new ArrayList<AstNodeAddedEdit>();
            Collections.reverse(this.removedAstNodeEdits);
            for (AstNodeRemovedEdit astNodeRemovedEdit : this.removedAstNodeEdits) {
                ASTNodeWrapper astObject = astNodeRemovedEdit.getAstObject();
                astNodeRemovedEdit.getParentAstObject().addChild(astObject, astNodeRemovedEdit.getOriginalIndex());
                refreshNodeList.add(new AstNodeAddedEdit(astNodeRemovedEdit.getParentNode(), astObject));
            }
            TestCaseTreeTableInput.this.processAfterEdits(refreshNodeList, false, true);
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            if (OSUtil.isMacBigSurOrLater()) {
                TestCaseTreeTableInput.this.treeTableViewer.getTree().redraw();
            }
            return Status.OK_STATUS;
        }

        public class AstNodeRemovedEdit {
            private AstTreeTableNode parentNode;
            private ASTNodeWrapper parentAstObject;
            private ASTNodeWrapper astObject;
            private int originalIndex;

            public AstNodeRemovedEdit(AstTreeTableNode parentNode, ASTNodeWrapper parentAstObject, ASTNodeWrapper astObject, int originalIndex) {
                this.parentNode = parentNode;
                this.astObject = astObject;
                this.originalIndex = originalIndex;
                this.parentAstObject = parentAstObject;
            }

            public AstTreeTableNode getParentNode() {
                return this.parentNode;
            }

            public ASTNodeWrapper getAstObject() {
                return this.astObject;
            }

            protected int getOriginalIndex() {
                return this.originalIndex;
            }

            protected ASTNodeWrapper getParentAstObject() {
                return this.parentAstObject;
            }
        }
    }

    private class ToogleDisableStepsOperation
    extends AbstractOperation {
        private List<AstTreeTableNode> treeTableNodes;
        private boolean isDisableMode;
        private List<AstStatementTreeTableNode> changedNodes;

        public ToogleDisableStepsOperation(List<AstTreeTableNode> treeTableNodes, boolean isDisableMode) {
            super(ToogleDisableStepsOperation.class.getName());
            this.changedNodes = new ArrayList<AstStatementTreeTableNode>();
            this.treeTableNodes = treeTableNodes;
            this.isDisableMode = isDisableMode;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.treeTableNodes == null || this.treeTableNodes.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            this.changedNodes.clear();
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            for (AstTreeTableNode treeTableNode : this.treeTableNodes) {
                if (!(treeTableNode instanceof AstStatementTreeTableNode) || !((AstStatementTreeTableNode)treeTableNode).canBeDisabled()) continue;
                AstStatementTreeTableNode statementNode = (AstStatementTreeTableNode)treeTableNode;
                if (!(this.isDisableMode ? statementNode.disable() : statementNode.enable())) continue;
                this.changedNodes.add(statementNode);
                TestCaseTreeTableInput.this.treeTableViewer.update((Object)statementNode, null);
                TestCaseTreeTableInput.this.setDirty(true);
            }
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            if (this.changedNodes.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            TestCaseTreeTableInput.this.treeTableViewer.setSelection(null);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doToogleEnableDisableMode();
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doToogleEnableDisableMode();
        }

        private IStatus doToogleEnableDisableMode() {
            AstTreeTableNode topItem = TestCaseTreeTableInput.this.getTopItem();
            Object[] expandedElements = TestCaseTreeTableInput.this.saveExpandedState();
            for (AstStatementTreeTableNode statementNode : this.changedNodes) {
                statementNode.toogleEnable();
                TestCaseTreeTableInput.this.treeTableViewer.update((Object)statementNode, null);
                TestCaseTreeTableInput.this.setDirty(true);
            }
            TestCaseTreeTableInput.this.reloadExpandedState(expandedElements);
            TestCaseTreeTableInput.this.setTopItem(topItem);
            TestCaseTreeTableInput.this.treeTableViewer.setSelection(null);
            return Status.OK_STATUS;
        }
    }
}

