/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.components.operation.OperationExecutor;
import com.kms.katalon.composer.testcase.ast.treetable.IAstItemEditableNode;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class ItemColumnEditingSupport
extends EditingSupport {
    private TreeViewer treeViewer;
    private ITestCasePart parentTestCasePart;

    public ItemColumnEditingSupport(TreeViewer viewer, ITestCasePart parentTestCasePart) {
        super((ColumnViewer)viewer);
        this.treeViewer = viewer;
        this.parentTestCasePart = parentTestCasePart;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof IAstItemEditableNode) {
            return ((IAstItemEditableNode)element).getCellEditorForItem((Composite)this.treeViewer.getTree());
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return element instanceof IAstItemEditableNode && ((IAstItemEditableNode)element).canEditItem();
    }

    protected Object getValue(Object element) {
        if (element instanceof IAstItemEditableNode) {
            return ((IAstItemEditableNode)element).getItem();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof IAstItemEditableNode)) {
            return;
        }
        new OperationExecutor((Object)this.parentTestCasePart).executeOperation((IUndoableOperation)new NodeItemValueChangeOperation((IAstItemEditableNode)element, value));
    }

    private class NodeItemValueChangeOperation
    extends AbstractOperation {
        private IAstItemEditableNode node;
        private Object value;
        private Object oldValue;

        public NodeItemValueChangeOperation(IAstItemEditableNode node, Object value) {
            super(NodeItemValueChangeOperation.class.getName());
            this.node = node;
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = this.cloneValue(this.node.getItem());
            this.value = this.cloneValue(this.value);
            return this.redo(monitor, info);
        }

        private Object cloneValue(Object value) {
            if (value instanceof ASTNodeWrapper) {
                return ((ASTNodeWrapper)value).clone();
            }
            return value;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.value);
        }

        protected IStatus doSetItemValue(Object itemValue) {
            Object tempValue = this.cloneValue(itemValue);
            if (!this.node.setItem(tempValue)) {
                return Status.CANCEL_STATUS;
            }
            ItemColumnEditingSupport.this.parentTestCasePart.getTreeTableInput().setDirty(true);
            ItemColumnEditingSupport.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.node));
            ItemColumnEditingSupport.this.treeViewer.refresh((Object)this.node);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.oldValue);
        }
    }
}

