/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.components.operation.OperationExecutor;
import com.kms.katalon.composer.testcase.ast.treetable.AstCallTestCaseKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstObjectEditableNode;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class TestObjectEditingSupport
extends EditingSupport {
    private TreeViewer treeViewer;
    private ITestCasePart parentTestCasePart;

    public TestObjectEditingSupport(TreeViewer treeViewer, ITestCasePart parentTestCasePart) {
        super((ColumnViewer)treeViewer);
        this.treeViewer = treeViewer;
        this.parentTestCasePart = parentTestCasePart;
    }

    protected CellEditor getCellEditor(Object element) {
        IAstObjectEditableNode editableNode = (IAstObjectEditableNode)element;
        editableNode.setTestCasePart(this.parentTestCasePart);
        return editableNode.getCellEditorForTestObject((Composite)this.treeViewer.getTree());
    }

    protected boolean canEdit(Object element) {
        return element instanceof IAstObjectEditableNode && ((IAstObjectEditableNode)element).canEditTestObject();
    }

    protected Object getValue(Object element) {
        return ((IAstObjectEditableNode)element).getTestObject();
    }

    protected void setValue(Object element, Object value) {
        new OperationExecutor((Object)this.parentTestCasePart).executeOperation((IUndoableOperation)new NodeObjectValueChangeOperation((IAstObjectEditableNode)element, value));
    }

    private class NodeObjectValueChangeOperation
    extends AbstractOperation {
        private IAstObjectEditableNode node;
        private Object value;
        private Object oldValue;
        private List<VariableEntity> testCaseVariables;

        public NodeObjectValueChangeOperation(IAstObjectEditableNode node, Object value) {
            super(NodeObjectValueChangeOperation.class.getName());
            this.node = node;
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = this.node.getTestObject();
            if (this.oldValue instanceof ASTNodeWrapper) {
                this.oldValue = ((ASTNodeWrapper)this.oldValue).clone();
            }
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = this.doSetTestObjectValue(this.value);
            if (status == Status.CANCEL_STATUS) {
                return status;
            }
            if (this.node instanceof AstCallTestCaseKeywordTreeTableNode) {
                this.testCaseVariables = ((AstCallTestCaseKeywordTreeTableNode)this.node).getCallTestCaseVariables();
                TestObjectEditingSupport.this.parentTestCasePart.addVariables(this.testCaseVariables.toArray(new VariableEntity[this.testCaseVariables.size()]));
            }
            return status;
        }

        protected IStatus doSetTestObjectValue(Object objectValue) {
            if (!this.node.setTestObject(objectValue)) {
                return Status.CANCEL_STATUS;
            }
            TestObjectEditingSupport.this.parentTestCasePart.getTreeTableInput().setDirty(true);
            TestObjectEditingSupport.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.node));
            TestObjectEditingSupport.this.treeViewer.refresh((Object)this.node);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = this.doSetTestObjectValue(this.oldValue);
            if (status == Status.CANCEL_STATUS) {
                return status;
            }
            if (this.node instanceof AstCallTestCaseKeywordTreeTableNode) {
                TestObjectEditingSupport.this.parentTestCasePart.deleteVariables(this.testCaseVariables);
            }
            return status;
        }
    }
}

