/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.testcase.ast.editors.StringConstantCellEditor;
import com.kms.katalon.composer.testcase.ast.variable.operations.ChangeVariableDefaultValueOperation;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.entity.variable.VariableEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;

public class VariableDefaultValueEditingSupport
extends EditingSupport {
    private TableActionOperator variablesPart;
    private ExpressionWrapper expression;
    private ITestCasePart testCasePart;

    public VariableDefaultValueEditingSupport(ColumnViewer viewer, TableActionOperator variablesPart) {
        this(viewer, variablesPart, null);
    }

    public VariableDefaultValueEditingSupport(ColumnViewer viewer, TableActionOperator variablesPart, ITestCasePart testCasePart) {
        super(viewer);
        this.variablesPart = variablesPart;
        this.testCasePart = testCasePart;
    }

    protected CellEditor getCellEditor(Object element) {
        this.expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(((VariableEntity)element).getDefaultValue());
        if (this.expression == null) {
            return null;
        }
        InputValueType inputValueType = AstValueUtil.getTypeValue(this.expression);
        if (inputValueType != null && !inputValueType.equals(InputValueType.String)) {
            return inputValueType.getCellEditorForValue((Composite)this.getViewer().getControl(), this.expression, this.testCasePart);
        }
        if (inputValueType.equals(InputValueType.String) && inputValueType != null) {
            return new MultilineTextCellEditor((Composite)this.getViewer().getControl());
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return element instanceof VariableEntity;
    }

    protected Object getValue(Object element) {
        InputValueType inputValueType = AstValueUtil.getTypeValue(this.expression);
        if (inputValueType != null) {
            return inputValueType.getValueToEdit(this.expression);
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (value == null) {
            return;
        }
        InputValueType inputValueType = AstValueUtil.getTypeValue(this.expression);
        if (inputValueType == null) {
            return;
        }
        Object object = inputValueType.changeValue(this.expression, value);
        if (!(object instanceof ASTNodeWrapper)) {
            return;
        }
        VariableEntity variableEntity = (VariableEntity)element;
        ASTNodeWrapper newAstNode = (ASTNodeWrapper)object;
        StringBuilder stringBuilder = new StringBuilder();
        GroovyWrapperParser groovyParser = new GroovyWrapperParser(stringBuilder);
        groovyParser.parse(newAstNode);
        if (!StringUtils.equals((String)variableEntity.getDefaultValue(), (String)stringBuilder.toString())) {
            this.variablesPart.executeOperation((IUndoableOperation)new ChangeVariableDefaultValueOperation(this.variablesPart, variableEntity, stringBuilder.toString()));
        }
    }

    private class MultilineTextCellEditor
    extends StringConstantCellEditor {
        public MultilineTextCellEditor(Composite parent) {
            super(parent, 2626);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData data = new CellEditor.LayoutData();
            data.minimumHeight = 100;
            data.verticalAlignment = 128;
            return data;
        }
    }
}

