/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.testcase.ast.variable.operations.ChangeVariableDefaultValueOperation;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.entity.variable.VariableEntity;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class VariableDefaultValueTypeEditingSupport
extends AstInputBuilderValueTypeColumnSupport {
    private TableActionOperator variablesPart;
    private ExpressionWrapper expression;

    public VariableDefaultValueTypeEditingSupport(ColumnViewer viewer, TableActionOperator variablesPart, InputValueType[] defaultInputValueTypes) {
        super(viewer, defaultInputValueTypes);
        this.variablesPart = variablesPart;
    }

    @Override
    protected CellEditor getCellEditor(Object element) {
        return new CustomComboBoxCellEditor((Composite)this.getViewer().getControl(), this.readableValueTypeNames);
    }

    @Override
    protected boolean canEdit(Object element) {
        return element instanceof VariableEntity;
    }

    @Override
    protected Object getValue(Object element) {
        this.expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(((VariableEntity)element).getDefaultValue());
        if (this.expression == null) {
            return 0;
        }
        return super.getValue(GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(((VariableEntity)element).getDefaultValue()));
    }

    @Override
    protected void setValue(Object element, Object value) {
        InputValueType oldValueType;
        if (!(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= this.inputValueTypes.length) {
            return;
        }
        InputValueType newValueType = this.inputValueTypes[(Integer)value];
        if (newValueType == (oldValueType = AstValueUtil.getTypeValue(this.expression))) {
            return;
        }
        ASTNodeWrapper newAstNode = (ASTNodeWrapper)newValueType.getNewValue(this.expression != null ? this.expression.getParent() : null);
        if (newAstNode == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        GroovyWrapperParser groovyParser = new GroovyWrapperParser(stringBuilder);
        groovyParser.parse(newAstNode);
        this.variablesPart.executeOperation((IUndoableOperation)new ChangeVariableDefaultValueOperation(this.variablesPart, (VariableEntity)element, stringBuilder.toString()));
    }

    private class CustomComboBoxCellEditor
    extends ComboBoxCellEditor {
        public CustomComboBoxCellEditor(Composite parent, String[] items) {
            super(parent, items);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData result = super.getLayoutData();
            result.minimumHeight = VariableDefaultValueTypeEditingSupport.this.variablesPart.getTableViewer().getTable().getHeaderHeight();
            return result;
        }
    }
}

