/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.views;

import com.kms.katalon.composer.testcase.views.TheAstTreeNode;
import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;

public class GroovyScriptToTreeNodeAdapter {
    static Properties overrides = new Properties(){
        private static final long serialVersionUID = 1L;
        {
            this.put("org.codehaus.groovy.ast.MethodNode", "Function - $expression.name");
        }
    };
    static Properties classNameToStringForm;

    static {
        try {
            File userFile;
            URL url = ClassLoader.getSystemResource("groovy/inspect/swingui/AstBrowserProperties.groovy");
            if (url == null) {
                url = GroovyScriptToTreeNodeAdapter.class.getClassLoader().getResource("groovy/inspect/swingui/AstBrowserProperties.groovy");
            }
            ConfigObject config = new ConfigSlurper().parse(url);
            classNameToStringForm = config.toProperties();
            classNameToStringForm.putAll((Map<?, ?>)overrides);
            String home = System.getProperty("user.home");
            if (home != null && !home.equals("") && (userFile = new File(home + File.separator + ".groovy/AstBrowserProperties.groovy")).exists()) {
                ConfigObject customConfig = new ConfigSlurper().parse(userFile.toURL());
                classNameToStringForm.putAll((Map<?, ?>)customConfig.toProperties());
            }
        }
        catch (Exception exception) {
            classNameToStringForm = new Properties();
        }
    }

    public TheAstTreeNode make(Object node) {
        TheAstTreeNode treeNode = null;
        if (node instanceof ASTNode) {
            String friendlyName = this.getStringForm((ASTNode)node);
            treeNode = new TheAstTreeNode(null, friendlyName);
            treeNode.ast = (ASTNode)node;
        }
        return treeNode;
    }

    public TheAstTreeNode make(MethodNode node) {
        String friendlyName = this.getStringForm((ASTNode)node);
        TheAstTreeNode treeNode = new TheAstTreeNode(null, friendlyName);
        treeNode.ast = node;
        return treeNode;
    }

    private String getStringForm(ASTNode node) {
        try {
            String templateTextForNode = classNameToStringForm.getProperty(node.getClass().getName());
            if (templateTextForNode != null) {
                GStringTemplateEngine engine = new GStringTemplateEngine();
                Template template = engine.createTemplate(templateTextForNode);
                HashMap<String, ASTNode> bindings = new HashMap<String, ASTNode>();
                bindings.put("expression", node);
                Writable writable = template.make(bindings);
                StringWriter result = new StringWriter();
                writable.writeTo((Writer)result);
                return result.toString();
            }
            return node.getClass().getSimpleName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    void extendMethodNodePropertyTable(List<List<String>> table, MethodNode node) {
        BytecodeHelper.getMethodDescriptor((MethodNode)node);
        table.add((List<String>)new ArrayList<String>(node){
            private static final long serialVersionUID = 1L;
            {
                this.add("descriptor");
                this.add(BytecodeHelper.getMethodDescriptor((MethodNode)methodNode));
                this.add("String");
            }
        });
    }
}

