package com.kms.katalon.core.mobile.helper;

import java.text.MessageFormat;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.touch.offset.PointOption;
import org.openqa.selenium.Point;

public class MobileGestureCommonHelper {
    
    private static final KeywordLogger logger = KeywordLogger.getInstance(MobileGestureCommonHelper.class);
    
    private static final int IOS_PINCH_OFFSET = 5;

    private static final int ANDROID_PINCH_OFFSET = 150;

    private static final int PINCH_PART_LENGTH = 10;

    public static void pinchToZoomIn(Number startX, Number startY, Number offset) {
        MobileCommonHelper.checkXAndY(startX, startY);
        checkOffset(offset);
        pinchToZoomIn(startX.intValue(), startY.intValue(), offset.intValue());
        logger.logPassed(
                MessageFormat.format(StringConstants.KW_LOG_PASSED_ZOOM_AT_X_Y_WITH_OFFSET_Z, startX, startY, offset));
    }

    private static void pinchToZoomIn(int startX, int startY, int offset) {
        offset = makeSureOffsetValueIsValid(startY, offset);
        AppiumDriver driver = MobileDriverFactory.getDriver();

        var start = new Point(startX, startY);
        var end1 = new Point(startX - offset, startY + offset);
        var end2 = new Point(startX + offset, startY - offset);
        MobileCommonHelper.pinch(driver, start, start, end1, end2);
    }

    public static void pinchToZoomOut(Number endX, Number endY, Number offset) {
        MobileCommonHelper.checkXAndY(endX, endY);
        checkOffset(offset);
        pinchToZoomOut(endX.intValue(), endY.intValue(), offset.intValue());
        logger.logPassed(
                MessageFormat.format(StringConstants.KW_LOG_PASSED_PINCH_AT_X_Y_WITH_OFFSET_Z, endX, endY, offset));
    }

    private static void pinchToZoomOut(int endX, int endY, int offset) {
        offset = makeSureOffsetValueIsValid(endY, offset);
        AppiumDriver driver = MobileDriverFactory.getDriver();

        var start1 = new Point(endX - offset, endY + offset);
        var start2 = new Point(endX + offset, endY - offset);
        var end = new Point(endX, endY);
        MobileCommonHelper.pinch(driver, start1, start2, end, end);
    }

    private static void checkOffset(Number offset) {
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_OFFSET);
        if (offset == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FAILED_PARAM_X_CANNOT_BE_NULL,
                    "offset"));
        }
    }

    private static int makeSureOffsetValueIsValid(int startY, int offset) {
        int deviceHeight = MobileDriverFactory.getDriver().manage().window().getSize().height;
        if (startY - offset < 0) {
            offset = startY;
        } else if (startY + offset > deviceHeight) {
            offset = deviceHeight - startY;
        }
        return offset;
    }
}
