package com.kms.katalon.core.mobile.keyword.builtin;

import java.text.MessageFormat

import org.apache.commons.lang.StringEscapeUtils
import org.apache.commons.lang3.StringUtils
import org.openqa.selenium.Keys
import org.openqa.selenium.interactions.KeyInput
import org.openqa.selenium.interactions.Sequence

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.selenium.util.SeleniumKeysUtil

import groovy.transform.CompileStatic;
import io.appium.java_client.AppiumDriver
import io.appium.java_client.android.AndroidDriver
import io.appium.java_client.ios.IOSDriver

@Action(value = "sendKeysToActiveElement")
public class SendKeysToActiveElementKeyword extends MobileAbstractKeyword {
    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @Override
    public Object execute(Object... params) {
        String strokeKeys = (String) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        sendKeys(strokeKeys, flowControl)
    }

    @CompileStatic
    public void sendKeys(String strokeKeys, FailureHandling flowControl) throws StepFailedException {
        String readableText = SeleniumKeysUtil.getReadableText(strokeKeys)

        AppiumDriver driver = MobileDriverFactory.getDriver();
        if (driver == null) {
            throw new IllegalStateException("Appium driver is not initialized.");
        }

        if (driver instanceof AndroidDriver) {
            sendAndroidKeys((AndroidDriver) driver, strokeKeys);
        } else if (driver instanceof IOSDriver) {
            sendIOSKeys((IOSDriver) driver, strokeKeys);
        } else {
            throw new UnsupportedOperationException(
            "Unsupported driver type: " + driver.getClass().getName());
        }

        MobileKeywordMain.runKeyword({
            logger.logPassed(MessageFormat.format(CoreMobileMessageConstants.KW_LOG_SEND_KEYS_X_ON_ACTIVE_ELEMENT_SUCCESSFULLY,
                    StringUtils.defaultString(readableText)))
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), MessageFormat.format(CoreMobileMessageConstants.KW_MSG_CANNOT_SEND_KEYS_X_ON_ACTIVE_ELEMENT,
        StringUtils.defaultString(readableText)))
    }


    private void sendAndroidKeys(AndroidDriver driver, String strokeKeys) {
        KeyInput keyboard = new KeyInput("keyboard");
        Sequence sequence = new Sequence(keyboard, 0);

        String converted = StringEscapeUtils.unescapeJava(strokeKeys)
        for (char c : converted.toCharArray()) {
            switch (c) {
                case '\n':
                    sequence.addAction(keyboard.createKeyDown(Keys.ENTER.getCodePoint()));
                    sequence.addAction(keyboard.createKeyUp(Keys.ENTER.getCodePoint()));
                    break;
                case '\b':
                    sequence.addAction(keyboard.createKeyDown(Keys.BACK_SPACE.getCodePoint()));
                    sequence.addAction(keyboard.createKeyUp(Keys.BACK_SPACE.getCodePoint()));
                    break;
                default:
                    sequence.addAction(keyboard.createKeyDown(c as int));
                    sequence.addAction(keyboard.createKeyUp(c as int));
                    break;
            }
        }

        driver.perform(List.of(sequence));
    }

    private void sendIOSKeys(IOSDriver driver, String strokeKeys) {
        KeyInput keyboard = new KeyInput("keyboard");
        Sequence sequence = new Sequence(keyboard, 0);

        for (char c : strokeKeys.toCharArray()) {
            sequence.addAction(keyboard.createKeyDown(c));
            sequence.addAction(keyboard.createKeyUp(c));
        }

        driver.perform(List.of(sequence));
    }
}
