package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat
import java.time.Duration

import org.openqa.selenium.Dimension
import org.openqa.selenium.Point
import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.helper.KeywordHelper
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.helper.MobileCommonHelper
import com.kms.katalon.core.mobile.helper.MobileElementCommonHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject

import groovy.transform.CompileStatic

@Action(value = "tapAndHold")
public class TapAndHoldKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        Number duration = (Number) params[1]
        int timeout = (int) params[2]
        FailureHandling flowControl = (FailureHandling)(params.length > 3 && params[3] instanceof FailureHandling ? params[3] : RunConfiguration.getDefaultFailureHandling())
        tapAndHold(to, duration, timeout, flowControl)
    }

    @CompileStatic
    public void tapAndHold(TestObject to, Number duration, int timeout, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            KeywordHelper.checkTestObjectParameter(to)
            timeout = MobileCommonHelper.checkTimeout(timeout)
            WebElement element = findElement(to, timeout)
            if (element == null){
                MobileKeywordMain.stepFailed(MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), flowControl, null, true)
                return
            }

            Point location = element.getLocation();
            Dimension size = element.getSize();
            Point tapPoint = new Point((int)(location.x + size.width / 2), (int)(location.y + size.height / 2));
            MobileCommonHelper.touchAndHold(MobileDriverFactory.getDriver(), tapPoint, Duration.ofSeconds(duration.longValue()));

            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_TAP_AND_HOLD_ON_ELEMENT_X_WITH_DURATION_Y,
                    to.getObjectId(), duration.toString()));
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null && duration != null) ? MessageFormat.format(StringConstants.KW_MSG_FAILED_TO_TAP_AND_HOLD_ON_ELEMENT_X_WITH_DURATION_Y, [
            to.getObjectId(),
            MobileElementCommonHelper.getStringForDuration(duration)
        ] as Object[]) : StringConstants.KW_MSG_FAILED_TO_TAP_AND_HOLD_ON_ELEMENT)
    }
}
