package com.kms.katalon.core.mobile.keyword.internal;

import java.util.Optional;

import org.apache.commons.lang3.StringUtils;

import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;

public class MobileLocatorFinder {

    public static String findLocator(TestObject testObject, LocatorStrategy strategy) {
        MobileSearchEngine searchEngine = new MobileSearchEngine(null, testObject);
        if (MobilePlatform.ANDROID.equals(((MobileTestObject) testObject).getPlatform())) {
            switch (strategy) {
                case ATTRIBUTES:
                    return searchEngine.findAndroidAttributesLocator();
                case ACCESSIBILITY:
                    return searchEngine.findAndroidAccessibilityId();
                case ANDROID_UI_AUTOMATOR:
                    return searchEngine.findAndroidUIAutomatorSelector();
                case CLASS_NAME: {
                    Optional<TestObjectProperty> match = testObject.getProperties()
                            .stream()
                            .filter(p -> AndroidProperties.ANDROID_CLASS.equals(p.getName()))
                            .findFirst();
                    return match.isPresent() ? match.get().getValue() : StringUtils.EMPTY;
                }
                case ID:
                    return searchEngine.findAndroidID();
                case NAME:
                    return searchEngine.findAndroidName();
                case XPATH: {
                    Optional<TestObjectProperty> match = testObject.getProperties()
                            .stream()
                            .filter(p -> AndroidProperties.XPATH.equals(p.getName()))
                            .findFirst();
                    return match.isPresent() ? match.get().getValue() : StringUtils.EMPTY;
                }
                case IMAGE: {
                    Optional<TestObjectProperty> match = testObject.getProperties()
                            .stream()
                            .filter(p -> AndroidProperties.IMAGE.equals(p.getName()))
                            .findFirst();
                    return match.isPresent() ? match.get().getValue() : StringUtils.EMPTY;
                }
                default:
                    return StringUtils.EMPTY;
            }
        } else if (MobilePlatform.IOS.equals(((MobileTestObject) testObject).getPlatform())) {
            switch (strategy) {
                case ATTRIBUTES:
                    return searchEngine.findIOSAttributesLocator();
                case ACCESSIBILITY:
                    return searchEngine.findIOSAccessibilityId();
                case CLASS_NAME: {
                    Optional<TestObjectProperty> match = testObject.getProperties()
                            .stream()
                            .filter(p -> IOSProperties.IOS_TYPE.equals(p.getName()))
                            .findFirst();
                    return match.isPresent() ? match.get().getValue() : StringUtils.EMPTY;
                }
                case ID:
                    return searchEngine.findIOSID();
                case XPATH: {
                    Optional<TestObjectProperty> match = testObject.getProperties()
                            .stream()
                            .filter(p -> IOSProperties.XPATH.equals(p.getName()))
                            .findFirst();
                    return match.isPresent() ? match.get().getValue() : StringUtils.EMPTY;
                }
                case IOS_CLASS_CHAIN:
                    return searchEngine.findIOSClassChain();
                case IOS_PREDICATE_STRING:
                    return searchEngine.findIOSPredicateString();
                case NAME:
                    return searchEngine.findIOSName();
                case IMAGE: {
                    Optional<TestObjectProperty> match = testObject.getProperties()
                            .stream()
                            .filter(p -> IOSProperties.IMAGE.equals(p.getName()))
                            .findFirst();
                    return match.isPresent() ? match.get().getValue() : StringUtils.EMPTY;
                }
                default:
                    return StringUtils.EMPTY;

            }
        }

        return StringUtils.EMPTY;
    }
}
